
Begin Sierra Fuego

    TITLE flow over a cylinder, Re = 2000

#-------------------------------------------------------------------------------
# DEFINE MATERIAL PROPERTIES
   Begin Property Specification for Fuego Material air
      Density   = 1.2
      Viscosity = 1.8e-5
   End   Property Specification for Fuego Material air
      
#-------------------------------------------------------------------------------    
# DEFINE MESH AND ASSIGN MATERIALS

    Begin Finite Element Model cylMesh
        Database Name = cyl_base.g
        Database Type = ExodusII
        Decomposition Method = RIB

        # ASSIGN MATERIALS TO BLOCKS
        Begin Parameters for Block block_1
          Material air
        End   Parameters for Block block_1
          
    End   Finite Element Model cylMesh

#-------------------------------------------------------------------------------
    Begin Fuego Procedure Fuego_procedure

        Time Start = 0.0, Stop = 10.0, Status Interval = 10

        begin time control
            BEGIN TIME STEPPING BLOCK  time_block
                START TIME IS   0.0
                TIME STEP = 1e-3
                BEGIN PARAMETERS FOR FUEGO REGION fuego_region
                    TRANSIENT STEP TYPE IS automatic
                    CFL LIMIT = 5.0
                    TIME STEP CHANGE FACTOR = 1.5
                END   PARAMETERS FOR FUEGO REGION fuego_region
            END   TIME STEPPING BLOCK time_block
            
            Termination time = 1e6
        end time control

#-------------------------------------------------------------------------------
        Begin Fuego Region Fuego_region
        
            # SET THE UNITS
            Set unit system to MKS
            
            # DECLARE WHICH MESH/FINITE ELEMENT MODEL TO USE
            Use Finite Element Model cylMesh
  
            Begin Solution Options
                Coordinate System = 2D
                Projection Method = Fourth_Order Smoothing with Timestep Scaling
                
                # DEFINE WHAT EQUATIONS TO SOLVE
                Activate Equation Continuity
                Activate Equation X_Momentum
                Activate Equation Y_Momentum
                Activate Equation turbulent_kinetic_energy
                  
                # DEFINE NONLINEAR ITERATION SETTINGS
                Minimum Number of Nonlinear Iterations = 1
                Maximum Number of Nonlinear Iterations = 2

                # DEFINE ADVECTION SCHEME
                Upwind Method is MUSCL
                UPWIND LIMITER IS SuperBee

                Begin Turbulence Model Specification
                    Turbulence Model = KSGS
                End
                
            End   Solution Options

            # SET INITIAL CONDITIONS
            Begin Initial Condition Block FlowInit
               Volume is block_1
               Pressure   = 0.0
               X_Velocity = 0.0
               Y_Velocity = 0.0
               turbulent_kinetic_energy = 1e-4
            End
                  
            # SET BOUNDARY CONDITIONS
            Begin Inflow Boundary Condition on Surface surface_1
               X_Velocity = "0.3 * (1+0.75*sin(t)) * (y>0 ? 1 : 0.1)"
               Y_Velocity = 0.0
               turbulent_kinetic_energy = 1e-4
               Postprocess total flux of continuity as mdot_in
            End
                  
            Begin Open Boundary Condition on Surface surface_2
               Pressure = 0.0
               turbulent_kinetic_energy = 1e-4
               Postprocess total flux of continuity as mdot_out
            End
                     
            Begin Symmetry Boundary Condition on Surface surface_3
            End
                        
            Begin Wall Boundary Condition on Surface surface_4
               post process yplus
            End
            
            # POSTPROCESSING
            Begin Postprocess point
               Output name = p_point
               Location = 0 0
               Function = "pressure"
            End
                              
            Begin Postprocess integral
               Output name = total_x_mom
               Location = all_blocks
               Function = "density * abs(x_velocity)"
            End

            # HEARTBEAT
            Begin Heartbeat myHeartbeat
               Stream Name = heartbeat.csv
               Format = csv
               At Step 0 increment = 1
               Variable is Global time
               Variable is Global mdot_in
               Variable is Global mdot_out
               Variable is Global total_x_mom
               Variable is Global p_point as Pressure
            End
            
            # DEFINE OUTPUT
            Begin Results Output Label Fuego_output
                Database Name = results/cylinder.e
                At Time 0, Interval = 0.1
                Title Turbulent backward facing step flow
                Nodal Variables = Pressure as P
                Nodal Variables = X_Velocity as Ux
                Nodal Variables = Y_Velocity as Uy
                Nodal Variables = yplus
                Nodal Variables = turbulent_kinetic_energy as TKE

                Global Variables = mdot_in
                Global Variables = mdot_out
                Global Variables = total_x_mom
                Global Variables = p_point
            End
            
        End   Fuego Region Fuego_region

    End   Fuego Procedure Fuego_procedure
#-------------------------------------------------------------------------------
End   Sierra Fuego

