
Begin Sierra Fuego

    TITLE flow over a cylinder, Re = 2000

#-------------------------------------------------------------------------------
# DEFINE MATERIAL PROPERTIES
   Begin Property Specification for Fuego Material air
      Density   = 1.2
      Viscosity = 1.8e-5
      Thermal_conductivity  = 0.025
      Specific_heat         = 1000
      Function For Enthalpy = Hfunc
      Reference Temperature = 300.0
   End   Property Specification for Fuego Material air
      
   Begin Definition For Function Hfunc 
      Type Is Piecewise Linear
      Abscissa = Temperature
      Begin Values
          0.    {1000*(0-300)}
          1000. {1000*(1000-300)}
      End
   End

   Begin Aria Material aluminum_foam
      Density              = Constant  rho = 50
      Thermal Conductivity = Constant  k = 1
      Specific Heat        = Constant  cp = 50
      Heat Conduction      = Generalized
   End 
    
   Begin Aria Material cht_interface
      BC Reference Temperature = user_field name=bc_ref_temp
      Heat Transfer Coefficient = user_field name=bc_ref_h
   End


#-------------------------------------------------------------------------------    
# DEFINE THERMAL SOLVER

    BEGIN TPETRA EQUATION SOLVER  HEAT
      BEGIN PRESET SOLVER
        SOLVER TYPE = THERMAL
      END
    END TPETRA EQUATION SOLVER

#-------------------------------------------------------------------------------    
# DEFINE MESHES AND ASSIGN MATERIALS

    Begin Finite Element Model cylMesh
        Database Name = cyl_base.g
        Database Type = ExodusII
        Decomposition Method = RIB

        # ASSIGN MATERIALS TO BLOCKS
        Begin Parameters for Block block_1
          Material air
        End   Parameters for Block block_1
          
    End   Finite Element Model cylMesh

    Begin Finite Element Model Pipe
        Database Name = pipe.g
        Database Type = ExodusII

        Use material aluminum_foam for block_1
        Use material cht_interface for surface_1
    End   Finite Element Model Pipe

#-------------------------------------------------------------------------------
    Begin Fuego Procedure Fuego_procedure

        Time Start = 0.0, Stop = 10.0, Status Interval = 10

        Begin Solution Control Description
            Use System Main

$---------------------------------------------------
$           Define initial transfer ordering
$---------------------------------------------------
            Begin Initialize Mytransient_init
                Advance Fluid_region
                Advance Solid_region
                Transfer solid_to_fluid_init
            End

            Begin System Main
                Use Initialize Mytransient_init

                Begin Transient Mytransient
                    Begin nonlinear CHT
                        Advance Fluid_region
                        Transfer fluid_to_solid
                        Advance Solid_region
                        Transfer solid_to_fluid
                    End
                End
            End   
            
            Begin Parameters for Nonlinear CHT
                Converged when "(Fluid_region.MaxInitialNonlinearResidual(0) < 1E-1 && \$
                                 Solid_region.MaxInitialNonlinearResidual(0) < 1E-2) || \$
                                 CURRENT_STEP > 1"
            End

            Begin Parameters For Transient Mytransient
                Start Time       = 0.0
                Initial Deltat   = 0.1
                Termination Time = 10.0

$-----------------------------------------------------
$               Define Fuego time integration settings
$-----------------------------------------------------
                Begin Parameters For Fuego Region Fluid_region
                    Transient Step Type Is Automatic
                    Cfl Limit = 5.0
                    Time Step Change Factor = 1.5
                End   Parameters For Fuego Region Fluid_region

$-----------------------------------------------------
$               Define Aria time integration settings
$-----------------------------------------------------
                Begin Parameters For Aria Region Solid_region
                    Initial Time Step Size = 0.1
                    Time Step Variation = Adaptive
                    predictor-corrector Tolerance = 1.0e-3
                    Time Integration Method = BDF2
                End   Parameters For Aria Region Solid_region

            End   Parameters For Transient Mytransient
        End   Solution Control Description

$------------------------------------------------------------------
$       Define transfers
$------------------------------------------------------------------
        Begin Transfer solid_to_fluid_init
            Interpolate Surface Nodes From Solid_region To Fluid_region 
            Send Block surface_1 To surface_4
            Send Field solution->Temperature State Old To Wall_temperature State None
            geometric tolerance = 5e-3
            nodes outside region = abort
        End

        Begin Transfer fluid_to_solid
            Interpolate Surface Nodes From Fluid_region To Solid_region
            Send Block surface_4 To surface_1
            Send Field flux_linearization_coefficient State None To bc_ref_h State None
            Send Field flux_linearization_temperature State None To bc_ref_temp State None
            geometric tolerance = 5e-3
            nodes outside region = abort
        End

        Begin Transfer solid_to_fluid
            Interpolate Surface Nodes From Solid_region To Fluid_region 
            Send Block surface_1 To surface_4
            Send Field solution->Temperature State New To Wall_temperature State None
            geometric tolerance = 5e-3
            nodes outside region = abort
        End

#-------------------------------------------------------------------------------
        Begin Fuego Region Fluid_region
        
            # SET THE UNITS
            Set unit system to MKS
            
            # DECLARE WHICH MESH/FINITE ELEMENT MODEL TO USE
            Use Finite Element Model cylMesh
  
            Begin Solution Options
                Coordinate System = 2D
                Projection Method = Fourth_Order Smoothing with Timestep Scaling
                
                # DEFINE WHAT EQUATIONS TO SOLVE
                Activate Equation Continuity
                Activate Equation X_Momentum
                Activate Equation Y_Momentum
                Activate Equation turbulent_kinetic_energy
                Activate Equation Enthalpy

                # DEFINE NONLINEAR ITERATION SETTINGS
                Minimum Number of Nonlinear Iterations = 1
                Maximum Number of Nonlinear Iterations = 2

                # DEFINE ADVECTION SCHEME
                Upwind Method is MUSCL
                UPWIND LIMITER IS SuperBee

                Begin Turbulence Model Specification
                    Turbulence Model = KSGS
                End
                
            End   Solution Options

            # SET INITIAL CONDITIONS
            Begin Initial Condition Block FlowInit
               Volume is block_1
               Pressure   = 0.0
               X_Velocity = 0.0
               Y_Velocity = 0.0
               Temperature = 300.0
               turbulent_kinetic_energy = 1e-4
            End
                  
            # SET BOUNDARY CONDITIONS
            Begin Inflow Boundary Condition on Surface surface_1
               X_Velocity = (2000*1.8e-5)/(1.2*0.1)
               Y_Velocity = 0.0
               turbulent_kinetic_energy = 1e-4
               Temperature = 300.0
               Postprocess total flux of continuity as mdot_in
            End
                  
            Begin Open Boundary Condition on Surface surface_2
               Pressure = 0.0
               turbulent_kinetic_energy = 1e-4
               Temperature = 300.0
               Postprocess total flux of continuity as mdot_out
            End
                     
            Begin Symmetry Boundary Condition on Surface surface_3
            End
                        
            Begin Wall Boundary Condition on Surface surface_4
               post process yplus
               Interface Boundary
               Calculate convection coefficient using Tref = 300
            End
            
            # POSTPROCESSING
            Begin Postprocess point
               Output name = p_point
               Location = 0 0
               Function = "pressure"
            End
                              
            Begin Postprocess integral
               Output name = total_x_mom
               Location = all_blocks
               Function = "density * abs(x_velocity)"
            End

            # HEARTBEAT
            Begin Heartbeat myHeartbeat
               Stream Name = heartbeat.csv
               Format = csv
               At Step 0 increment = 1
               Variable is Global time
               Variable is Global mdot_in
               Variable is Global mdot_out
               Variable is Global total_x_mom
               Variable is Global p_point as Pressure
            End
            
            # DEFINE OUTPUT
            Begin Results Output Label Fuego_output
                Database Name = results/fluid.e
                At Time 0, Interval = 0.1
                Title Turbulent backward facing step flow
                Nodal Variables = Pressure as P
                Nodal Variables = X_Velocity as Ux
                Nodal Variables = Y_Velocity as Uy
                Nodal Variables = yplus
                Nodal Variables = turbulent_kinetic_energy as TKE
                Nodal Variables = heat_flux
                Nodal Variables = wall_temperature as Twall
                Nodal Variables = Temperature as T
                Nodal Variables = wall_convection_coefficient as hConv

                Global Variables = mdot_in
                Global Variables = mdot_out
                Global Variables = total_x_mom
                Global Variables = p_point
            End
            
        End   Fuego Region Fluid_Region


$------------------------------------------------------------
$       Aria Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------------

        Begin Aria Region Solid_region
            Use Linear Solver Heat
            Nonlinear Solution Strategy = Newton
            Use Dof Averaged Nonlinear Residual
            Use Finite Element Model Pipe

            EQ Energy For Temperature On all_blocks Using Q1 With Diff Mass

            IC for temperature on all_blocks = constant value = 500
            
            User Field Real Node Scalar bc_ref_temp On surface_1
            User Field Real Node Scalar bc_ref_h    On surface_1

            BC Flux for energy on surface_1 = Generalized_Nat_Conv

            Begin Results Output Label Aria_output
                Database Name = results/solid.e
                At Time 0, Interval = 0.1
                Title Temperature In The Solid Pipe
                Nodal Variables = solution->Temperature As T
            End   Results Output Label Aria_output
        End   Aria Region Solid_region

    End   Fuego Procedure Fuego_procedure
#-------------------------------------------------------------------------------
End   Sierra Fuego

