Begin SIERRA Aria 

    Title Aria Contact example

$---------------------------------------------------
$   Define material properties to be used
$---------------------------------------------------
    Begin Aria Material board
        Density              = Constant rho = 2000   # kg/m^3
        Specific Heat        = Constant cp  = 500.0  # J/kg-K
        Thermal Conductivity = Constant k   = 5.0    # W/mK
        Heat Conduction      = Basic
    End

    Begin Aria Material component
        Density              = Constant rho = 3000   # kg/m^3
        Specific Heat        = Constant cp  = 800.0  # J/kg-K
        Thermal Conductivity = Constant k   = 20.0   # W/mK
        Heat Conduction      = Basic
    End

$-----------------------------------------------------------
$   Define linear solver settings
$-----------------------------------------------------------
  BEGIN TPETRA EQUATION SOLVER  solve_temperature
    BEGIN PRESET SOLVER
      SOLVER TYPE = Thermal
    END
  END

$---------------------------------------------------
$   Specify mesh name and settings
$---------------------------------------------------
    Begin Finite Element Model FEModel
        Database Name = contact_mesh.g

$---------------------------------------------------
$       Assign material properties to element blocks
$---------------------------------------------------
        Use Material board for block_1
        Use material component for block_2 block_3 block_4

    End   Finite Element Model FEmodel 
 
$--------------------------------------------------------
$   Procedure domain - solution control, region settings
$--------------------------------------------------------

    Begin Procedure AriaProcedure

        # Transient solution parameters
        Begin Solution Control Description
            Use System Main
            Begin System Main
                Simulation Start Time       = 0.0
                Simulation Termination Time = 100.0
                Begin Transient solution_block_1
                    Advance AriaRegion
                End Transient solution_block_1
            End System Main
   
            # Note: There could be several solution blocks changing these parameters
            Begin Parameters for Transient solution_block_1
                Start Time = 0.0 # seconds
                Termination Time = 100.0 # seconds
                Begin Parameters for Aria Region AriaRegion
                    Time Step Variation     = Adaptive
                    Time Integration Method = BDF2
                    Initial Time Step Size  = 0.004 # seconds
                    Minimum Time Step Size  = 0.0001 # seconds
                    Maximum Time Step Size  = 20.0 # seconds
                    Predictor-Corrector Tolerance = 0.01 # seconds
                End   Parameters for Aria Region AriaRegion
            End   Parameters for Transient solution_block_1
        End   Solution Control Description

$------------------------------------------------------
$       Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------

        Begin Aria Region AriaRegion

$---------------------------------------------------
$           Specify which linear solver to use
$---------------------------------------------------
            Use Linear Solver solve_temperature

$---------------------------------------------------
$           Define nonlinear solver parameters
$---------------------------------------------------
            Nonlinear Solution Strategy  = Newton
            Maximum Nonlinear Iterations = 4
            Nonlinear Residual Tolerance = 1.e-6
            Nonlinear Relaxation Factor  = 1.0 # default

$-----------------------------------------------------------
$           Specify which mesh model to use for this region
$-----------------------------------------------------------
            Use Finite Element Model FEModel

$---------------------------------------------------
$           Specify equations to solve
$---------------------------------------------------
            EQ Energy for Temperature on all_blocks Using Q1 with Mass Diff Src
            Source for energy on block_3 = constant value = 1e6

$---------------------------------------------------
$           Specify initial conditions
$---------------------------------------------------
            IC for temperature on all_blocks = constant value = 300.0 # K

$---------------------------------------------------
$           Specify boundary conditions
$---------------------------------------------------
            BC Flux for Energy on surface_1 = Generalized_Nat_Conv T_ref=250 h=100
            BC Flux for Energy on surface_2 = Generalized_Nat_Conv T_ref=300 h=10
            BC Flux for Energy on surface_3 = Generalized_Nat_Conv T_ref=300 h=10
            BC Flux for Energy on surface_4 = Generalized_Nat_Conv T_ref=300 h=10
            BC Flux for Energy on surface_5 = Generalized_Nat_Conv T_ref=300 h=10

$---------------------------------------------------
$           Specify thermal contact surfaces
$---------------------------------------------------
            Begin Contact Definition res1
                Begin Search Options
                    normal tolerance = 0.001
                End

                # All skinned blocks participate
                skin all blocks = on

                begin enforcement enf_1
                    Enforcement for Energy = tied_temperature
                end

            End

$---------------------------------------------------
$           Define contents of binary plot file
$---------------------------------------------------
            Begin Results Output AriaOutput
                Title Aria: contact example
                Database Name = contact_example.e
                Nodal Variables = Solution->Temperature as T
                At Step 0 Interval = 1
            End   Results Output AriaOutput

        End   Aria Region AriaRegion

    End   Procedure AriaProcedure

End

