Begin SIERRA Aria

    Title Aria Heat Conduction Training Model

$---------------------------------------------------
$   Define material properties to be used
$---------------------------------------------------

    Begin Aria Material aluminum
        Density              = Constant value = 2770  # kg/m^3
        Specific Heat        = Constant value = 800.0 # J/kg-K
        Thermal Conductivity = Constant value = 175.0 # W/mK
        Heat Conduction      = Generalized
    End   Aria Material aluminum


$---------------------------------------------------
$   Specify mesh name and settings
$---------------------------------------------------
    Begin Finite Element Model FEModel
        Database Name = mesh.g

        Use Material aluminum for ClampA ClampB CenterRod

    End   Finite Element Model FEModel

$------------------------------------------------------------
$   Define linear solver settings
$------------------------------------------------------------
    BEGIN TPETRA EQUATION SOLVER solve_temperature
      BEGIN PRESET SOLVER
        SOLVER TYPE = THERMAL_SYMMETRIC
      END
    END TPETRA EQUATION SOLVER
    
$--------------------------------------------------------
$   Procedure domain - solution control, region settings
$--------------------------------------------------------

    Begin Procedure AriaProcedure

$---------------------------------------------------
$       Define temporal solution parameters
$---------------------------------------------------
        Begin Solution Control Description
            Use System Main
            
            Begin System Main
                Begin Transient solution_block_1
                    Advance AriaRegion
                End   Transient solution_block_1
            End   System Main
   
$---------------------------------------------------
$           Specify time integration settings
$---------------------------------------------------
            Begin Parameters for Transient Solution_Block_1
                Start Time       = 0.0   # seconds
                Termination Time = 600.0 # seconds
                
                Begin Parameters for Aria Region AriaRegion
                    Time Step Variation = Adaptive
                    Initial Time Step Size = 0.05
                    Time Integration Method = BDF2
                    Maximum Time Step Size = 20.0 
                    Minimum Time Step Size = 0.01
                    Predictor-Corrector Tolerance = 0.01
                End   Parameters for Aria Region AriaRegion
                
            End   Parameters for Transient Solution_Block_1
        End   Solution Control Description

$------------------------------------------------------
$       Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------

        Begin Aria Region AriaRegion

$---------------------------------------------------
$           Define linear and nonlinear solver parameters
$---------------------------------------------------
            Use Linear Solver solve_temperature
            Nonlinear Solution Strategy  = Newton
            Maximum Nonlinear Iterations = 10
            Nonlinear Residual Tolerance = 1.e-6

$-----------------------------------------------------------
$           Specify which mesh model to use for this region
$-----------------------------------------------------------
            Use Finite Element Model FEModel
           
$---------------------------------------------------
$           Specify equations to solve
$---------------------------------------------------
            EQ Energy for Temperature on all_blocks using Q1 with Mass Diff

$---------------------------------------------------
$           Specify initial conditions
$---------------------------------------------------
            IC for Temperature on all_blocks = constant value = 300 # K

$---------------------------------------------------
$           Specify source terms
$---------------------------------------------------

$---------------------------------------------------
$           Specify boundary conditions
$---------------------------------------------------
            BC Dirichlet for temperature on EndA = constant value = 300 # K
            BC Dirichlet for temperature on EndB = scalar_string_function f = "350+100*sin(t/300)"

$---------------------------------------------------
$           Post-processing
$---------------------------------------------------

$---------------------------------------------------
$           Define contents of output files
$---------------------------------------------------
            Begin Results Output AriaOutput
                Database Name = heat_cond.e
                At Step 0 Interval = 5
                Title Aria: Transient Training Model
                Nodal Variables = Solution->Temperature as T
            End   Results Output AriaOutput

        End   Aria Region AriaRegion

    End   Procedure AriaProcedure

End

