# start_time = { start_time = 0 }

Begin SIERRA Aria

    Title Aria Heat Conduction Training Model

$---------------------------------------------------
$   Define material properties to be used
$---------------------------------------------------

    Begin Aria Material aluminum
        Density              = Constant value = 2770  # kg/m^3
        Specific Heat        = Constant value = 800.0 # J/kg-K
        Thermal Conductivity = Constant value = 175.0 # W/mK
        Heat Conduction      = Generalized
        
        Electrical Conductivity = Constant Value = 10000 # S/m
        Current Density = Ohms_Law
    End   Aria Material aluminum

    Begin Aria Material ss304
        Density              = Constant value = 8000
        Specific Heat        = Polynomial Variable=Temperature order=1 C0=500 C1=0.1
        Thermal Conductivity = User_Function name=ssteel_k_function X=temperature
        Heat Conduction      = Generalized
        
        Electrical Conductivity = Constant Value = 0.1 # S/m
        Current Density = Ohms_Law
    End   Aria Material ss304

    Begin Definition for Function ssteel_k_function
        Type is Piecewise Linear
        Begin Values
            #T (K)  k (W/mK)
            100    10
            500    20
        End Values
    End   Definition for Function ssteel_k_function
    
   
$---------------------------------------------------
$   Specify mesh name and settings
$---------------------------------------------------
    Begin Finite Element Model FEModel
        Database Name = heat_cond.e

        Use Material aluminum for ClampA ClampB
        Use Material ss304 for CenterRod

    End   Finite Element Model FEModel

$------------------------------------------------------------
$   Define linear solver settings
$------------------------------------------------------------
    BEGIN TPETRA EQUATION SOLVER solve_temperature
      BEGIN PRESET SOLVER
        SOLVER TYPE = Multiphysics
      END
    END TPETRA EQUATION SOLVER
    
$--------------------------------------------------------
$   Procedure domain - solution control, region settings
$--------------------------------------------------------

    Begin Procedure AriaProcedure

$---------------------------------------------------
$       Define temporal solution parameters
$---------------------------------------------------
        Begin Solution Control Description
            Use System Main
            
            Begin System Main
                Begin Transient solution_block_1
                    Advance AriaRegion
                End   Transient solution_block_1
            End   System Main
   
$---------------------------------------------------
$           Specify time integration settings
$---------------------------------------------------
            Begin Parameters for Transient Solution_Block_1
                Start Time       = {start_time} # seconds
                Termination Time = 600.0        # seconds
                
                Begin Parameters for Aria Region AriaRegion
                    Time Step Variation = Adaptive
                    Initial Time Step Size = 0.05
                    Time Integration Method = BDF2
                    Maximum Time Step Size = 20.0 
                    Minimum Time Step Size = 0.01
                    Predictor-Corrector Tolerance = 0.01
                End   Parameters for Aria Region AriaRegion
                
            End   Parameters for Transient Solution_Block_1
        End   Solution Control Description

$------------------------------------------------------
$       Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------

        Begin Aria Region AriaRegion

$---------------------------------------------------
$           Define linear and nonlinear solver parameters
$---------------------------------------------------
            Use Linear Solver solve_temperature
            Nonlinear Solution Strategy  = Newton
            Maximum Nonlinear Iterations = 10
            Nonlinear Residual Tolerance = 1.e-6

$-----------------------------------------------------------
$           Specify which mesh model to use for this region
$-----------------------------------------------------------
            Use Finite Element Model FEModel
           
$---------------------------------------------------
$           Specify equations to solve
$---------------------------------------------------
            EQ Energy for Temperature on all_blocks using Q1 with Mass Diff Src
            EQ Current for Voltage on all_blocks using Q1 with Diff

$---------------------------------------------------
$           Specify initial conditions
$---------------------------------------------------
            Ic Read_File Temperature = T
            Ic Read_File Voltage = V

$---------------------------------------------------
$           Specify source terms
$---------------------------------------------------
            Source for Energy on all_blocks = joule_heating
            
$---------------------------------------------------
$           Specify boundary conditions
$---------------------------------------------------
            BC Dirichlet for temperature on EndA = constant value = 300 # K
            BC Dirichlet for temperature on EndB = constant value = 300 # K

            Mesh Group clamp_conv = EndASides EndBSides
            Mesh Group rad_surfs = all_surfaces - EndA - EndB
              
            BC Flux for Energy on clamp_conv = Nat_Conv H=5 T_ref=250
            BC Flux for Energy on RodSurf = Nat_Conv H=10 T_ref=250
            
# emissivity = {e = 0.9}
# sigma = {sigma = 5.67e-8}
            BC Flux for Energy on rad_surfs = Rad T_ref = 250 Crad = {e*sigma}
            
            BC Dirichlet for Voltage on EndA = constant value = 0
            BC Flux for Current on EndB = constant value = -100 # Amps/m2

$---------------------------------------------------
$           Post-processing
$---------------------------------------------------
            Postprocess integrated_flux of equation energy on EndA as FluxA
            Postprocess integrated_flux of equation energy on EndB as FluxB
            Postprocess integrated_flux of equation energy on clamp_conv as ClampConvLoss
            Postprocess integrated_flux of equation energy on RodSurf as RodConvLoss
            
            Postprocess value of expression heat_conduction on all_blocks as HeatFlux
            Postprocess value of expression energy_flux on RodSurf Model Nat_Conv as ConvFlux
            Postprocess value of expression energy_flux on RodSurf Model Rad as RadFlux
            
            Postprocess value of expression energy_source on all_blocks as Esrc
            Postprocess value of expression current_density on all_blocks as Current
            
            Postprocess value of expression temperature at point 0 0 0 as Trod
            
            Postprocess average of function "temperature-273.15" on CenterRod as TavgC
            Postprocess value of function "voltage / (density*specific_heat*temperature)" on all_blocks as VEratio

$---------------------------------------------------
$           Define contents of output files
$---------------------------------------------------
            Begin Results Output AriaOutput
                Database Name = %B.e
                At Step 0 Interval = 5
                Title Aria: Transient Training Model
                Nodal Variables = Solution->Temperature as T
                Nodal Variables = Solution->Voltage as V
                Nodal Variables = Current
                Nodal Variables = HeatFlux
                Nodal Variables = ConvFlux
                Nodal Variables = RadFlux
                Nodal Variables = Esrc
                Nodal Variables = VEratio
                
                Global Variables = FluxA
                Global Variables = FluxB
                Global Variables = ClampConvLoss
                Global Variables = RodConvLoss
            End   Results Output AriaOutput
            
            Begin Heartbeat AriaTxtOutput
                Stream name = %B.csv
                Format = csv
                At Step 0 increment = 1
                Variable is Global time
                Variable is Global FluxA
                Variable is Global FluxB
                Variable is Global ClampConvLoss
                Variable is Global RodConvLoss
                Variable is Global Trod
                Variable is Global TavgC
            End

        End   Aria Region AriaRegion

    End   Procedure AriaProcedure

End

