# <Problem_Description>
#
# 3D transient heat conduction simulation of a low power laser 
# flux moving over the surfaces of a parallepiped geometry
# in six separate scans which turn on at various times.
#
#
# Solver: cg
# Preconditioner: jacobi
# Element: 3D-hex8
# BC: CONST Dirichlet
# Flux BC: laser_weld
# Flux BC: sharp_line_weld
# Flux BC: gaussian_line_weld
# Flux BC: sharp_spot_weld
# Flux BC: gaussian_spot_weld
# Flux BC: circle_weld
# postprocessing: heat_conduction
#
# </Problem_Description>


BEGIN SIERRA myJob

   Begin Definition for Function mueve
     Type is Multicolumn Piecewise Linear
     Column Titles Time X Y Z NX NY NZ
     Begin Values
         0.00000E+00  0.0000000E+00  0.2500000E+00  0.0000000E+00  -1 0 0
         6.50000E+00  0.0000000E+00  0.1792700E+00  0.1792700E+00  -1 0 0
        12.50000E+00  0.0000000E+00  0.0000000E+00  0.2500000E+00  -1 0 0
        18.75000E+00  0.0000000E+00 -0.1792700E+00  0.1792700E+00  -1 0 0
        25.00000E+00  0.0000000E+00 -0.2500000E+00  0.0000000E+00  -1 0 0
        31.25000E+00  0.0000000E+00 -0.1792700E+00 -0.1792700E+00  -1 0 0
        37.50000E+00  0.0000000E+00  0.0000000E+00 -0.2500000E+00  -1 0 0
        43.75000E+00  0.0000000E+00  0.1792700E+00 -0.1792700E+00  -1 0 0
        50.00000E+00  0.0000000E+00  0.2500000E+00  0.0000000E+00  -1 0 0
        56.25000E+00  0.0000000E+00  0.1792700E+00  0.1792700E+00  -1 0 0
        62.50000E+00  0.0000000E+00  0.0000000E+00  0.2500000E+00  -1 0 0
     End
   End

  Begin Definition for Function PATH1
    Type is multicolumn piecewise linear
    Column Titles Time X Y Z NX NY NZ
    Begin Values
      0.0   0.16  -0.4333    0.40   0.      0.    1.0
      75.0  0.535 -0.0583    0.40   0.      0.   1.0
    End
  End
  Begin Definition for Function PATH2
    Type is multicolumn piecewise linear
    Column Titles Time X Y Z NX NY NZ
    Begin Values
      0.0   0.16  -0.4333    0.52   0.      0.    1.0
      75.0  0.535 -0.0583    0.52   0.      0.   1.0
    End
  End
   
  Begin Definition for Function PATH3
    Type is multicolumn piecewise linear
    Column Titles Time X Y Z NX NY NZ
    Begin Values
      75.0   0.16 -0.4333    -0.52   0.      0.    -1.0
      150.0  1.5  -0.1624875 -0.52   0.      0.    -1.0
    End
  End

  Begin Definition for Function PATH4
    Type is multicolumn piecewise linear
    Column Titles Time X Y Z NX NY NZ
    Begin Values
      150.0   0.066 0.52 -0.3333     0.      -1.0   0.0
      250.0   0.066 0.52 -0.3333     0.      -1.0   0.0
    End
  End

  Begin Definition for Function PATH5
    Type is multicolumn piecewise linear
    Column Titles Time X Y Z NX NY NZ
    Begin Values
      250.0   0.066 -0.52 -0.3333     0.      1.0   0.0
      350.0   0.066 -0.52 -0.3333     0.      1.0   0.0
    End
  End

  Begin Definition for Function PATH6
    Type is multicolumn piecewise linear
    Column Titles Time X Y Z NX NY NZ
    Begin Values
                 350.0       1.9000000000000008      0.09999999999999684      1      0      0      1
                   360.0       1.3834110193593538      0.39548326082550583      1      0      0      1
                   370.0       1.1097211428084894      -0.1329752369025473      1      0      0      1
                   380.0       1.6491302764393196     -0.38439583849091313      1      0      0      1
                   390.0       1.8778444340893423      0.16502600894315037      1      0      0      1
                   400.0       1.3193652050119085       0.3706360355383839      1      0      0      1
                   410.0       1.1372168232319984     -0.19592949408937133      1      0      0      1
                   420.0       1.7108835118951344      -0.3542995122926007      1      0      0      1
                   430.0       1.8451997934686204       0.2254708464285836      1      0      0      1
                   440.0       1.2603338666999033      0.33549984284494144      1      0      0      1
                   450.0       1.1747834733492808     -0.25344468981070045      1      0      0      1
    End
  End

   BEGIN ARIA MATERIAL Kryptonite
      Density               = CONSTANT rho = 100.0
      Thermal Conductivity = Constant k   = 401.0
      Specific Heat         = Constant cp  = 385.0
      heat conduction     = basic
   END ARIA MATERIAL Kryptonite
   
  BEGIN TPETRA EQUATION SOLVER  SOLVE_TEMPERATURE
    BEGIN CG SOLVER
      BEGIN JACOBI PRECONDITIONER
      END
      MAXIMUM ITERATIONS = 1000
      RESIDUAL SCALING = R0
      CONVERGENCE TOLERANCE = 1.000000e-10
    END
  END TPETRA EQUATION SOLVER

   
   BEGIN FINITE ELEMENT MODEL cube
      database name = directed_energy.g
      coordinate system is cartesian
      
      BEGIN PARAMETERS FOR BLOCK block_1
       material Kryptonite
      END PARAMETERS FOR BLOCK block_1
      
   END FINITE ELEMENT MODEL cube

   BEGIN PROCEDURE myAriaProcedure
      
      begin SOLUTION CONTROL DESCRIPTION
        use system main
        begin SYSTEM main
          simulation termination time = 500.00
          begin TRANSIENT mytransient
            advance myRegion
          end
        end
        begin PARAMETERS FOR TRANSIENT mytransient
          start time = 0.0
          termination time = 500.0
          begin PARAMETERS FOR ARIA REGION myRegion
            Initial Time Step Size = 10.0
            Time Step Variation = Fixed
          end
        end
      end

      BEGIN ARIA REGION myRegion
 
       use linear solver solve_temperature
       nonlinear solution strategy = newton
       maximum nonlinear iterations = 10
       nonlinear residual tolerance = 1.0e-6
       nonlinear relaxation factor  = 1.0
       
       use finite element model cube
       
       IC CONST at block_1 Temperature = 273.0

       BC CONST dirichlet at surface_6 Temperature = 273.0

       BEGIN DIRECTED ENERGY MODEL bc1
         laser_power = CONSTANT Value=14140.0
         laser absorption coefficient = CONSTANT Value=1.0
         add surface surface_4
         Origin and Normal function = mueve
         BEGIN Sharp Power Weld Flux
           efficiency = 1.0
           beam diameter = 0.3
         END
       END

       BEGIN DIRECTED ENERGY MODEL bc2
         laser_power = CONSTANT Value=6283.0
         laser absorption coefficient = CONSTANT Value=1.0
         add volume block_1
         add surface surface_1
         Origin and Normal function = path2
         path function = path1
         BEGIN Sharp Power Weld Flux
           efficiency = 0.5
           beam diameter = 0.20
         END
         BEGIN hemisphere source
           efficiency = 0.5
           beam diameter = 0.20
         END
       END

       BEGIN DIRECTED ENERGY MODEL bc3
         laser_power = CONSTANT Value=1082.0
         laser absorption coefficient = CONSTANT Value=1.0
         add surface surface_2
         Origin and Normal function = path3
         BEGIN Gaussian Power Weld Flux
           efficiency = 1.0
           beam diameter = 0.20
           effective beam diameter = 0.18
         END
       END

       BEGIN DIRECTED ENERGY MODEL bc4
         laser_power = CONSTANT Value=1082.0
         laser absorption coefficient = CONSTANT Value=1.0
         add surface surface_3
         Origin and Normal function = path4
         BEGIN Gaussian Power Weld Flux
           efficiency = 1.0
           beam diameter = 0.20
           effective beam diameter = 0.18
           clip diameter = 2.e16
         END
       END

       BEGIN DIRECTED ENERGY MODEL bc5
         laser_power = CONSTANT Value=6283.0
         laser absorption coefficient = CONSTANT Value=1.0
         add surface surface_5
         Origin and Normal function = path5
         BEGIN Sharp Power Weld Flux
           efficiency = 1.0
           beam diameter = 0.20
         END
       END


       BEGIN DIRECTED ENERGY MODEL bc6
         laser_power = CONSTANT Value=6283.0
         laser absorption coefficient = CONSTANT Value=1.0
         add surface surface_7
         Origin and Normal function = path6
         BEGIN Sharp Power Weld Flux
           efficiency = 1.0
           beam diameter = 0.20
         END
       END

       EQ ENERGY for TEMPERATURE on block_1 using Q1 with lumped_mass DIFF 

       postprocess heat_conduction on block_1
         
       BEGIN RESULTS OUTPUT LABEL diffusion output
          database Name = %B.e
          at step 0, increment = 1
          title Aria laser flux test
          nodal variables = solution->TEMPERATURE as T
          nodal variables = pp->heat_conduction as q
       END RESULTS OUTPUT LABEL diffusion output
       
      END ARIA REGION myRegion
      
   END PROCEDURE myAriaProcedure
   
END SIERRA myJob
