# <Problem_Description>
#
# transient
# chemistry (ChemEQ)
#
# </Problem_Description>

Begin SIERRA Aria VOTD: Class-Model

    Title  Aria Chemistry -class-model

$---------------------------------------------------
$   Define material properties to be used
$---------------------------------------------------
    # Aluminum alloy 2024-T6
    Begin Aria Material aluminum
        Density              = Constant rho = 2770.0 # kg/m^3, at 20 C
        Specific Heat        = Constant cp  = 875.0  # J/kg-K, at 20 C
        Thermal Conductivity = Constant k   = 177.0  # W/mK, at 20 C
        Emissivity           = Constant e   = 0.4
        Heat Conduction      = Basic
    End   Aria Material aluminum

    # Polyurethane foam
    Begin Aria Material foam
        Density              = Constant rho = 150.0   # kg/m^3, at 20 Cs
        Specific Heat        = Constant cp  = 1464.4  # J/kg-K, at 20 C
#       Thermal Conductivity = Constant k   = 0.41862 # W/mK, at 20 C
        Thermal Conductivity = Constant k   = 4.0     # 10x for stability
        Emissivity           = Constant e   = 0.5
        Heat Conduction      = Basic

$---------------------------------------------------
$       Specify ChemEQ material parameters
$---------------------------------------------------
        Begin Parameters for CHEMEQ model foam_reaction_model

            Species Names    = F_SPEC_A   F_SPEC_B
            Species Phases   = CONDENSED  GAS

            Concentration Units = mass_fraction
            Energy release units are per unit mass

            Begin Reaction R1
              Reaction is F_SPEC_A -> F_SPEC_B
              Rate Function = Arrhenius A = 1e14 Ea = 188370 R = 8.314 
              Concentration Function = Standard mu = Automatic
              Heat of Reaction = -4186800 # J/kg
            End
  
        End   Parameters for CHEMEQ model foam_reaction_model
     End   Aria Material foam

    # Stainless steel AISI 304
    Begin Aria Material ssteel304
        Density              = Constant  rho = 7.7500E+03 # kg/m^3, at 20 C
        Specific Heat        = User_Function X = Temperature Name = my_ssteel_cp_function
        Thermal conductivity = user_function X = Temperature Name = my_ssteel_k_function
        Emissivity           = Constant  e = 0.4
        Heat Conduction      = Basic
    End   Aria Material ssteel304

    Begin Aria Material silicone_oil
        Density              = Constant rho = 953.0  # kg/m^3, at 20 C
        Specific Heat        = Constant cp  = 1200.0 # J/kg-K, at 20 C
        Thermal Conductivity = Constant k   = 1.5    # W/mK, at 20 C
        Emissivity           = Constant e   = 0.25
        Heat Conduction      = Basic
    End   Aria Material silicone_oil

    Begin Aria Material ceramic
        Density              = Constant  rho = 2900.0 # kg/m^3, at 20 C
        Specific Heat        = User_Function X = Temperature Name = my_ceramic_cp_function
        Thermal conductivity = user_function X = Temperature Name = my_ceramic_k_function
        Emissivity           = Constant  e = 0.5
        Heat Conduction      = Basic
    End   Aria Material ceramic

$---------------------------------------------------
$   Linear function for ssteel304 cp vs temperature
$---------------------------------------------------
    Begin Definition for Function my_ssteel_cp_function
        Type is Piecewise Linear
        Begin Values
            100.0, 5.02416E+02
            273.15, 5.02416E+02 # J/kg-K at 0 C
            673.15, 5.65218E+02
            3500.0, 5.65218E+02
        End   Values
    End   Definition for Function my_ssteel_cp_function

$---------------------------------------------------
$   Linear function for ssteel304 k vs temperature
$---------------------------------------------------
    Begin Definition for Function my_ssteel_k_function
        Type is Piecewise Linear
        Begin Values
            173.15, 10.8857
            273.15, 13.3978 # W/mK at 0 C
            373.15, 16.3285
            773.15, 21.7714
            973.15, 25.9582
            3500.0, 25.9582
        End   Values
    End   Definition for Function my_ssteel_k_function

$---------------------------------------------------
$   Linear function for ceramic cp vs temperature
$---------------------------------------------------
    Begin Definition for Function my_ceramic_cp_function
        Type is Piecewise Linear
        Begin Values
            1.73150E+02, 5.02416E+02
            2.73150E+02, 9.42030E+02 # J/kg-K at 0 C
            3.73150E+02, 1.28953E+03
            4.73150E+02, 1.50725E+03
            5.73150E+02, 1.65379E+03
            6.73150E+02, 1.76683E+03
            8.73150E+02, 1.90918E+03
            1.07315E+03, 2.03060E+03
            1.77315E+03, 2.19807E+03
            2.82315E+03, 2.57488E+03
            3400.0, 2.6e3
        End   Values
    End   Definition for Function my_ceramic_cp_function

$---------------------------------------------------
$   Linear function for ceramic k vs temperature
$---------------------------------------------------
    Begin Definition for Function my_ceramic_k_function
        Type is Piecewise Linear
        Begin Values
            1.73150E+02, 2.68E+02
            2.73150E+02, 2.67955E+02 # W/mK at 0 C
            3.73150E+02, 1.92593E+02
            4.73150E+02, 1.46538E+02
            6.73150E+02, 8.79228E+01
            8.73150E+02, 5.86152E+01
            1.07315E+03, 3.97746E+01
            1.27315E+03, 2.93076E+01
            1.47315E+03, 2.21900E+01
            1.77315E+03, 1.75846E+01
            1.97315E+03, 1.54912E+01
            2.37315E+03, 1.50725E+01
            3400.0, 15.1
        End   Values
    End   Definition for Function my_ceramic_k_function

$---------------------------------------------------
$   Define global constants
$---------------------------------------------------
    Begin Global Constants
        Stefan Boltzmann Constant = 5.6704e-08 # W/m2-K4
        Ideal Gas Constant        = 8.3143      # kJ/kgmol-K
    End   Global Constants

$-----------------------------------------------------------
$   Define linear solver settings
$   - Conjugate Gradient method with Jacobi preconditioning
$   - 
$-----------------------------------------------------------
    BEGIN TPETRA EQUATION SOLVER solve_temperature_cg
      BEGIN GMRES SOLVER                     
        BEGIN DD-ILU PRECONDITIONER          
        END                                  
        MAXIMUM ITERATIONS = 500             
        CONVERGENCE TOLERANCE = 1.000000e-08
        RESTART ITERATIONS = 500             
      END                                    
    END TPETRA EQUATION SOLVER               

$---------------------------------------------------
$   Specify mesh name and settings
$---------------------------------------------------
    Begin Finite Element Model FEModel
        Database Name = model_coarse_hex.g
#       Database Name = model_med_hex.g

        # center section outer case
        Use Material aluminum for \$
        block_7 block_8 \$
        block_9 block_10 block_31 \$
        block_32 block_33 block_120 block_121 block_122 block_123

        # foam for enclosures
        Use Material foam for block_5

        Use Material silicone_oil for block_4 block_6

        # top and bottom mount = ceramic
        Use Material ceramic for block_1 block_21 block_22

$---------------------------------------------------
$       Choose blocks to omit from analysis
$---------------------------------------------------
        Omit Volume block_11

    End   Finite Element Model FEModel

$--------------------------------------------------------
$   Procedure domain - solution control, region settings
$--------------------------------------------------------

    Begin procedure AriaProcedure

$---------------------------------------------------
$       Define temporal solution parameters
$---------------------------------------------------
        Begin Solution Control Description
            Use System Main
            Begin System Main
                Simulation Start Time       = 0.0
                Simulation Termination Time = 2500.0
                Begin Transient solution_block_1
                    Advance AriaRegion
                End   Transient solution_block_1
            End   System Main
   
$---------------------------------------------------
$           Specify time integration settings
$---------------------------------------------------
            Begin Parameters for Transient solution_block_1
                Start Time       = 0.0    # seconds
                Termination Time = 2500.0 # seconds
                Begin Parameters for Aria Region AriaRegion
                    Time Step Variation     = Adaptive
                    Time Integration Method = Second_Order
                    Initial Time Step Size = 0.004  # seconds
                    Minimum Time Step Size = 0.0001 # seconds
                    Maximum Time Step Size = 20.0   # seconds
                    Predictor-Corrector Tolerance = 0.01 # seconds
                    Limit Solution Increment Temperature =  20.0 # K
                End   Parameters for Aria Region AriaRegion
            End   Parameters for Transient solution_block_1
        End   Solution Control Description

$------------------------------------------------------
$       Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------

        Begin Aria Region AriaRegion

$---------------------------------------------------
$           Specify which linear solver to use
$---------------------------------------------------
            Use Linear Solver solve_temperature_cg

$---------------------------------------------------
$           Define nonlinear solver parameters
$---------------------------------------------------
            Nonlinear Solution Strategy  = Newton
            Nonlinear Residual Tolerance = 1.0e-6
            Maximum Nonlinear Iterations = 10
            Nonlinear Relaxation Factor  = 1.0 # default

            Use DOF Averaged Nonlinear Residual

$-----------------------------------------------------------
$           Specify which mesh model to use for this region
$-----------------------------------------------------------
            Use Finite Element Model FEModel

$-----------------------------------------------------------
$           Define mesh groups for use with ICs and BCs
$-----------------------------------------------------------
            mesh group reacting_foam = block_5
            mesh group other_blocks = all_blocks - reacting_foam

$---------------------------------------------------
$           Specify equations to solve
$---------------------------------------------------
            EQ Energy for Temperature on other_blocks using Q1 with Diff Lumped_Mass
            EQ Energy for Temperature on reacting_foam using Q1 with Diff Lumped_Mass Src

$---------------------------------------------------
$           Specify initial conditions
$---------------------------------------------------
            Begin Initial Condition IC_block
                Temperature = 300.0 # K
                All Volumes
            End   Initial Condition IC_block

$---------------------------------------------------
$           Specify boundary conditions
$---------------------------------------------------
            # Driving heat flux into problem (constant)
            Begin Heat Flux Boundary Condition hot_bath
                Add Surface surface_1211
                Flux = 100000. # W/m^2
            End   Heat Flux Boundary Condition hot_bath

            # Stabilize model with Dirichlet
            Begin Temperature Boundary Condition surface_temp_1
                Add Surface surface_101
                Temperature = 325.0 # K
            End   Temperature Boundary Condition surface_temp_1

$---------------------------------------------------
$           Define volumetric heating sources
$---------------------------------------------------
            Source for Energy on reacting_foam = ChemEQ_Heating

$---------------------------------------------------
$           Set ChemEQ solver parameters
$---------------------------------------------------
            Begin CHEMEQ Solver for foam_reaction_model

                ODE Solver = CVODE ADAMS 12 FUNCTIONAL
                Absolute Tolerance = 1e-10
                Relative Tolerance = 1e-4
                Maximum Substeps = 100000

                Activation Temperature = 350.0 # K
                Deactivation Temperature = 950 continue # K

                # Set the initial concentration values
                Species F_SPEC_A = 1.0 # all foam to start with
                Species F_SPEC_B = 0.0 # default = none
            End   CHEMEQ Solver for foam_reaction_model

$-------------------------------------------------------
$           Define additional variables to post-process
$-------------------------------------------------------
            Postprocess Heat_Conduction on all_blocks
            Postprocess Energy_Source on reacting_foam

$---------------------------------------------------
$           Define contents of binary plot file
$---------------------------------------------------
            Begin Results Output AriaOutput
                Title Aria: Chemistry class-model
                Database Name = chemistry.e
                Nodal Variables   = Solution->Temperature as T
                Element Variables = F_SPEC_A as FR_SPEC_A
                Element Variables = F_SPEC_B as FR_SPEC_B
                Nodal Variables   = PP->Heat_Conduction as q
                Nodal Variables   = PP->Energy_Source as Src
                At Step 0 Interval = 5
            End   Results Output AriaOutput

        End   Aria Region AriaRegion

    End   Procedure AriaProcedure

End   SIERRA Aria VOTD: Class-Model

