begin sierra Concentric_Spheres
  Begin Global Constants
    Stefan Boltzmann Constant = 5.67e-8 # W/m^2-K^4
  End Global Constants

  Begin Aria Material a
    absorption cross section     = Constant abs   = 5.0
    scattering cross section     = Constant scat  = 0.0
    radiation source             = Black_Body
    density                      = Constant rho = 1.0
    specific heat                = Constant cp  = 1.0
    heat conduction              = Basic
    thermal conductivity         = Constant k   = 1.0
  End

  Begin Aria Material b
    density                      = Constant rho = 1.0
    specific heat                = Constant cp  = 1.0
    heat conduction              = Basic   
    thermal conductivity         = Constant k   = 1.0
  End

  Begin Aria Material wall_a
    emissivity                   = Constant e = 0.6
    transmissivity               = Constant t = 0.4
    bc environment temperature   = Constant T = 1000.0
  End

  Begin Aria Material wall_b   
    emissivity                   = Constant e = 0.6
    transmissivity               = Constant t = 0.4
    irradiation                  = FROM_MPMD_FIELD
    bc environment temperature   = Constant T = 0.0
  End


  BEGIN TPETRA EQUATION SOLVER  GMRES_ILUT
    BEGIN GMRES SOLVER
      BEGIN DD-ILUT PRECONDITIONER
        DROP TOLERANCE = 1.000000e-08
        FILL FRACTION = 2.000000e+00
        SUBDOMAIN OVERLAP LEVEL = 2
      END
      MAXIMUM ITERATIONS = 500
      CONVERGENCE TOLERANCE = 1.000000e-08
      RESTART ITERATIONS = 500
    END
  END TPETRA EQUATION SOLVER

  Begin Finite Element Model Spheres
    Database Name        = pmr_test_coarse.g
    Decomposition Method = rcb
    Coordinate System = Cartesian
    Begin Parameters for Block block_1
      Material a
    End
    Begin Parameters for Block block_2
      Material b
    End
    Begin Parameters for surface surface_1
      Material wall_a
    End
    Begin Parameters for surface surface_2
      Material wall_b
    End
  End


  Begin Procedure The_Procedure 
    Begin Solution Control Description
      Use System Main
      Begin System Main
        Begin Sequential MySolveBlock
          Advance The_Region
        End
      End
    End
    Begin Aria Region The_Region
      Begin MPMD Coupling
        Coupling Type is Radiation
        Begin Radiation Coupling
          ITERATIONS PER RADIATION SOLVE is 2
        End Radiation Coupling
      End MPMD Coupling
     
      Use Finite Element Model Spheres
      Use Linear Solver gmres_ilut

      Nonlinear Solution Strategy  = Newton
      Maximum Nonlinear Iterations = 1000
      Nonlinear Residual Tolerance = 1.0e-6
      Nonlinear Correction Tolerance = 1.0e-3
      Nonlinear Correction Scaling = dof_amax


      EQ Radiation_Transport For rte_scalar_flux On Block_1 Using Q1 With xfer

      EQ Energy For Temperature On block_1 Using Q1 With Diff Src
      Source For Energy On block_1 = RTE_FIELD
      BC Const Dirichlet At surface_1 Temperature = 1000.0
      postprocess average of expression temperature on surface_2 touching block_1 as shell_avg_temperature
  
      IC for Temperature on all_blocks = Constant value = 300

      BC Flux for Energy on surface_2 = Generalized_Rad

      Postprocess Integrated_Flux of equation Energy on surface_2 as total_energy

      Begin Results Output Label The_Output
        Database Name = output.e
        At Step 0, Increment is 1
        Title Aria Concentric Sphere Radiation
        Global Variables = shell_avg_temperature
        Global Variables = total_energy
        Nodal Variables = solution->Temperature as T
        Nodal Variables = solution->rte_scalar_flux as G
        Nodal Variables = rte_incident_flux as I
        Nodal Variables = rte_radiative_flux as Q
      End

     Begin Heartbeat The_Heartbeat
       Stream Name = heartbeat_shell_avg.txt
       Timestamp Format = "" # Omit time stamps for diffing purposes.
       Precision = 3
       At Step 0 increment = 1
       Variable = Global time as t
       Variable = Global shell_avg_temperature
     End
      
    End Aria Region The_Region  
  End Procedure The_Procedure
end sierra Concentric_Spheres
