# <Problem_Description>
#
# multiple enclosures
# radiative flux boundary condition
# heat flux boundary condition
# nonlinear tabular material properties
# transient
#
# </Problem_Description>

Begin SIERRA Aria VOTD: Class-Model

    Title Aria Enclosure Radiation class-model

$---------------------------------------------------
$   Define material properties to be used
$---------------------------------------------------
    # Aluminum alloy 2024-T6
    Begin Aria Material aluminum
        Density              = Constant rho = 2770.0  # kg/m^3, at 20 C
        Specific Heat        = Constant cp  = 875.0   # J/kg-K, at 20 C
        Thermal Conductivity = Constant k   = 177.0   # W/mK, at 20 C
        Emissivity           = Constant value = 0.2
        Heat Conduction      = Basic
    End   Aria Material aluminum

    # Stainless steel AISI 304
    Begin Aria Material ssteel304
        Density              = Constant  rho = 7.7500E+03 # kg/m^3, at 20 C
        Specific Heat        = User_Function  X = Temperature  Name = my_ssteel_cp_function
        Thermal Conductivity = User_Function  X = Temperature  Name = my_ssteel_k_function
        Emissivity           = Constant value = 0.2
        Heat Conduction      = Basic
    End   Aria Material ssteel304

    Begin Aria Material Air # Units in mks
       Density		   = Constant Rho = 1.   # kg/m^3
       Specific Heat	   = Constant Cp = 1000. # J/kg-K
       absorption coefficient = constant k = 0.1
    End

$---------------------------------------------------
$   Linear function for ssteel304 cp vs temperature
$---------------------------------------------------
    Begin Definition for Function my_ssteel_cp_function
        Type is Piecewise Linear
        Begin Values
            100.0, 5.02416E+02
            273.15, 5.02416E+02 # J/kg-K at 0 C
            673.15, 5.65218E+02
            3500.0, 5.65218E+02
        End   Values
    End   Definition for Function my_ssteel_cp_function

$---------------------------------------------------
$   Linear function for ssteel304 k vs temperature
$---------------------------------------------------
    Begin Definition for Function my_ssteel_k_function
        Type is Piecewise Linear
        Begin Values
            173.15, 10.8857
            273.15, 13.3978 # W/mK at 0 C
            373.15, 16.3285
            773.15, 21.7714
            973.15, 25.9582
            3500.0, 25.9582
        End   Values
    End   Definition for Function my_ssteel_k_function

$---------------------------------------------------
$   Define global constants
$---------------------------------------------------
    Begin Global Constants
        Stefan Boltzmann Constant = 5.67e-08 # W/m2-K4
    End   Global Constants

$-----------------------------------------------------------
$   Define linear solver settings
$   - Conjugate Gradient method with Jacobi preconditioning
$   - 
$-----------------------------------------------------------
    BEGIN TPETRA EQUATION SOLVER solve_temperature
      BEGIN PRESET SOLVER
        SOLVER TYPE = THERMAL_SYMMETRIC
      END
    END

$---------------------------------------------------
$   Specify mesh name and settings
$---------------------------------------------------
    Begin Finite Element Model FEModel

        # External mesh file to be used
        Database Name = model_coarse_hex.g

        # center section outer case
        Use Material aluminum for \$
        block_1 block_21 block_22\$
        block_7 block_8 block_9 block_10\$
        block_31 block_33\$
        block_32 block_120 block_121 block_122 block_123

$---------------------------------------------------
$       Choose blocks to omit from analysis
$---------------------------------------------------
        Omit Volume block_4 block_5 block_6 block_11

    End   Finite Element Model FEModel

$--------------------------------------------------------
$   Procedure domain - solution control, region settings
$--------------------------------------------------------

    Begin Procedure AriaProcedure

$---------------------------------------------------
$       Define temporal solution parameters
$---------------------------------------------------
        Begin Solution Control Description
            Use System Main
            Begin System Main
                Simulation Start Time       = 0.0
                Simulation Termination Time = 40.0
                Begin Transient solution_block_1
                    Advance AriaRegion
                End   Transient solution_block_1
            End   System Main
   
$---------------------------------------------------
$           Specify time integration settings
$---------------------------------------------------
            Begin Parameters for Transient solution_block_1
                Start Time       = 0.0    # seconds
                Termination Time = 40.0   # seconds
                Begin Parameters for Aria Region AriaRegion
                    Time Step Variation     = Adaptive
                    Time Integration Method = BDF2
                    Initial Time Step Size = 0.05   # seconds
                    Minimum Time Step Size = 0.01   # seconds
                    Maximum Time Step Size = 20.0   # seconds
                    Predictor-Corrector Tolerance = 0.01 # seconds
                    Limit Solution Increment Temperature =  20.0 # K
                End   Parameters for Aria Region AriaRegion
            End   Parameters for Transient solution_block_1
        End   Solution Control Description

$------------------------------------------------------
$       Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------

        Begin Aria Region AriaRegion

$---------------------------------------------------
$           Specify which linear solver to use
$---------------------------------------------------
            Use Linear Solver solve_temperature

$---------------------------------------------------
$           Define nonlinear solver parameters
$---------------------------------------------------
            Nonlinear Solution Strategy  = Newton
            Nonlinear Residual Tolerance = 1.0e-6
            Maximum Nonlinear Iterations = 4
            Nonlinear Relaxation Factor  = 1.0 # default

$-----------------------------------------------------------
$           Specify which mesh model to use for this region
$-----------------------------------------------------------
            Use Finite Element Model FEModel

$-----------------------------------------------------------
$           Specify the bulk fluid element
$-----------------------------------------------------------
            BEGIN BULK FLUID ELEMENT pmr
               CALCULATE VOLUME FROM ENCLOSING SURFACE
               Material = Air
               Initial Temperature = 300.0
               bulk eq energy for temperature using p0 with mass
            END            

$---------------------------------------------------
$           Specify equations to solve
$---------------------------------------------------
            EQ Energy for Temperature on all_blocks using Q1 with Diff Lumped_Mass

$---------------------------------------------------
$           Specify initial conditions
$---------------------------------------------------
            IC for temperature on all_blocks = constant value = 300.0 # K

$---------------------------------------------------
$           Specify boundary conditions
$---------------------------------------------------
            # Driving heat flux into problem (constant)
            Mesh group heated_surfs = surface_1201 surface_1221 surface_903 surface_1002 surface_802
            BC Flux for energy on heated_surfs = constant value = -720000. # W/m2

            # Radiation to far-field
            Mesh group rad_surfs = surface_701 surface_801
            BC Flux for Energy on rad_surfs = Generalized_Rad  T_ref = 273.0

$---------------------------------------------------
$           Define enclosure radiation settings
$---------------------------------------------------
            # Viewfactor calculation parameters
            Begin Viewfactor Calculation vf_hemicube
                Compute Rule = HEMICUBE # default
            End 

            # Viewfactor smoothing parameters
            Begin Viewfactor Smoothing vf_smooth
                Method = LEAST-SQUARES
            End

            # Radiosity solution solver parameters
            Begin Radiosity Solver rad_solver
                Coupling = MASON 
                Solver = CHAPARRAL CG 
                Convergence Tolerance = 1e-06
                Maximum Iterations = 200
            End

            # Definition for Enclosure 1
            Begin Enclosure Definition cavity_1
                Add Surface surface_401 surface_402
                Add surface surface_403 surface_404

                Use Viewfactor Calculation vf_hemicube
                Use Viewfactor Smoothing vf_smooth
                Use Radiosity Solver rad_solver
            End

            # Definition for Enclosure 3
            Begin Enclosure Definition cavity_3
                Add Surface surface_601 surface_602
                Add surface surface_603 surface_604

                Use Viewfactor Calculation vf_hemicube
                Use Viewfactor Smoothing vf_smooth
                Use Radiosity Solver rad_solver
                
                mean beam length = from_geometry prefactor = 3.6
                activate mean beam model with bulk node pmr
            End   Enclosure Definition cavity_3

$---------------------------------------------------
$           Define contents of binary plot file
$---------------------------------------------------
            Begin Results Output AriaOutput
                Title Aria: Enclosure Radiation class-model
                Database Name = enclrad.e
                Nodal Variables = Solution->Temperature as T
                At Step 0 Interval = 1
            End   Results Output AriaOutput

        End   Aria Region AriaRegion

    End   Procedure AriaProcedure

End   SIERRA Aria VOTD: Class-Model

