
# Inner diameter = { D = 0.12 } m

begin sierra bar_ref_temp_test

   begin definition for function bar_area
      scale by 1.0
      type = piecewise linear
      begin values
         -1.   {PI/4*D^2}
          1.   {PI/4*D^2}
      end values
   end

   begin definition for function bar_hydraulic_diameter
      scale by 1.0
      type = piecewise linear
      begin values
         -1.   {D}
          1.   {D}
      end values
   end

  begin definition for function air_density
      type = piecewise linear
      begin values
{NOECHO} { _T = 200}
{loop(12)}
{NOECHO}      { _T = _T + 25}
{ECHO}        {_T}  {101325*28/(8314*_T)}
{endloop}
      end values
  end definition for function air_density

  begin aria material ssteel304
    density              = constant rho = 100.0
    specific heat        = constant  cp = 10.0
    thermal conductivity = constant   k = 10.0
    heat conduction = basic
  end aria material ssteel304

  BEGIN Aria MATERIAL Air
    Viscosity            = constant value = 1e-5
    density              = user_function name = air_density   X = temperature
    specific heat        = constant value = 1000
    thermal conductivity = constant value = 0.04
    bar area             = user_function name = bar_area X = bar_coordinate
    heat conduction = basic
    Advection Velocity = bar
  END Aria MATERIAL Air

###################################################

  begin finite element model fem

    database name = pipe.g
    database type = exodusII
    decomposition method = rcb

    use material ssteel304 for pipe
    use material Air for bar

  end finite element model fem

################################################
############### Linear Solver ##################
################################################

  BEGIN TPETRA EQUATION SOLVER  trilinos_solve
    BEGIN PRESET SOLVER
      SOLVER TYPE = MULTIPHYSICS
    END
  END

#######################################################
##################### procedure #######################
#######################################################

  begin procedure aria_procedure

#######################################################
############### solution control description Block ####
#######################################################

    begin solution control description

      Use System main

      Begin System main

        Simulation Start Time = 0.0
        Simulation Termination Time = 5.0
        simulation max global iterations = 100000

        Begin Transient time_stepping_block
            Advance myRegion
        End

      End System main

      begin parameters for transient time_stepping_block
        start time = 0.0
        termination time = 5.0
        initial deltat = 0.025
        begin parameters for aria region myRegion
            maximum time step size = 0.1
            minimum time step size = 0.001
            fail time step when time step size ratio is below 0.0
            time integration method = BDF2
            predictor-corrector tolerance = 1.0e-3
            initial time step size = 0.025
            time step variation = adaptive
        end parameters for aria region myRegion
      end parameters for transient time_stepping_block

    end solution control description

#######################################################
#################### ARIA Region ####################
#######################################################

    begin aria region myRegion

      use finite element model fem

      nonlinear solution strategy = newton
      use dof averaged nonlinear residual
      use linear solver trilinos_solve
      nonlinear relaxation factor = 1.00

      nonlinear residual tolerance = 1.0e-8
      maximum nonlinear iterations = 20

      EQ ENERGY for TEMPERATURE on pipe using Q1  with Diff Lumped_mass
      EQ ENERGY for TEMPERATURE on bar using Q1P0 with Diff Lumped_mass Adv SUPG 

      IC for temperature on pipe = constant value = 300
      IC for temperature on bar = constant value = 500

      Advection Velocity for Energy = advection_Velocity

      BC Dirichlet for temperature on outer_surface = constant value = 300
      BC Dirichlet for temperature on bar_inlet = constant value = 500

      BC Bar_Flux for energy on inner_surface = generalized_nat_conv bar=airBar h=500.0

      Begin Advective Bar Network airBar
         add volume bar
         initial temperature = 300
         MASS FLOW RATE AT bar_inlet = 0.1 # kg/s

         coordinate reference = bar_inlet component z
         fluid density function = air_density
         hydraulic diameter function = bar_hydraulic_diameter
         flow cross sectional area function = bar_area
      end

      Begin Results Output NodalTdata
        Title Advective Bar With Bulknode Thermal Solution
        database name = %B.e
        Nodal Variables = solution->temperature as T
        at step 0 increment is 1
      End

    end aria region myRegion

  end procedure aria_procedure

end sierra bar_ref_temp_test
