# Problem Setup:
# T_foam_0 = {T_foam_0 = 300}
# P_foam_0 = {P_foam_0 = 101325}

Begin Sierra myJob

  ################################################
  ############ Finite Element Model ##############
  ################################################

  BEGIN DEFINITION FOR FUNCTION upright_150_rate
     type is piecewise linear
     begin values
       #t(s)     T (K) v1
       0  303.42
       10  303.44
       20  303.57
       30  303.99
       40  304.84
       50  306.87
       60  310.45
       70  316.25
       80  324.27
       90  334.42
       100  344.65
       110  357.25
       120  373.91
       130  393.47
       140  415.67
       150  439.88
       160  465.69
       170  493.44
       180  522.55
       190  552.74
       200  583.98
       210  616.09
       220  646.54
       230  674.56
       240  701.63
       250  729.12
       260  756.83
       270  782.52
       280  807
       290  832.69
       300  859.51
       310  886.39
       320  912.85
       330  939.82
       340  967.68
       350  995.19
       360  1021.74
       370  1047.23
       380  1072.78
       390  1098.29
       400  1115.86
       410  1124.91
       420  1128.94
       430  1130.06
       440  1128.78
       450  1125.65
       460  1120.87
       470  1115.26
       480  1110.08
       490  1107.44
       500  1106.96
       510  1106.19
       520  1104.24
       530  1101.59
       540  1099.19
       550  1097.77
       560  1097.57
       570  1097.1 
       580  1096.25
       590  1094.92
       600  1093.68
       610  1093.13
       620  1092.81
       630  1092.43
       640  1091.98
       650  1091.32
       660  1090.73
       670  1090.33
       680  1090.01
       690  1089.74
       700  1089.39
       710  1089.13
       720  1088.76
       730  1088.44
       740  1088.19
       750  1087.91
       760  1087.62
       770  1087.36
       780  1087.08
       790  1086.86
       800  1086.59
       810  1086.35
       820  1086.17
       830  1085.97
       840  1085.73
       850  1085.42
       860  1085.25
       870  1085.02
       880  1084.76
       890  1084.52
       900  1084.32
       910  1084.12
       920  1083.97
       930  1083.73
       940  1083.52
       950  1083.28
       960  1083.06
     end values
  END DEFINITION FOR FUNCTION upright_150_rate

  Begin Finite Element Model all
    Database Name = fic_2d_axisym_old.g
    Coordinate System Is axisymmetric
    Use Material 304ss For block_20  # Top plate
    Use Material 304ss For block_30  # Bottom plate
    Use Material 304ss For block_40  # Slug
    Use Material pmdifoam_aria_PF_20lbs For block_50   # Foam
    decomposition method = rib
  End Finite Element Model all


  ################################################
  ############ Solvers ###########################
  ################################################
  BEGIN TPETRA EQUATION SOLVER multiphysics
    BEGIN PRESET SOLVER
      SOLVER TYPE = MULTIPHYSICS
    END
  END

  ################################################
  ############ Material Data & Params ############
  ################################################

  Begin Global Constants
    Stefan Boltzmann Constant = 5.670373e-8
  end Global Constants

  Begin Aria Material 304SS  # 304 Stainless Steel, Isotropic 
        Density              = constant  rho = 7901.  # [kg/m^3]
        Thermal Conductivity = user_function  name=f_steelcond X=Temperature  # [W/m-K]
        Specific Heat        = user_function  name=f_steelspheat X=Temperature  # [J/kg-K]
        Emissivity           = constant  e=0.8
        Heat Conduction = basic                                                 
        gap_conductance_coefficient = constant H = 10000.0
  end Aria Material 304SS  # 304 Stainless Steel, Isotropic 

  Begin Aria Material 321SS  # Copy properties from 304SS
        Density              = constant  rho = 7901.  # [kg/m^3]
        Thermal Conductivity = user_function  name=f_steelcond X=Temperature  # [W/m-K]
        Specific Heat        = user_function  name=f_steelspheat X=Temperature  # [J/kg-K]
        Emissivity           = constant  e=0.8
        Heat Conduction = basic
        gap_conductance_coefficient = constant H = 10000.0
  end Aria Material 321SS  # Copy properties from 304SS

  Begin Definition for Function f_steelcond  # AISI-304 stainless steel conductivity
    Type is PIECEWISE LINEAR
    Begin Values
      #Temperature    Conductivity (W/mK) from W.Gill
      50.0            14.5
      300.0           14.5     
      330.0           15      
      344.5           15.33
      372.8           15.77
      415.5           16.68
      470.1           17.56
      511.7           18.26
      562.2           19.17
      606.5           19.97
      743.1           22.2
      783.2           22.91
      840.6           23.91
      880.1           24.6
      2000.0          24.6     # Extrapolated value
   End Values
  End Definition for Function f_steelcond

  Begin Definition for Function f_steelspheat  # AISI-304 stainless steel specific heat 
    Type is PIECEWISE LINEAR
    Begin Values
      #Temperature    Specific Heat (J/kgK) from W.Gill
      50.0            460.31 
      273.5           460.31   
      293.3           472.86
      300.3           477.05
      350.3           497.97
      400.3           514.71
      450.3           527.26
      500.3           539.82
      550.3           548.19
      600.3           556.56
      650.3           564.92
      700.3           569.11
      750.3           577.48
      800.3           581.66
      850.3           585.85
      900.3           594.22
      950.3           602.59
      1000.3          610.96
      1100.3          623.51
      1200.3          640.25
      1300.3          652.8
      1400.3          665.36
      1500.3          682.09
    End Values
  End Definition for Function f_steelspheat
  
  
################################
## Can Thermal boundary Properties  
# conv_coeff   = { conv_coeff   = 10.}
# emis_can     = { emis_can    = 0.8}
################################

###############################################################
##    Porous Media Flow & Vapor-Liquid Equlibrium PMDI 20lbs  
############################################################### 
  # Sarah N. Scott, Modeling Heat Transfer and Pressurization of Polymeric Methylene Diisocyanate (PMDI) Polyurethane Foam in a Sealed Container
  # SAND2018-0171 Printed January 2018
  
# MW_LMWO_20_pmdi          = { MW_LMWO_20_pmdi           =  85e-3}
# MW_HMWO_20_pmdi          = { MW_HMWO_20_pmdi           =  113e-3}
# MW_CO2_20_pmdi           = { MW_CO2_20_pmdi            = 44e-3 }   
# MW_foam_20_pmdi          = { MW_foam_20_pmdi           = 1e2 }

  Begin Aria Material pmdifoam_aria_PF_20lbs
    volumetric_heat_transfer_coefficient = constant  h=1.E5
    Emissivity = constant  e=0.7

    gap_conductance_coefficient = constant H = 10000.0

    Begin Material Phase gas_phase

      SPECIES NAMES = CO2 LMWO HMWO
      gap_conductance_coefficient = constant H = 10000.0

      density = general_ideal_gas_extract_average_pressure  R=8.314472
      velocity = darcy  GX=0. GY=-9.81 GZ=0.
      relative_permeability = Constant  K=1.

      specific_heat = constant  cp=1000.  # [J/kg-K]

      viscosity     = constant  mu=2.0e-5

      specific heat of CO2  = constant cp=1000
      specific heat of LMWO = constant cp=1000
      specific heat of HMWO = constant cp=1000

      molecular_weight of CO2     = constant  M={MW_CO2_20_pmdi }   # units: kg/mol
      molecular_weight of LMWO    = constant  M={MW_LMWO_20_pmdi}  # units: kg/mol
      molecular_weight of HMWO    = constant  M={MW_HMWO_20_pmdi}  # units: kg/mol

      mass_diffusivity of CO2     = chapman_enskog  D0=2.0e-5 P0=101325 T0=300
      mass_diffusivity of LMWO    = chapman_enskog  D0=2.0e-5 P0=101325 T0=300
      mass_diffusivity of HMWO    = chapman_enskog  D0=2.0e-5 P0=101325 T0=300
      mixture_mass_diffusivity = mixture_average

      bulk_mass_density         = porous_density                # d(phi*rho)/dt term
      bulk_mass_density of CO2  = mass_fraction_porous_density  # d(phi*rho*Y_i)/dt term
      bulk_mass_density of LMWO = mass_fraction_porous_density  # d(phi*rho*Y_i)/dt term
      bulk_mass_density of HMWO = mass_fraction_porous_density  # d(phi*rho*Y_i)/dt term

      # Species densities for chemistry module
      species of CO2     = from_mass_fraction
      species of LMWO    = from_mass_fraction
      species of HMWO    = from_mass_fraction


      mass balance advective flux of LMWO     = porous_upwind  # d(rho*u_j*Y_i)/dx_j term
      mass balance advective flux of HMWO     = porous_upwind  # d(rho*u_j*Y_i)/dx_j term


      mass_balance_diffusive_flux of LMWO     = porous  # d(q_j)/dx_j term
      mass_balance_diffusive_flux of HMWO     = porous  # d(q_j)/dx_j term



      transported_enthalpy = porous                          # d(phi*rho*h)/dt term
      enthalpy_advection   = porous_upwind                          # d(mdot*h)/dx term
      heat_conduction      = porous_simplified_diffusive_enthalpy_flux  # d(q)/dx term
    end Material Phase gas_phase

    Begin Material Phase solid_phase
      SPECIES NAMES = FoamA FoamB FoamC Char

      molecular_weight of FoamA = constant M={MW_foam_20_pmdi}
      molecular_weight of FoamB = constant M={MW_foam_20_pmdi}
      molecular_weight of FoamC = constant M={MW_foam_20_pmdi}
      molecular_weight of Char  = constant M={MW_foam_20_pmdi}



      intrinsic_permeability_scaling of FoamA = user_function name = pmdi20lb_PM_foamperm X = solid_phase_temperature
      intrinsic_permeability_scaling of FoamB = user_function name = pmdi20lb_PM_foamperm X = solid_phase_temperature
      intrinsic_permeability_scaling of FoamC = user_function name = pmdi20lb_PM_foamperm X = solid_phase_temperature

      intrinsic_permeability_scaling of Char  = T_Exponent  K_ref={10**-7.1093273117} T_ref={300.} n=0.0
      intrinsic_permeability of FoamA = constant  XX=1.0 YY=1.0 ZZ=1.0
      intrinsic_permeability of FoamB = constant  XX=1.0 YY=1.0 ZZ=1.0
      intrinsic_permeability of FoamC = constant  XX=1.0 YY=1.0 ZZ=1.0

      intrinsic_permeability of Char  = constant  XX=1.0 YY=1.0 ZZ=1.0
      intrinsic_permeability = volume_average

      specific_heat of FOAMA = user_function x = solid_phase_temperature name= pmdi20lb_PM_cpfoam
      specific_heat of FOAMB = user_function x = solid_phase_temperature name= pmdi20lb_PM_cpfoam
      specific_heat of FOAMC = user_function x = solid_phase_temperature name= pmdi20lb_PM_cpfoam
      specific_heat of CHAR  = user_function x = solid_phase_temperature name= pmdi20lb_PM_cpfoam

      specific_heat = mass_average  # Only used for post-processing

      enthalpy = mass_average

      bulk_conductivity of FOAMA = user_function  name = pmdi20lb_PM_Ksolid  X = solid_phase_temperature 
      bulk_conductivity of FOAMB = user_function  name = pmdi20lb_PM_Ksolid  X = solid_phase_temperature
      bulk_conductivity of FOAMC = user_function  name = pmdi20lb_PM_Ksolid  X = solid_phase_temperature
      bulk_conductivity of Char = user_function  name = pmdi20lb_PM_Kchar  X = solid_phase_temperature
      bulk_conductivity = volume_average   

      radiative_conductivity of FoamA = Optically_Thick  n=1.0 beta_r=1990
      radiative_conductivity of FoamB = Optically_Thick  n=1.0 beta_r=1990
      radiative_conductivity of FoamC = Optically_Thick  n=1.0 beta_r=1990

      #to try to mimic temperature only FIC runs to increase radiation as decomp occurs
      radiative_conductivity of Char  = Optically_Thick  n=1.0 beta_r=226.31795187
      radiative_conductivity = volume_average

      thermal_conductivity = summed  contributions="bulk_conductivity radiative_conductivity"

      #  rhob0_20_pmdi = { rhob0_20_pmdi = 20*16.01846 } - 20lb/ft^3 converted to kg/m^3
      bulk_density of FoamA = T_Exponent  rho_ref={rhob0_20_pmdi} T_ref={304.2} n=0.0
      bulk_density of FoamB = T_Exponent  rho_ref={rhob0_20_pmdi} T_ref={304.2} n=0.0
      bulk_density of FoamC = T_Exponent  rho_ref={rhob0_20_pmdi} T_ref={304.2} n=0.0
      bulk_density of Char  = T_Exponent  rho_ref=64. T_ref={304.2} n=0.0


      # SolidRho_foam_20_pmdi    = { SolidRho_foam_20_pmdi     = 1500. } 
      # SolidRho_char_20_pmdi    = { SolidRho_char_20_pmdi     = 1500. }
      solid_density of FoamA = constant  rho_solid={SolidRho_foam_20_pmdi}
      solid_density of FoamB = constant  rho_solid={SolidRho_foam_20_pmdi}
      solid_density of FoamC = constant  rho_solid={SolidRho_foam_20_pmdi}
      solid_density of Char  = constant  rho_solid={SolidRho_char_20_pmdi}

      volume fraction of FoamA = from_mass_fraction
      volume fraction of FoamB = from_mass_fraction
      volume fraction of FoamC = from_mass_fraction
      volume fraction of Char = from_mass_fraction

      porosity = one_minus_volume_fractions

      bulk_mass_density           = density                # d(rho)/dt term
      bulk_mass_density of FoamA  = mass_fraction_density  # d(rho*Y_i)/dt term
      bulk_mass_density of FoamB  = mass_fraction_density  # d(rho*Y_i)/dt term
      bulk_mass_density of FoamC  = mass_fraction_density  # d(rho*Y_i)/dt term
      bulk_mass_density of Char   = mass_fraction_density  # d(rho*Y_i)/dt term

      # Species densities for use by chemistry module
      species of FoamA = from_mass_fraction
      species of FoamB = from_mass_fraction
      species of FoamC = from_mass_fraction
      species of Char  = from_mass_fraction

      transported_enthalpy = standard        # d(rho*h)/dt term
      heat_conduction      = fouriers_law    # d(q)/dx term
    end Material Phase solid_phase

##################################################################
## Reaction Module
##################################################################
       # gasorg_20_pmdi           = { gasorg_20_pmdi            = 3.7096743545e-01 }   
       # E1_20_pmdi               = { E1_20_pmdi                = 179441062}
       # E2_20_pmdi               = { E2_20_pmdi        = 179441062 }
       # E3_20_pmdi               = { E3_20_pmdi        = 179441062 }
       # A1_20_pmdi               = { A1_20_pmdi        = 8.077e+12 }
       # A2_20_pmdi               = { A2_20_pmdi        = 1.79e+11  }
       # A3_20_pmdi               = { A3_20_pmdi        = 8906000000  }
       # DeltaH1_20_pmdi          = { DeltaH1_20_pmdi   = 0.}
       # DeltaH2_20_pmdi          = { DeltaH2_20_pmdi   = 0.}
       # DeltaH3_20_pmdi          = { DeltaH3_20_pmdi   = 0.}
    BEGIN general chemistry foam_decomp
    
    
      Species Names  = FoamA FoamB FoamC Char CO2 LMWO HMWO
      Species Phases = solid_phase solid_phase solid_phase solid_phase gas_phase gas_phase gas_phase

      Species Variable Name = species

      Begin Reaction FoamA
        Reaction is {1./MW_foam_20_pmdi} FoamA -> {1./MW_CO2_20_pmdi * 0.56} CO2 + {1./MW_LMWO_20_pmdi * (0.44-gasorg_20_pmdi)} LMWO + {1./MW_foam_20_pmdi * (0+gasorg_20_pmdi)} Char
        Concentration Function = Standard mu = 1. 0. 0. 0. 0. 0. 0. 

        Rate Function = Arrhenius A={MW_foam_20_pmdi * A1_20_pmdi} Ea={E1_20_pmdi} R=8314.
        Heat of Reaction = {DeltaH1_20_pmdi}
        Temperature Phase = solid_phase
      End

      Begin Reaction FoamB
        Reaction is {1./MW_foam_20_pmdi} FoamB -> {1./MW_HMWO_20_pmdi * (1-2*gasorg_20_pmdi)} HMWO + {1./MW_foam_20_pmdi * (2*gasorg_20_pmdi)} Char
        Concentration Function = Standard mu = 0. 1. 0. 0. 0. 0. 0.

        Rate Function = Arrhenius A={MW_foam_20_pmdi * A2_20_pmdi} Ea={E2_20_pmdi} R=8314.
        Heat of Reaction = {DeltaH2_20_pmdi}
        Temperature Phase = solid_phase
      End

      Begin Reaction FoamC
        Reaction is {1./MW_foam_20_pmdi} FoamC -> {1./MW_foam_20_pmdi * (0.5+gasorg_20_pmdi)} Char + {1./MW_HMWO_20_pmdi * (0.5-gasorg_20_pmdi)} HMWO
        Concentration Function = Standard mu = 0. 0. 1. 0. 0. 0. 0.

        Rate Function = Arrhenius A={MW_foam_20_pmdi*A3_20_pmdi} Ea={E3_20_pmdi} R=8314.
        Heat of Reaction = {DeltaH3_20_pmdi}
        Temperature Phase = solid_phase
      End

    END    
  End Aria Material pmdifoam_aria_PF_20lbs

# functions

#Perm_foam_20_pmdi         = { Perm_foam_20_pmdi          = 10**-11.281455428 }   
  Begin Definition for Function pmdi20lb_PM_foamperm  $Permeability pmdi
    Type is PIECEWISE LINEAR
      Begin Values
        $Temperature       Permeability (m^2)
                 50.0            {Perm_foam_20_pmdi}
                 296.0           {Perm_foam_20_pmdi}
                 2000.0          {Perm_foam_20_pmdi}        
         End Values
  End Definition for Function pmdi20lb_PM_foamperm

#Perm_liquid_20_pmdi       = { Perm_liquid_20_pmdi        = 10**-11.28 }
  Begin Definition for Function pmdi20lb_PM_liquidperm  $Permeability pmdi
    Type is PIECEWISE LINEAR
      Begin Values
      $Temperature       Permeability (m^2)
                 50.0            {Perm_liquid_20_pmdi}
                 296.0           {Perm_liquid_20_pmdi}
                 2000.0          {Perm_liquid_20_pmdi}        
      End Values
  End Definition for Function pmdi20lb_PM_liquidperm

  Begin Definition for Function pmdi20lb_PM_Ksolid  $ conductivity with linear dependence on conductivity (based on 1-T model, removing gas contribution)
    Type is PIECEWISE LINEAR
    Begin Values
            $Temperature       Conductivity (W/m/K)
                 200.0           0.049368139       $ Extrapolated value
                 303.15          9.77E-02
                 523.15          2.01E-01
                 2000.0          0.79010888        $ Extrapolated value
    End Values
  End Definition for Function pmdi20lb_PM_Ksolid


  Begin Definition for Function pmdi20lb_PM_Kchar  $ conductivity with linear dependence on conductivity (based on 1-T model, removing gas contribution)
    Type is PIECEWISE LINEAR
    Begin Values
            $Temperature       Conductivity (W/m/K)
                 200.0           0.049368139       $ Extrapolated value
                 303.15          9.77E-02
                 523.15          2.01E-01
                 2000.0          0.79010888        $ Extrapolated value
    End Values
  End Definition for Function pmdi20lb_PM_Kchar

  Begin Definition for Function pmdi20lb_PM_cpfoam  $specific heat capacity pmdi
    Type is PIECEWISE LINEAR
    Begin Values
      $Temperature       Specific heat (J/kgK)-- data from tprl data- from gill memo via ken
                50.0            1269.0
                296.0           1269.0
                323.0           1356.0
                373.0           1497.0
                423.0           1843.0
                473.0           1900.0
                523.0           2203.0
                2000.0          2203.0        $ Extrapolated value  where UQ_cp_char is >= 1
    End Values
  End Definition for Function pmdi20lb_PM_cpfoam



  ################################################
  ############ Output Scheduler ##################
  ################################################
  
  Begin Output Scheduler forResults
    #At Step 0, Increment = 1  # Rapid output for testing
    At Time 0, Increment = 10.0
  end Output Scheduler forResults


  ################################################
  ############ Procedure Block ###################
  ################################################

  Begin Procedure myAriaProcedure

    Begin Solution Control Description
      Use System Main

      Begin System Main
        Begin Transient The_Transient_Block
          Advance all
        end Transient The_Transient_Block

        Simulation Start Time = 0.0
        Simulation Termination Time = 495.
      end System Main

      Begin Parameters For Transient The_Transient_Block
        Begin Parameters For Aria Region all
          Initial Time Step Size = 1.e-4
          maximum time step size = 10.0
          minimum time step size = 1.e-9
          Time Step Variation = adaptive
          Time Integration Method = BDF2
          predictor order = 1
          predictor-corrector tolerance = 1.0e-3

          Maximum Time Step Size Ratio = 1.2

          predictor-corrector field normalization for solid_phase_mass_fraction_FoamA = NONE
          predictor-corrector field normalization for solid_phase_mass_fraction_FoamB = NONE
          predictor-corrector field normalization for solid_phase_mass_fraction_FoamC = NONE
          predictor-corrector field normalization for solid_phase_mass_fraction_Char = NONE
          predictor-corrector field normalization for gas_phase_mass_fraction_HMWO = NONE
          predictor-corrector field normalization for gas_phase_mass_fraction_LMWO = NONE

        end Parameters For Aria Region all
      end Parameters For Transient The_Transient_Block

    End solution control description
    
    ################################################
    ############ Aria Region #######################
    ################################################
    
    BEGIN ARIA REGION all
      Axisymmetry Axis = Y
      Enable Rebalance
      Maximum number of rebalances = 1

      Begin Solution Options
        Begin Porous Flow Options
          Use CVFEM = true
        End
      End

      Begin Chemistry Solver Parameters for foam_decomp
        Chemistry Solver Algorithm = segregated
        ODE Solver = CVODE
        Absolute Tolerance = 1e-12
        Relative Tolerance = 1e-6
        Maximum Substeps = 50000
      End Chemistry Solver Parameters for foam_decomp



      use finite element model all
      use data block Heater_Control

    ################################################
    ############ Mesh Groups #######################
    ################################################

      Mesh Group porous = block_50
      Mesh Group porous_solid_interface_both = surface_7 surface_8 surface_9
      Mesh Group heated_surface         = surface_3
      Mesh Group convective_surface     = surface_1 surface_2
      Mesh Group canister               = block_20 block_30 block_40
      
      
    ################################################
    ############ Equation System ###################
    ################################################
      
      
      Begin Equation System full_system
        Nonlinear Relaxation Factor    = 1.0
        Nonlinear Solution Strategy    = newton
        Use Linear Solver multiphysics
        Maximum Nonlinear Iterations = 7
        Nonlinear Residual Tolerance = 2.e-4

# porous_block = {porous_block = "porous"}
        EQ mass_balance FOR pressure IN gas_phase ON {porous_block} USING Q1 WITH lumped_mass adv src
        Source FOR mass_balance IN gas_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ porous_enthalpy FOR temperature IN solid_phase ON {porous_block} USING Q1 WITH lumped_mass diff src
        SOURCE FOR porous_enthalpy IN solid_phase ON {porous_block} = volumetric_transfer  remote_phase="gas_phase"
        SOURCE FOR porous_enthalpy IN solid_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ porous_enthalpy FOR temperature IN gas_phase ON {porous_block} USING Q1 WITH lumped_mass adv diff src
        SOURCE FOR porous_enthalpy IN gas_phase ON {porous_block} = compressible_pressure 
        SOURCE FOR porous_enthalpy IN gas_phase ON {porous_block} = volumetric_transfer  remote_phase="solid_phase"
        SOURCE FOR porous_enthalpy IN gas_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR density IN solid_phase ON {porous_block} USING Q1 WITH lumped_mass src
        SOURCE FOR mass_balance IN solid_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR mass_fraction OF FoamA IN solid_phase ON {porous_block} USING Q1 WITH lumped_mass src
        Source FOR mass_balance OF FoamA IN solid_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR mass_fraction OF FoamB IN solid_phase ON {porous_block} USING Q1 WITH lumped_mass src
        Source FOR mass_balance OF FoamB IN solid_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR mass_fraction OF FoamC IN solid_phase ON {porous_block} USING Q1 WITH lumped_mass src
        Source FOR mass_balance OF FoamC IN solid_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR mass_fraction OF Char IN solid_phase ON {porous_block} USING Q1 WITH fracbal

        EQ mass_balance FOR mass_fraction OF LMWO IN gas_phase ON {porous_block} USING Q1 WITH lumped_mass adv diff src
        Source FOR mass_balance OF LMWO IN gas_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR mass_fraction OF HMWO IN gas_phase ON {porous_block} USING Q1 WITH lumped_mass adv diff src
        Source FOR mass_balance OF HMWO IN gas_phase ON {porous_block} = LUMPED_GENERAL_CHEM_MASS  MECHANISM=foam_decomp

        EQ mass_balance FOR mass_fraction OF CO2 IN gas_phase ON {porous_block} USING Q1 WITH fracbal

        EQ energy FOR temperature ON canister USING Q1 WITH mass diff

        #######################
        ## Boundary/Interface
        BC Interface for energy on porous_solid_interface_both = contact_resistance opposite_material_phase ="solid_phase"
        BC Interface for porous_enthalpy in solid_phase on porous_solid_interface_both = contact_resistance
        BC Flux for Energy on convective_surface = Nat_Conv T_REF={T_foam_0}. H={conv_coeff}
        BC Flux for Energy on convective_surface = Rad T_REF={T_foam_0} Crad={5.670373e-8*emis_can}
        BC dirichlet FOR temperature ON heated_surface = user_function  name=upright_150_rate X=Time

        #######################
        ## Postprocess
        #######################
        Postprocess density IN gas_phase ON porous
        Postprocess velocity IN gas_phase ON porous
        Postprocess mass_balance_advection in gas_phase on porous
        Postprocess Heat_Flux ON canister
        Postprocess heat_conduction in gas_phase   on porous
        Postprocess heat_conduction in solid_phase on porous
        Postprocess enthalpy in gas_phase on porous
        Postprocess porosity IN solid_phase ON porous
        Postprocess intrinsic_permeability_XX IN solid_phase ON porous
        Postprocess volume_fraction of FoamA in solid_phase on porous
        Postprocess volume_fraction of FoamB in solid_phase on porous
        Postprocess volume_fraction of Char  in solid_phase on porous
        Postprocess thermal_conductivity in solid_phase on porous
        Postprocess thermal_conductivity in gas_phase on porous
        postprocess average of expression GAS_PHASE_UNSHIFTED_PRESSURE on porous as Pressure

        # Probe point comparisons to validation data
        #  ONE = {ONE = -1.}
        postprocess value of expression temperature at point {-0.036068*ONE} 0.063754 as TC1 restricted to block_20
        postprocess value of expression temperature at point 0.01905 0.063754 as TControl restricted to block_20
        postprocess value of expression temperature at point 0.036068 0.063754 as TC3 restricted to block_20
        postprocess value of expression temperature at point {-0.01905*ONE} 0.063754 as TC4 restricted to block_20
        postprocess value of expression temperature at point 0.0444 0.0575056 as TC10 restricted to block_40
        postprocess value of expression temperature at point 0.0444 0.0465836 as TC11 restricted to block_40
        postprocess value of expression temperature at point 0.0444 0.0331216 as TC12 restricted to block_40
        postprocess value of expression temperature at point 0.0444 0.0196596 as TC13 restricted to block_40
        postprocess value of expression temperature at point 0.0444 0.008636 as TC14 restricted to block_40
        postprocess value of expression temperature at point {-0.0444*ONE} 0.0575056 as TC15 restricted to block_40
        postprocess value of expression temperature at point {-0.0444*ONE} 0.0465836 as TC16 restricted to block_40
        postprocess value of expression temperature at point {-0.0444*ONE} 0.0331216 as TC17 restricted to block_40
        postprocess value of expression temperature at point {-0.0444*ONE} 0.0196596 as TC18 restricted to block_40
        postprocess value of expression temperature at point {-.0444*ONE} 0.008636 as TC19 restricted to block_40
        postprocess value of expression temperature at point 0.01524 0.046863 as TC24 restricted to block_30
        postprocess value of expression temperature at point {0} 0.046863 as TC25 restricted to block_30
        postprocess value of expression temperature at point {-0.01524*ONE} 0.046863 as TC26 restricted to block_30
      end Equation System full_system
      
      ################################################
      ############ Initial Conditions ################
      ################################################
      #######################
      ## Canister 
      IC const FOR canister Temperature = {T_foam_0}
      ####################### 
      # Foam
      # frac_a_pmdi = { frac_a_pmdi = 0.45 }  
      # frac_b_pmdi = { frac_b_pmdi = 0.15 }
      # frac_c_pmdi = { frac_c_pmdi = 1 - (frac_a_pmdi + frac_b_pmdi)}  
      IC FOR density IN solid_phase ON {porous_block} = mass_average
      IC FOR mass_fraction OF FoamA IN solid_phase ON {porous_block} = constant  value= {frac_a_pmdi}
      IC FOR mass_fraction OF FoamB IN solid_phase ON {porous_block} = constant  value= {frac_b_pmdi}
      IC FOR mass_fraction OF FoamC IN solid_phase ON {porous_block} = constant  value= {frac_c_pmdi}
      IC FOR mass_fraction OF Char  IN solid_phase ON {porous_block} = fracbal

      IC For pressure in gas_phase on {porous_block} = constant value = {P_foam_0}
      IC FOR mass_fraction OF LMWO IN gas_phase ON {porous_block} = constant  value=0.0
      IC FOR mass_fraction OF HMWO IN gas_phase ON {porous_block} = constant  value=0.0
      IC FOR mass_fraction OF CO2  IN gas_phase ON {porous_block} = fracbal

      IC for temperature in gas_phase on {porous_block} = constant value = {T_foam_0}
      IC for temperature in solid_phase on {porous_block} = constant value = {T_foam_0}

      Predictor Fields = not solid_phase_mass_fraction_Char
      Predictor Fields = not gas_phase_mass_fraction_CO2
      Predictor Fields = not gas_phase_pressure

      ################################################
      ############ Predictor Fields ##################
      ################################################
      Predictor Fields = not solid_phase_mass_fraction_Char
      Predictor Fields = not gas_phase_mass_fraction_CO2
      Predictor Fields = not gas_phase_pressure

      ##################################################
      ##############  Outputs ##########################
      ##################################################

      ####################### 
      ## Heartbeat File 

      BEGIN HEARTBEAT out_1
        STREAM NAME = ./hb_data.csv
        Precision = 7
        timestamp format ''
        Variable = Global time as time
        variable = global count as count
        variable = global po1 as po1
        variable = global psig1 as psig1
        variable = global psig as psig
        variable = global p as p
        variable = global psigadmix as psigadmix
        variable = global psigadmix1 as psigadmix1
        variable = global padmix as padmix
        variable = global psigxuncert as psigxuncert
        variable = global pxuncertsig as pxuncertsig
        variable = global gmasco2 as gmasco2
        variable = global gmasn2 as gmasn2
        variable = global gmascyclopentanone as gmascyclopentanone
        variable = global gmastda as gmastda
        variable = global gmaseaother as gmaseaother
        variable = global molesco2 as molesco2
        variable = global molesn2 as molesn2
        variable = global molescyclopentanone as molescyclopentanone
        variable = global molestda as molestda
        variable = global moleseaother as moleseaother
        variable = global molesofv as molesofv
        variable = global molestotal as molestotal
        variable = global itv as itv
        variable = global mcvT as mcvT
        variable = global mcv as mcv
        variable = global gvol as gvol
        variable = global TC1
        variable = global TControl as TC2# TC2
        variable = global TC3
        variable = global TC4
        variable = global TC10
        variable = global TC11
        variable = global TC12
        variable = global TC13
        variable = global TC14
        variable = global TC15
        variable = global TC16
        variable = global TC17
        variable = global TC18
        variable = global TC19
        variable = global TC24
        variable = global TC25
        variable = global TC26
        variable = global Pressure as Pressure
        labels = off
        legend = on
        Timestep Adjustment Interval = 4
        at time 0.0, increment = 5.0 # seconds
      END HEARTBEAT out_1


      ####################### 
      ## Exodus Output
      ####################### 
      BEGIN RESULTS OUTPUT LABEL output
        database Name = ./results_fic.e
        Use Output Scheduler forResults

        Nodal Variables = solution->TEMPERATURE as T_can
        Nodal Variables = pp->heat_flux as q_can

        Node Variables = solution->solid_phase_density as rho_foam_s
        Node Variables = solution->solid_phase_temperature as T_foam_s
        Node Variables = solution->solid_phase_mass_fraction_FoamA as Y_FoamA
        Node Variables = solution->solid_phase_mass_fraction_FoamB as Y_FoamB
        Node Variables = solution->solid_phase_mass_fraction_FoamC as Y_FoamC
        Node Variables = solution->solid_phase_mass_fraction_Char as Y_Char
        Node Variables = solution->gas_phase_temperature as T_foam_g
        Node Variables = solution->gas_phase_pressure as P_foam_g
        Node Variables = solution->gas_phase_pressure_average as P_foam_avg
        Node Variables = solution->gas_phase_mass_fraction_CO2 as Yg_CO2
        Node Variables = solution->gas_phase_mass_fraction_HMWO as Yg_HMWO
        Node Variables = solution->gas_phase_mass_fraction_LMWO as Yg_LMWO


        node variables = pp->gas_phase_enthalpy as h_foam_g
        node variables = pp->gas_phase_specific_heat as cp_foam_g
        node variables = pp->gas_phase_thermal_conductivity as k_foam_g
        node variables = pp->solid_phase_thermal_conductivity as k_foam_s
        node variables = pp->solid_phase_porosity as porosity

        node variables = pp->solid_phase_volume_fraction_FoamA as vol_frac_FoamA
        node variables = pp->solid_phase_volume_fraction_FoamB as vol_frac_FoamB
        node variables = pp->solid_phase_volume_fraction_FoamC as vol_frac_FoamC
        node variables = pp->solid_phase_volume_fraction_Char as vol_frac_Char

        Node Variables = pp->solid_phase_intrinsic_permeability_XX as perm

        Node Variables = pp->gas_phase_velocity as v_foam_g
        Node Variables = pp->gas_phase_density as rho_foam_g
        Node Variables = pp->solid_phase_heat_flux as q_foam_s

        nodal variables = bc_conv_coeff_porous
        nodal variables = bc_ref_temp_porous

      END RESULTS OUTPUT LABEL output


    End aria region all
  End Procedure myAriaProcedure
END SIERRA myJob
