Begin SIERRA Aria VOTD: Class-Model

    Title Aria Partial enclosure example

$---------------------------------------------------
$   Define material properties to be used
$---------------------------------------------------
    Begin Aria Material flondium
        Density              = Constant rho = 100.0  # kg/m^3, at 20 C
        Specific Heat        = Constant cp  = 100.0   # J/kg-K, at 20 C
        Thermal Conductivity = Constant k   = 0.1     # W/mK, at 20 C
        Emissivity           = Constant value = 1.0
        Heat Conduction      = Basic
    End

$---------------------------------------------------
$   Define global constants
$---------------------------------------------------
    Begin Global Constants
        Stefan Boltzmann Constant = 5.67e-08 # W/m2-K4
    End   Global Constants

$-----------------------------------------------------------
$   Define linear solver settings
$-----------------------------------------------------------
    BEGIN TPETRA EQUATION SOLVER solve_temperature
      BEGIN PRESET SOLVER
        SOLVER TYPE = THERMAL_SYMMETRIC
      END
    END

$---------------------------------------------------
$   Specify mesh name and settings
$---------------------------------------------------
    Begin Finite Element Model FEModel
        Database Name = partial_encl.g
        Use Material flondium for block_1
    End   Finite Element Model FEModel

$--------------------------------------------------------
$   Procedure domain - solution control, region settings
$--------------------------------------------------------
    Begin Procedure AriaProcedure

$---------------------------------------------------
$       Define temporal solution parameters
$---------------------------------------------------
        Begin Solution Control Description
            Use System Main
            Begin System Main
                Simulation Start Time       = 0.0
                Simulation Termination Time = 100.0
                Begin Transient solution_block_1
                    Advance AriaRegion
                End   Transient solution_block_1
            End   System Main
   
$---------------------------------------------------
$           Specify time integration settings
$---------------------------------------------------
            Begin Parameters for Transient solution_block_1
                Start Time       = 0.0    # seconds
                Termination Time = 100.0   # seconds
                Begin Parameters for Aria Region AriaRegion
                    Time Step Variation     = Adaptive
                    Time Integration Method = BDF2
                    Initial Time Step Size = 0.05   # seconds
                    Minimum Time Step Size = 0.01   # seconds
                    Maximum Time Step Size = 20.0   # seconds
                    Predictor-Corrector Tolerance = 0.01 # seconds
                    Limit Solution Increment Temperature =  20.0 # K
                End   Parameters for Aria Region AriaRegion
            End   Parameters for Transient solution_block_1
        End   Solution Control Description

$------------------------------------------------------
$       Region domain - EQs, BCs, ICs, post-processing
$------------------------------------------------------

        Begin Aria Region AriaRegion

$---------------------------------------------------
$           Specify which linear solver to use
$---------------------------------------------------
            Use Linear Solver solve_temperature

$---------------------------------------------------
$           Define nonlinear solver parameters
$---------------------------------------------------
            Nonlinear Solution Strategy  = Newton
            Nonlinear Residual Tolerance = 1.0e-6
            Maximum Nonlinear Iterations = 4
            Nonlinear Relaxation Factor  = 1.0 # default

$-----------------------------------------------------------
$           Specify which mesh model to use for this region
$-----------------------------------------------------------
            Use Finite Element Model FEModel    

$---------------------------------------------------
$           Specify equations to solve
$---------------------------------------------------
            EQ Energy for Temperature on all_blocks using Q1 with Diff Lumped_Mass

$---------------------------------------------------
$           Specify initial conditions
$---------------------------------------------------
            IC for temperature on all_blocks = constant value = 300.0 # K

$---------------------------------------------------
$           Specify boundary conditions
$---------------------------------------------------
            # Back surface held at 300 K
            BC Dirichlet for temperature on surface_3 = constant value = 300

$---------------------------------------------------
$           Define enclosure radiation settings
$---------------------------------------------------
            # Viewfactor calculation parameters
            Begin Viewfactor Calculation vf_hemicube
                Compute Rule = HEMICUBE # default
            End 

            # Viewfactor smoothing parameters
            Begin Viewfactor Smoothing vf_smooth_none
                Method = NONE
            End

            # Radiosity solution solver parameters
            Begin Radiosity Solver rad_solver
                Coupling = MASON 
                Solver = CHAPARRAL CG 
                Convergence Tolerance = 1e-06
                Maximum Iterations = 200
            End

            # Definition for Enclosure 1
            Begin Enclosure Definition cavity_1
                Add Surface surface_1

                Use Viewfactor Calculation vf_hemicube
                Use Viewfactor Smoothing vf_smooth_none
                Use Radiosity Solver rad_solver

                Partial Enclosure Area = 1
                Partial Enclosure Temperature = 50.0
                Partial Enclosure Emissivity = 1.0
            End

$---------------------------------------------------
$           Define contents of binary plot file
$---------------------------------------------------
            Begin Results Output AriaOutput
                Title Aria: Enclosure Radiation class-model
                Database Name = enclrad_partial.e
                Nodal Variables = Solution->Temperature as T
                At Step 0 Interval = 1
            End   Results Output AriaOutput

        End   Aria Region AriaRegion

    End   Procedure AriaProcedure

End   SIERRA Aria VOTD: Class-Model

