BEGIN SIERRA myJob
   BEGIN ARIA MATERIAL liquid
      Density          = Constant rho=1000
      Viscosity        = constant mu=10.0
      Momentum Stress  = Incompressible_Newtonian
   END ARIA MATERIAL liquid
   BEGIN ARIA MATERIAL gas
      Density          = Constant rho=1
      Viscosity        = constant mu=0.1
      Momentum Stress  = Incompressible_Newtonian pressure=pressure_1
   END ARIA MATERIAL gas
   BEGIN ARIA MATERIAL gas_liquid_interface
      Surface Tension = Constant Sigma = 1.
   END ARIA MATERIAL gas_liquid_interface
   
   BEGIN TPetra Equation Solver levelset
      BEGIN PRESET SOLVER
         Convergence Tolerance = 1e-12
         Solver Type = scalar_transport
      END
   END

   BEGIN TPetra Equation Solver momentum
      BEGIN PRESET SOLVER
         Convergence Tolerance = Automatic
         Solver Type = multiphysics
      END
   END TPETRA EQUATION SOLVER

   
   BEGIN FINITE ELEMENT MODEL TwoPhaseFlow
      database name = cdfem_slosh_adapt.g
      coordinate system is cartesian
      Decomposition Method = RCB
      
      Begin Parameters For Phase gas
         where LS is positive
      End
      Begin Parameters For Phase liquid
         where LS is negative
      End
      Begin Parameters For Block block_1_gas
         Material gas
      End
      Begin Parameters For Block block_1_liquid
         Material liquid
      End
      Begin Parameters For Block block_1
         Material gas
      End
      Begin Parameters For Surface surface_block_1_liquid_gas
         Material gas_liquid_interface
      End
   END FINITE ELEMENT MODEL TwoPhaseFlow

   BEGIN PROCEDURE myProcedure
   
      Begin Solution Control Description
         Use System Main
         Begin System Main
            Simulation Start Time            = 0.0
            Simulation Termination Time      = 2.0
            Begin Transient Stepper
               Advance MyRegion
               Event LS_CONSERVED_REDISTANCE when "(CURRENT_TIME - LAST_LS_CONSERVED_REDISTANCE_TIME) >= 0.01"
            End
         End
         Begin Parameters For Transient Stepper
            Start Time      = 0.0
            Begin Parameters For Aria Region MyRegion
               Initial Time Step Size = 0.005
               Maximum Time Step Size = 0.1
               Minimum Time Step Size = 0.005
               Time Step Variation = Adaptive
               Interface Courant Limit = 0.5
               Predictor-Corrector Tolerance = 1.0
            End
         End
      End
    
      BEGIN ARIA REGION MyRegion
      
         BEGIN LEVEL SET INTERFACE LS
            Distance Variable = solution->LEVEL_SET
            Begin analytic initial condition myIC
              plane normal = 0.7 1. 0 offset = 0
            End
         END

         Predictor Fields = Not Pressure
         Predictor Fields = Not Pressure_1
         
         Begin CDFEM OPTIONS
           cdfem nonconformal adaptivity levels = 1
         End
      
         USE FINITE ELEMENT MODEL TwoPhaseFlow
         MESH GROUP gas_blocks = block_1_gas
         MESH GROUP liquid_blocks = block_1_liquid
         MESH GROUP liquid_gas_interface = surface_block_1_liquid_gas
         MESH GROUP nonconformal_blocks = block_1
         
         begin equation system LS
            Use Linear Solver levelset
             
            Nonlinear Solution Strategy    = Newton
            Maximum Nonlinear Iterations   = 3
            Nonlinear Residual Tolerance   = 1e-6
            Nonlinear Correction Tolerance = 1e+12 # LINEAR

            EQ Level_Set for Level_Set on nonconformal_blocks Using Q1 with Mass
            EQ Level_Set for Level_Set on gas_blocks          Using Q1 with Mass Adv SUPG
            EQ Level_Set for Level_Set on liquid_blocks        Using Q1 with Mass Adv SUPG
         end equation system
         
         begin equation system momentum
            Nonlinear Solution Strategy    =  Newton
            Maximum Nonlinear Iterations   =  10
            Nonlinear Residual Tolerance   =  1e-6
            Nonlinear Correction Tolerance =  0
            
            USE LINEAR SOLVER momentum
            
            EQ Momentum for Velocity ON gas_blocks   USING Q1 WITH MASS ADV DIFF SRC SUPG
            EQ Momentum for Velocity ON liquid_blocks USING Q1 WITH MASS ADV DIFF SRC SUPG
            EQ Continuity_1 for Pressure_1 ON gas_blocks   USING Q1 WITH DIV
            EQ Continuity   for Pressure   ON liquid_blocks USING Q1 WITH DIV
            PRESSURE STABILIZATION is pspg_shakib with scaling = 1.0

            BC FluxBP for Momentum on liquid_gas_interface = Capillary
            BC FluxBP for Momentum on liquid_gas_interface = Capillary_stabilization
            
            BC dirichlet for velocity_y on surface_1_gas = constant value = 0.0
            BC dirichlet for velocity_y on surface_1_liquid = constant value = 0.0
            BC dirichlet for velocity_x on surface_2_gas = constant value = 0.0
            BC dirichlet for velocity_x on surface_2_liquid = constant value = 0.0
            BC dirichlet for velocity_x on surface_4_gas = constant value = 0.0
            BC dirichlet for velocity_x on surface_4_liquid = constant value = 0.0
            
            Source For Momentum On gas_blocks   = Hydrostatic gx=0 gy=-10
            Source For Momentum On liquid_blocks = Hydrostatic gx=0 gy=-10
         end equation system

         BEGIN RESULTS OUTPUT LABEL SolutionOutput
           DATABASE NAME = cdfem_slosh_adapt.e
           AT STEP 0, INCREMENT = 1
           TITLE Aria Two Phase Sloshing
           NODAL VARIABLES = solution->Level_Set AS F
           NODAL VARIABLES = solution->Pressure   AS Pliquid
           NODAL VARIABLES = solution->Pressure_1 AS Pgas
           NODAL VARIABLES = solution->Velocity AS V
         END RESULTS OUTPUT LABEL SolutionOutput
         
      END ARIA REGION MyRegion
      
   END PROCEDURE MyProcedure
   
END SIERRA myJob
