      PROGRAM SOLERGY  
C THIS VERSION HAS A MODIFIED RCVR TO ACCOUNT FOR PARTLY CLOUDY DAYS
C THERE IS A CLEAR SKY MODEL USING ALLEN'S EQUATIONS TO COMPARE WITH THE 
C ACTUAL VALUE. 
C JULY 14, 1992
c
C Copyright 6/17/2009 Sandia Corporation. 
C Under the terms of Contract DE-AC04-94AL85000 
C with Sandia Corporation, the U.S. Government retains certain rights in this software.
C
c
C   SOLERGY 1.4
c ++++++++++++++++++   
c Replaced all 10 (ten) "CALL EXIT" statements with "STOP" statements
c to allow SOLERGY to run in Microsoft FORTRAN 5.1 on a pc.
c H. Reilly Sept, 93.
c ++++++++++++++++++
C   SOLERGY1.0  WAS OBTAINED FROM S. FAAS OF SANDIA NATIONAL LABORATORY
C    (LIVERMORE) ON 1/7/87 AND MODIFIED BY D. ALPERT OF SANDIA NATIONAL
C   LABORATORY (ALBUQUERQUE) TO MAKE VERSION 1.1,2, AND 3.
C
C   ALL CHANGES BETWEEN SOLERGY 1.0 AND 1.1 ARE DENOTED WITH THE WORD "CHANGE"
C   ALL CHANGES BETWEEN 1.1 AND 1.2 ARE DENOTED WITH THE WORD CHANGE2
C   CHANGES BETWEEN 1.2 AND 1.3 ARE DENOTED WITH THE WORD CHANGE3
C
C    VERSION 1.3 HAS AN IMPROVED PARASITICS MODEL, WHICH ALSO REQUIRED SOME
C     MINOR CHANGES TO RCVR AND HANDLER (I.E. CALCULATION OF AUXCOST), AND
C     AN EASIER READ VERSION OF THE SMART DISPATCH STRATEGT THAT REQUIRES 
C     SOME ADDITIONAL INPUT.  THE COLD PUMP PARASITIC MODEL WAS CHANGED
C     TO ALLOW FULL FLOW THROUGH CLOUDS.  EXFAC PARAMETER ADDED TO 
C     PERFORM STUDIES OF THE EFFECT OF OPERATOR ACTIONS DURING PARTLY CLOUDY
C     WEATHER
C
C     VERSION 1.4 INCLUDES A MODEL OF THERMAL AND ELECTRICAL PARASITICS
C     DURING THE OVERNIGHT SHUTDOWN PERIOD.  BUMPING THE COLD SALT PUMPS
C     TO KEEP LINES WARM OR DRAINING LINES FOLLOWED BY RAPID HEATUP IN THE
C     MORNING WITH HEATTRACE OR STARTUP SALT CAN BE SIMULATED THROUGH
C     VARIABLES PAHR, RCVPAT, AND RCVPAE IN NAMELIST /PRSTIC/
C
C   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C                                                                    
C                   *************************   
C                   *       ISSUED BY       *   
C                   *    SANDIA NATIONAL    *   
C                   * LABORATORIES, A PRIME *   
C                   ********   CONTRACTOR   *   
C                          *     TO THE     *   
C                          *  UNITED STATES *   
C                          *   DEPARTMENT   *
C                          *    OF ENERGY   *
C      *********************  ---NOTICE---  *********************  
C      *    THIS REPORT WAS PREPARED AS AN ACCOUNT OF WORK      *  
C      *  SPONSORED BY THE UNITED STATES GOVERNMENT.  NEITHER   *  
C      *   THE UNITED STATES NOR THE UNITED STATES DEPARTMENT   *  
C      *   OF ENERGY, NOR ANY OF THEIR EMPLOYEES, NOR ANY OF    *  
C      * THEIR CONTRACTORS, SUBCONTRACTORS, OR THEIR EMPLOYEES, *  
C      *   MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES   *  
C      *      ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE     *  
C      *          **********    ACCURACY,   **********          *  
C      *          *        *  COMPLETENESS  *        *          *  
C      *          *        *  OR USEFULNESS *        *          *  
C      *          *        *     OF ANY     *        *          *  
C      *          *        *  INFORMATION,  *        *          *  
C      *          *        *   APPARATUS,   *        *          *  
C      *       ****        *     PRODUCT    *        ****       *   
C      *       *           *   OR PROCESS   *           *       *   
C      *       *           *   DISCLOSED,   *           *       *   
C      *       *           *  OR REPRESENTS *           *       *   
C      *       *          **    THAT ITS    **          *       *   
C      *       *          **  USE WOULD NOT **          *       *   
C      *********          **    INFRINGE    **          *********   
C                         **    PRIVATELY   **                      
C                         **      OWNED     **                      
C                         **     RIGHTS.    **                      
C                         **                **                      
C                         **                **                      
C                         **                **                      
C                         ********************                      
C
C**************************************************************************
C   * * * * * * * * * * * *   NOTICE    * * * * * * * * * *   * * * * *
C   * THIS REPORT WAS PREPARED AS AN ACCOUNT OF WORK SPONSORED BY THE
C   * UNITED STATES GOVERNMENT.  NEITHER THE UNITED STATES NOR THE
C   * UNITED STATES DEPARTMENT OF ENERGY, NOR THE NUCLEAR REGULATORY
C   * COMMISSION NOR ANY OF THEIR EMPLOYEES, NOR ANY OF THEIR CONTRACTORS, 
C   * SUBCONTRACTOR, OR THEIR EMPLOYEES, MAKES ANY WARRANTY, EXPRESS OR
C   * IMPLIED, OR ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE
C   * ACCURACY, COMPLETENESS OR USEFULNESS OF ANY INFORMATION,
C   * APPARATUS, PRODUCT OR PROCESS DISCLOSED, OR REPRESENTS THAT ITS
C   * USE WOULD NOT INFRINGE PRIVATELY OWNED RIGHTS.
C   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C   * THE BASIC REFERENCE DOCUMENT FOR THIS CODE IS SAND86-8068
C   * "SOLERGY - A COMPUTER CODE FOR CALCULATING THE ANNUAL ENERGY FROM
C   *  CENTRAL RECEIVER POWER PLANTS," BY M. C. STODDARD, S. E. FAAS,
C   *  C. J. CHIANG, AND J. A. DIRKS, MARCH 1987. (AVAILABLE FROM NTIS)
C   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C   * * This modified version runs on A VAX 8650 machine and is         * *
C   * * ANSI Standard FORTRAN 77 with the following MAJOR exceptions:   * *
C   * *       ! is used to indicate a comment on a statement record     * *
C   * *       names of variables, common blocks, subroutines, etc.      * *
C   * *           may be 8 characters or shorter in length              * *
C   * *       NAMELIST input is used                                    * *
C   * *       non-standard PROGRAM statement                            * *
C   * *                                                                 * *
C   ***********************************************************************
C
C       The main program is primarily a driver and output routine. DELT,
C   the simulation time step, is a namelist input. Its value may be as
C   low as 0.125 hours without revising the variable dimensioning. Code
C   initialization is performed in INPUT1, which initializes the
C   NAMELIST values and calculates collector field efficiency matrices.
C
C       The daily loop begins at statement 30. One day of insolation and
C   weather data are obtained from INPUT2 as are azimuth and elevation
C   values from DEA. COLF, the collector field model, calculated a day's
C   array of power to receiver (PTR) values.
C
C       The DO 500 statement begins the loop for each DELT period of the
C   day. RCVR, the receiver model, is called resulting in determination of
C   PTWF, power to the working fluid. Thermal power transmission losses to
C   the EPGS and/or storage facilities are determined in PIPE yielding PWF,
C   power in working fluid. Most of the operational logic of the plant is
C   contained in GONOGO, the turbine operational controller. GONOGO decides
C   when to operate the turbine and formulate the demands for energy from 
C   storage for turbine operation. In the event the storage model is unable 
C   to accommodate these demands, HANDLER is called. HANDLER determines how
C   the demands on storage must be changed in order to satisfy STRG.
C   In the event that GONOGO and STRG are unable to use all the receiver
C   power, heliostat defocusing is simulated. Finally TRBN calculates the 
C   electrical power from turbine.
C
C     A second, more sophisticated operational strategy (MAXOUT) is available.
C   This option seeks to maximize the value of the electrical power generated
C   by implementing SCE'S Standard Offer 2 to determine the optimal turbine
C   startup and shutdown times.  Carryover of energy in thermal storage is
C   permitted.  Setting the IDISP flag equal to 1 in the input namelist 
C   DISPATCH implements this option. The default value of IDISP=0 
C   implements the simpler operating strategy contained in GONOGO.
C
C      The remainder of the main program is concerned with output.
C
C
C  *  *  *  *  *  *  *  *   Input/Output  *  *  *  *  *  *  *  *  *
C  *
C  *  TAPE2  -  Data of insolation and weather for year
C  *  TAPE3  -  Output for energy value calculation in VALCALC (EGEN.DAT)
C  *  TAPE8  -  Namelist input file (SOLNML.DAT)
C  *  TAPE9  -  General output file (SOLOUT.PRT)
C  *
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  *  *  *  *  *  *  COMMON Block variable definitions   *  *  *  *
C  *
C  *  AZ      -  Azimuth (degrees)
C  *  EL      -  Elevation (degrees)
C  *  DNI     -  Direct normal insolation (kilowatts/square meter)
C  *  WD      -  Wind direction (degrees)
C  *  WS      -  Wind speed (meters/sec)
C  *  DBT     -  Dry bulb temperature (F)
C  *  DPT     -  Dew point temperature (F)
C  *  WBT     -  Wet bulb temperature (F)
C  *  TIM     -  Clock time (hrs)
C  *  NPTS    -  Number of data points in day
C  *  PTR     -  Power to receiver (MW)
C  *  DELT    -  Time increment of data points (hours)
C  *  PTWF    -  Power to working fluid from receiver (MW)
C  *  PWF     -  Power in working fluid at EPGS or storage unit entrance (MW)
C  *  TRSHUT  -  Time receiver has been shutdown (hours)
C  *  PTS     -  Thermal power to storage  (MW)
C  *  PFS     -  Thermal power from storage  (MW)
C  *  PFT     -  Electrical power from turbine (MW)
C  *  BOPPAR  -  Balance of plant parasitics (MWe)
C  *  TPPAR   -  Turbine plant parasitics (MWe)
C  *  SPPAR   -  Solar plant parasitics (MWe)
C  *  PMPAR   -  Nonoperational parasitics (non-shutdown)  (MWe)
C  *  SDPAR   -  Parasitics during scheduled outage or extended weather outage
C  *  IFOUT*  -  Matrix containing forced outage days (Julian dates)
C  *  ISOUT*  -  Matrix containing scheduled outage days (Julian dates)
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
      COMMON /COMCOEF/ FR(7,7),ELR(7),AZR(7),CAE(2,7,2,7),
     1  WK(210), NX, NY, IC
C CHANGE IDAYMX ADDED 
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /PLANT/ IFOUT(50), ISOUT(50), IFORC, ISCHED, GPOWER
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /COUNTER/ IBEGIN1, IBEGIN2, IBEGIN3, IBEGIN4
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON TO ALLOW ACCUMULATION
C OF ENERGY LOST FROM STORAGE (TPLDC,TPLDD,TPLBTC,TPLFT)
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C
C CHANGE3 ADDITIONAL COMMON BLOCK FOR MAXOUT DISPATCH
      COMMON /DISPATCH2/ NVAC,IVAC(10),IDYLT1,IDYLT2,ISUMR1,ISUMR2,IWEEK
C CHANGE IYR ADDED TO THIS COMMON
      COMMON /LOCATION/ ALAT, ALONG, ZONE, IFLAGP,IYR
      COMMON /COMPRNT/ MFLAG, NDAF, NDAL
C CHANGE2 NEW COMMON BLOCK FOR LOSSES DURING RCVR HOLD (IFILL=1)
      COMMON /COMHLD/HLDLSH,HLDTIM
      COMMON /PRSTC2/STWPAR,CSPAR,HSPAR,DCPAR,DTHRS
C
c moved dimension statement before data statement for pc ver gjk 6/18/93
      DIMENSION XTITLE(20),WTITLE(19)
c gjk change 1/19/94 moved next 2 data statements from gonogo and maxout
c to main to avoid compilation problems on pc
      DATA TTSB /5.000/, TS1 /0./, ICAN /0/, ITSTART /0/, ION /0/
      DATA ISBT /1/, ISUT /0/, IROT /0/, IDROT /0/
C CHANGE3 DATA STATEMENTS SHORTENED
      DATA INOOP /0/, IMULTI /0/
C      DATA SUPTS /0./ , UPFS /0./, SUPTR /0./, SPTS /0./
C CHANGE YRTRHR AND YDTRHR ADDED TO INITIALIZATION LIST
C ACCUMULATE HOURS OF TURBINE RATED AND DERATED OPERATION 
      DATA YSPTR, YSPTS, YSUPTR, YBOPPAR, YTPPAR, YSPPAR, YSDPAR,
     1 YPMPAR, YPFT, YPTS, YPFS, YDNI, YPTR, YPTWF, YPWF, YPTT, YGPFT,
     1 YPARN, YPLRMF, YSTIME, YWTIME, YFORC, YSCHED,YRTRHR,YDTRHR,
     1 YRSTRT, YCSTRT, YESTRT, YTSTRT, YEOUTAGE /30*0./
      DATA YSTWPR,YCSPAR,YHSPAR,YDCPAR,yidni/5*0.0/
C CHANGE  YTPLDC,YTLDD,YTNKLOS,YRANKLOS ADDED TO INITIALIZAION
C ACCUMULATE ANNUAL ENERGY LOST FROM STORAGE AND FROM THERMAL TO ELECTRIC
C CONVERSION 
      DATA YTPLDC,YTPLDD,YTNKLOS,YRANKLOS / 4*0./
C CHANGE2 ACCUMLATOR FOR HOURS OF RECEIVER OPERATION ADDED
      DATA YRCVHR/0.0/ 
C CHANGE2 ACCUMULATOR OF ENERGY LOST DUE TO FIELD OPERATIONAL LIMITS ADDED
      DATA YPWRLS/0.0/
      DATA HOWFULL/0./
C CHANGE2 ONE LINE ADDED FOR LOSSES DUING RCVR HOLD:
      DATA YHLDH,YHLDT/2*0./
      DATA IBEGIN1, IBEGIN2, IBEGIN3, IBEGIN4 /4*0/
      DATA SUNP /193*0./
C CHANGE3 LINE REMOVED:      DIMENSION IVAC(10,5)
C CHANGE3 JOB TITLE ADDED TO OUTPUT AND INSOLATION FILE

c change 2/17/88 solwea variable added
c weather file hardwired for pc application gjk 6/17/93, comment next line
c      CHARACTER*30 SOLWEA
C CHANGE3 LINES REMOVED (ADDED TO NAMELIST)
C      DATA IVAC/2,51,149,186,247,317,327,360,0,0,
C     +          1,49,147,185,245,315,332,359,0,0,
C     +          10*0,
C     +          10*0,
C     +          10*0/
C      DATA NVAC/8/
C CHANGE 1/23/87  CPUTIM  (DJA)
C      SANDIA-UNIQUE LIBRARY SUBROUTINE THAT RETURNS THE CPU TIME USED
C      SINCE INITIALIZATION - NOT AVAILABLE OUTSIDE SANDIA 
C      INITIALIZE CPUTIM
C       CPINIT = CPUTIM(1) 
C
C CHANGE 1/7/87
C OUTPUT UNIT 1 WAS DELETED, NAMELIST OUTPUT NOW APPEARS WITH THE RESULTS
C  IN UNIT 9 (SOLOUT.PRT)
C      OPEN(UNIT=1, FILE='NMLOUT.PRT', STATUS='NEW') ! Namelist input data
C
c change2 2/17/88 prompt user for name of weather file
C CHANGE3 INSOLATION FILE PROVIDED BY USER
c comment out next 3 lines for pc application, 6/17/93 gjk
c      WRITE(*,*)' ENTER NAME OF INSOLATION FILE:'
c      READ(*,1067)SOLWEA
c 1067 FORMAT(A)
      OPEN(UNIT=2, FILE='SOLWEA77.dat',STATUS='OLD')
C END CHANGE2
C
C THE EGEN.DAT FILE IS THE INPUT TO VALCALC
      OPEN(UNIT=3, FILE='EGEN.DAT', STATUS='unknown')
C DISPAT.TRC GIVES AN OPTIONAL DETAILED TRACE OF THE MAXOUT DISPATCH (IDF1<NDAL)
      OPEN(UNIT=5, FILE='DISPAT.TRC', STATUS='unknown')
C SOLNML.DAT IS THE NAMELIST INPUT FILE
      OPEN(UNIT=8, FILE='SOLNML.DAT', STATUS='OLD')
C SOLOUT.PRT IS THE OUTPUT FILE
      OPEN(UNIT=9, FILE='SOLOUT.PRT', STATUS='unknown')
C
C CHANGE DJA 1/7/87
C NEW WRITE STATEMENT ADDED
      WRITE(9,11)
  11  FORMAT(/' SOLERGY1.4 THIS VERSION LAST CHANGED ON
     1  25 AUG  1993 BY D. J. ALPERT SNLA')
C
C CHANGE - A JOB TITLE IS READ FROM UNIT 8 (THE NAMELIST FILE) AND PRINTED
C  ON THE OUTPUT FILE
      READ(8,12)(XTITLE(J),J=1,20)
  12  FORMAT(20A4)
      WRITE(9,1300)(XTITLE(J),J=1,20)
C CHANGE2 WRITE TITLE TO EGEN.DAT FILE FOR VALCALC (SIMILAR CHANGE IN 
C  VALCALC.FOR) READ/WRITE TITLE FROM INSOLATION FILE
      WRITE(3,12)(XTITLE(J),J=1,20)
C CHANGE3 LINES ADDED TO DETERMINE IF THIS IS A LEAP YEAR 
      READ(2,15)IYR,(WTITLE(K),K=1,19)
 15   FORMAT(I4,19A4)
      YEAR = FLOAT(IYR)
      ILEAP = 2
C NUMBER OF DAYS IN A YEAR (NEEDED IF IDISP=1)
      NDAYSY = 365  
      IF(AMOD( ABS(YEAR-1980.),4.).LT..01)THEN
C THIS IS A LEAP YEAR
	ILEAP = 1
	NDAYSY = 366
      END IF
C WRITE TITLE TO TERMINAL AND TO OUTPUT
      WRITE(*,12)(WTITLE(K),K=1,19)      
      WRITE(*,1300)(XTITLE(J),J=1,20)
      WRITE(9,13)SOLWEA,IYR,(WTITLE(K),K=1,19)
 13   FORMAT(/' THE NAME OF THE INSOLATION FILE IS: ',A,/,' YEAR= ',
     1  I4,/,19A4/)
C      REWIND 2
C
C  Initialize constants and zero data arrays
C THESE ARE NEVER USED:
C
C      PI = 4. * ATAN(1.)
C      TPI = 2. * PI    ! Two times PI
C      TORAD = PI/180.  ! Conversion to radians
C      TODEG = 180./PI  ! Conversion to degrees
C END CHANGE3
C
      FMAX = 0.
C
      CALL INPUT1  ! Initializes namelist variables
      WRITE(9,1300)(XTITLE(J),J=1,20)
C CHANGE3 2/20/88
C SET UP THE TIME STEPS ONCE PER RUN 
C NPTS IS THE NUMBER OF THE LAST TIME STEP (97 FOR DELT = .25)
C (SOLERGY DOES NOT USE TIME STEP NO. 1 !?)
C FIRST TIME STEP ( TIM(2) ) ENDS AT TIME=DELT, LAST TIME STEP (TIM(NPTS))
C ENDS AT TIME=24. 
      NPTS = NINT(24./DELT) + 1
      TIM(1)= 0.
      DO 14 K=2,NPTS
  14  TIM(K) = FLOAT(K-1) * DELT
C END CHANGE3 
C
C CHANGE2 
C DEFINITION OF DESIGN POINT RECEIVER EFFICIENCY CHANGED BECAUSE RS
C WAS CHANGED FROM MAXIMUM INPUT POWER TO RECEIVER TO MAXIMUM OUTPUT POWER.
C DESIGN POINT WIND SPEED IS 3.5 METERS PER SECOND
C DESIGN POINT RECEIVER THERMAL LOSS IS XLRDP 
      XLRDP = XLR(3.5)
      DPLOSS = RS / ( (RS + XLRDP)/EPS )  
C       THE DESIGN POINT RECEIVER OUPUT IS RS. 
C       THE DESIGN POINT RECEIVER INPUT (PTR) IS THE DENOMINATOR 
C       EPS IS THE RECEIVER ABSORPTANCE; XLR IS THE RECEIVER THERMAL
C       LOSS, IN MWT. 
C      CALL COEF    ! Collector field efficiency calculated (MIRVAL or
C                    DELSOL output used to generate field efficiency matrices)
C END CHANGE2
C
C CHANGE3 LINES REMOVED (NOT NEEDED)
C      REWIND 2
C      PTWF = 0.
C      PWF = 0.
C      SUPTS = 0.
C      SUPTR = 0.
C      UPFS = 0.
C END CHANGE3
C
      GPOWER = TPFSL * EPSS(74.,1.)  ! Calculates turbine gross electrical power
C
C CHANGE3 THE NEXT LARGE SECTION WAS REMOVED AND PLACED INTO A SUBROUTINE
C CALLED "PERIODS" (FROM HERE TO 54 CONTINUE)
C      IF (IDISP.NE.1) GO TO 54
C PERIODS SETS UP THE ELECTRICITY RATE PERIODS FOR THE FULL YEAR
      IF(IDISP.EQ.1)CALL PERIODS
C
C  The daily loop starts here:
C
      NDA = 0
C
   30 CONTINUE
C
      NDA = NDA + 1
      WRITE(*,*)'*******   BEGINNING OF DAY ',NDA
C
C  Zero the daily energy accumulators:
C
      DBOPPAR = 0.
      DTPPAR = 0.
      DSPPAR = 0.
      DPMPAR = 0.
      DSDPAR = 0.
      DPAR = 0.     ! Daily total aux. energy furnished
      EOUTAGE = 0.  ! Daily energy lost due to forced/sched. outages
      DRSTRT = 0.   ! Daily energy for receiver start
      DCSTRT = 0.   ! Daily energy for extraction train start
      DESTRT = 0.   ! Daily energy for charging train start
      DTSTRT = 0.   ! Daily energy for turbine start
      DDNI = 0.     ! Daily energy to collector field
      DIDNI = 0.
      DPTR = 0.
      DPTWF = 0.
      DPWF = 0.
      DPTT = 0.
      DGPFT = 0.
C CHANGE
C ADDED TWO NEW ACCUMULATORS - HOURS OF TURB OPERATION, RATED AND DERATED
      DRTRHR = 0.
      DDTRHR = 0.
C CHANGE2 ACCUMULATE HOURS OF RECEIVER OPERATION
      DRCVHR = 0.
      DPARN = 0.    ! Daily aux. energy purchases from net
      DPTS = 0.
      DPFS = 0.
      DPFT = 0.
      SPTR = 0.
      SPTS = 0.
      PLRMF = 0.
      DSPTR = 0.    ! Daily surplus energy to receiver
      DSUPTR = 0.   ! Daily surplus energy to rcvr due to strg overflow
      DSPTS = 0.    ! Daily surplus energy to storage (DSUPTR at storage)
      DPLRMF = 0.
      DSTIME = 0.
      DWTIME = 0.
      DFORC = 0.
      DSCHED = 0.
C CHANGE NEW DAILY ACCUMULATORS ADDED, DTPLDC - DAILY ENERGY LOSS FROM
C THE CHARGING HX, DTPLDD - DAILY ENERGY LOSS FROM THE EXTRACTION HX,
C DTNKLOS - DAILY ENERGY LOSS FROM STORAGE TANK, AND DRANKLOS - DAILY THERMAL
C TO ELECTRIC CONVERSION LOSS.
      DTPLDC = 0.
      DTPLDD = 0.
      DTNKLOS = 0.
      DRANKLOS = 0.
C CHANGE2 DAILY ENERGY LOST DUE TO FIELD OPERATION LIMITS
      DPWRLS = 0.
C CHANGE2 DAILY ENERGY LOST FROM RECEVIER WHILE ON HOLD MODE (IFILL=1)
      DHLDH = 0.
C
      NFLAG = 0
      IF( NDA .GE. NDAF . AND. NDA .LE. NDAL ) NFLAG = MFLAG
C CHANGE3 LINES REMOVED 
C      SUNR = 0.
C      SUNS = 0.
C
C REMOVING THESE NEXT LINES SAVES NEARLY 2 MILLION CALCULATIONS!
C      DO 35 J=1,193
C      AZ(J) = 0.
C      EL(J) = 0.
C      DNI(J) = 0.
C      WD(J) = 0.
C      WS(J) = 0.
C      DBT(J) = 0.
C      DPT(J) = 0.
C      EF(J) = 0.
C      SP(J) = 0.
C      TIM(J) = 0. INCREDIBLE
C      PTR(J) = 0.
C      WBT(J) = 0.
C   35 CONTINUE
C
C Read Insolation and weather data FOR ONE DAY
      CALL INPUT2(NDA,NFLAG)  
C
      IF( NFLAG .GE. 1 ) WRITE(9,1535) NDA, SUNR, SUNS
C
C   CALL THE  COLLECTOR FIELD MODEL, CALCULATES FIELD EFFICIENCY AND
C    POWER TO RECEIVER (PTR) FOR A FULL DAY
      CALL COLF(NDA)
C
C CHANGE2 NEXT SECTION CHANGED
C CHECK TO SEE IF ANY OF THE FIELD OPERATIONAL LIMITS ARE EXCEEDED
C ACCUMULATE ANY LOST ENERGY IN DPWRLS
      DO 37 J = 2, NPTS
	IF(PTR(J).GT.0)THEN
C THERE IS POWER AVAILABLE TO THE FIELD
	  IF (EL(J).LT.ELIM .OR. WS(J).GT.WSLIM .OR.
     1       DBT(J).LT.TLIML .OR. DBT(J).GT.TLIMU) THEN
C
C OPERATIONAL LIMITS ARE EXCEEDED, FIELD CAN NOT OPERATE
C ACCUMULATE LOST POWER
c remove delt. Noticed change in pc solergy, gjk 6/17/93
c changed back 9/14/93
             DPWRLS = DPWRLS + PTR(J)*delt
c	     DPWRLS = DPWRLS + PTR(J)
	     PTR(J) = 0.
	     WRITE(9,1100)NDA,TIM(J),WS(J),DBT(J) 
 1100 FORMAT(' FIELD OPERATIONAL LIMITS EXCEEDED
     1 (WSLIM,TLIML,OR TLIMU) DAY,TIME=',I4,', ',F7.3,' WS= ',F4.1,
     2 ' DBT= ',F4.0) 
	  END IF
	END IF
  37  CONTINUE
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      IF( NFLAG .GE. 3 )THEN
	WRITE(9,2005)
	WRITE(9,2008)
	WRITE(9,2010) (TIM(J),EF(J),PTR(J),J=2,NPTS)
      END IF
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF( NFLAG .GE. 2 )
     1WRITE(9,1515)
C
C  The power to the receiver is set to zero for days on which there
C  is a forced or scheduled outage
C
C CHANGE TWO LINES ADDED
      IFORC = 0
      ISCHED = 0
C
      DO 45 JOUT = 1, 50
C
      IF (ISOUT(JOUT) .EQ. NDA) THEN
C
	ISCHED = 1
	DO 46 J = 2, NPTS
C CHANGE OUTAGE DAYS ARE SUBTRACTED FROM INSOLATION RATHER THAN PTR
C THIS LINE REMOVED: EOUTAGE = EOUTAGE + PTR(J)*DELT
	  EOUTAGE = EOUTAGE + DNI(J)*DELT*FS/1000.
	  PTR(J) = 0.
   46   CONTINUE
	GO TO 49
C
      ELSE IF (IFOUT(JOUT) .EQ. NDA) THEN
C
	  IFORC = 1
	  DO 48 J = 2, NPTS
C CHANGE OUTAGE DAYS ARE SUBTRACTED FROM INSOLATION RATHER THAN PTR
C THIS LINE REMOVED: EOUTAGE = EOUTAGE + PTR(J)*DELT
	    EOUTAGE = EOUTAGE + DNI(J)*DELT*FS/1000.
	    PTR(J) = 0.
   48     CONTINUE
	  GO TO 49
C
      END IF
C
   45   CONTINUE
   49 CONTINUE
C
C CHANGE3 FOLLOWING LINES MOVED TO A SUBROUTINE
C  Dispatch loop 2:
C
      IF( IDISP .EQ. 1 ) THEN   
C       VALUE MAXIMIZING DISPATCH
C
	KRISE = INT( SUNR/DELT ) + INT(.751/DELT)
	KSET = INT( SUNS/DELT ) + INT(.251/DELT)
C
C
	CALL DISP(NDA,KRISE,KSET)
      END IF
C
C  The DELT loop starts here
C
      DO 500 K = 2, NPTS  ! Number of data points for day
      PAR = 0.   ! Total parasitics furnished to system
      SPTR = 0.  ! Surplus power to receiver
      SPTS = 0.  ! Surplus power to storage
      SUPTR = 0. ! Surplus power to receiver due to storage overfill
      RCVRST = 0.
      CHRGST = 0.
      EXTRST = 0.
      TRBNST = 0.
C CHANGE2 NEXT LINE MOVED AFTER CALL TO RCVR
C      EOLD = ES   ! Current value of energy in storage - may have to
C                   be recalled once STRG subroutine changes it
      ISURP = 0
      ITURNON = 0  ! Thermal storage/turbine start is not in progress
C
      CALL RCVR(K, NFLAG)
C CHANGE2 LINE MOVED FROM ABOVE
      EOLD = ES
C
      CALL PIPE(K,NDA)
      PTS = PWF    ! All power is sent to storage
C
C  Dispatch loop 3:
C
C CHANGE2 KSET + 1
      IF ((K.GE.KRISE) .AND. (K.LE.KSET+1) .AND. (IDISP.EQ.1)) THEN
C
	IF(NDA.GE.IDF1.AND.NDA.LE.IDF2)WRITE(5,1808)SUNAP(K),DNI(K)
	CALL ADJPRE(K,KSET)
	CALL PREDICT(K,KSET)
	IF(NDA.GE.IDF1.AND.NDA.LE.IDF2)WRITE(5,1809)K,PHBTS/TPFSL,
     1                                 PHBT/TPFSL
C
      END IF
C
      IF (IDISP .EQ. 1) THEN
C
	IF(NDA.GE.IDF1.AND.NDA.LE.IDF2)WRITE(5,1811)TIM(K),PTS/TPFSL,
     1                                 ES/TPFSL
	CALL MAXOUT(K,NDA,NFLAG)
C
      ELSE
C
	CALL GONOGO(K,NDA,NFLAG)
C
      END IF
C
      CALL STRG(K,NDA,NFLAG)
C
C CHANGE THESE LINES REORDERED 
      IF ((ISURP.NE.0) .OR. (ITURNON.NE.0)) THEN
C       FIRST CALL OF HANDLER
	CALL HANDLER(K,NDA,NFLAG)
	IF ((ISURP.NE.0) .OR. (ITURNON.NE.0)) THEN
C
C         SECOND CALL TO HANDLER, WRITE WARNING
C          IF(ISURP .NE. 0) WRITE(9,5001)K,NDA,ISURP,ITURNON
	  CALL HANDLER(K,NDA,NFLAG)
 5001     FORMAT(' TWO CALLS TO HANDLER THIS TIME STEP, K=',I3,' NDA=',
     1      I4,' ISURP=',I2,' ITURNON=',I2)
C
	    IF ((ISURP.NE.0) .OR. (ITURNON.NE.0)) THEN
C            THIRD  CALL TO HANDLER, WRITE WARNING
C             IF(ISURP.NE.0)WRITE(9,5002)K,NDA,ISURP,ITURNON
 5002    FORMAT(' THREE CALLS TO HANDLER THIS TIME STEP, K=',I3,' NDA=',
     1       I4,' ISURP=',I2,' ITURNON=',I2)
	     CALL HANDLER(K,NDA,NFLAG)
	   IF (ISURP.NE.0) WRITE (9,4000) ISURP, NDA
C       IF STORAGE IS STILL UNHAPPY WRITE WARNING
	    END IF
	END IF
      END IF
C END CHANGE

 4000 FORMAT ( /,10X,' ISURP = ',I3,'*** WARNING ***',/,
     1 ' AFTER CALLING HANDLER THREE TIMES',/'  UNSATISFIED ',
     1'CONDITION EXISTS ON DAY ',I4,' CHECK FOR PROBLEM *** ',/)
C
      CALL TRBN(K,NDA,NFLAG)
      CALL PARASI(K,NDA)
C
C  Daily accumulators:
C
C CHANGE2 ACCUMULATE THERMAL LOSSES DURING RECEIVER HOLD (IFILL=1)
      YHLDH = YHLDH + HLDLSH*DELT
      DHLDH = DHLDH + HLDLSH*DELT
      YHLDT = YHLDT + HLDTIM
C CHANGE 4/4/87 DJA
C HOW FULL DID STORAGE EVER GET?
      IF(ES.GT.HOWFULL)HOWFULL = ES
      GPFT = PFT  ! GPFT is gross power from turbine
C CHANGE, ACCUMULATE HOURS OF TURBINE OPERATION
      IF(GPFT.GT.0)THEN
C TURBINE IS OPERATING
	IF(IROT.EQ.1)THEN
C TURBINE IS OPERATING AT RATED CAPACITY
	  DRTRHR = DRTRHR + DELT
	ELSE
C TURBINE IS OPERATING AT DERATED CAPACITY (OR IS IN THE "RAMP" PHASE OF STARTUP
	  DDTRHR = DDTRHR + DELT
	END IF 
      END IF
C
C CHANGE2 ACCUMULATE HOURS OF RECEIVER OPERATION
      IF( PTWF .GT. 0.)DRCVHR = DRCVHR + DELT 
C
C CHANGE
C ACCUMULATE DAILY THERMAL TO ELECTRIC CONVERSION LOSSES
      DRANKLOS = DRANKLOS + (PTT-GPFT-TRBNST)*DELT
C CHANGE INSOLATION IS ACCUMULATED ONLY IF THE PLANT COULD OPERATE
C ON OUTAGE DAYS, THE DNI IS ACCUMULATED IN EOUTAGE
      IF( (ISCHED+IFORC) .EQ. 0) THEN
C        THIS IS AN OPERATING DAY
	 DDNI = DDNI + DNI(K)*FS*DELT*1.E-3
      END IF
      DIDNI = DIDNI + DNI(K)*DELT*1.E-3
      DPTR = DPTR + PTR(K)*DELT
      DPTWF = DPTWF + PTWF*DELT
      DPWF = DPWF + PWF*DELT
      DPTT = DPTT + PTT*DELT
      DGPFT = DGPFT + GPFT*DELT
      DPTS = DPTS + PTS*DELT
      DPFS = DPFS + PFS*DELT
      DSPTR = DSPTR + SPTR*DELT
      DSPTS = DSPTS + SPTS*DELT
      DSUPTR = DSUPTR + SUPTR*DELT
      DPLRMF = DPLRMF + PLRMF*DELT
      DRSTRT = DRSTRT + RCVRST*DELT
      DCSTRT = DCSTRT + CHRGST*DELT
      DESTRT = DESTRT + EXTRST*DELT
      DTSTRT = DTSTRT + TRBNST*DELT
      DSTIME = DSTIME + STIME
      DWTIME = DWTIME + WTIME
      IF (IFORC .EQ. 1) DFORC = DFORC + DELT
      IF (ISCHED .EQ. 1) DSCHED = DSCHED + DELT
C CHANGE ACCUMULATORS FOR 
C ENERGY LOST FROM STORAGE SYSTEM ADDED
      DTPLDC = DTPLDC + TPLDC * DELT
      DTPLDD = DTPLDD + TPLDD * DELT
      DTNKLOS = DTNKLOS + (TPLFT + TPLBTC)*DELT
C
C  Parasitics are accumulated in Kilowatt-hrs for daily reporting
C
      BOPPAR = BOPPAR * 1000. * DELT  ! Convert parasitics (in MWe-hr)
      TPPAR = TPPAR * 1000. * DELT    ! to kWe-hr
      SPPAR = SPPAR * 1000. * DELT
      PMPAR = PMPAR * 1000. * DELT
      SDPAR = SDPAR * 1000. * DELT
      PAR = BOPPAR + TPPAR + SPPAR + SDPAR + PMPAR  ! Kw-hrs
      DBOPPAR = DBOPPAR + BOPPAR  ! Daily parasitics are accumulated
      DTPPAR = DTPPAR + TPPAR     ! and reported in kWe-hr
      DSPPAR = DSPPAR + SPPAR
      DPMPAR = DPMPAR + PMPAR
      DSDPAR = DSDPAR + SDPAR
      DPAR = DPAR + PAR
      DPARN = DPARN + PAR*1.E-3  ! Parasitics in MW-hrs
C
C ACCUMULATE SUBSET OF PARASITCS FOR YEARLY TOTALS IN MWHRS
C
C ENERGY TO STOW AND UNSTOW THE FIELD
      YSTWPR = YSTWPR + STWPAR * DELT
C ENERGY FOR COLD SALT PUMP
      YCSPAR = YCSPAR + CSPAR * DELT
C ENERGY FOR HOT SALT PUMP
      YHSPAR = YHSPAR + HSPAR * DELT
C ENERGY FOR DRY COOLING
      YDCPAR = YDCPAR + DCPAR * DELT
C
      DPFT = DPFT + PFT * DELT - PAR*1.E-3
C
      IF(IDISP.EQ.1.AND.NDA.GE.IDF1.AND.NDA.LE.IDF2)WRITE(5,1812)
     1                                        PTS/TPFSL,PFS/TPFSL
      IF( NFLAG .GE. 2 )
C CHANGE NEW VARIABLES ADDED TO WRITE
     1WRITE(9,1520) TIM(K), PTR(K), PTWF, PWF, PTS, PFS, PTT,PFT,
     1 BOPPAR,TPPAR,SPPAR, PMPAR, PAR, ES 
      
C
C CHANGE - ADDITIONAL OUTPUT OPTION DJA 1/8/87
      IF(NFLAG .GE.2)THEN
	IF(PLRMF .NE. 0.) WRITE(9,1521)PLRMF
	IF(SPTR. NE. 0.) WRITE (9,1527)SPTR
C CHANGE2 THREE LINES ADDED:
	IF (IFILL.EQ.1)THEN
	  IF(HLDLSH.NE.0)WRITE(9,*)' HOLD THERMAL LOSS=',HLDLSH 
	END IF
	IF(SUPTR .NE. 0.) WRITE(9, 1524)SUPTR
	IF(RCVRST .NE. 0.) WRITE (9,1526)RCVRST
	IF(CHRGST .NE. 0.) WRITE(9,1522)CHRGST
	IF(EXTRST .NE. 0.) WRITE(9, 1523)EXTRST
C        IF(SPTS .NE. 0.) WRITE (9,1525)SPTS
	IF(TRBNST .NE. 0.) WRITE (9,1528)TRBNST
      END IF
C
C  Write power generated by turbine into file EGEN.DAT. This file will be
C  processed and the value of the power generated will be assessed.
C
      WRITE (3,3000) PFT,PAR/DELT/1000.,IFORC,ISCHED
 3000 FORMAT (2F8.3,2I2)
C
  500 CONTINUE !  End of DELT loop ********************************
C
C  Characterize this day's receiver operation
C     There were no receiver starts:
	 IF (IDAYOP .EQ. 0) INOOP = INOOP + 1
C     There were multiple receiver starts:
	 IF (IDAYOP .GT. 1) IMULTI = IMULTI + 1
C
      IF (NFLAG.GE.1) THEN
       WRITE(9,9000)
       WRITE(9,1300)(XTITLE(J),J=1,20)
C CHANGE
C NEW WRITE ADDED
       IF(ISCHED.EQ.1)WRITE(9,*)'          SCHEDULED OUTAGE ALL DAY'
       IF(IFORC.EQ.1)WRITE(9,*)'          FORCED OUTAGE ALL DAY'
C CHANGE 1/28/87 DJA, NDA ADDED TO WRITE STATEMENT
       WRITE(9,1530)NDA,DBOPPAR, DTPPAR, DSPPAR, DPMPAR, DPAR, 
     1 DDNI, DPTR
c broke write statement into 2 pieces gjk, 6/17/93
       write(9,2530)
     1 DPTWF, DPWF, DPTS, DPFS, DPTT, ES, DSPTR, DSUPTR, DSPTS
       WRITE(9,1533)DRSTRT, DCSTRT, DESTRT, DTSTRT, EOUTAGE
C  CHANGE DRANKLOS ADDED TO WRITE 
       WRITE(9,1531) DSTIME, DWTIME, DPLRMF, DGPFT, DPFT, DPARN,
     1  DRANKLOS
C CHANGE2 DRCVHR AND DPWRLS ADDED TO WRITE
C CHANGE NEW WRITE ADDED FOR HOURS OF TURBINE OPERATION
       WRITE(9,1541)DRTRHR,DDTRHR,DRCVHR,DPWRLS
 1541  FORMAT(/'  DAILY HOURS OF TURBINE RATED AND DE-RATED OPERATION',
     1 F10.3,',',F7.3,' HOURS (DRTRHR, DDTRHR)'/
     2 '  DAILY HOURS OF RECEIVER OPERATION           =',F10.3,
     3 ' HRS (DRCVHR)'/
     4 ' DAILY ENERGY LOST TO FIELD OPERATION LIMITS  =',F10.3,
     5 ' MWH (DPWRLS)' )
C CHANGE2 THREE LINES ADDED FOR RCVR HOLD MODE
	IF(IFILL.EQ.1)THEN
	  WRITE(9,*)'DHLDH=',DHLDH
	END IF
      ELSE IF(DSUPTR.GT. 0.)THEN
	 WRITE(9,*)'DSUPTR = ',DSUPTR,' ON DAY ',NDA
      END IF
C
C  Convert daily parasitics from kWhrs to MWhrs:
C
      DBOP = DBOPPAR * 1.E-3
      DTP = DTPPAR * 1.E-3
      DSP = DSPPAR * 1.E-3
      DPM = DPMPAR * 1.E-3
      DSD = DSDPAR * 1.E-3
C
C  Yearly accumulators
C
      YBOPPAR = YBOPPAR + DBOP
      YTPPAR = YTPPAR + DTP
      YSPPAR = YSPPAR + DSP
      YPMPAR = YPMPAR + DPM
      YSDPAR = YSDPAR + DSD
      YRSTRT = YRSTRT + DRSTRT
      YCSTRT = YCSTRT + DCSTRT
      YESTRT = YESTRT + DESTRT
      YTSTRT = YTSTRT + DTSTRT
      YDNI = YDNI + DDNI
      YIDNI = YIDNI + DIDNI
      YPTR = YPTR + DPTR
      YPTWF = YPTWF + DPTWF
      YPWF = YPWF + DPWF
      YPTT = YPTT + DPTT
      YGPFT = YGPFT + DGPFT ! Before parasitics removed
      YPFT = YPFT + DPFT    ! After parasitics removed
      YPTS = YPTS + DPTS
      YPFS = YPFS + DPFS
      YSPTR = YSPTR + DSPTR
      YSPTS = YSPTS + DSPTS
      YSUPTR = YSUPTR + DSUPTR
      YPARN = YPARN + DPARN
      YPLRMF = YPLRMF + DPLRMF
      YSTIME = YSTIME + DSTIME
      YWTIME = YWTIME + DWTIME
      YFORC = YFORC + DFORC
      YSCHED = YSCHED + DSCHED
      YEOUTAGE = YEOUTAGE + EOUTAGE
C CHANGE, TWO NEW ACCUMULATORS ADDED FOR HOURS OF TURBINE OPERATION AT
C RATED AND DE-RATED CAPACITY
      YRTRHR = YRTRHR + DRTRHR
      YDTRHR = YDTRHR + DDTRHR
C
C CHANGE2 HOURS OF RECEIVER OPERATION ADDED
      YRCVHR = YRCVHR + DRCVHR
C CHANGE2 ENERGY LOST TO FIELD OPERATION LIMITS ADDED
      YPWRLS = YPWRLS + DPWRLS
C CHANGE YEARLY ACCUMULATORS FOR ENERGY LOST FROM STORAGE SYSTEM
C AND FOR ANNUAL THERMAL TO ELECTRIC CONVERSION LOSS
      YTPLDC = YTPLDC + DTPLDC
      YTPLDD = YTPLDD + DTPLDD
      YTNKLOS = YTNKLOS + DTNKLOS
      YRANKLOS = YRANKLOS + DRANKLOS
C
      IF(IDISP.EQ.1)THEN
C FOR THE VALUE MAXIMIZING ROUTINE, CALCULATE A PREDICTION OF THE INSOLATION
C ON DAY NDA+1. THE PREDICTION IS BASED ON THE WEIGHTED AVERAGE OF THE OLD
C PREDICTION (SUNP) AND THE OBSERVED INSOLATION (DNI) ON DAY NDA.
	 DO 505 KDUM=KRISE,KSET
  505    SUNP(KDUM)=(3.*SUNP(KDUM)+1.*DNI(KDUM))/4.
      END IF
      WRITE(*,*)'*******   END OF DAY ',NDA
C
      IF( NDA .LT. NDAL) GO TO 30 !End of NDA loop 30 *********************
C
C
      WRITE(9,9000)
      WRITE(9,1300)(XTITLE(J),J=1,20)
      WRITE(9,1540)NDAL
C CHANGE YSDPAR ADDED TO PRINT
      WRITE(9,1550) YBOPPAR, YTPPAR, YSPPAR, YPMPAR,YSDPAR,
     1 YDNI, YPTR, YPTWF,
     1 YPWF, YPTS, YPFS, YPTT, YSPTR
c broke write statement into 2 pieces, gjk 6/17/93
      write(9,1556) YSUPTR, YSPTS, YPLRMF, YSTIME,
     1 YWTIME, YFORC, YSCHED
      WRITE(9,1552)YEOUTAGE,IBEGIN1,IBEGIN2,IBEGIN3,IBEGIN4,
     1 INOOP, IMULTI, YRSTRT, YCSTRT, YESTRT, YTSTRT, ITSTART, ION
C CHANGE YRANKLOS ADDED TO WRITE
      WRITE(9,1551) YGPFT, YPFT, YPARN,YRANKLOS
C
C
C CHANGE2 HOURS OR RECEIVER OPERATION AND ENERGY LOST TO FIELD OPERATION
C LIMITS ADDED
C CHANGE NEW WRITE ADDED FOR HOURS OF TURBINE OPERATION
      WRITE(9,1542)YRTRHR,YDTRHR,YRCVHR,YPWRLS
 1542 FORMAT('  YEARLY HOURS OF TURBINE RATED AND DERATED OPERATION',
     1 F10.2,',',F10.2,' HOURS (YRTRHR, YDTRHR)'//
     2 '  YEARLY HOURS OF RECEIVER OPERATION =            ',
     3 F10.2,' HOURS (YRCVHR)'/,
     4 ' YEARLY ENERGY LOST TO FIELD OPERATION LIMITS  =  ',
     5 F10.2,' MWH (YPWRLS)'//)
      WRITE(9,1543)(HOWFULL*100./EMAX)
C CHANGE2 WRITE OUT LOSSES WHILE RCVR ON HOLD
      IF(IFILL.EQ.1)THEN
       WRITE(9,*)' TOTAL HOLD THERMAL LOSSES=',YHLDH,' MWHR (ENERGY
     1 RETURNED TO RCVR FROM STORAGE'
       WRITE(9,*)'  TOTAL RECEIVER HOLD TIME=',YHLDT,' HRS' 
      END IF
C
C WRITE OUT THE SUBSET OF THE PARASITICS 
      WRITE(9,1529)YSTWPR,YCSPAR,YHSPAR,YDCPAR
 1529 FORMAT(' ANNUAL ENERGY TO STOW/UNSTOW FIELD ',F15.3,' MWHRS',/
     1 ' ANNUAL ENERGY FOR COLD SALT PUMP ',F15.3,' MWHRS',/
     2 ' ANNUAL ENERGY FOR HOT SALT PUMP ',F15.3,' MWHRS',/
     3 ' ANNUAL ENERGY FOR DRY COOLING OP',F15.3,' MWHARS')
 1543 FORMAT(' STORAGE REACHED ', F6.2,'% OF CAPACITY')
      write(9,*)' yearly incident insolation (MWh/sq m)',yidni
C
C CHANGE2 THE CALCULATION OF DPLOSS WAS MOVED UP 
C
C CHANGE2, TURBINE NET POWER ESTIMATED 7/13/87
C ASSUMED TO BE AT FULL RATED POWER (PTWF/RS = 1)
	 SPPAR = PA(1)*FS + PA(3) + PA(4) + PA(5) + PA(6)
C FOR TPPAR, NO HOT PUMPS ARE ASSUMED AND PFT/GPOWER = 1
	 TPPAR = PA(7) + PA(8) 
C CONDENSATE PUMP
	 BOPPAR = PA(13) 
      XNTPWR = GPOWER - BOPPAR - TPPAR - SPPAR
      WRITE(9,9000)
      WRITE(9,1300)(XTITLE(J),J=1,20)
      WRITE (9,2005)
      WRITE (9,1500)
C CHANGE2 XNTPWR ADDED 7/13/87
      WRITE(9,2020) TPFSL,GPOWER,PTSMAX, FMAX,IDAYMX,DPLOSS, RS,
     1 EMAX, FS,XNTPWR
      WRITE (9,2005)
C     WRITE (9,2005)
C
      IF(IFILL.EQ.1)THEN
C
      WRITE(9,*)' ALL OF THE FOLLOWING CALUCLATIONS HAVE BEEN CORRECTED
     1 FOR RCVR HOLD LOSSES--THOSE ABOVE HAVE NOT'
C
C SUBTRACT THE ENERGY LOST DURING RCVR HOLD (IF IFILL .EQ.1), IT IS ADDED
C  BACK IN LATER IN THE CALCULATION OF THERMAL HEAT LOSS FROM RCVR.
       YPTWF = YPTWF - YHLDH
       YPWF  = YPWF  - YHLDH
       YPTS  = YPTS  - YHLDH
      END IF
C
C  "Annual" Efficiency calculations:
C
C    Collector field annual efficiency:  All energy that the collector
C    field could direct to the receiver divided by annual insolation.
C CHANGE, YEARLY POWER FROM FIELD PFF DEFINED
      YPFF = YPTR + YSPTR + YSUPTR + YPLRMF 
C     OUTAGE DAYS ARE NOT INCLUDED ANY MORE
C
      EFCF = YPFF / YDNI
C
C    Receiver efficiency:  Energy transmitted to the working fluid
C    divided by all energy directed onto the receiver.
C
C CHANGE DJA 3/29/87
C THE RECEIVER EFFICIENCY NOW INCLUDES LOSS DUE TO RECEIVER MINIMUM FLOW
C AS WELL AS LOSS DUE TO EXCEEDING MAXIMUM POWER
C THIS LINE REMOVED:      EFREC = YPTWF / YPTR
      EFREC = YPTWF/(YPTR+YPLRMF+YSPTR)
C
C    Piping efficiency:  Energy contained in the working fluid after
C    passing through the piping divided by energy collected by receiver.
C
      EFPIPE = YPWF / YPTWF
C
C    Thermal storage efficiency:  Thermal energy delivered by storage to
C    the turbine divided by energy delivered to storage by piping.
C
      EFTS = YPTT / YPTS
C
C    EPGS efficiency:  Gross electrical energy produced by the turbine
C    divided by the thermal energy delivered to the turbine from storage.
C
      EFEPGS = YGPFT / YPTT
C
C    Total system efficiency:  Net electrical energy produced by the
C    turbine divided by the annual insolation.
C
      EFTOT = (YGPFT - YPARN) / (YDNI+YEOUTAGE)
C
C  "Design point" calculations:
C      Ambient temperature is 82.6 deg F, Wind speed is 3.5 m/sec,
C      Wet bulb temperature is 74 deg F
C
      DEF1 = FMAX  ! Design point collector field efficiency
C CHANGE2
C THIS LINE REMOVED, DPLOSS HAS ALREADY BEEN CALCULATED.
C      DEF2A = EPS - XLR(3.5)/RS ! Design point receiver efficiency
      DEF3=1. - XLP(82.6,-99,-99)  ! Design point piping efficiency
      DEF4=EPSS(74.,1.)   ! Design point EPGS efficiency
C
C CHANGE2 DPLOSS REPLACED DEF2A
      WRITE(9,1600) DEF1, EFCF, DPLOSS, EFREC, DEF3, EFPIPE, EFTS,
     1 DEF4, EFEPGS, EFTOT
 1600 FORMAT(/15X,'DESIGN POINT EFF.     ANNUAL EFF.'///
     1' FIELD            'F10.5,10X,F10.5,//
     2' RECEIVER         'F10.5,10X,F10.5,//
     3' PIPING           'F10.5,10X,F10.5,//
     4' THERMAL STORAGE     N/A              'F10.5,//
     5' EPGS             'F10.5,10X,F10.5,//
     6' OVERALL             N/A              'F10.5//)
C CHANGE DJA 3/29/87
C MORE DETAILED OUTPUT OF THE FIELD PERFORMANCE ADDED
C
C THE AMOUNT OF ENERGY LOST DUE TO PLANT OUTAGE IS YEOUTAGE
C THE EFFICIENCY OF THE PLANT FOR OUTAGE
      EFCOUT = 1. - (YEOUTAGE)/(YDNI+YEOUTAGE)
C
C AVERAGE FIELD EFFICIENCY (COSINE, SHADOWING, BLOCKING, TRANSMISSION
C AND SPILLAGE CAN BE ESTIMATED:
      EFCFLD = EFCF/RFLCTY 
C
C THE AMOUNT OF ENERGY LOST DUE TO MIRROR REFLECTIVITY
      YREFLOS = YDNI*(1. - RFLCTY)

C THE AMOUNT OF ENERGY LOST DUE TO FIELD EFFICIENCY (COSINE, SHADOWING,
C BLOCKING, SPILLAGE, TRANSMISSION
      YFLDLOS = (YDNI-YREFLOS) * (1. - EFCFLD)
C
C THE AMOUNT OF ENERGY LOST DUE TO RECEIVER/STORAGE MISMATH IS YSUPTR
C THE EFFICIENCY OF THE PLANT TO THIS MISMATCH IS
      EFCMTCH = (YPFF - YSUPTR)/(YPFF)
C
C THE AMOUNT OF ENERY LOST DUE TO PTR > RS IS YSPTR
C THE AMOUNT OF ENERGY LOST FROM THE RECEIVER DUE TO LOW FLOW IS YPLRMF
C THE AMOUNT OF ENERGY LOST FROM THE RECEIVER DUE TO ABSORPTANCE OF THE
C RECEIVER IS
      YABSLOS = YPTR * (1. - EPS)
C
C THE AMOUNT OF ENERGY LOST FROM THE RECEIVER DUE TO THERMAL CONVECTION AND
C RADIATION IS THE DIFFERENCE (I.E., WHAT'S LEFT)
      YRCVRLOS = YPTR - YABSLOS - YRSTRT - YPTWF 
C
C FOR THE CASE WHERE IFILL = 1, RCVR HOLD LOSSES ARE INCLUDED IN YRCVRLOS
C
C THE AMOUNT OF ENERGY LOST FROM THE RECEIVER DURING STARTUP IS YRSTRT
C
C THE AMOUNT OF ENERGY LOST FROM THE TRANSPORT SYSTEM IS
C (ALSO EQUAL TO (1-EFPIPE)*YPTWF
      YPIPELOS = YPTWF - YPWF 
C
C THE ENERGY LOST FROM THE CHARGNING HX IS YTPLDC
C THE ENERGY LOST FROM THE EXTRACTION HX IS YTPLDD
C THE ENERGY LOST DURING START OF THE CHARGING HX IS YCSTRT
C THE ENERGY LOST DURING START OF THE EXTRACTION HX IS YESTRT
C THE ENERGY LOST FROM THE STORAGE TANK IS YTNKLOS
C THE EFFICIENCY OF THE STORAGE SYSTEM IS EFTS (YPFS/YPTS)
C THE ENERGY LOST FROM THE TURBINE DURING TURBINE START IS YTSTRT
C THE ENERGY LOST FROM THE TURBINE DUE TO RANKINE CYCLE IS YRANKLOS
C ( ALSO, RANKLOS = YPTT - YGPFT - YTSTRT)
C      
      YREDIR = YDNI - YREFLOS - YFLDLOS
C YINC IS ALSO EQUAL TO YPFF
      YINC = YREDIR - YSUPTR
C YNDI4 IS ALSO EQUAL TO YPTR + YPLRMF + YSPTR
      EFCTOT = EFCOUT*EFCFLD*RFLCTY*EFCMTCH*EFREC*EFPIPE*
     1 EFTS*EFEPGS*(YPFT/YGPFT)
C
      WRITE(9,1301)(XTITLE(K),K=1,20)
      WRITE(9,1575)NDAL,IYR,YDNI+YEOUTAGE
      WRITE(9,1576)EFCOUT,YEOUTAGE,YDNI
      WRITE(9,1577)RFLCTY,YREFLOS,EFCFLD,YREDIR,YFLDLOS,YPWRLS
      WRITE(9,1578)EFCMTCH,YSUPTR,YINC
      WRITE(9,1580)YPLRMF,YSPTR,EFREC,YABSLOS,YPTWF,YRCVRLOS,YRSTRT
      WRITE(9,1581)EFPIPE,YPIPELOS,YPWF
      WRITE(9,1582)YCSTRT,YTPLDC,EFTS,YTNKLOS,YPFS,YESTRT,YTPLDD,
     1 ES,NDAL
      WRITE(9,1583)EFEPGS,YTSTRT,YGPFT,YRANKLOS
      WRITE(9,1584)YBOPPAR,YPFT/YGPFT,YTPPAR,YSPPAR,YPFT,YPMPAR,YSDPAR,
     1 EFCTOT,YPARN
      WRITE(9,1586)YPFT/(YDNI+YEOUTAGE)
C
 1575 FORMAT(/,7X,'PLANT SUMMARY - DAYS 1 TO ',I3,' YEAR ',I4,//,
     1 '     EFFICIENCY        (MWHRS)           ENERGY LOSSES ',/
     1 12x,   ' I-------------------------I   (MWHRS)'/,
     1 12x,   ' I     TOTAL INSOLATION    I'/,
     1 12X,   ' I       ',F10.2,'        I'/
     1 12X,   ' I-------------------------I'/
     1 26X,'V')
 1576 FORMAT(
     112X,    ' I-------------------------I OUTAGE LOSSES'/
     17X,F5.3,' I     AVAILABLE ENERGY    I ',F10.2,' (YEOUTAGE)',/,
     1 12X,   ' I       ',F10.2,'        I'/
     1 12X,   ' I-------------------------I'/
     1 26X,'V')
 1577 FORMAT(
     1 12X,   ' I-------------------------I FIELD LOSSES'/, 
     17X,F5.3,' I    REDIRECTED ENERGY    I ',F10.2,' REFLECTIVITY
     1 LOSS'/
     17X,F5.3,' I       ',F10.2,'        I ',F10.2,' COSINE,
     1 SHADOWING, BLOCKING,',/
     1 12X,   ' I-------------------------I              SPILLAGE,
     1 TRANSMISION (AND OPERATION LIMITS=',F7.2,')'/,
     1 26X,'V')
 1578 FORMAT(
     1 12X,   ' I-------------------------I STORAGE FULL OR 
     1 CHARGING HX IN STARTUP'/
     17X,F5.3,' I  RCVR INCIDENT ENERGY   I ',F10.2,' DEFOCUS
     1 HELIOSTATS (YSUPTR)'/
     1 12X,   ' I       ',F10.2,'        I'/
     1 12X,   ' I-------------------------I'/
     1 26X,'V')
 1580 FORMAT(
     1 12X,   ' I-------------------------I RECEIVER LOSSES'/
     1 12X,   ' I        RECEIVER         I ',F10.2,' RCVR MIN FLOW
     1 (YPLRMF)'/,
     112X,    ' I     ABSORBED ENERGY     I ',F10.2,' SURPLUS ENERGY TO 
     1 RCVR (PTR TOO BIG) DEFOCUS HELIOSTATS (YSPTR)'/
     17X,F5.3,' I                         I ',F10.2,' ABSORPTANCE',/
     1 12X,   ' I       ',F10.2,'        I ',F10.2,' THERMAL LOSS
     1 (RADIATION AND CONVECTION)',/
     1 12X,   ' I-------------------------I ',F10.2,' RCVR STARTUP
     1 (YRSTRT)'/,
     1 26X,'V')
 1581 FORMAT(
     1 12X,   ' I-------------------------I PIPING LOSSES',/
     17X,F5.3,' I    ENERGY TO STORAGE    I ',F10.2/
     1 12X,   ' I       ',F10.2,'        I'/
     1 12X,   ' I-------------------------I'/
     1 26X,'V')
 1582 FORMAT(
     1 12X,   ' I-------------------------I STORAGE LOSSES'/
     1 12X,   ' I                         I ',F10.2,' CHARGING HX START
     1 (YCSTRT)'/,
     1 12X,   ' I        ENERGY TO        I ',F10.2,' LOSS FROM CHARGING
     1 HX (YTPLDC)'/,
     17X,F5.3,' I         TURBINE*        I ',F10.2,' TANK LOSS
     1 (YTNKLOS)',/
     1 12X,   ' I       ',F10.2,'        I ',F10.2,' STEAM GENERATOR
     1 STARTUP (YESTRT)'/,
     1 12X,   ' I-------------------------I ',F10.2,' LOSS FROM STEAM
     1 GEN (YTPLDD)',/
     1 26X,'V',16X,'*',F8.2,' MWHRS IN STORAGE AT END OF DAY ',
     1 I3,/,26X,'V')
 1583 FORMAT(
     1 12X,   ' I-------------------------I EPGS LOSSES',/
     17X,F5.3,' I      GROSS ENERGY       I ',F10.2,
     1 ' TURBINE SYNC LOSS (YTSTRT)'/,
     1 12X,   ' I       ',F10.2,'        I ',F10.2,' RANKINE LOSS
     1 (APPROX)',/
     1 12X,   ' I-------------------------I',/
     1 26X,'V')
 1584 FORMAT(
     1 12X,   ' I-------------------------I AUXILIARY ENERGY'/,
     1 12X,   ' I       NET ENERGY        I ',F10.2,' BALANCE OF PLANT
     1 (YBOPPAR)',/
     17X,F5.3,' I         OUTPUT          I ',F10.2,' TURBINE PLANT
     1 (YTPPAR)',/
     1 12X,   ' I                         I ',F10.2,' SOLAR PLANT
     1 (YSPPAR)',/
     1 12X,   ' I       ',F10.2,' MWHe   I ',F10.2,' OVERNIGHT 
     1 (YPMPAR)',/
     1 12X,   ' I-------------------------I ',F10.2,' SHUTDOWN
     1 (YSDPAR)',/7X,F5.3,28X,'(',F10.2,' TOTAL AUX ENERGY (YPARN))'/)
 1586 FORMAT(7X,F5.3,' OVERALL PLANT EFFICIENCY (TOTAL NET ELECTRICITY/
     1TOTAL DNI ON FIELD)')
C
C   
  590 CONTINUE
  600 CONTINUE
C
C CHANGE 1/23/87 USE SANDIA LIBRARY ROUTINE TO OBTAIN TOTAL CPU TIME
C USED - NOT AVAILABLE OUTSIDE SANDIA
C      CPUSED = CPUTIM(2)
C      WRITE(*,*) '  CPU USED = ',CPUSED
C      WRITE(9,*) '  CPU USED = ',CPUSED
C
 1000 FORMAT(20I5)
 1300  FORMAT(' ',20A4)
 1301  FORMAT('1',20A4)
 1500 FORMAT('     PLANT CHARACTERISTICS:     ')
C CHANGE FORMATS 1515 AND 1520 CHANGED
 1515 FORMAT(/10X,2H**,12X,10HPOWER (MW),22X,5H**-**,8X,
     1 19HAUX. POWER (KW-HRS),5X,5H**-**,8X,7HSTORAGE,6X,2H**/
     1 2X,4HTIME,4X,3HPTR,5X,4HPTWF,4X,3HPWF,5X,3HPTS,5X,3HPFS,5X,
     1 3HPTT,5X,
     1 4HGPFT,2X,6HBOPPAR,2X,5HTPPAR,6X,5HSPPAR,2X,5HPMPAR,4X,3HPAR,
     1 3X,8HES (MWH),4X,5HSUPTS,3X,4HUPFS/)
 1520 FORMAT(F6.2,1X,F7.2,1X,F7.2,1X,F7.2,1X,F7.2,1X,F7.2,1X,F7.2,1X,
     1 F7.2,1X,F9.2,1X,F7.2,1X,F7.2,1X,F7.2,1X,F9.2,1X,F8.2,1X,F7.2,
     1 1X,F7.2,1X,F7.2)
 1521 FORMAT(7X,6HPLRMF=,F7.2,' RECEIVER MIN FLOW')
 1522 FORMAT(7X,'CHARG HX STRT=',F7.2)
 1523 FORMAT(7X,'EXTR HX STRT=',F7.2)
 1524 FORMAT(7X,'SUPTR=',F7.2,' DEFOCUS HELIOSTATS, STRG/RCVR MISMATCH')
 1525 FORMAT(7X,'SPTS=',F7.2,' TEMPORARY MISMATCH/HANDLER CALLED')
 1526 FORMAT(7X,'RCVRST=',F7.2,' RECEIVER STARTUP')
 1527 FORMAT(7X,'SPTR=',F7.2,' DEFOCUS HELIOSTATS - PTR TOO BIG')
 1528 FORMAT(7X,'TRBNST=',F7.2,' TURBINE STARTUP')
 1530 FORMAT(20X,16HDAILY TABULATION ,'   DAY',I4//
     140H  DAILY PARASITICS - BALANCE OF PLANT  =,F15.2,5X,3HKWH
     1 ' (DBOPPAR)'/
     140H  DAILY PARASITICS - TURBINE PLANT     =,F15.2,5X,3HKWH
     1 ' (DTPPAR)'/
     140H  DAILY PARASITICS - SOLAR PLANT       =,F15.2,5X,3HKWH
     1 ' (DSPPAR)'/
     140H  DAILY PARASITICS - PM SHUTDOWN       =,F15.2,5X,3HKWH
     1 ' (DPMPAR)'/
     140H  DAILY PARASITICS FURNISHED PLANT     =,F15.2,5X,3HKWH
     1 ' (DPAR)'//
     140H  DAILY ENERGY TO COL. FLD.            =,F15.2,5X,7HMWH(TH)
     1 ' (DDNI)'//
     140H  DAILY ENERGY TO RECEIVER             =,F15.2,5X,7HMWH(TH)
     1 ' (DPTR)'//)
c broke format into 2 pieces for pc application, gjk, 6/17/93
 2530 format(
     140H  DAILY ENERGY TO WORKING FLUID        =,F15.2,5X,7HMWH(TH)
     1 ' (DPTWF)'//
     140H  DAILY ENERGY IN WORKING FLUID        =,F15.2,5X,7HMWH(TH)
     1 ' (DPWF)'//
     140H  DAILY ENERGY TO STORAGE              =,F15.2,5X,7HMWH(TH)
     1 ' (DPTS)'//
     140H  DAILY ENERGY TO TURBINE FROM STORAGE =,F15.2,5X,7HMWH(TH)
     1 ' (DPFS)'//
     140H  DAILY ENERGY TO TURBINE (PTT)        =,F15.2,5X,7HMWH(TH)
     1 ' (DPTT)'//
     140H  ENERGY IN STORAGE (END OF DAY)       =,F15.2,5X,7HMWH(TH)
     1 ' (ES)'//
     140H  DAILY SURPLUS ENERGY TO RECEIVER     =,F15.2,5X,7HMWH(TH)
     1 ' (DSPTR) PTR TOO BIG'//
     140H  DAILY SURPLUS ENERGY TO STRG AT RCVR =,F15.2,5X,7HMWH(TH)
     1 ' (DSUPTR)'//
     140H  DAILY SURPLUS ENERGY TO STRG AT STRG =,F15.2,5X,7HMWH(TH)
     1 ' (DSPTS)-TEMPORARY MISMATCH'/)
 1533 FORMAT(
     140H  DAILY ENERGY FOR RECEIVER START      =,F15.2,5X,7HMWH(TH)
     1 ' (DRSTRT)'//
     140H  DAILY ENERGY FOR CHARGING TRAIN STRT =,F15.2,5X,7HMWH(TH)
     1 ' (DCSTRT)'//
     140H  DAILY ENERGY FOR EXTR. TRAIN START   =,F15.2,5X,7HMWH(TH)
     1 ' (DESTRT)'//
     140H  DAILY ENERGY FOR TURBINE START       =,F15.2,5X,7HMWH(TH)
     1 ' (DTSTRT)'//
     140H  DAILY ENERGY LOSS DUE TO OUTAGE TIME =,F15.2,5X,7HMWH(TH)
     1 ' (EOUTAGE)'/)
 1531 FORMAT(
     140H  DAILY RECEIVER START TIME            =,F15.2,5X,5HHOURS  
     1 ' (DSTIME)'//
     140H  DAILY WEATHER RECEIVER DOWN TIME     =,F15.2,5X,5HHOURS 
     1 ' (DWTIME)' //
     140H  DAILY RECEIVER MINIMUM FLOW LOSSES   =,F15.2,5X,7HMWH(TH)
     1 ' (DPLRMF)' //
     140H  DAILY GROSS ELECTRICITY FROM TURBINE =,F15.2,5X,3HMWH
     1 ' (DGPFT)'//
     140H  DAILY NET ELECTRICITY FROM TURBINE   =,F15.2,5X,3HMWH
     1 ' (DPFT)'//
     140H  DAILY AUX. ENERGY PURCHASES FROM NET =,F15.2,5X,7HMWH(EL)
     1 ' (DPARN)'/
     140H  DAILY THERM-ELECTRIC CONVERSION LOSS = ,F15.2,5X,7HMWH(TH)
     1 ' (DRANKLOS)')
 1532 FORMAT(////4H DAY,I5,10X,7HSUNRISE,F7.3,10X,6HSUNSET,F7.3)
 1535 FORMAT(4H1DAY,I5,10X,7HSUNRISE,F7.3,10X,6HSUNSET,F7.3)
 1540 FORMAT(1H ,19X,17HYEARLY TABULATION ,' DAYS  1 TO',I4//)
 1550 FORMAT(
     140H YEARLY PARASITICS - BALANCE OF PLANT  =,F15.2,5X,3HMWH
     1 ' (YBOPPAR)'//
     140H YEARLY PARASITICS - TURBINE PLANT     =,F15.2,5X,3HMWH
     1 ' (YTPPAR)'//
     140H YEARLY PARASITICS - SOLAR PLANT       =,F15.2,5X,3HMWH
     1 ' (YSPPAR)'//
     140H YEARLY PARASITICS - PM SHUTDOWN       =,F15.2,5X,3HMWH
     1 ' (YPMPAR)'//
     140H YEARLY PARASITICS -    SHUTDOWN       =,F15.2,5X,3HMWH
     1 ' (YSDPAR)'//
     140H YEARLY ENERGY TO COL. FLD.            =,F15.2,5X,7HMWH(TH)
     1 ' (YDNI)'//
     140H YEARLY ENERGY TO RECEIVER             =,F15.2,5X,7HMWH(TH)
     1 ' (YPTR)'//
     140H YEARLY ENERGY TO WORKING FLUID        =,F15.2,5X,7HMWH(TH)
     1 ' (YPTWF)'//
     140H YEARLY ENERGY IN WORKING FLUID        =,F15.2,5X,7HMWH(TH)
     1 ' (YPWF)'//
     140H YEARLY ENERGY TO STORAGE              =,F15.2,5X,7HMWH(TH)
     1 ' (YPTS)'//
     140H YEARLY ENERGY TO TURBINE FROM STORAGE =,F15.2,5X,7HMWH(TH)
     1 ' (YPFS)'//
     140H YEARLY ENERGY TO TURBINE (PTT)        =,F15.2,5X,7HMWH(TH)
     1 ' (YPTT)'//
     140H YEARLY SURPLUS ENERGY TO RECEIVER     =,F15.2,5X,7HMWH(TH)
     1 ' (YSPTR)'//)
c broke write statement in 2 for pc.  gjk 6/17/93
 1556 format(
     140H YEARLY SURPLUS ENERGY TO STRG AT RCVR =,F15.2,5X,7HMWH(TH)
     1 ' (YSUPTR)'//
     140H YEARLY SURPLUS ENERGY TO STRG AT STRG =,F15.2,5X,7HMWH(TH)
     1 ' (YSPTS)'//
     140H YEARLY RECEIVER MINIMUM FLOW LOSSES   =,F15.2,5X,7HMWH(TH)
     1 ' (YPLRMF)'//
     140H YEARLY RECEIVER START TIME            =,F15.2,5X,5HHOURS 
     1 ' (YSTIME)'//
     140H YEARLY WEATHER RECEIVER DOWN TIME     =,F15.2,5X,5HHOURS 
     1 ' (YWTIME)'//
     140H YEARLY FORCED OUTAGE DOWN TIME        =,F15.2,5X,5HHOURS 
     1 ' (YFORC)'//
     140H YEARLY SCHEDULED OUTAGE DOWN TIME     =,F15.2,5X,5HHOURS 
     1 ' (YSCHED)'/)
C
 1552 FORMAT(40H YEARLY ENERGY LOSS DUE TO OUTAGE TIME =,F15.2,
     15X,7HMWH(TH),' (YEOUTAGE)'//
     19H STRT1 = ,I3,4X,9H STRT2 = ,I3,4X,9H STRT3 = ,I3,4X,
     19H STRT4 = ,I3,' (IBEGIN1,2,3,4)'//
     147H NUMBER OF DAYS RECEIVER DID NOT OPERATE     = ,I4,
     1 ' (INOP)'//
     147H NUMBER OF DAYS RECEIVER HAD MULTIPLE STARTS = ,I4,
     1 ' (IMULTI)'//
     130H STARTUP ENERGIES: RECEIVER = ,F10.2,4X,11HCHARGING = ,
     1F10.2,'(YRSTRT, YCSTRT)',//
     130H                 EXTRACTION = ,F10.2,4X,11HTURBINE  = ,
     1F10.2,'(YESTRT, YTSTRT)',//
     118H TURBINE STARTS = ,I4,4X,25H TURB STARTS COMPLETED = ,I4//)
 1551 FORMAT(
     140H YEARLY GROSS ELECTRICITY FROM TURBINE =,F15.2,5X,3HMWH
     1 ' (YGPFT)'//
     140H YEARLY NET ELECTRICITY FROM TURBINE   =,F15.2,5X,3HMWH
     1 ' (YPFT)'//
     140H YEARLY PARASITICS FURNISHED PLANT     =,F15.2,5X,7HMWH(E)
     1 ' (YPARN)'//
     140H YEARLY THERM TO ELEC CONVERSION LOSS  =,F15.2,5X,7HMWH(E)
     1 ' (YRANKLOS)'//)
 2005 FORMAT(//)
 2008 FORMAT(6(7X,3HTIM,3X,2HEF,4X,3HPTR)/)
 2010 FORMAT(6(F10.3,F5.2,F7.1))
C CHANGE - GPOWER ADDED TO PLANT CHARACTERISTICS 1/8/87
 2020 FORMAT( //, 10X,' MAXIMUM POWER TO TURBINE = ',F10.2,' MWT',/,
     1   10X,' GROSS ELECTRIC POWER     = ',F10.2,' MWE',/,
     1   10X,' MAXIMUM POWER TO STORAGE = ',F10.2,' MWT',/,
     1   10X,' FIELD EFFICIENCY         = ',F11.5,' ON DAY ',I3,/,
     1   10X,' RECEIVER EFFICIENCY      = ',F11.5,/,
C CHANGE2 NEXT LINE CHANGED
     1   10X,' MAX RECEIVER OUTPUT      = ',F10.2,' MWT',/,
     1   10X,' STORAGE CAPACITY         = ',F10.2,' MWhr',/,
     1   10X,' TOTAL FIELD SIZE         = ',F10.2,' SQ M.',/,
C CHANGE2 ONE LINE ADDED 7/13/87
     1   10X,' TURBINE NET POWER        = ',F10.2,' MWE',/)
C CHANGE3 FORMATS MOVED TO SUBROUTINE DISP
 1808 FORMAT('    Before Call ADJPRE: SUNAP(K),DNI(K)=',2F9.3)
 1809 FORMAT('    After Call PREDICT: K,PHBTS,PHBT=',I4,2F9.3)
 1811 FORMAT('       Before Call MAXOUT: TIM(K),PTS,ES=',3F9.3)
 1812 FORMAT('             Actual Dispatch:  PTS,PFS=',2F9.3)
 9000 FORMAT(1H1)
c
  900 STOP '>>>SOLERGY Stop at Line 900: Run successfully completed<<<'
c
      END   !   End of SOLERGY
C
C
      SUBROUTINE INPUT1
C
C     This routine initializes all NAMELIST constants via either the
C  default data statements or new values read from the NAMELIST file, or a
C  combination thereof. The default values represent a 100 MWe plant with
C  a molten salt external receiver and molten salt storage system. There
C  is 1.25 hours of storage and a solar multiple of 1.2.  The dispatch
C  strategy selected is sunfollowing.
C
      common /conesta/sunmx,exfac
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /COMCOEF/ FR(7,7),ELR(7),AZR(7),CAE(2,7,2,7),
     +  WK(210), NX, NY, IC
C CHANGE IDAYMX ADDED
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
      COMMON /COMEFWS/ NEFWS, WSX(8), WSEF(8)
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMXLR/ NXLR, WXLR(7), PLXLR(7)
      COMMON /COMXLP/ NXLP, TXLP(9), YXLP(9)
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
      COMMON /COMEPSS/ NREPSS, NCEPSS, REPSS(4), CEPSS(6), FEPSS(24)
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /PLANT/ IFOUT(50), ISOUT(50), IFORC, ISCHED, GPOWER
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C CHANGE IYR ADDED TO THIS COMMON
      COMMON /LOCATION/ ALAT, ALONG, ZONE, IFLAGP,IYR
      COMMON /COMPRNT/ MFLAG, NDAF, NDAL
C CHANGE3 NEW COMMON BLOCK
      COMMON /DISPATCH2/ NVAC,IVAC(10),IDYLT1,IDYLT2,ISUMR1,ISUMR2,IWEEK
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
C
C
C  ************  NAMELIST NMLGEN variables  ************
      NAMELIST /NMLGEN/ IFOUT, ISOUT,DELT
C
C  *  *  *  *  NMLGEN variables  *  *  *  *  *  *  *  *  *  *
C  *  DELT   -  Time step of weather data, hrs
C  *  IFOUT  -  Julian dates of forced outage days
C  *  ISCHED -  Julian dates of scheduled outage days
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  The time step is 15 minutes:
C
      DATA DELT  /0.25/
C
C  There are no forced or scheduled outages:
C
      DATA IFOUT /50*0/
      DATA ISOUT /50*0/
C
C  *************  NAMELIST NMLLOC variables  **************
      NAMELIST /NMLLOC/ ALAT, ALONG, ZONE, IFLAGP
C
C  *  *  *  *  NMLLOC variables  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  ALAT     -  Local latitude in degrees (North is positive). The default
C  *             value provided is for Barstow, CA
C  *  ALONG    -  Local longitude in degrees west of Greenwich. The default
C  *             value provided is for Barstow, CA
C  *  ZONE    -  Local international time zone, ie. 8. is Pacific time
C  *             zone, 7. is Mountain time zone, 6. is Central time zone,
C  *             and 5. is Eastern time zone.
C  *  IFLAGP  -  Print flag: when equal to one - prints full output of
C  *             calculated values to screen; any other value gives no
C  *             output.
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  The plant location is Barstow, California:
C
      DATA ALAT /34.897/
      DATA ALONG /117.022/
      DATA ZONE /8./
      DATA IFLAGP /0/
C
C  *************  NAMELIST NMLCOEF variables  *************
      NAMELIST /NMLCOEF/ NX, ELR, NY, AZR, FR
C
C  *  *  *  *  COEF variables  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  NX  -   Number of rows (7 max) in FR matrix, ie. NUMBER OF ELEVATION
C  *          ANGLES.
C  *  NY  -   Number of columns (7 max) in FR matrix, ie., NUMBER OF 
C  *          AXIMUTH ANGLES
C  *  AZR  -  Row vector of azimuth values for bicubic spline.  Must be
C  *          NY values in ascending order.
C  *  ELR  -  Column vector of elevation values for bicubic spline.
C  *          Must be NX values in ascending order.
C  *  FR  -   Matrix values for bicubic spline.  If entire matrix is
C  *          being replaced and the short NAMELIST form is being used,
C  *          order is important.  It must be all values in column 1
C  *          followed by all values in column 2, ... etc.,  and in
C  *          correspondence with the vector of elevation values.
C  *          These values are generated by DELSOL2a and include
C  *          heliostat reflectivity (0.91). Receiver reflectivity (0.948)
C  *          has been removed, but IS included in the DELSOL generated
C  *          table. Also, DELSOL reports solar zenith angle, which must
C  *          be subtracted from 90 degrees to get solar elevation.
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  The Az-El table is defined from DELSOL output:
C
      DATA AZR /0.,30.,60.,75.,90.,110.,130./ , NY /7/
      DATA ELR /0.,5.,15.,25.,45.,65.,89.5/ , NX /7/,IC/7/
      DATA FR /
     1 0.0, .289, .473, .578, .638, .658, .678,
     1 0.0, .287, .472, .572, .637, .657, .678,
     1 0.0, .286, .469, .569, .636, .657, .678,
     1 0.0, .326, .482, .572, .634, .656, .678,
     1 0.0, .286, .467, .566, .634, .656, .678,
     1 0.0, .320, .477, .569, .632, .655, .678,
     1 0.0, .319, .476, .568, .631, .654, .678/
C
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  **************  NAMELIST NMLCOLF variables  **********************
      NAMELIST /NMLCOLF/ FS, TLIML, TLIMU, ELIM, WSLIM,
     1 RFLCTY, NEFWS, WSX, WSEF
C
C  *  *  *  *  COLF variables  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  FS     -   Field area (square meters)
C  *  TLIML  -   Temperature limit lower (dry bulb F)
C  *  TLIMU  -   Temperature limit upper (dry bulb F)
C  *  ELIM   -   Minimum elevation for collector operation (degrees)
C  *  WSLIM  -   Maximum wind speed for collector on line (m/s)
C  *  RFLCTY -   Collector reflectivity factor
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  The field size is defined from the DELSOL run; collector field
C  operational limits are set.  The Az-El table contains the effect 
C  field reflectivity if it was generated by DELSOL, so RFLCTY is
C  set equal to unity here.
C
      DATA FS /589000./,
     1 TLIML /0.0/,
     1 TLIMU /120.0/,
     1 ELIM /0.0/,
     1 WSLIM /16.0/,
     1 RFLCTY /1.0/
C
C  *  *  *  *  EFWS variables  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  NEFWS  -  Number of elements in WSX - WSEF arrays.  Current array
C  *            dimensions in EFWS permit 8 maximum
C  *  WSX    -  Wind speed values for spline fit
C  *  WSEF   -  Wind speed efficiency factor values for spline fit
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  There is no collector field efficiency decline with increasing wind
C  speed:
C
      DATA NEFWS /8/,
     1 WSX /0.0,2.0,4.0,6.0,8.0,10.0,12.0,13.4/,
     1 WSEF /8*1.0/
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  *************  NAMELIST NMLRCVR variables  **************************
      NAMELIST /NMLRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 NXLR, WXLR, PLXLR, IFILL, exfac
C
C  *  *  *  *  RCVR variables  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  EPS     -  Receiver proportional efficiency
C  *  RS      -  Receiver size - maximum thermal input (MW)
C  *  ALPHAR  -  Receiver cool down/start up parameter
C  *  TREQD   -  Receiver cold start time (hrs)
C  *  EREQD   -  Energy required for receiver start (MWhr)
C  *  RMF     -  Receiver minimum flow factor.  Fraction of RS
C  *  IFILL   -  1 = Receiver has doors; remains filled at standby
C  *             2 = Receiver is drained; must shutdown at standby
c  *  exfac   -  0 to 1 fraction of clear sky sun to shutdown by operators
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  Receiver operational and physical characteristics are defined:
C
      DATA EPS  /0.948/,
     1 RS /365.0/,
     1 ALPHAR /1.0/,
     1 TREQD /0.0/,
     1 EREQD /15./,
     1 RMF /0.10/,
     1 IFILL /2/,
     1 exfac /0./
C
C  *  *  *  *  XLR variables  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  NXLR  -   Number of elements (7 max.) in the wind speed vector
C  *  WXLR  -   Vector of wind speeds (m/sec) for spline fit - must be
C  *            in ascending order
C  *  PLXLR -   Vector of corresponding receiver loss coefficients
C  *            (subtractive - units of MWth)
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  The losses given correspond to those for a liquid sodium, external receiver
C  (320 MWth) at design point.  Ref: memo to Distribution from J. M. Hruby
C  and J. C. Yu, December 9, 1985, "Comparison of Off Design Day Thermal
C  Losses Calculations with the Design Day Performance and the DELSOL
C  Predictions for Off Design"
C
C  Receiver thermal losses are defined as a function of wind speed (note
C  that there is no functional dependence in this case):
C
      DATA NXLR /7/, WXLR /0.0,2.0,4.0,6.0,8.0,10.0,12.0/
      DATA (PLXLR(J),J=1,7) /
     1 27.4, 27.4, 27.4, 27.4, 27.4, 27.4, 27.4/
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  *************   NAMELIST NMLPIPE variables   ************************
      NAMELIST /NMLPIPE/ NXLP, TXLP, YXLP
C
C  *  *  *  *  XLP variables  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  NXLP  -  Number of elements (9 max) in temperature vector
C  *  TXLP  -  Vector of temperature points for spline fit.  Must be
C  *           in ascending order
C  *  YXLP  -  Vector of corresponding loss coefficients
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  Piping losses (fractional) are expressed as a function of ambient
C  temperature:
C
      DATA NXLP /9/, TXLP /-22.,-4.,14.,32.,50.,68.,86.,104.,122./,
     1 YXLP /3.473E-4,3.393E-4,3.313E-4,3.232E-4,3.152E-4,3.071E-4,
     1 2.991E-4,2.911E-4,2.830E-4/
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  ************   NAMELIST NMLTRBN variables   *************************
      NAMELIST /NMLTRBN/ TBHWS, TBWCS, TPFSL, TMFS, ESMIN1, ESMIN2,
     1 ESMAX1, ESMAX2, SDH, SDW, SDC, RDH, RDW, RDC,
     1 NREPSS, NCEPSS, REPSS, CEPSS, FEPSS
C
C  *  *  *  *  NMLTRBN variables  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  TBHWS   -  Time between hot and warm start-up
C  *  TBWCS   -  Time between warm and cold start-up
C  *  TPFSL   -  Power (th) that turbine requires for rated operation
C  *             from storage
C  *  TMFS    -  Turbine minimum flow rate coefficient for power from
C  *             storage (fraction of maximum flow rate)
C  *  ESMIN1  -  Min. storage energy level at which to start turbine
C  *             when receiver is in rated operation
C  *  ESMIN2  -  Min. storage energy level at which to start turbine
C  *             when receiver is not in rated operation
C  *  ESMAX1  -  Max. storage energy level, at which turbine must be
C  *             started, when receiver is at rated operation
C  *  ESMAX2  -  Max. storage energy level, at which turbine must be
C  *             started, when receiver is not at rated operation
C  *  SDH     -  Turbine sync. delay (hot) hours
C  *  SDW     -  Turbine sync. delay (warm) hours
C  *  SDC     -  Turbine sync. delay (cold) hours
C  *  RDH     -  Ramp delay (hot) hours
C  *  RDW     -  Ramp delay (warm) hours
C  *  RDC     -  Ramp delay (cold) hours
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  Turbine operational and startup characteristics are defined:
C
      DATA TBHWS /12./,
     1 TBWCS /72./,
     1 TPFSL /265.00/,
     1 TMFS /0.25/
      DATA ESMIN1 /25./,
     1 ESMIN2 /25./,
     1 ESMAX1 /25./,
     1 ESMAX2 /330./
      DATA SDH /0.20/,
     1 SDW /0.24/,
     1 SDC /0.40/,
     1 RDH /0.55/,
     1 RDW /1.10/,
     1 RDC /3.33/
C
C  *  *  *  *  EPSS variables  *  *  *  *  *  *  *  *  *  *  *  *  *
C  *  NREPSS  -  Number of rows (6 max) in FEPSS matrix, ie.,
C  *             length of column vector
C  *  NCEPSS  -  Number of columns (4 max) in FEPSS matrix, ie.,
C  *             length of row vector
C  *  REPSS   -  Row vector of fraction of rated power (th) for bicubic
C  *             spline.  Must be NCEPSS values in ascending order
C  *  CEPSS   -  Column vector of wet bulb tempeeature (f) values for
C  *             bicubic spline.  Must be NREPSS values in ascending
C  *             order.
C  *  FEPSS   -  Matrix values for bicubic spline.  If entire matrix is
C  *             being replaced and the short NAMELIST form is being used,
C  *             order is important.  It must be all values in column 1
C  *             followed by all values in column 2, ...etc.,  and in
C  *             correspondence with the vector of wet bulb temperatures
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  The turbine thermal to electric conversion efficiency is defined:
C
      DATA NCEPSS /4/,  REPSS /0.2907,0.5239,0.7563,1.00/
      DATA NREPSS /6/,  CEPSS /30.0,40.0,50.0,60.0,70.0,80.0/
      DATA (FEPSS(J),J=1,24) /
     1 6*0.3598, 6*0.3992, 6*0.4148, 6*0.4183/
C
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  ************   NAMELIST NMLSTRG   ***********************************
C
      NAMELIST /NMLSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN,
     1 ES, A, CLF, DLF, TNKLF, LS, REFPC, TSTCR, ESTCR, TSTDR,
     1 ESTDR, PWARMC, PWARMD
C
C  *  *  *  *  *  *  *  *  NMLSTRG  Variables  *  *  *  *  *  *  *  *  *  *
C  *  ES     - Energy in storage (MWh)
C  *  EMAX   - Maximum ES
C  *  EMIN   - Minimum ES
C  *  PTSMAX - Maximum charging rate (MW)
C  *  PTSMIN - Minumum charging rate (MW)
C  *  SUPTS  - Surplus power sent to storage (MW)
C  *  PFSMAX - Maximum discharge rate (MW)
C  *  PFSMIN - Minimum discharge rate (MW)
C  *  UPFS   - Unavailable power from storage (MW)
C  *  TPLDC  - Thermal power lost during charging (MW)
C  *  TPLDD  - Thermal power lost during discharging (MW)
C  *  TPLFT  - Thermal power lost from tanks (conduction losses) (MW)
C  *  TPLBTC - Thermal power lost due to thermocline degradation (MW)
C  *  CLF    - Charging loss factor
C  *  DLF    - Discharging loss factor
C  *  TNKLF  - Tankage loss factor
C  *  A      - Thermocline degradation coefficients
C  *  LS     - Storage flag.  1 = non-thermocline,  2 = thermocline,
C  *           3 = sodium receiver with salt storage.
C  *  PTS2   - Power actually delivered to the storage tanks (MW)
C  *  PFS2   - Power actually extracted from the storage tanks (MW)
C  *  TSTC   - Time charging system has been in startup transition (hr)
C  *  ESTC   - Energy accumulated during charging startup transition (MWhr)
C  *  TSTCR  - Minimum time delay for storage charging startup (hr)
C  *  ESTCR  - Energy penalty for storage charging startup (MWhr)
C  *  TSTD   - Time discharging system has been in startup transition (hr)
C  *  ESTD   - Energy accumulated during discharging startup transition (MWhr)
C  *  TSTDR  - Minimum time delay for storage discharging startup (hr)
C  *  ESTDR  - Energy penalty for storage discharging startup (MWhr)
C  *  PWARMC - Storage charge startup power rate (MW)
C  *  PWARMD - Storage discharge startup power rate (MW)
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  Thermal storage charging and extraction heat exchanger operational
C  and startup characteristics are defined as are tank characteristics.
C
      DATA PTSMAX /375.0/,
     1 PFSMAX /270./,
     1 PTSMIN /0.0/,
     1 PFSMIN /0.0/,
     1 EMAX  /330.0/,
     1 EMIN  /0.0/,
     1 ES   /0.0/,
     1 A  /0.0,0.0,0.0/
     1 CLF  /0.0/,
     1 DLF  /0.14/,
     1 TNKLF  /0.1/,
     1 LS    /1/,
     1 REFPC  /264.0/,
     1 TSTCR  /0.0/,
     1 ESTCR /0.0/,
     1 TSTDR /0.25/,
     1 ESTDR /0.0/,
     1 PWARMC /375.0/
     1 PWARMD /30.0/
C
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  ************   NAMELIST DISPATCH ***********************************
C
C CHANGE3
C NEW VALUES ADDED TO ALLOW INSOLATION DATA FROM ANY YEAR TO BE USED
C
      NAMELIST /DISPATCH/ IDISP, TSTUR, PSTFR,IDF1,IDF2,NVAC,IDYLT1,
     1 IDYLT2,ISUMR1,ISUMR2,IVAC,IWEEK
C
C  *  *  *  *  *  *  *  DISPATCH  Variables  *  *  *  *  *  *  *  *  *  *
C  *  IDISP  - 0 for GONOGO (sunfollowing); 1 for MAXOUT (time-of-day)
c  *  TSTUR  - average time to start turbine (hrs)
c  *  PSTFR  - average fraction of TPFSL required during TSTUR
C  *  IDF1,2 - printing of dispatch strategy trace on unit5(DISPAT.TRC)
c  *           occurs for days NDA=IDF1,IDF2
C  *  NVAC   - number of holidays in the year
c  *  IVAC(10) - the days of the year that are holidays
c  *  IDYLT1,2 - the day of the year that daylight savings time  starts
c  *              and ends 
c  *  ISUMR1,2 - The day of the year that the "summer" electricty rates
c  *              begin and end
C  *  IWEEK    - day of the week for 1 January (1=monday, etc)
C
C  Positions in the IVAC (vacation and holiday) array are as follows:
C  THESE ARE HOLIDAYS IN SCE'S RATE SYSTEM
C
C        1 - New Years Day
C        2 - Washington's Birthday
C        3 - Memorial Day         
C        4 - Independence Day     
C        5 - Labor Day            
C        6 - Veteran's Day
C        7 - Thanksgiving Day
C        8 - Christmas Day
C        9 - Unused
C       10 - Unused
C
C   If vacation/holiday days are added, be sure to increment NVAC to 
C   reflect the change.
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C  The dispatch strategy is selected:
C
      DATA IDISP /0/,
     1 TSTUR /1.25/,
     1 PSTFR /0.50/,
     1 IDF1 /400/,
     1 IDF2 /0/
C CHANGE3 NEW VARIABLES ADDED
c default values are for 1985
      DATA NVAC/8/,ISUMR1/153/,ISUMR2/279/,IDYLT1/118/,IDYLT2/299/,
     1 IVAC/1,49,147,185,245,315,332,359,0,0/,IWEEK/2/
C
C   VALUES FOR 1984:  IVAC/2,51,149,186,247,317,327,0,0/,
C    NVAC/8/,ISUMR1/155/,ISUMR2/280/,IDYLT1/120/,IDYLT2/301/,IWEEK/7/
C
C IT WOULD NOT BE COMPLETELY INCONSISTENT TO USE THE 1985 VALUES FOR ANY
C NON LEAP YEAR AND THE 1984 VALUES FOR ANY LEAP YEAR
C
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  ************   NAMELIST PRNTOUT **************************************
C
      NAMELIST /PRNTOUT/ MFLAG, NDAF, NDAL
C
C  *  *  *  *  *  *  *  PRNTOUT  Variables  *  *  *  *  *  *  *  *  *  *
C  *  MFLAG  -  Daily output print flag:
C  *            0 = None, only final summary will be printed
C  *            1 = In addition, a daily summary is also printed
C  *            2 = In addition, a record of the power flow and energy 
C  *                status will be printed for each DELT period
C  *            3 = In addition, the collector field efficiency and
C  *                power to the receiver will be printed for each
C  *                DELT period
C  *            4 = In addition, input data from the weather data tape 
C  *                will also be printed
C  *  NDAF  -  First day to be printed with MFLAG level of information.
C  *           if left blank, NDAF will be 1
C  *  NDAL  -  Last day of run.  if left blank, NDAL will be 366
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      DATA MFLAG, NDAF, NDAL /0, 1, 366/
C
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C CHANGE 8/25/93 ADD NEW PRSTIC VARIABLES
      NAMELIST /PRSTIC/ PA,PAHR,RCVPAT,RCVPAE
C
C PAHR IS IN HOURS
C RCVPAT STARTUP THERMAL LOSS IS IN MWHRS
C RCVPAE STARTUP ELECTRICAL LOSS IS IN MW FOR ONE TIME STEP
C
      DATA PAHR /1.,2.,3.,4.,5.,6.,7.,8.,9.,10.,11.,12.,13.,14.,15./
      DATA RCVPAT/0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0./
      DATA RCVPAE/0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0./
C
C THESE VECTORS ARE THE LOOK UP TABLE FOR RECEIVER STARTUP
C PARASITICS (BOTH THERMAL AND ELECTRIC) AS A FUNCTION OF TRSHUT.
C
C NEW NAMELIST FOR THE PARASITIC MODELS WHICH USE PA(30)
      PA(1)=  .8E-6
C PA(2) IS IN MW NOT ENERGY
      PA(2)=  .24E-4
      PA(3)=  1.1
      PA(4)=  -1.68
      PA(5)=  6.58
      PA(6)=  0.0
      PA(7)=  2.41
      PA(8)=  1.15
C PA(9) IS THE SOLAR MULTIPLE AND SHOULD BE EQUAL TO RS/TPFSL
      PA(9)=  1.38
      PA(10)= .712
      PA(11)= 0.356
      PA(12)= 0.0
      PA(13)= 1.65
      PA(14)= 0.21
      PA(15)= 0.239
      PA(16)= 0.275
      PA(17)= 0.537
      PA(18)= 0.608
      PA(19)= 1.04
      PA(20)= 1.35
      PA(21)= 1.18
      PA(22)= 0.728
      PA(23)= 0.469
      PA(24)= 0.293
      PA(25)= 0.251
      PA(26)=11.5
C PA(27) MUST NOT BE 1
      PA(27)=3.
      PA(28)=.31
      PA(29)= .285
      PA(30)= 1.06
C
C
C  *************  Read in NAMELIST values,  if any  ********************
      REWIND 8
      READ (8,NMLGEN)
      REWIND 8
      READ (8,NMLLOC)
      REWIND 8
      READ (8,NMLCOEF)
      REWIND 8
      READ (8,NMLCOLF)
      REWIND 8
      READ (8,NMLRCVR)
      REWIND 8
C CHANGE2
      IF(IFILL.EQ.1)THEN
        WRITE(9,*)'WARNING, THE MEANING OF IFILL=1 AND PMPAR '
	WRITE(9,*)' HAS BEEN CHANGED.  CALL GREG KOLB (505)-844-1887 '
	WRITE(*,*)'WARNING, THE MEANING OF IFILL=1 AND PMPAR '
	WRITE(*,*)' HAS BEEN CHANGED.  CALL GREG KOLB (505)-844-1887 '
      END IF
      READ (8,NMLPIPE)
      REWIND 8
      READ (8,NMLTRBN)
      REWIND 8
      READ (8,NMLSTRG)
      REWIND 8
      READ (8,DISPATCH)
      IF(IDISP.EQ.1)THEN
	WRITE(9,*)'WARNING, NEW INPUT REQUIRED FOR IDISP=1 '
	WRITE(9,*)' CALL DAN ALPERT (505) 844-6982'
	WRITE(*,*)'WARNING, NEW INPUT REQUIRED FOR IDISP=1 '
	WRITE(*,*)' CALL DAN ALPERT (505) 844-6982'
      END IF
      REWIND 8
      READ (8,PRNTOUT)
      REWIND 8
      READ (8,PRSTIC)
      IF( NDAF .EQ. 0 ) NDAF = 1
      IF( NDAL .EQ. 0 ) NDAL = 366
C
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C  *************  Print NAMELIST values  *******************************
      WRITE(9,NMLGEN)
      WRITE(9,NMLLOC)
      WRITE(9,NMLCOEF)
      WRITE(9,NMLCOLF)
      WRITE(9,NMLRCVR)
      WRITE(9,NMLPIPE)
      WRITE(9,NMLTRBN)
      WRITE(9,NMLSTRG)
      WRITE(9,DISPATCH)
      WRITE(9,PRNTOUT)
      WRITE(9,PRSTIC)
C CHANGE3
      IWEEK = IWEEK-1
      IF(IWEEK.EQ.0)IWEEK=7
C  ********************************************************************
C     THERE IS LIMITED CHECKING OF THE VALIDITY OF CERTAIN INPUT VALUES
C CHANGE 1/15/87 
C PRINT WARNING IF SPLINE FITS ARE NOT GOING TO BE USED IN FUNCTIONS
C XLR AND EFWS (IF THE FIRST AND LAST VALUES OF THE DATA ARE EQUAL,
C NO SPLINE FIT WILL BE PERFORMED - THE FIRST VALUE IS USED)
      IF(WSEF(1) .EQ. WSEF(NEFWS))THEN
	WRITE(9,*)' SPLINE FIT NOT USED TO
     1 ESTIMATE FIELD EFFICIENCY AS A FUNCTION OF WINDSPEED -'
	WRITE(9,*)'  CONSTANT EFFICIENCY OF', WSEF(1), ' ASSUMED.'
      END IF
C
      IF(PLXLR(1) .EQ. PLXLR(NXLR))THEN 
	WRITE(9,*)' SPLINE FIT NOT USED TO
     1 ESTIMATE THERMAL RECEIVER LOSSES -'
       WRITE(9,*)'  CONSTANT LOSS OF', PLXLR(1), 'MW(T) ASSUMED'  
      END IF
C
C CHANGE 1/9/87 DJA
C INPUT CHECK FOR INCONSISTENT VALUES
      IF(PWARMC .LT. (RS*RMF))WRITE(*,*)'DANGER DANGER - PWARMC .LT. 
     1  RECEIVER MIN FLOW, CHECK INPUT'
      IF(PTSMIN .GT. PWARMC + 1.)WRITE(*,*)'DANGER DANGER - PTSMIN .GT.
     1 PWARMC+THERMAL LOSSES, CHECK INPUT'
      IF(PFSMIN.GT.TPFSL*TMFS)WRITE(*,*)'DANGER DANGER - PFSMIN TOO BIG
     1 TO START TRBN, CHECK INPUT'
C
C CHANGE 1/28/87 DJA
C THE SPLINE FIT INTERPOLATIN DOES NOT ALLOW FOR EXTRAPOLATION OUTSIDE
C OF THE DATA CONTAINED IN THE AZ/EL TABLE. TO PREVENT THE FIELD FROM
C OPERATING OUTSIDE THIS RANGE, ELIM MUST BE .GE. THE FIRST
C VALUE IN THE VECTOR ELR
      IF(ELIM.LT.ELR(1))WRITE(*,*)' DANGER DANGER - ELIM .LT.ELR(1),
     1  CHECK INPUT NAMELIST: NMLCOEF'
C
      IF(IDISP.EQ.0)THEN
	 IF(ESMAX1.LT.ESMIN1 .OR. ESMAX2.LT.ESMIN2)WRITE(*,*)
     1   'DANGER DANGER  ESMAX < ESMIN, CHECK NAMELIST NMLTRBN'
	 IF(ESMAX1.EQ.ESMIN1)THEN
	    WRITE(9,*)' GONOGO DISPATCH SELECTED WITH TRUE
     1 SUNFOLLOWING DISPATCH'
	 ELSE
	    WRITE(9,*)' GONOGO DISPATCH SELECTED WITH 
     1 SIMPLE VERSION OF VALUE MAXIMIZATION'
	 END IF
      ELSE
	    WRITE(9,*)' VALUE MAXIMIZING DISPATCH (MAXOUT) SELECTED'
      END IF
      WRITE(9,1500)
 1500 FORMAT(1H1)
      RETURN
      END
C
C
      SUBROUTINE COEF
C
C     The subroutine COEF calls IBCICU, an interpolatory natural
C  bicubic spline routine, to generate matrices representing collector
C  field efficiencies. They are based on NAMELIST values obtained from the
C  code MIRVAL or DELSOL3.
C
C     COEF was revised on 27-Nov-1985 to use the new IMSL coefficient
C  generating routine IBCCCU.
C
      COMMON /COMCOEF/ FR(7,7),ELR(7),AZR(7),CAE(2,7,2,7),
     +  WK(210), NX, NY, IC
C
C
C  Initialize the spline fit array for the field efficiencies.  This 
C  code is necessary if the IMSL math subroutines are used in place 
C  of subroutine TSPLIN provided with SOLERGY
C
C      CALL IBCCCU(FR,ELR,NX,AZR,NY,CAE,IC,WK,IER)
C
C     IF( IER .NE. 0 ) GO TO 30
C
      RETURN
C
   30 CONTINUE
      WRITE(9,1500) IER
 1500 FORMAT(// 13H IBCICU ERROR,I5,5X,1HJ,I3,5X,1HK,I3)
      STOP '!!! Run terminated by error !!!'
      END
C
C
      SUBROUTINE INPUT2 (NDA,NFLAG)
C
C     This is the only routine that must be reviewed if the form of
C  the insolation and weather data or plant location (Barstow, CA) is
C  changed. It reads the values for direct normal insolation, wind
C  direction, wind speed, dew point temperature, station pressure, and dry
C  bulb temperature from TAPE2. It calculates the wet bulb temperatures and
C  obtains the azimuth and elevation values from subprogram DEA. It lists
C  all values if so desired.
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
C CHANGE IYR ADDED TO THIS COMMON
      COMMON /LOCATION/ ALAT, ALONG, ZONE, IFLAGP,IYR
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C 
      REAL MIN
      DIMENSION DT(5)
      DATA PRESSA /826./
      DO 20 J = 2, NPTS
C
	READ (2,*) DNI(J), WD(J), WS(J), DPT(J), SP(J), DBT(J)
C CONVERT DNI FROM WATTS TO KW
	DNI(J) = DNI(J) * 1.E-3
C USE SIMPLE MODLE TO CONVERT DBT AND DPT TO WET BULB TEMP
	XN = ( DBT(J) - DPT(J) ) / 10.
	IF (DBT(J) .LT. 0.) GO TO 15
	WBT(J) = DBT(J) - (0.034*XN - .00072*XN*(XN-1.)) *
     1  (DBT(J) + DPT(J) - 2.*SP(J) + 108.)
	GO TO 20
C
   15   CONTINUE  ! Dry bulb temperaure less than zero
	WBT(J) = DBT(J) - (0.034*XN - .006*XN*XN) *
     1  (0.6*(DBT(J) + DPT(J)) - 2.0*SP(J) + 108.0)
   20 CONTINUE
      IF (NFLAG .GE. 4) THEN 
	 WRITE(9,2001)NDA,IYR
	 WRITE(9,2015)
	 WRITE(9,2005)
      END IF
C
      DO 100 N = 2,NPTS
C
C  Convert time in hours to hours, minutes, and seconds for SUNPOS
      IQ   = IFIX(TIM(N))
      XNHR = FLOAT(IQ)
      XXX  = (TIM(N)-IQ)*60.
      IQ   = IFIX(XXX)
      MIN  = FLOAT(IQ)
      SEC  = (XXX-MIN)*60. 
      DA   = FLOAT(NDA)
C
C CHANGE3 YEAR REMOVED FROM ARGUMENT LIST
	CALL SUNPOS(DA,XNHR,MIN,SEC,
     1              EL(N),EC,AZ(N),T,SOLTIME,DBT(N),PRESSA)
C CHANGE2 4/29/87
C IN SOME CASES THE INSOLATION IS NONZERO FOR ELEVATION ANGLES LESS THAN
C ZERO. THIS PROBABLY ARISES FROM THE PROCESS OF FILLING IN MISSING
C DAYS OR FROM THE ALORITHM USED TO CONVERT THREE MINUTE DATA TO 15 MINUTE.
C OR IF 30 MINUTE DATA IS CONVERTED TO 15 MINUTE. 
C ONE LINE ADDED TO ZERO-OUT DNI FOR ELEVATION LESS THAN ZERO
      IF(EL(N) .LE. 0.) then
c       if(dni(n).gt.0.)write(*,*)'sun below horizon',nda,n,dni(n)
       DNI(N)=0.
      end if
C
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      IF (NFLAG .GE. 4)
     1 WRITE(9,2010) TIM(N), AZ(N), EL(N), DNI(N), WD(N),
     1 WS(N), DBT(N), DPT(N), SP(N), WBT(N)
C     - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  100 CONTINUE
      IF (NFLAG .GE. 4) WRITE(9,2015)
C
 1000 FORMAT(/5H YEAR,I6)
 2001 FORMAT(1H1,/'  DAY ',I4,' YEAR ',I4/)
 2005 FORMAT(4X,4HTIME,6X,2HAZ,8X,2HEL,7X,3HDNI,7X,2HWD,
     1 7X,2HWS,6X,3HDBT,7X,3HDPT,7X,2HSP,7X,3HWBT/)
 2010 FORMAT(1X,F7.3,2F10.1,F10.3,F9.0,F9.2,3F9.1,F9.1)
 2015 FORMAT(/)
      RETURN
      END
C
C
      SUBROUTINE SUNPOS (DAY, XNHR, MIN, SEC,
     1 E, EC, A, T, SOLTIME, TA, PRESSA)
C
C
C    This subroutine calculates the local azimuth and elevation of
C  the sun at a specified location and time using an approximations to
C  the equations used to generate the nautical almanac.
C
C    This is copied from an article by Robert Walraven of the
C  University of California, Davis in Solar Energy, vol. 20 no. 5-c
C  published in November 1978 with some additions and corrections.
C
C    Another reference is John C. Zimmerman,"Sun-Pointing Programs
C  and Their Accuracy," SAND81-0761, Sandia National Laboratories,
C  Albuquerque, NM, May 1981 wherein this subroutine, called SUNAEP by
C  Zimmerman, as well as many other sun position routines are presented
C  and evaluated.
C
C  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *  *  *
C  *
C  *  Input Parameters:
C  *
C  *  YEAR         -  the year number (e.g., 1984).
C  *  DAY          -  the day number of the year starting with 1 for
C  *                  January 1
C  *  XNHR,MIN,SEC -  the time of the day in local time:  hours, minutes,
C  *                  seconds
C  *  ZONE         -  the local international zone time (e.g. PST=8)
C  *  ALAT         -  the local latitude in degrees (north is positive)
C  *  ALONG        -  the local longitude in degrees west of Greenwich.
C  *  IFLAGP       -  set to one to get full output to screen of
C  *                  calculated variables.  Any other value give
C  *                  no output.
C  *  TA           -  ambient temperature (degrees F). Used in atmospheric
C  *                  refraction correction calculation.
C  *  PRESSA       -  ambient pressure (millibars). Used in atmospheric
C  *                  refraction correction calculation.
C  *
C  *
C  *
C  *  Output Parameters:
C  *
C  *  A            -  Azimuthal angle of the sun in degrees (positive
C  *                  is west of south).
C  *  E            -  Elevation of the sun in degrees.
C  *  EC           -  Elevation corrected for atmospheric refraction
C  *                  (degrees)
C  *  T            -  Local Standard time in hours
C  *  SOLTIME      -  Local solar time (hours)
C  *  SUNR         -  Time of sunrise in Local Standard time (hours)
C  *  SUNS         -  Time of sunset in Local Standard time (hours)
C  *
C  *
C  *  Internal Variables of Some Interest
C  *
C  *  DECL         -  Solar declination (radians).
C  *  PHI          -  Latitude in radians.
C  *  SUNDA        -  Length of solar day in hours.
C  *
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
C CHANGE IYR ADDED TO THIS COMMON
      COMMON /LOCATION/ ALAT, ALONG, ZONE, IFLAGP,IYR
C
      REAL MIN
C CHANGE3 TWO LINES ADDED
      YEAR = FLOAT(IYR)
      DATA HLDAY/0./
C RAD CONVERTS DEGREES TO RADIANS:
      DATA TWOPI, RAD /6.2831853, 0.017453293/
C
      DYSAV = DAY
      YRSAV = YEAR
      DELYR = YEAR-1980.
      LEAP = INT(DELYR/4.)
C POSSIBLE CHANGE3
C      IF((DELYR/4.-FLOAT(LEAP)).LT. 0.001 .AND. DAY.LE.60.) DAY = DAY-1.
      IF((DELYR/4.-FLOAT(LEAP)).EQ. 0. .AND. DAY.LE.60.) DAY = DAY-1.
      T = XNHR+(MIN+SEC/60.)/60.+ZONE
      TIME = DELYR*365.+FLOAT(LEAP)+DAY-1.+T/24. ! Time in days
C                                                    since 1980.
      IF (DELYR .EQ. (FLOAT(LEAP)*4.)) TIME = TIME-1.
      IF ((DELYR.LT.0.).AND.(DELYR.NE.(FLOAT(LEAP*4))))TIME = TIME-1.
      THETA = (360.*TIME/365.25)*RAD
      G = -0.031271 - 4.53963E-7*TIME +THETA
      EL = 4.900968+3.67474E-7*TIME+(0.033434-2.3E-9*TIME)*SIN(G)
     1 +0.000349*SIN(2.*G) + THETA
	EPS = 0.409140 - 6.2146E-9*TIME
      SEL = SIN(EL)
      A1 = SEL*COS(EPS)
      A2 = COS(EL)
      RA = ATAN2(A1,A2)
      IF (RA .LT. 0.) RA = RA+TWOPI
      DECL = ASIN(SEL*SIN(EPS))
	DECLD = DECL/RAD
      ST = 1.759335+TWOPI*(TIME/365.25-DELYR)+3.694E-7*TIME
      IF (ST .GE. TWOPI) ST = ST-TWOPI
      S = ST+(T*15.-ALONG)*RAD
      IF (S .GE. TWOPI) S = S-TWOPI
      H = RA-S
C
C  Compute the local solar time.
C
	SOLANG = H/RAD
	IF(SOLANG.LT.0.) SOLANG = -SOLANG
      IF(H.LT.0. .AND. SOLANG.GT.180.)SOLTIME = 12.-(360.-SOLANG)/15.
      IF(H.LT.0. .AND. SOLANG.LE.180.)SOLTIME = 12.+SOLANG/15.
      IF(H.GE.0. .AND. SOLANG.GT.180.)SOLTIME = 12.+(360.-SOLANG)/15.
      IF(H.GE.0. .AND. SOLANG.LE.180.)SOLTIME = 12.-SOLANG/15.
C
C  Compute the sun elevation and azumith.
C
      PHI = ALAT*RAD
      ER = ASIN(SIN(PHI)*SIN(DECL)+COS(PHI)*COS(DECL)*COS(H))
      CSC = COS(DECL)*SIN(H)/COS(ER)
      IF (CSC .GT. 1.) CSC=1.
      IF (CSC .LT. -1.) CSC=-1.
      A = ASIN(CSC)/RAD
      IF (SIN(ER) .GE. SIN(DECL)/SIN(PHI)) GO TO 15
      IF (A .LT. 0.) A = A + 360.
      A = 180. - A
      AZ = A
   15 E = ER/RAD
      A = -1.0 * A
C
C CHANGE3 SUNRISE AND SUNSET TIMES ARE CALULATED ONLY ONCE PER DAY
      IF(DYSAV.EQ.HLDAY)THEN
C SUNRISE AND SUNSET ALREADY KNOWN FOR TODAY
	GO TO 40
      END IF
      HLDAY = DYSAV
C  Calculate solar time for sunrise and the length of the solar day.

C
      H = ACOS(-TAN(PHI)*TAN(DECL)) !  This is the hour angle for
C                                        sun elevation = 0.
      SOLANG = H/RAD
      IF (SOLANG.LT.0.) SOLANG = -SOLANG
      IF(H.LT.0. .AND. SOLANG.GT.180.) SOLT=12.-(360.-SOLANG)/15.
      IF(H.LT.0. .AND. SOLANG.LE.180.) SOLT=12.+SOLANG/15.
      IF(H.GE.0. .AND. SOLANG.GT.180.) SOLT=12.+(360.-SOLANG)/15.
      IF(H.GE.0. .AND. SOLANG.LE.180.) SOLT=12.-SOLANG/15.
C
C  Solar time for sunrise.
C
      SUNR=SOLT
C
C  Calculate correction to change sunrise time from solar time
C  to local time.
C  This code was not originally part of the subroutine and was
C  provided by Clement Chiang of Sandia Labs.  Its original source has been
C  lost in the passage of time wherein the memories of man grow dim.
C
      XQ = 360.*RAD*(DAY-1.)/365.242
      CLONG = (ALONG-ZONE*15.)/15.
      EOT = 0.1236*SIN(XQ)-0.0043*COS(XQ)+0.1538*SIN(2.0*XQ)+
     +  0.0608*COS(2.0*XQ)
C
C  Calculate sunrise and sunset time in local time.
C
      SUNR = SUNR+EOT+CLONG
      SUNDA = 2.*SOLANG/15.
      SUNS = SUNR+SUNDA
C
C  Correction for atmospheric refraction.  The correction is not
C  used in SOLERGY as there is some doubt to its accuracy.
C  However, it is included if a particular user should feel the need
C  for a such a correction.  The effect of the correction is to
C  indicate a slightly earlier sunrise and a slightly later sunset
C  than the sunrise and sunset times calculated above.
C  During the majority of the day, the correction is useless given the
C  coarseness of the Az-El table.
C CHANGE3 COMMENTED OUT
C
C      IF (E .LT. -0.575) GO TO 20
C      IF (E .LT. 5.) GO TO 10
C      TANE = TAN(E*RAD)
C      R = 58.1/TANE-0.7/TANE**3+0.000086/TANE**5
C      GO TO 30
C   10 R = 1735.+E*(-518.2+E*(103.4+E*(-12.79+E*0.711)))
C      GO TO 30
C   20 R = -20.774/TAN(E*RAD)
C   30 CONTINUE
C      RFAC = (PRESSA*510.)/(1013.*(460.+TA)) 
C      RC = R*RFAC
C      RC = RC/3600.
C      EC = E + RC
C
C CHANGE3 LINE ADDED
  40  CONTINUE
C  If the print flag is set to 1, print out variable values,
C  otherwise, print nothing.
C
      IF (IFLAGP .NE. 1) GO TO 500
      WRITE(*,*)'A= ',A,'   E= ',E
      WRITE(*,*)'LEAP= ',LEAP,'   T= ',T
      WRITE(*,*)'TIME= ',TIME,'   DELYR= ',DELYR
      WRITE(*,*)'THETA= ',THETA,'   G= ',G
      WRITE(*,*)'EL= ',EL,'   EPS= ',EPS
      WRITE(*,*)'SEL= ',SEL,'   RA= ',RA
      WRITE(*,*)'DECL= ',DECL,'   SOLTIME= ',SOLTIME
      WRITE(*,*)'ST= ',ST,'   S= ',S
      WRITE(*,*)'H= ',H,'   ER= ',ER
      WRITE(*,*)'EC= ',EC,'   R= ',R
      WRITE(*,*)'RC= ',RC,'   RFAC= ',RFAC
  500 CONTINUE
C CHANGE3 COMMENTED OUT
C      DAY = DYSAV
C      YEAR = YRSAV
	RETURN
	END
C
C
      SUBROUTINE COLF(NDA)
C
C     The collector field model calculates the power to receiver (PTR)
C  as a function of the direct normal insolation, the field size and field
C  efficiency.
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *  FS      -  Field area x number of fields (square meters)
C  *  TLIML   -  Lower temperature limit (F)
C  *  TLIMU   -  Upper temperature limit (F)
C  *  ELIM    -  Minimum elevation for collector operation (degrees)
C  *  WSLIM   -  Maximum wind speed for collector on line (meters/sec)
C  *  RFLCTY  -  Mirror reflectivity coefficient
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
C CHANGE3 COMMON REMOVED - NOT NEEDED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
C CHANGE IDAYMX ADDED
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
C
      DATA WC /1.E-3/
C
C CHANGE2 NEXT SECTION REWRITTEN
C      IST = 0
C      TDWN = 0.
C      TDWNL = DELT
C      DO 50 J = 1,NPTS
C      IF (EL(J) .LT. ELIM) GO TO 50
C CHANGE NEXT LINE CHANGED
C      IF (WS(J) .GT. WSLIM) GO TO 40
C      IF (DBT(J) .LT. TLIML) GO TO 40
C      IF (DBT(J) .GT. TLIMU) GO TO 40
C      IF (DNI(J) .EQ. 0.) GO TO 30
C
C      TDWN = 0.
      DO 50 J=2,NPTS
      IF(EL(J).GT. 0.0)THEN
C THE SUN IS ABOVE THE HORIZON, CALCULATE FIELD EFFICIENCY
	 CALL EFFIC (AZ(J),EL(J),F,WS(J),RFLCTY)
	 IF( FMAX .LT. F ) THEN
C  FMAX IS HIGHEST COLLECTOR FIELD EFFICIENCY
	    FMAX = F  
	    IDAYMX = NDA
	 END IF
      ELSE
C SUN IS BELOW HORIZON
	 F=0.0
      END IF 

C
C CHANGE2 NEXT SECTION CHANGED 
C THE EFFECT OF WIND ON THE
C FIELD IS INCLUDED HERE RATHER THAN IN
C F (THE FIELD EFFICIENCY)
C
      PTR(J) = F * DNI(J) * FS * WC *  EFWS(WS(J))
      EF(J) = F
  50  CONTINUE
C
C   30 CONTINUE
C      TDWN = TDWN + DELT
C      IF( TDWN .GE. TDWNL ) GO TO 50
C      GO TO 50
C
C   40 CONTINUE
C      F = 0.
C      EF(J) = F
C
C   50 CONTINUE
      RETURN
      END
C
C
      SUBROUTINE EFFIC(AZ,EL,EFF,WS,RFLCTY)
C
C     With the aid of LOCATE and IBCEVU, this routine calculates the
C  collector field efficiency as a function of azimuth, elevation, wind
C  speed and an efficiency constant.
C
C     Subroutine EFFIC was changed to utilize the new IMSL
C  routines on 27-Nov-1985.  Subroutine LOCATE was eliminated since
C  it became superfluous.
C
C     A two-dimensional linear interpolation routine (LININT) was added
C  on 29-May-1985 as a substitute for the IMSL routines so SOLERGY may
C  be executed on computers without an appropriate math package.
C
      COMMON /COMCOEF/ FR(7,7),ELR(7),AZR(7),CAE(2,7,2,7),
     +  WK(210), NX, NY, IC
C
      AZ1 = ABS(AZ) !  Only positive values of the azumith angle are
C                      used.  This assumes the heliostat field is
C                      symmetric.
      EL1 = EL
C
C           Check whether the elevation and azumith value are out
C         of range.
C
      IF (EL1.LT.0 .OR. EL1.GT.89.5) WRITE(*,10) EL1
   10 FORMAT (1H0,'ELEVATION VALUE OUT OF RANGE: ELEVATION= ',
     +         1PE11.3)
      IF (EL1 .LT. 0.) EL1=0.
      IF (EL1 .GT. 89.5) EL1=89.5
      IF (AZ1.LT.0 .OR. AZ1.GT.130.) WRITE(*,20) AZ1
   20 FORMAT (1H0,'AZUMITH VALUE OUT OF RANGE:  AZUMITH= ',
     +         1PE11.3)
      IF (AZ1 .LT. 0.) AZ1=0.
      IF (AZ1 .GT. 130.) AZ1=130.
C
C  Use the new IMSL routine to calculate the field efficiency:
C
C      CALL IBCEVL(ELR,NX,AZR,NY,CAE,IC,EL1,AZ1,EFF,IER)
C
C  Or on machines where the IMSL math library is not available, use
C  the following interpolation routine provided in SOLERGY
C
      CALL TSPLIN(ELR,NX,AZR,NY,FR,EL1,AZ1,EFF,IER)
C
      IF( IER .NE. 0 ) GO TO 50
C
C  Include the effects of mirror reflectivity and wind:
C
C CHANGE2 NEXT LINE REMOVED 
C  EFWS(WS) IS  NOW INCLUDED IN SUBROUTINE COLF
C      EFF = EFF * RFLCTY * EFWS(WS)  ! EFWS(WS) is the multiplicative wind
C       speed correction factor for the collector field - Table 3.2 (manual)
C
      EFF = EFF * RFLCTY 
      RETURN
C
C
C
   50 CONTINUE
      WRITE(9,1500) IER,LX,LY, EL1, AZ1
 1500 FORMAT(///20H ERROR IN SPLINE FIT/6H IER =,I5/5H LX =,I5/
     1 5H LY =,I5,/,6H EL1 =,F10.2/6H AZ1 =,F10.2)
      STOP '!!! Run terminated by error !!!'
      END
C
C
      FUNCTION EFWS(XI)
C
C     With the aid of the cubic spline routines, SPLIFT and SPLINT,
C  this routine calculated the effect of wind speed on collector field
C  efficiency.
C
      DIMENSION X(8), Y(8), YP(8), YPP(8), W(24)
C
      COMMON /COMEFWS/ NEFWS, WSX(8), WSEF(8)
C
      EQUIVALENCE (N,NEFWS) , (X,WSX) , (Y,WSEF)
C
      DATA M /0/
      DATA ISX /0/ , A1 /0./ , B1 /0./ , AN /0./ , BN /0./ , NI /1/
C
C CHANGE 1/8/87 DJA
C TO SPEED UP SOLERGY, IF THERE ARE NO DATA TO BE FIT, THE FUNCTION ROUTINE
C RETURNS A CONSTANT (A WARNING IS PRINTED IN INPUT1).
C
      IF (M .GT. 0) GO TO 10
C  THIS SECTION EXECUTED ONLY ONCE PER SOLERGY RUN (NEXT TIME, M=1)
C IF THE FIRST AND LAST EFFICIENCIES ARE EQUAL, NO INTERPOLATION IS NEEDED
      IF(WSEF(1).EQ.WSEF(NEFWS))THEN
	LSPEED = 1
      ELSE
	LSPEED = 0
	CALL SPLIFT (X,Y,YP,YPP,N,W,IERR,ISX,A1,B1,AN,BN)
	IF (IERR .NE. 1) GO TO 20
      END IF
      M = 1
C
   10 CONTINUE
      IF (LSPEED  .EQ. 1) THEN
	EFWS = WSEF(1)
	RETURN
      ELSE
	IF (XI .GE. X(N)) GO TO 40
	CALL SPLINT (X,Y,YPP,N,XI,YI,YPI,YPPI,NI,KERR)
	IF (KERR .NE. 1) GO TO 30
	EFWS = YI
	RETURN
      END IF
C
   20 CONTINUE
      WRITE (9,1510) IERR, XI
      STOP '!!! Run terminated by error !!!'
C
   30 CONTINUE
      WRITE (9,1500) KERR, XI
      STOP '!!! Run terminated by error !!!'
C
   40 CONTINUE
      EFWS = Y(N)
      RETURN
C
 1500 FORMAT(//6H ERROR,I2,17H IN SPLINT.  WS =,F7.3)
 1510 FORMAT(//6H ERROR,I2,17H IN SPLIFT.  WS =,F7.3)
      END
C
C
C
      SUBROUTINE RCVR(K,NFLAG)
C
C     The receiver model is entered once each DELT period. Its mode of
C  operation is determined by the current thermal power available and the
C  previous status of the receiver. In addition to shutdown, startup and
C  rated modes, a derated mode is included.
C
C    The first section of coding determines that the thermal power is
C  within the input operating range of the receiver. If below minimum flow
C  criteria, the thermal power input is set to zero and the power loss
C  tallied. If above, the input is diminished to the receiver size,
C  simulating heliostat defocusing, and the power loss is tallied.
C
C    A branch jump is then made to the section of the applicable mode
C  of operation.
C
C    The thermal power loss is calculated by the function XLR. 
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *  EPS    -  Receiver reflectivity
C  *  XLR    -  Receiver subtractive thermal loss parameter
C  *  RS     -  Receiver size - maximum thermal OUTPUT (MW)
C  *  ALPHAR -  Receiver cool down/start-up constant
C  *  TREQD  -  Receiver cold start time (hours)
C  *  EREQD  -  Energy required for receiver start (MWhr)
C  *  RMF    -  Receiver minimum flow factor (fraction of RS)
C  *  PLRMF  -  Power available to receiver, but not used because
C  *            it is less than receiver requires for operation
C  *  THOLD  -  Time receiver leaves rated operation for hold mode
C  *  TRSHUT -  Time receiver has been shut down (hours)
C  *  STIME  -  Time receiver spends in startup daily (hours)
C  *  WTIME  -  Time receiver is down due to weather (hours)
C  *  IRSU   -  Receiver mode flag.  1 = Start-up,  0 = Not
C  *  IRO    -  Receiver mode flag.  1 = Rated operation, 0 = Not
C  *  IDRO   -  Receiver mode flag.  1 = Derated operation, 0 = Not
C  *  IHOLD  -  Receiver mode flag.  1 = Startup/hold mode, 0 = Not
C  *  IRSHUT -  Receiver mode flag.  1 = Shutdown,  0 = Not
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
      COMMON /PLANT/ IFOUT(50), ISOUT(50), IFORC, ISCHED, GPOWER
      COMMON /COUNTER/ IBEGIN1, IBEGIN2, IBEGIN3, IBEGIN4
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C CHANGE2 COMSTRG ADDED, NEW COMMON ADDED
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /COMHLD/HLDLSH,HLDTIM
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
      common /conesta/sunmx,exfac
C
      DATA TRSHUT /8.000/, IRSHUT /1/, IRSU /0/, IRO /0/
      DATA IHOLD /0/, IDRO /0/
C
C     ALLEN calculates SUNMX* maximum insolation values using a method
C  developed by Allen and described and referenced in the DELSOL manual.
C
C  *
C  *  AMC    - Air mass correction
C  *  BETA   - An exponent
C  *  ET     - Extraterrestrial insolation, W/sq. meter
C  *  GAMMA  - An exponent
C  *  KRISE  - Time interval preceding sunrise
C  *  KSET   - Time interval following sunset
C  *  PRAT   - Ratio of atmospheric to sea level pressures
C  *  RAIN   - Precipitable water overhead, mm
C  *  ZEN    - Zenith angle, degrees
C
C
C ALLEN'S MODEL FOR CLEAR SKY INSOLATION.
      Data DPR /57.296/,PRAT/1.0/,RAIN /20./  ! For Barstow, CA
C      GAMMA = .367*(RAIN+11.53)/(RAIN+7.88)
      DATA GAMMA /0.415/
c      NDA = 1
c      NDAYSY = 365
c      ET = 1.353+.045*COS(6.283*FLOAT(NDA+10)/FLOAT(NDAYSY)) 
C  EXTRA-TERRISTRIAL INSOLATION KW/M**2
      DATA ET/ 1.35/
C      COEF = .263*(RAIN+2.72)/(RAIN+5.)
      DATA COEF /.239/ 
C EXFAX IS THE MARGIN BELOW THE THEORETICAL INSOLATION TO SHUT DOWN RCVR
c exfac now input in namelist receiver
c      DATA EXFAC /0.5000/
      IF(DNI(K).GT.0)THEN
C CALCULATE THEORETICAL MAXIMUM INSOLATION
       ZEN = 90.-EL(K)  ! Degrees
       BETA = .000849854*ABS(EL(K))**2.-.04117341*ABS(EL(K))-2.0936381
       IF (ZEN .LT. 60.) AMC = 1./COS(ZEN/DPR)
       IF (ZEN .GE. 60.) THEN
	 IF (COS(ZEN/DPR) .LT. .001) AMC = 10.
	 IF (COS(ZEN/DPR) .GE. .001) AMC = 1./ABS(COS(ZEN/DPR))-
     1                 41.972213*ABS(EL(K))**BETA
       END IF
       SUNMX = ET*(1.-COEF*ABS(AMC*PRAT)**GAMMA)
C       IF(DNI(K).GT.SUNMX)WRITE(*,*)'DNI .GT. SUNMX ',dni(k)/sunmx
	IF(SUNMX.LT.0.)THEN
c          WRITE(9,*)'SUNMX.LT.0',SUNMX,TIM(K)
	  SUNMX = 0.0
	END IF
      ELSE
       SUNMX = -1.
      END IF
C BACK TO THE ORIGINAL SOLERGY:
      IF( K .GT. 2 ) GO TO 5
      IRSHUT = 1   ! Receiver shut down
      IHOLD = 0    ! Receiver not in startup/hold mode
      IRSU = 0     ! Receiver not in startup
      IDRO = 0     ! Receiver not in derated operation
      IRO = 0      ! Receiver not in rated operation
      IDAYOP = 0
      ISUT = 0    ! Turbine not in startup from storage
      THOLD = 0.  ! Time receiver goes on hold
C CHANGE 1/8/87 DJA
C FOLLOWING LINE REMOVED - TRSHUT SHOULD NOT BE RESET EVERY NIGHT AT MIDNIGHT
C      TRSHUT = 0. ! Receiver shutdown time accumulator
      MFLG = 0    ! Penalty flag accumulator for receiver in hold mode 
C                   (only for receiver with doors)
      NFLG = 0    ! Penalty flag accumulator for receiver in derated mode
C
    5 CONTINUE
C CHANGE 8/25/93 ADD NEXT 3 LINES
C INITIALIZE RCVR STARTUP PARASITICS (THERMAL AND ELECTRICAL)
      STRPAT = 0.0
      STRPAE = 0.0
C CHANGE2 TWO LINES ADDED
      HLDLSH=0.
      HLDTIM=0.
      STIME = 0.0  ! Zero start-time accumulator
      WTIME = 0.0  ! Zero weather down-time accumulator
      PLRMF = 0.0  ! Receiver minimum flow losses (MWth)
C  CHANGE2 XLRWS IS A NEW VARIABLE
      XLRWS = XLR(WS(K))
C CHANGE2 THE NEXT 3 LINES CHANGED BECAUSE RS IS RECEIVER OUTPUT 
      IF( PTR(K) .GT. (RS+XLRWS)/EPS ) THEN 
C PTR TOO BIG, RS OUTPUT POWER LIMIT EXCEEDED.
C CALCULATE SURPLUS POWER TO RECEIVER
	SPTR = PTR(K) - (RS + XLRWS)/EPS
C  REDUCE POWER TO RECEIVER
	PTR(K) = PTR(K) - SPTR
C
      END IF
      EPTR = EPS * PTR(K)
      IF (IRSHUT .EQ. 0) GO TO 40  ! Otherwise, receiver was previously shut dow
C CHANGE 4/1/87
C THIS NEXT SECTION WAS RE WRITTEN
C
C THE RECEIVER IS SHUT DOWN (AND NOT IN STARTUP EITHER)  
C RECEIVER CAN'T STARTUP BEFORE SUNRISE AND SHOULDN'T
C BE STARTED UP 1.5 HOURS BEFORE SUNSET 
C (1.5 HOURS SELECTED BASED ON EXPERIENCE AT SOLAR 1)
C
      IF( TIM(K) .LT. SUNR .OR. TIM(K) .GT. SUNS-1.5) THEN 
C  RECEIVER REMAINS SHUTDOWN
C
	TRSHUT = TRSHUT + DELT  ! Accumulate receiver shutdown time
C TWO LINES ADDED
C ANY INSOLATION IN THIS PERIOD IS ACCUMLATED IN PLRMF
	PLRMF = PTR(K)
	PTR(K) = 0.
	PTWF = 0.0
	RETURN
      END IF
C 
C IT IS DAYTIME, IS THERE ENOUGH POWER TO THE RECEIVER TO START UP? 
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K)) 
      IF ((EPTR - XLRWS).LE.(RS*RMF).OR.(DNI(K).LT.EXFAC*SUNMX)) THEN 
C
C  THERE IS INSUFFICIENT POWER, RECEIVER REMAINS SHUTDOWN DUE TO WEATHER
C
       TRSHUT = TRSHUT + DELT  ! Accumulate receiver shutdown time
C
C TWO LINES ADDED ANY INSOLATION IS ACCUMULATED IN PLRMF 
C 
       PLRMF = PTR(K)
       PTR(K) = 0.
       PTWF = 0.0
       IRSHUT = 1
       IHOLD = 0
       IRSU = 0
       IDRO = 0
       IRO = 0
C
       WTIME = DELT
       IF ((IFORC .EQ. 1).OR.(ISCHED .EQ. 1)) WTIME = 0.  ! Do not accumulate
C                            weather outage time for forced or scheduled outages
       RETURN
      END IF
C
   30 CONTINUE     ! Begin receiver startup
C
      TS = TIM(K)   ! Receiver started now
      IDAYOP = IDAYOP + 1  ! Count daily receiver starts
      IRSU = 1      ! Receiver in startup mode
      IRSHUT = 0
C  Receiver startup counters (for information only):
      IF (TIM(K) .LE. (SUNR + 0.75)) IBEGIN1 = IBEGIN1 + 1
      IF (TIM(K) .LE. (SUNR + 2.00)) IBEGIN2 = IBEGIN2 + 1
      IF (TIM(K) .LE. (SUNR + 3.00)) IBEGIN3 = IBEGIN3 + 1
      IBEGIN4 = IBEGIN4 + 1
C CALCULATE CURRENT RECEIVER STATE, BASED ON TRSHUT (HOW LONG RECEIVER HAS 
C BEEN SHUT DOWN)
C XT0 = 0 FOR A HOT RECEIVER, XT0=1 FOR A COLD RECEIVER
C CHANGE2 6/21/87
C FOR VERY LONG SHUT-DOWN PERIODS, THE RECEIVER STATE IS SET TO ONE
C (AVOID UNDERFLOW ON SOME COMPUTERS)
C
      IF(TRSHUT * ALPHAR .GT. 15.) THEN
       XT0 = 1.
      ELSE
       XT0 = 1. - EXP ( -TRSHUT * ALPHAR)
      END IF  
C TWO LINES REMOVED
C      EINIT = XT0 * EREQD  ! Scale initial time and energy by receiver state
C      TINIT = XT0 * TREQD
C
C SCALE ENERGY AND TIME REQUIRED TO START RECEIVER
C NEXT TWO LINES CHANGED
      ETOSTART = EREQD * XT0 
      TTOSTART = TREQD * XT0 
C END CHANGE2
C
C CHANGE 8/25/93 ADD NEXT SECTION TO MODEL RCVR SU PARASITICS
C ADD ADDITIONAL THERMAL AND ELECTRICAL PARASITICS FOR ONLY THE 
C FIRST TIME STEP OF EVERY RECEIVER STARTUP.
C PARASITICS ARE A FUNCTION OF TRSHUT
      DO 35 I=1,15
      IF(TRSHUT .LE. PAHR(I) ) THEN
	STRPAT = RCVPAT(I)
	STRPAE = RCVPAE(I)
	GO TO 38
      END IF
 35   CONTINUE
C
C LONG RECEIVER SHUT DOWN, TRSHUT.GT.PAHR(15)
C
      STRPAT = RCVPAT(16)
      STRPAE = RCVPAE(16)
 38   CONTINUE
C
C DEDUCT SOME ENERGY FROM STORAGE TO ACCOUNT FOR THIS ONE-TIME
C STARTUP LOSS
C
      ES = ES - STRPAT
C
C THE ELECTRICAL PARASITICS FOR THE STARTUP LOSS WILL BE ADDED IN
C SUBROUTINE PARAS
C END NEW SECTION
C
      TRSHUT = 0.
      PLRMF = 0.
C CHANGE NEXT LINE REMOVED
C      GO TO 40
C
   40 CONTINUE  ! Receiver was not previously shutdown (IRSHUT = 0)
C
      IF ( IRSU .EQ. 0 ) GO TO 110  ! Receiver was not starting up
C
C  RECEIVER IS IN STARTUP (IRSU=1)
C
C IF IT IS 0.5 HOURS BEFORE SUNSET WITH THE RECEIVER "STILL" IN STARTUP,
C TERMINATE THE STARTUP (GO TO 80)
      IF ( TIM(K) .GT. (SUNS-0.5) ) GO TO 80
      IF (IHOLD .EQ. 1) GO TO 55  ! Receiver in startup/hold mode
      SCALE = PTR(K) / RS  ! Receiver thermal loss scaling factor
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      PTWF = EPTR - SCALE * XLRWS
      IF (PTWF .LT. 0.) PTWF = 0.
c CHANGE 3/3/87 DJA
C IF THE RECEIVER WAS IN STARTUP AND THE INSOLATION DROPPED, THE
C RECEIVER SHOULD BE SHUT DOWN. 
C
C  THESE LINES ADDED:
C IS THERE ENOUGH POWER FOR RECEIVER OPERATION?
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      IF(EPTR-XLRWS .LT. RS*RMF .OR. (DNI(K).LT.EXFAC*SUNMX))THEN
C      THERE IS NOT SUFFFICIENT POWER TO RECEIVER FOR OPERATION
C        IF RECEIVER STARTUP HAS BEEN COMPLETED, RECEIVER CAN GO ON HOLD
	IF ((ETOSTART.LE.0.) .AND. (TTOSTART.LE.0.))GO TO 50
C
C        OTHERWISE RECEIVER IS SHUT DOWN
	GO TO 80
       END IF
C
C THERE IS SUFFICIENT POWER TO RECEIVER FOR OPERATION (OR CONTINUE STARTUP)
C END CHANGE
C
C HAVE  STARTUP REQUIREMENTS BEEN MET?  (YES=GO TO 90)
      IF ((ETOSTART.LE.0.) .AND. (TTOSTART.LE.0.)) GO TO 90
C
C CONTINUE IN STARTUP
C
      ETOSTART = ETOSTART - PTWF * DELT ! Reduce energy required to
C       start by energy collected this time period
      TTOSTART = TTOSTART - DELT  ! Reduce time required to start
C THIS POWER IS ACCUMULATED IN RCVRST
      RCVRST = PTWF
      PTWF = 0.
      STIME = DELT  ! Count start times
      RETURN
C
   50 CONTINUE  ! First time entering startup/hold mode. Only rcvrs that
C                 remain filled qualify...doors are shut in this mode.
C
C CHANGE2 
C IF IFILL=1, THE RECEIVER CAN GO ON HOLD MODE. WITHIN 1.5 HOURS OF
C SUNSET, SHUT RECEIVER DOWN (1.5 HRS IS ARBITRARY).
C NEXT LINE CHANGED:
C      IF (IFILL .EQ. 2) GO TO 80  ! Shutdown if this is a drained rcvr
      IF (IFILL .EQ. 2 .OR. TIM(K).GE.SUNS-1.5) GO TO 80
C RECEIVER ON HOLD MODE
C END CHANGE2
      IRSU = 1
      IRSHUT = 0
      IRO = 0
      IDRO = 0
      MFLG = 0
      NFLG = 0
      THOLD = TIM(K)
      IHOLD = 1
      GO TO 60
   55 CONTINUE
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      IF ((EPTR - XLRWS).GT.(RS*RMF) .AND. (DNI(K).GT.EXFAC*SUNMX))THEN
C
C NEW LINES ADDED FOR HOLD MODE
C
C RECEIVER CAN BE RESTARTED
       RCVRST = EPTR - XLRWS
       PTWF = 0.
       STIME = DELT
C TAKE RECEIVER OFF HOLD MODE
       IHOLD = 0
C FOOL CODE INTO THINKING ALL STARTUP REQUIREMENTS HAVE BEEN MET
       ETOSTART = -1.
       TTOSTART = -1.
C THE RECEIVER WILL BE OPERATED ATTHE NEXT TIME STEP
       RETURN
C
      END IF
C END CHANGE2
C
   60 CONTINUE  ! Holding at startup - receiver should be started but
C                 there is not enough insolation for rated operation
C
      WTIME = DELT  ! Holding is a weather penalty
      MFLG = MFLG + 1  ! Penalty for holding at startup
C CHANGE2
C REMOVE SOME ENERGY FROM STORAGE TO ACCOUNT FOR RECEIVER THERMAL LOSSES DURING
C THE RECEIVER HOLD PERIOD
C HERE, THE THERMAL LOSSES ARE INPUT IN PA(26)  MWT
      HLDLSH= PA(26) 
      ES = ES-HLDLSH*DELT
      HLDTIM = DELT
C HERE THE RECEIVER CAN STAY ON HOLD FOR PA(27) TIME STEPS 
C OTHER VALUES ARE POSSIBLE (BUT DO NOT USE 1!!!!)
      IF ( MFLG .EQ. NINT(PA(27)) ) GO TO 80  ! Shutdown if weather not improved after 45 m
C
C END CHANGE2
      PLRMF = PTR(K)
      PTR(K) = 0.
      PTWF = 0.  ! Doors are closed
      RETURN
C
   80 CONTINUE  ! Begin receiver shutdown
C
      IRSHUT = 1
      IRSU = 0
      IHOLD = 0
      IRO = 0
      IDRO = 0
      MFLG = 0
      NFLG = 0
      THOLD = 0.
      TRSHUT = DELT
C
C CHANGE  - THIS SECTION DIDN'T WORK PROPERLY, PLRMF WASN'T BEING RECORDED
C DJA 1/8/87 THESE LINES REMOVED
C      IF (TIM(K) .GE. (SUNS - 0.50)) GO TO 85  ! It's after sunset
C      WTIME = DELT  ! If not, this is a weather outage
C      PLRMF = PTR(K)
C      PTR(K) = 0.
C   85 CONTINUE
C      PLRMF = PTR(K)
C      PTR(K) = 0.
C      PTWF = 0.0
C      RETURN
C NEW LINES:
       IF (TIM(K) .LT. SUNS)  THEN
C   THIS IS DAYTIME
C  SO THIS IS A WEATHER OUTAGE, RECORD OUTAGE TIME
	WTIME = DELT
       END IF 
C 
C ANY INSOLATION IS ACCUMULATED IN PLRMF 
       PLRMF = PTR(K)
       PTR(K) = 0.
       PTWF = 0.
       RETURN
C
C END CHANGE 1/8/87
C
   90 CONTINUE  ! There is now enough power for operations
C
      MFLG = 0  ! Reset receiver hold penalty flag
      NFLG = 0  ! Reset receiver derated operation penalty flag
      IRSU = 0  ! Receiver no longer starting up
      IHOLD = 0 ! Receiver no longer in startup/hold mode
      THOLD = 0.
C
C  Check if there will be NET positive power generated:
C
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      PTWF = EPTR - XLRWS
      SP0 = PTWF/RS
      SPPR = PA(1)*FS + PA(3) + PA(4)*SP0 + PA(5)*SP0**2 + PA(6)*SP0**3
C Convert parasitics (MWe) back to thermal power equivalent
      AUXCOST = SPPR / EPSS (74., 1.)
      IF (PTWF .GT. AUXCOST ) GO TO 100
C
   95 CONTINUE  ! Otherwise enter derated operation
C
C if ptwf is above the min flow (rmf), but less than the solar plant parastics,
c  the code goes into a "derated" mode for up to 3 time steps.  Energy is
c still collected and put in storage.  After 3 time steps, the rcvr will go into
c either "hold" mode (ifill=1), or be shut down and drained.  However, if the
c dni continues to be above rmf but less than sppr, then after one time step in
c hold or drained mode, it will restart!  Generally, the code never gets here. 
c
      write(9,*)'cold pump par. exceeds ptwf' 
c
      IRO = 0
      IDRO = 1
      NFLG = NFLG + 1  ! Accumulate penalty for derated operation
      IF ( (NFLG .EQ. 4) .AND. (IFILL .EQ. 2) ) GO TO 80  ! Shutdown drained rcv
      IF (NFLG .EQ. 4) GO TO 50  ! Filled rcvr goes into startup/hold mode
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      PTWF = EPTR - XLRWS
      RETURN
C
  100 CONTINUE  ! Rated operation
C
      IRO = 1
      IDRO = 0
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      PTWF = EPTR - XLRWS
      RETURN
C
  110 CONTINUE  ! Receiver was not previously in startup mode or shutdown
C
C       Check if there is NET positive power
C
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
      PTWF = EPTR - XLRWS
C CHANGE - THESE LINES REPLACED DJA 1/8/87
C      SPPAR = 0.0691 * (GPOWER ** 1.0408)
C      AUXCOST = SPPAR / EPSS (74., 1.)   ! Convert parasitics (MWe)
CC       back to thermal power equivalent
C      IF (PTWF .GT. AUXCOST ) GO TO 100  ! Continue rated operation
C CHANGE2 XLRWS USED INSTEAD OF XLR(WS(K))
C      IF ((EPTR - XLRWS) .GT. (RS * RMF)) GO TO 95 ! Derated operation
C      IF ( TIM(K) .GE. (SUNS - 0.5) ) GO TO 80  ! Low power due to sunset
C
CC  There is not enough power on rcvr, go to holding mode:
CC
C      IF (IFILL .EQ. 2) GO TO 80  ! Drained receiver must shutdown
C      GO TO 50
C CHANGE - DJA 1/8/87
C THESE LINES REPLACE THOSE ABOVE, AN OPERATING RECEIVER IS
C NOW FIRST CHECKED TO SEE IF MINIMUM FLOW IS EXCEEDED
      IF (PTWF.LT. (RS * RMF) .OR. (DNI(K).LT.EXFAC*SUNMX)) THEN
C       POWER LESS THAN MINIMUM
C        IS THE LOW POWER DUE TO SUNSET?
	IF ( TIM(K) .GE. (SUNS - 0.5) ) GO TO 80 
C           
C         LOW POWER IS DUE TO WEATHER, BEGIN SHUT DOWN OF RECEIVER
	GO TO 50
      ELSE
C       POWER EXCEEDS MINUMUM, CHECK IF RECEIVER CAN BE RUN DERATED
	SP0 = PTWF/RS
      SPPR = PA(1)*FS + PA(3) + PA(4)*SP0 + PA(5)*SP0**2 + PA(6)*SP0**3
C Convert parasitics (MWe) back to thermal power equivalent
	AUXCOST = SPPR / EPSS (74., 1.)
C
C       CAN RATED OPERATION BE CONTINUED?
	IF (PTWF .GT. AUXCOST ) THEN
C          CONTINUE RATED RECEIVER OPERATION
	   GO TO 100 
	ELSE
C          DERATED RECEIVER OPERATION
	   GO TO 95 
	END IF
      END IF

C
      END
C
C
      FUNCTION XLR(WS)
C
C     This routine is used in the receiver model to calculate the
C  thermal losses due to reradiation, conduction and convection as a
C  function of wind speed.
C
C CHANGE IDAYMX ADDED
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
      COMMON /COMXLR/ NXLR, WXLR(7), PLXLR(7)
C
      DIMENSION W(7), P(7), PP(7), PPP(7), Z(27)
C
      EQUIVALENCE (N,NXLR), (W,WXLR), (P,PLXLR)
C
      DATA NPASS, ISX /2*0/, A1, B1, AN, BN /4*0./, NI /1/
C
C CHANGE 1/8/87 DJA
C TO SPEED UP SOLERGY, IF THERE ARE NO DATA TO BE FIT, THE FUNCTION ROUTINE 
C RETURNS A CONSTANT (A WARNING IS PRINTED IN INPUT1)
      IF (NPASS .GT. 0) GO TO 30 
C
C IF THE FIRST AND LAST THERMAL LOSS VALUES ARE EQUAL, NO INTERPOLATION IS USED
C THIS SECTION OF CODE EXECUTED ONLY ONCE PER SOLERGY RUN (NEXT TIME, NPASS =1)
      IF (PLXLR (1) .EQ. PLXLR(NXLR) ) THEN
	NSPEED = 1
      ELSE
	NSPEED = 0
C
       CALL SPLIFT (W, P, PP, PPP, N, Z, IERR, ISX, A1,B1,AN,BN)
       IF (IERR .NE. 1) GO TO 100
      END IF
      NPASS = 1 

C
   30 CONTINUE
      IF ( NSPEED .EQ. 1) THEN
	XLR = PLXLR(1)
	RETURN
      ELSE
	XI = WS   ! Wind speed (m/sec)
	IF (XI .LT. W(1)) XI = W(1)
	IF (XI .GT. W(N)) XI = W(N)
	CALL SPLINT (W, P, PPP, N, XI, YI, YPI, YPPI, NI, KERR)
	IF (KERR .NE. 1) GO TO 110
	XLR = YI
	RETURN
      END IF
C
  100 CONTINUE
      WRITE(9,200) IERR, WS, K, NDA
  200 FORMAT(///13H SPLIFT ERROR,I3,5X,1HW,F8.2,5X,3HTIM,I3,5X,3HDAY,I5)
      STOP '!!! Run terminated by error !!!'
C
  110 CONTINUE
      WRITE(9,210) KERR, WS, K, NDA
  210 FORMAT(///13H SPLINT ERROR,I3,5X,1HW,F8.2,5X,3HTIM,I3,5X,3HDAY,I5)
      STOP '!!! Run terminated by error !!!'
      END
C
C
      SUBROUTINE PIPE(K,NDA)
C
C     PIPE models the transmission of the working fluid from receiver
C  to the turbine and /or storage facilities. Function XLP is used to
C  determine the magnitude of thermal losses.
C
C
C  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *  XLP  -  Thermal power loss coefficient.  Function of dry bulb
C  *           temperature (F)
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
C
      IF(PTWF .GT. 0.) GO TO 100
C
C  Receiver is shutdown
C
      PTWF = 0.
      PWF = 0.
      RETURN
C
  100 CONTINUE  ! Receiver is operating
C
      PWF = PTWF - RS * XLP(DBT(K),K,NDA)  ! Calc. piping losses 
      IF( PWF .LT. 0. ) PWF = 0.
      RETURN
      END
C
C
      FUNCTION XLP(DBT,K,NDA)
C
C     XLP is used in the working fluid transmission model to determine
C  conduction and convection losses, a function of dry bulb temperature.
C
      COMMON /COMXLP/ NXLP, TXLP(9), YXLP(9)
C
      DIMENSION T(9), Y(9), YP(9), YPP(9), W(27)
C
      EQUIVALENCE (N,NXLP) , (T,TXLP) , (Y,YXLP)
C
      DATA NPASS, ISX /2*0/, A1, B1, AN, BN /4*0./, NI/1/
C
C
      IF( NPASS .GT. 0 ) GO TO 30 
      CALL SPLIFT(T,Y,YP,YPP,N,W,IERR,ISX,A1,B1,AN,BN)
      NPASS = 1
      IF( IERR .NE. 1 ) GO TO 100
C
   30 CONTINUE
      XI = DBT  ! Dry bulb temperature
      IF( XI .LT. T(1) ) XI = T(1)  ! Check limits - upper and lower
      IF( XI .GT. T(N) ) XI = T(N)
      CALL SPLINT(T,Y,YPP,N,XI,YI,YPI,YPPI,NI,KERR)
      IF( KERR .NE. 1 ) GO TO 110
      XLP = YI
      RETURN
C
  100 CONTINUE
       WRITE(9,200) IERR, DBT, K, NDA
  200 FORMAT(//13H SPLIFT ERROR,I3,5X,1HT,F8.2,5X,1HK,I3,5X,3HDAY,I5)
      STOP '!!! Run terminated by error !!!'
C
  110 CONTINUE
      WRITE(9,210) KERR, DBT, K, NDA
  210 FORMAT(//13H SPLINT ERROR,I3,5X,1HT,F8.2,5X,1HK,I3,5X,3HDAY,I5)
      STOP '!!! Run terminated by error !!!'
      END
C
C
      SUBROUTINE GONOGO(K,NDA,NFLAG)
C
C     The go/no go subroutine monitors the energy in thermal storage.
C  When a specified level is reached, the turbine is started. Turbine
C  operation is always at rated conditions except when storage is being
C  depleted, in which case operation at off-design conditions is
C  permitted.
C
C    The time that power is generated and the power generated is
C  written onto a separate file for determining the "value of
C  energy produced".
C
C    The routine uses the function EPSS to calculate power conversion
C  efficiency for the turbine operating from thermal storage.
C
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *
C  *  TBHWS   -  Time between hot and warm start-up
C  *  TBWCS   -  Time between warm and cold start-up
C  *  EPSS    -  Turbine efficiency term when operating from storage
C  *  TPFSL   -  Power (th) that turbine requires for rated operation
C  *             from storage
C  *  TS1     -  Time that turbine picks up load
C  *  TS2     -  Time that EPGS goes to rated operation
C  *  TTSB    -  Time that turbine has been on stand-by (hours)
C  *  ISBT    -  Turbine mode flag.  1 = Turbine on stand-by, 0 = not
C  *  ISUT    -  Turbine mode flag.  1 = Turbine start-up from storage,
C  *             0 = not
C  *  IROT    -  Turbine mode flag.  1 = Turbine in rated operations
C  *             0 = not
C  *  IDROT   -  Turbine mode flag.  1 = Turbine in derated operations
C  *             0 = not
C  *  TMFS    -  Turbine minimum flow rate coefficient for power from
C  *             storage   (fraction of maximum flow rate)
C  *  SDH     -  Turbine sync. delay (hot)
C  *  SDW     -  Turbine sync. delay (warm)
C  *  SDC     -  Turbine sync. delay (cold)
C  *  RDH     -  Ramp delay (hot)
C  *  RDW     -  Ramp delay (warm)
C  *  RDC     -  Ramp delay (cold)
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C gjk change 1/19/94 moved data statement to main to allow compilation
c on PC
ccc      DATA TTSB /5.000/, TS1 /0./, ICAN /0/, ITSTART /0/, ION /0/
ccc      DATA ISBT /1/, ISUT /0/, IROT /0/, IDROT /0/
C-------------------------------------------------------------------------
C          Operational Strategy
C-------------------------------------------------------------------------
      IF (ISUT .EQ. 1) GO TO 10   ! Turbine was previously starting up
      IF (ISBT .EQ. 1) GO TO 20   ! Turbine was previously at standby
      IF (ISURP .NE. 0) GO TO 30  ! Storage unable to satisfy turbine demand
      IF ((IROT .EQ. 1) .OR. (IDROT .EQ. 1) ) GO TO 70
C                                   Turbine was in rated/derated operation
C                                   Always request power for rated operation
C
   10 CONTINUE    ! Turbine in startup
C
      IF (ICAN .EQ. 0) THEN
	IF ((ITURNON .EQ. 1).AND.(ISURP .NE. 0)) GO TO 90  ! Terminate startup
	GO TO 35  ! Continue in pre-start
      END IF
C
      IF ( (ICAN .EQ. 1) .AND. (ITURNON .EQ. 1) ) THEN
	IF (ISURP .NE. 0) GO TO 90  ! Terminate startup
	GO TO 40 ! Transition to start
      END IF
C
      IF ( (TIM(K) .GE. TS2) .AND. (ICAN .EQ. 1) ) THEN
	IF (ISURP .NE. 0) GO TO 90  ! Terminate startup
	TTSB = 0.
	ICAN = 0
	ION = ION + 1
	GO TO 50  ! Transition to rated operation
      ELSE
	IF (ISURP .NE. 0) GO TO 90  ! Terminate startup
	GO TO 45 ! Continue true startup
      END IF
C
   20 CONTINUE    ! Turbine at standby
C
      IF (IRO .EQ. 1) THEN   ! Receiver at rated operation
C
	 IF (ES .GT. ESMIN1) THEN  ! Min. energy is in storage
C
C    This logic is to delay startup of the turbine until peak generating
C  time - in the summer, peak period starts at noon and in the winter,
C  peak period starts at 5 pm. (SCE Standard Offer 2)
C  Other options can be coded in.
C
	    IF ((NDA .GE. 120) .AND. (NDA .LE. 280)) THEN
	       IF ((TIM(K) .GE. 12.) .OR. (ES .GT. ESMAX1)) THEN
		  IF (TIM(K) .GE. (SUNS - 1.)) GO TO 65
		  ITSTART = ITSTART + 1
		  GO TO 35  ! Transition to startup
	       ELSE
		  GO TO 65  ! Remain at standby
	       END IF
C
	    ELSE
C
	       IF ((TIM(K) .GE. 17.) .OR. (ES .GT. ESMAX1)) THEN
		  IF (TIM(K) .GE. (SUNS - 1.)) GO TO 65
		  ITSTART = ITSTART + 1
		  GO TO 35  ! Transition to startup
	       ELSE
		  GO TO 65  ! Remain at standby
	       END IF
C
	    END IF
C
	 ELSE
	    GO TO 65  ! Remain at standby
	 END IF
C
      ELSE   ! Receiver is not at rated operation
C
	 IF (ES .GT. ESMIN2) THEN
C
	    IF ((TIM(K) .GE. 12.) .OR. (ES .GT. ESMAX2)) THEN
	       ITSTART = ITSTART + 1
	       GO TO 35  ! Transition to startup
	    ELSE
	       GO TO 65  ! Remain at standby
	    END IF
C
	 ELSE
	    GO TO 65  ! Remain at standby
	 END IF
      END IF
C
   30 CONTINUE  ! Storage was unable to satisfy turbine demands
C
      IF (PFS .GE. TPFSL) GO TO 70  ! Rated operation
      IF (PFS .GE. TPFSL*TMFS) GO TO 80 ! Derated operation
      IF (ISUT .EQ. 1) THEN
	GO TO 90  ! Undesirable transition
	ELSE
	GO TO 60  ! Transition to standby
      END IF
C
C--------------------------------------------------------------------------
C          Transition (a1) - Standby to Pre-startup
C--------------------------------------------------------------------------
C
   35 CONTINUE  ! Prestartup - hold until storage discharge is in service
C
      ISBT = 0
      ISUT = 1
      PFS = TMFS * TPFSL  ! Request dummy demand to start storage discharge
      RETURN
C
C--------------------------------------------------------------------------
C          Transition (a) - Pre-startup to Startup
C--------------------------------------------------------------------------
C
   40 CONTINUE
C
      ISBT = 0
      ISUT = 1
      IF ( TTSB .LT. TBHWS ) GO TO 44
      IF ( TTSB .LT. TBWCS ) GO TO 42
C
C  Cold Start
C
      TS1 = TIM(K) + SDC
      TS2 = TS1 + RDC
      GO TO 45
C
   42 CONTINUE  !  Warm Start
C
      TS1 = TIM(K) + SDW
      TS2 = TS1 + RDW
      GO TO 45
C
   44 CONTINUE  ! Hot Start
C
      TS1 = TIM(K) + SDH
      TS2 = TS1 + RDH
C
   45 CONTINUE  ! Startup
       PFS1 = AMAX1 (PFSMIN, TMFS * TPFSL)  ! PFSMIN is the min.
C                                             discharge rate from storage
C CHANGE 3/27/87 DJA
C THE NEXT FOUR LINES WERE CHANGED
C        PM = 0.
C        PMX = (TIM(K) - TS1) / (TS2 - TS1)
C        IF (TIM(K) .GT. TS1) PM = PMX * EPSS(WBT(K),1.) * TPFSL
C       PFS2 = PM / EPSS(WBT(K), PMX)
C
      IF (TIM(K) .GT. TS1) THEN
C       THE SYNC DELAY IS OVER, BEGIN POWER RAMP UP OF TURBINE
C       PMX IS THE FRACTION OF FULL TURBINE FLOW
	PMX = (TIM(K) - TS1) / (TS2 - TS1)
	PFS2 = PMX * TPFSL
      ELSE
C       DURING THE SYNC DELAY
	PFS2 = 0.
      END IF
C
C    There is one case when two passes are made through this section during
C  one time step, even though ISURP=0 (ie. STRG thinks it has been
C  satisfied). This occurs when there is transition from turbine pre-start
C  to start. Since STRG thinks it has satisfied its input and output
C  requirements, it updates the energy in storage (ES). However, if a
C  second pass through STRG is required due to a revision of the PFS
C  demands based on the above calculations, there will be a double
C  subtraction or addition to ES. Therefore, if the requested power
C  from storage needs revision (PFSNEW .NE. PFS) for this specific case
C  (storage has already been updated...EOLD .NE. ES), then the old value
C  of ES will be recovered and storage will be called with the new
C  request for power (PFS = PFSNEW).
C
      IF (ES .NE. EOLD) THEN
C
	PFSNEW = AMAX1 (PFS1, PFS2)
C
	IF (PFSNEW .NE. PFS) THEN
	  PFS = PFSNEW
	  ES = EOLD
	  ISURP = 0
	  ITURNON = 0
	  CALL STRG (K, NDA, NFLAG)
	  IF (ISURP .NE. 0) CALL HANDLER (K, NDA, NFLAG)
	  RETURN
C
	ELSE
C
	  RETURN
	END IF
C
      ELSE
C
	PFS = AMAX1 (PFS1, PFS2)
      END IF
C
      RETURN
C---------------------------------------------------------------------------
C          Transition (b) - Startup to Rated Operation
C---------------------------------------------------------------------------
C
   50 CONTINUE
C
      ISUT = 0
      IROT = 1
C
   55 CONTINUE  ! Rated Operation
C
      PFS = TPFSL
      RETURN
C---------------------------------------------------------------------------
C          Transition (c) - To Standby
C---------------------------------------------------------------------------
C
   60 CONTINUE
C
      ISBT = 1
      ISUT = 0
      IROT = 0
      IDROT = 0
      TTSB = 0.
C
   65 CONTINUE  ! Standby
C
      TTSB = TTSB + DELT
      PFS = 0.
      RETURN
C----------------------------------------------------------------------
C          Transition (d) - To Rated Operation
C----------------------------------------------------------------------
C
   70 CONTINUE
C
      ISUT = 0
      IROT = 1
      IDROT = 0
C
   75 CONTINUE
C
      PFS = TPFSL
      RETURN
C--------------------------------------------------------------------------
C          Transition (e) - To Derated Operation
C--------------------------------------------------------------------------
C
   80 CONTINUE
C
      ISUT = 0
      IROT = 0
      IDROT = 1
C
   85 CONTINUE
C
      FMF = PFS / TPFSL
      IF (FMF .LT. TMFS) THEN
	GO TO 30
      ELSE
	RETURN
      END IF
C--------------------------------------------------------------------------
C          Transition (f) - This is the termination of startup due to
C                           insufficient energy in storage.
C--------------------------------------------------------------------------
C
   90 CONTINUE
C
      ITURNON = 0
      ICAN = 0
      ISURP = 0
      ISBT = 1
      ISUT = 0
      TTSB = DELT
      PFS = 0.
      IF (NFLAG .GE. 2) WRITE (9,1000)
 1000 FORMAT (10X, 'At completion of startup, there was not enough')
      IF (NFLAG .GE. 2) WRITE (9,1010)
 1010 FORMAT (10X, 'storage energy left to run the turbine ! ')
      RETURN
      END
C
C
      SUBROUTINE MAXOUT(K,NDA,NFLAG)
C
C    MAXOUT attempts to maximize the value of solar electricity by
c  running the turbine during the peak period.
c
C    The routine uses the function EPSS to calculate power conversion
C  efficiency for the turbine operating from thermal storage.
C
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *
C  *  TBHWS   -  Time between hot and warm start-up
C  *  TBWCS   -  Time between warm and cold start-up
C  *  EPSS    -  Turbine efficiency term when operating from storage
C  *  TPFSL   -  Power (th) that turbine requires for rated operation
C  *             from storage
C  *  TS1     -  Time that turbine picks up load
C  *  TS2     -  Time that EPGS goes to rated operation
C  *  TTSB    -  Time that turbine has been on stand-by (hours)
C  *  ISBT    -  Turbine mode flag.  1 = Turbine on stand-by, 0 = not
C  *  ISUT    -  Turbine mode flag.  1 = Turbine start-up from storage,
C  *             0 = not
C  *  IROT    -  Turbine mode flag.  1 = Turbine in rated operations
C  *             0 = not
C  *  IDROT   -  Turbine mode flag.  1 = Turbine in derated operations
C  *             0 = not
C  *  TMFS    -  Turbine minimum flow rate coefficient for power from
C  *             storage   (fraction of maximum flow rate)
C  *  SDH     -  Turbine sync. delay (hot)
C  *  SDW     -  Turbine sync. delay (warm)
C  *  SDC     -  Turbine sync. delay (cold)
C  *  RDH     -  Ramp delay (hot)
C  *  RDW     -  Ramp delay (warm)
C  *  RDC     -  Ramp delay (cold)
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
c gjk change 1/19/94 moved data statement to main for pc version
ccc      DATA TTSB /5.000/, TS1 /0./, ICAN /0/, ITSTART /0/, ION /0/
ccc      DATA ISBT /1/, ISUT /0/, IROT /0/, IDROT /0/
C
C-------------------------------------------------------------------------
C          Operational Strategy
C-------------------------------------------------------------------------
      IF (ISUT .EQ. 1) GO TO 10   ! Turbine was previously starting up
      IF (ISBT .EQ. 1) GO TO 20   ! Turbine was previously at standby
      IF (ISURP .NE. 0) GO TO 30  ! Storage unable to satisfy turbine demand
      IF ((IROT .EQ. 1) .OR. (IDROT .EQ. 1) ) GO TO 70
C                                   Turbine was in rated/derated operation
C                                   Always request power for rated operation
C
   10 CONTINUE    ! Turbine in startup
C
      IF (ICAN .EQ. 0) THEN
	IF ((ITURNON .EQ. 1).AND.(ISURP .NE. 0)) GO TO 90  ! Terminate startup
	GO TO 35  ! Continue in pre-start
      END IF
C
      IF ( (ICAN .EQ. 1) .AND. (ITURNON .EQ. 1) ) THEN
	IF (ISURP .NE. 0) GO TO 90  ! Terminate startup
	GO TO 40 ! Transition to start
      END IF
C
      IF ( (TIM(K) .GE. TS2) .AND. (ICAN .EQ. 1) ) THEN
	IF (ISURP .NE. 0) GO TO 90  ! Terminate startup
	TTSB = 0.
	ICAN = 0
	ION = ION + 1
	GO TO 50  ! Transition to rated operation
      ELSE
	IF (ISURP .NE. 0) GO TO 90  ! Terminate startup
	GO TO 45 ! Continue true startup
      END IF
C
   20 CONTINUE    ! Turbine at standby
C
      ITST=0
C
C  Before the peak period of any day:
C
C CHANGE2 NEXT LINE CHANGED
      IF (TIM(K) .LE. PERS(NDA,1)-TSTUR) THEN
	 COND1 = ES-SCO1  ! At least SCO1 in storage
	 COND2 = PHBT+ES-SCO1-(TPFSL*(PERE(NDA,1)-(TIM(K)-DELT)
     1           -TSTUR)+TPFSL*TSTUR*PSTFR) ! Start and reach end of peak
C                                     ! without using carryover storage
	 COND3 = ES+PHBTS-SCO1-TPFSL*TSTUR*PSTFR !Start without using 
C                                     ! carryover storage
	 COND4 = ES-SCO1-(TPFSL*TSTUR*PSTFR+TPFSL*(SUNR+1.5-TIM(K)-
     1           TSTUR))  ! Start and reach SUNR+1.5 without using carryover
C
C CHANGE NEW COND5 ADDED
	 COND5 = ES - (SUNR + 3. *DELT - TIM(K)) * PSTFR * TPFSL
C
	 IF ((COND1.GE.0.).AND.(COND2.GE.0.).AND.(COND3.GE.0.).AND.
     1      (COND4.GE.0.) .AND. (COND5.GE.0.)) ITST = 1
C
	 IF ((NDA.GE.IDF1).AND.(NDA.LE.IDF2)) WRITE(5,1802)
     1   COND1/TPFSL,COND2/TPFSL,COND3/TPFSL,COND4/TPFSL,COND5/TPFSL
 1802    FORMAT('          START? BEFORE PEAK:  COND1,2,3,4,5=',5F9.3)
      END IF
C
C  Just before the peak period and not an off peak day:
C
C CHANGE2 LINE CHANGED
      IF (TIM(K).GT.PERS(NDA,1)-TSTUR .AND. TIM(K).LE.PERS(NDA,1)
     1   .AND. PERE(NDA,1).NE.PERS(NDA,1)) THEN
	 COND1 = PHBT+ES-(TPFSL*(PERE(NDA,1)-(TIM(K)-DELT)-TSTUR)+
     1           TPFSL*TSTUR*PSTFR) !  Same as COND2 above, but use of
C                                   !  SCO1 is allowed
	 COND2 = ES+PHBTS-TPFSL*TSTUR*PSTFR !  Same as condition 3 above,
C                                           !  but use of SCO1 is allowed
C CHANGE NEW COND3 ADDED
	 COND3 = ES - (SUNR + 3. * DELT - TIM(K)) * PSTFR * TPFSL
     
	 IF ((COND1.GT.0.) .AND. (COND2.GT.0.).AND. (COND3.GT.0))
     1      ITST = 1
C
	 IF((NDA.GE.IDF1).AND.(NDA.LE.IDF2))WRITE(5,1803)
     1       COND1/TPFSL,COND2/TPFSL,COND3/TPFSL
 1803    FORMAT('          START? JUST BEFORE PEAK: COND1,2,3=',3F9.3)
      END IF
C
C  During the peak period and not an off peak day:
C
      IF (TIM(K).GT.PERS(NDA,1).AND.TIM(K).LE.PERE(NDA,1)-TSTUR.AND.
     1   PERS(NDA,1).NE.PERE(NDA,1)) THEN
	 COND1 = PHBTS+ES-TPFSL*TSTUR*PSTFR !  Sufficient heat for start
C CHANGE NEW COND2 ADDED
	 COND2 = ES - (SUNR + 3. *DELT - TIM(K)) * PSTFR * TPFSL
C
	 IF ((COND1.GT.0.).AND. (COND2 .GT. 0.)) ITST = 1
C
	 IF((NDA.GE.IDF1).AND.(NDA.LE.IDF2))WRITE(5,1799)
     1       COND1/TPFSL,COND2/TPFSL
 1799    FORMAT('          START? DURING PEAK: COND1,2=',2F9.3)
      END IF
C
C  If an off peak day and PHBT+ES<=SCO3 do not start - try to end an
C  off peak day with SCO3 in storage:
C
      IF ((PERE(NDA,1).EQ.PERS(NDA,1)) .AND. (PHBT+ES.LE.SCO3+
     1   TPFSL*TSTUR*PSTFR)) THEN
	 ITST = 0
	 IF ((NDA.GE.IDF1) .AND. (NDA.LE.IDF2)) WRITE (5,1804)
 1804    FORMAT('          OFF PEAK DAY AND PHBT+ES<=SCO3',
     1          '-DONOTSTART')
      END IF
C
C  Start if discard is imminent:
C
      IF ((ES+PHBTS-EMAX) .GE. (TPFSL*TSTUR*PSTFR)) THEN
	 ITST = 1
	 IF ((NDA.GE.IDF1) .AND. (NDA.LE.IDF2)) WRITE (5,1806)
 1806    FORMAT('          START TO AVOID DISCARD')
      END IF
C
      IF (ITST .EQ. 1) THEN
	 ITSTART = ITSTART + 1
	 GO TO 35  ! Transition to startup
C
      ELSE
C
	 GO TO 65  ! Remain on standby
C
      END IF
C
   30 CONTINUE  ! Storage was unable to satisfy turbine demands
C
      IF (PFS .GE. TPFSL) GO TO 70  ! Rated operation
      IF (PFS .GE. TPFSL*TMFS) GO TO 80 ! Derated operation
      IF (ISUT .EQ. 1) THEN
	GO TO 90  ! Undesirable transition
	ELSE
	GO TO 60  ! Transition to standby
      END IF
C
C--------------------------------------------------------------------------
C          Transition (a1) - Standby to Pre-startup
C--------------------------------------------------------------------------
C
   35 CONTINUE  ! Prestartup - hold until storage discharge is in service
C
      ISBT = 0
      ISUT = 1
      PFS = TMFS * TPFSL  ! Request dummy demand to start storage discharge
      RETURN
C
C--------------------------------------------------------------------------
C          Transition (a) - Pre-startup to Startup
C--------------------------------------------------------------------------
C
   40 CONTINUE
C
      ISBT = 0
      ISUT = 1
      IF ( TTSB .LT. TBHWS ) GO TO 44
      IF ( TTSB .LT. TBWCS ) GO TO 42
C
C       Cold Start
C
      TS1 = TIM(K) + SDC
      TS2 = TS1 + RDC
      GO TO 45
C
   42 CONTINUE  !  Warm Start
C
      TS1 = TIM(K) + SDW
      TS2 = TS1 + RDW
      GO TO 45
C
   44 CONTINUE  ! Hot Start
C
      TS1 = TIM(K) + SDH
      TS2 = TS1 + RDH
C
   45 CONTINUE  ! Startup
       PFS1 = AMAX1 (PFSMIN, TMFS * TPFSL)  ! PFSMIN is the min.
C                                             discharge rate from storage

C CHANGE 3/27/87 DJA
C THE NEXT FOUR LINES WERE CHANGED
C        PM = 0.
C        PMX = (TIM(K) - TS1) / (TS2 - TS1)
C        IF (TIM(K) .GT. TS1) PM = PMX * EPSS(WBT(K),1.) * TPFSL
C       PFS2 = PM / EPSS(WBT(K), PMX)
C
      IF (TIM(K) .GT. TS1) THEN
C       THE SYNC DELAY IS OVER, BEGIN POWER RAMP UP OF TURBINE
C       PMX IS THE FRACTION OF FULL TURBINE FLOW
	PMX = (TIM(K) - TS1) / (TS2 - TS1)
	PFS2 = PMX * TPFSL
      ELSE
C       DURING THE SYNC DELAY
	PFS2 = 0.
      END IF
C
C CHANGE2
C IT MAY BE NECESSARY TO RAMP THE TURBINE TO A DERATED POWER
C  BEFORE THE PEAK PERIOD RATHER THAN GOING ALL THE WAY TO FULL POWER
      IF(TIM(K).GT. TS1) THEN
C      AFTER SYNC DELAY, DURING THE RAMP DELAY
	 IF (TIM(K) .LE. PERS(NDA,1)) THEN
C  BEFORE PEAK PERIOD
C FR1 IS PFS LIMITED ONLY BY THE NORMAL TURBINE RAMP RATE (FR1=PMX)
	   FR1 = PFS2/TPFSL
C TRY TO REACH END OF PEAK PERIOD
	   FR2 = AMIN1(1.,(PHBT+ES-AMAX1(0.,SCO1)-TPFSL*
     1      (PERE(NDA,1)-TIM(K)))/TPFSL/DELT) 
	   FR = AMIN1(FR1,FR2)
C
C FR CAN NOT BE LESS THAN TURBINE MINIMUM FLOW (TMFS)
	   FR = AMAX1(TMFS,FR)
C
C FINAL CHECK. IF STORAGE IS FULL, NORMAL RAMP TO FULL POWER TO AVOID DISCARD
	 IF (ES+PTS*DELT-TPFSL*FR*DELT .GT. EMAX) FR = FR1 
	   IF (NDA.GE.IDF1 .AND. NDA.LE.IDF2) WRITE(5,1825)FR1,FR2,FR
 1825    FORMAT('         STARTING BEFORE PEAK: FR1,FR2 FR=',3F9.3)
	   PFS2 = TPFSL * FR
	 END IF
      END IF
C
C END CHANGE2
C
C    There is one case when two passes are made through this section during
C  one time step, even though ISURP=0 (ie. STRG thinks it has been
C  satisfied). This occurs when there is transition from turbine pre-start
C  to start. Since STRG thinks it has satisfied its input and output
C  requirements, it updates the energy in storage (ES). However, if a
C  second pass through STRG is required due to a revision of the PFS
C  demands based on the above calculations, there will be a double
C  subtraction or addition to ES. Therefore, if the requested power
C  from storage needs revision (PFSNEW .NE. PFS) for this specific case
C  (storage has already been updated...EOLD .NE. ES), then the old value
C  of ES will be recovered and storage will be called with the new
C  request for power (PFS = PFSNEW).
C
      IF (ES .NE. EOLD) THEN
C
	PFSNEW = AMAX1 (PFS1, PFS2)
C
	IF (PFSNEW .NE. PFS) THEN
	  PFS = PFSNEW
	  ES = EOLD
	  ISURP = 0
	  ITURNON = 0
	  CALL STRG (K, NDA, NFLAG)
	  IF (ISURP .NE. 0) CALL HANDLER (K, NDA, NFLAG)
	  RETURN
C
	ELSE
C
	  RETURN
	END IF
C
      ELSE
C
	PFS = AMAX1 (PFS1, PFS2)
      END IF
C
      RETURN
C---------------------------------------------------------------------------
C          Transition (b) - Startup to Rated Operation
C---------------------------------------------------------------------------
C
   50 CONTINUE
C
      ISUT = 0
      IROT = 1
C
   55 CONTINUE  ! Rated Operation
C CHANGE2
C  BEFORE THE PEAK PERIOD, 
C IT MAY BE NECESSARY TO DERATE THE TURBINE RATHER THAN GO ALL
C THE WAY TO FULL POWER
      IF (TIM(K) .LE. PERS(NDA,1)) THEN  
C BEFORE THE PEAK PERIOD
C Build up SCO1 
	 FR1 = AMIN1(1.,(PTS*DELT+ES-AMAX1(0.,SCO1))/TPFSL/DELT)
C REACH END OF PEAK PERIOD
	 FR2 = AMIN1(1.,(PHBT+ES-AMAX1(0.,SCO1)-TPFSL*
     1    (PERE(NDA,1)-TIM(K)))/TPFSL/DELT) 
	 FR = AMIN1(FR1,FR2)
C
C FR CAN NOT BE LESS THAN TURBINE MINIMUM FLOW (TMFS)
	 FR = AMAX1(TMFS,FR)
C
C FINAL CHECK. IF STORAGE IS FULL, RUN AT FULL POWER TO AVOID DISCARD
	 IF (ES+PTS*DELT-TPFSL*FR*DELT .GT. EMAX) FR = 1. 
C
	 IF (NDA.GE.IDF1 .AND. NDA.LE.IDF2) WRITE(5,1826)FR1,FR2,FR
 1826    FORMAT(' GO TO FULL POWER BEFORE PEAK: FR1,FR2,FR=',3F9.3)
C
	 PFS = TPFSL * FR
	 IF(FR.LT.1.)THEN
C          TURBINE IS DERATED
	   IROT=0
	   IDROT=1
	 END IF
      ELSE
C NOT BEFORE THE PEAK PERIOD
	IDROT = 0
	PFS = TPFSL
      END IF      
      RETURN
C---------------------------------------------------------------------------
C          Transition (c) - To Standby
C---------------------------------------------------------------------------
C
   60 CONTINUE
C
      ISBT = 1
      ISUT = 0
      IROT = 0
      IDROT = 0
      TTSB = 0.
C
   65 CONTINUE  ! Standby
C
      TTSB = TTSB + DELT
      PFS = 0.
      RETURN
C----------------------------------------------------------------------
C          Transition (d & e) - To Rated or Derated Operation
C----------------------------------------------------------------------
C
  70  CONTINUE
C
      ISUT = 0
C
C  Try to end an off peak day with SCO3 in storage:
C
      IF ((PERE(NDA,1).EQ.PERS(NDA,1)) .AND. (PHBT+ES.LE.SCO3)) THEN
	 IF ((NDA.GE.IDF1) .AND. (NDA.LE.IDF2)) WRITE (5,1820)
 1820    FORMAT('          RUNNING,OFF PEAK DAY, AND PHBT+ES<=SCO3',
     1          ' SHUT OFF TURBINE')
	 GO TO 60  ! Transition to standby
      END IF
C
C  Before the peak period:
C
      IF (TIM(K) .LE. PERS(NDA,1)) THEN  ! Before peak period
C CHANGE2 NEXT TWO LINES CHANGED 1 MAY 87:
C Build up SCO1 
	 FR1 = AMIN1(1.,(PTS*DELT+ES-AMAX1(0.,SCO1))/TPFSL/DELT)
C REACH END OF PEAK PERIOD INCLUDING THERMAL LOSSES FROM TANK
	 FR2 = AMIN1(1.,(PHBT+ES-AMAX1(0.,SCO1)-(TPFSL+TPLDD+TPLFT)*
     1    (PERE(NDA,1)-TIM(K)))/TPFSL/DELT) 
	 FR = AMIN1(FR1,FR2)
	 FR = AMAX1(TMFS,FR)  ! Minimum turndown is TMFS
	 IF (ES+PTS*DELT-TPFSL*FR*DELT .GT. EMAX) FR = 1.  ! Reduce discard
	 IF (NDA.GE.IDF1 .AND. NDA.LE.IDF2) WRITE(5,1821) FR1, FR2, FR
 1821    FORMAT('          RUNNING BEFORE PEAK: FR1,FR2 FR=',3F9.3)
	 IF ((FR*TPFSL*DELT) .GT. (ES+PTS*DELT)) GO TO 60  ! Insufficient heat
C                                                          ! shutoff the turbine
	 PFS = TPFSL * FR
	 IF (FR .LT. 1.) THEN
	    IDROT = 1
	    IROT = 0
	 ELSE
	    IROT = 1
	    IDROT = 0
	 END IF
	 RETURN
      END IF
C
C  During peak:
C
      IF (TIM(K).GT.PERS(NDA,1) .AND. TIM(K).LE.PERE(NDA,1)) THEN
	 PFS = AMIN1(TPFSL*DELT,ES+PTS*DELT)/DELT
	 FR = PFS/TPFSL
	 IF (NDA.GE.IDF1 .AND. NDA.LE.IDF2) WRITE (5,1822) FR
 1822    FORMAT('          RUNNING DURING PEAK: FR=',F9.3)
	 IF (FR .LT. TMFS) GO TO 60  ! Transition to standby
	 IF (FR .LT. 1.) THEN
	    IDROT = 1
	    IROT = 0
	 ELSE
	    IROT = 1
	    IDROT = 0
	 END IF
	 RETURN
      END IF
C
C  During mid peak after peak:
C
      IF (TIM(K)-DELT.GE.PERE(NDA,1) .AND. TIM(K).LE.PERE(NDA,2)) THEN
	 IF (PHBT+ES .LE. SCO2) GO TO 60  ! Transition to standby
	 IF (PHBT+ES .GT. SCO2) THEN      ! Run turbine
	    PFS = AMIN1(TPFSL*DELT,PHBT+ES-SCO2,ES+PTS*DELT)/DELT
	    FR = PFS/TPFSL
	    IF(NDA.GE.IDF1 .AND. NDA.LE.IDF2) WRITE (5,1823) FR
 1823       FORMAT('          RUNNING MID PEAK AFTER PEAK: FR=',F9.3)
	    IF (FR .LT. TMFS) GO TO 60  ! Transition to standby
	    IF (FR .LT. 1.) THEN        ! Derate
	       IDROT = 1
	       IROT = 0
	    ELSE    ! Full power
	       IROT = 1
	       IDROT = 0
	    END IF
	 END IF
	 RETURN
      END IF
C
C  After mid peak period:
C
      IF (TIM(K)-DELT .GE. PERE(NDA,2)) THEN
	 IF (PHBT+ES .LE. SCO3) GO TO 60  ! Transition to standby
	 IF (PHBT+ES .GT. SCO3) THEN      ! Run turbine
	    PFS = AMIN1(TPFSL*DELT,PHBT+ES-SCO3,ES+PTS*DELT)/DELT
	    FR = PFS/TPFSL
	    IF (NDA.GE.IDF1 .AND. NDA.LE.IDF2) WRITE (5,1824) FR
 1824       FORMAT('          RUNNING AFTER MID PEAK: FR=',F9.3//)
	    IF (FR .LT. TMFS) GO TO 60    ! Transition to standby
	    IF (FR .LT. 1.) THEN          ! Derate
	       IDROT = 1
	       IROT = 0
	    ELSE   ! Full power
	       IROT = 1
	       IDROT = 0
	    END IF
	 END IF
	 RETURN
      END IF
C
      RETURN
C
   80 CONTINUE
C
      ISUT = 0
      IROT = 0
      IDROT = 1
C
   85 CONTINUE
C
      FMF = PFS / TPFSL
      IF (FMF .LT. TMFS) THEN
	GO TO 30
      ELSE
	RETURN
      END IF
C--------------------------------------------------------------------------
C          Transition (f) - This is the termination of startup due to
C                           insufficient energy in storage.
C--------------------------------------------------------------------------
C
   90 CONTINUE
C
      ITURNON = 0
      ICAN = 0
      ISURP = 0
      ISBT = 1
      ISUT = 0
      TTSB = DELT
      PFS = 0.
      IF (NFLAG .GE. 2) WRITE (9,1000)
 1000 FORMAT (10X, 'At completion of startup, there was not enough')
      IF (NFLAG .GE. 2) WRITE (9,1010)
 1010 FORMAT (10X, 'storage energy left to run the turbine ! ')
      RETURN
      END
C
C
      FUNCTION EPSS(WBT,FMF)
C
C    The function EPSS uses a bicubic spline to compute the gross
C  thermal to electric conversion efficiency as a function of wet bulb
C  temperatures and mass flow fractions for power from the receiver.
C  It uses data as shown in Table 3.6 of the manual.
C
      COMMON /COMEPSS/ NREPSS, NCEPSS, REPSS(4), CEPSS(6), FEPSS(24)
      DIMENSION X(6), Y(4), F(24), FL(1,4), WK(25)
      EQUIVALENCE (NX,IFD,NREPSS) , (NY,NCEPSS) , (X,CEPSS) ,
     1 (Y,REPSS) , (F,FEPSS)
      DATA NXL, NYL, IFLD /3*1/
C
      AXL = WBT  ! WBT is the wet bulb temperature, deg F
      IF(AXL .LT. X(1) ) AXL = X(1)   ! CEPSS (or X) - Column vector of
C       wet bulb temperature values for bicubic spline. This sets the
C       measured value to the smallest value in the table if the data is
C       less than this smallest value
C
      IF( AXL.GT. X(NX) ) AXL = X(NX) ! This sets the measured value to
C       the largest value in the table if the data is greater than this
C       largest value
C
      AYL = FMF  ! FMF is the mass flow fraction at time t
C
      IF( AYL .LT. Y(1) ) AYL = Y(1)    !  Again, make sure the bounds
      IF( AYL .GT. Y(NY) ) AYL = Y(NY)  !  of the table are not exceeded.
C
C       Call IMSL (old version) routine
C
C      CALL IBCIEU(F,IFD,X,NX,Y,NY,AXL,NXL,AYL,NYL,FL,IFLD,WK,IER)
C
C       Or use the interpolation routine provided with SOLERGY
C
      CALL TSPLIN(X,NX,Y,NY,F,AXL,AYL,FM,IER)
C
      IF( IER .NE. 0 ) GO TO 100
C
C      EPSS = FL(1,1)  ! Return gross thermal to electric conversion efficiency
C                       for the IMSL routines
      EPSS = FM ! LININT returns only a single value
      RETURN
C
  100 CONTINUE
      WRITE(9,1500) IER, WBT, FMF
 1500 FORMAT(//6H ERROR,I4,3X,7HIN EPSS/6H WBT =,F10.4/6H FMF =,F10.4)
      STOP '!!! Run terminated by error !!!'
      END
C
C
      SUBROUTINE STRG(K,NDA,NFLAG)
C
C    The storage model receives desired charge or discharge commands from
C  TRBN and if possible complies with them, in which case control is returned
C  to the main program for completion of the DELT loop. If the charge rate is
C  excessive or storage is full, the surplus power to storage is calculated
C  and the driver program is reentered for the purpose of repeating a pass
C  through the EPGS and storage models with the storage commands suitably
C  altered. If the energy in storage is insufficient, the unavailable power
C  from storage is calculated and the same loop is repeated as described
C  above.
C
C    The modes of operation are standby, charge, discharge, and simultaneous
C  charge and discharge. The particular mode chosen is dictated by TRBN
C  commands and the level of energy currently in storage.
C
C    Thermal losses due to conduction and providing sealing power to the
C  turbine are taken into account. Auxiliary power needs are also calculated.
C
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *  ES  -  Energy in storage (MWhr)
C  *  EMAX  -  Maximum ES
C  *  EMIN  -  Minimum ES
C  *  PTSM  -  Maximum charging rate (MW)
C  *  PTSMIN - Minumum charging rate (MW)
C  *  SUPTS -  Surplus power sent to storage (MW)
C  *  PFSM  -  Maximum discharge rate (MW)
C  *  PFSMIN - Minimum discharge rate (MW)
C  *  UPFS  -  Unavailable power from storage (MW)
C  *  TPLDC -  Thermal power lost during charging (MW)
C  *  TPLDD -  Thermal power lost during discharging (MW)
C  *  TPLFT -  Thermal power lost from tanks (conduction losses) (MW)
C  *  TPLBTC - Thermal power lost due to thermocline degradation (MW)
C  *  CLF    - Charging loss factor
C  *  DLF    - Discharging loss factor
C  *  TNKLF  - Tankage loss factor
C  *  A      - Thermocline degradation coefficients
C  *  LS    -  Storage flag.  1 = non-thermocline,  2 = thermocline,
C  *           3 = sodium receiver with salt storage.
C  *  TOL   -  Tolerance used when determining whether storage is 
C  *           completely full or empty (MWhr)
C  *  PTS2  -  Power actually delivered to the storage tanks (MW)
C  *  PFS2  -  Power actually extracted from the storage tanks (MW)
C  *  TSTC  -  Time charging system has been in startup transition (hr)
C  *  ESTC  -  Energy accumulated during charging startup transition (MWhr)
C  *  TSTCR -  Minimum time delay for storage charging startup (hr)
C  *  ESTCR -  Energy penalty for storage charging startup (MWhr)
C  *  TSTD  -  Time discharging system has been in startup transition (hr)
C  *  ESTD  -  Energy accumulated during discharging startup transition (MWhr)
C  *  TSTDR -  Minimum time delay for storage discharging startup (hr)
C  *  ESTDR -  Energy penalty for storage discharging startup (MWhr)
C  *  PSHXC -  Storage charge startup power rate (MW)
C  *  PSHXD -  Storage discharge startup power rate (MW)
C  *  ITRNC -  0 = Charging not in transition, 1 = Charging in transition
C  *  ITRND -  0 = Discharging not in transition, 1 = Discharging in transition
C  *  ISTSS -  Thermal storage system status flag
C                    0 = Standby
C                    1 = Charging only
C                    2 = Discharging only
C                    3 = Combined charge and discharge
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
      COMMON /ZERO/ DT, ZPTS, ZPFS
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C
	DATA TOL /0.001/
c change typo corrected in next line
	DATA ITRND,ITRNC,ISTSS/0,0,0/
	DATA PTS,PFS/0.0,0.0/
C
C  Initialize key variables
C
      SUPTS=0.0
      UPFS=0.0
      TPLDC=0.0
      TPLDD=0.0
      TPLBTC=0.0
      TPLFT=0.0
      PTS2=0.0
      PFS2=0.0
      PSHXC=0.0
      PSHXD=0.0
C-----------------------------------------------------------------------
C                      CHARGING POWER CHECKS
C-----------------------------------------------------------------------
C
C
C  Check to see if thermal energy is being sent to thermal storage.
C
      IF (PTS.LE.0. .AND. ISTSS.EQ.3) ISTSS=2 ! Transition from
C                                                 simultaneous charge and
C                                                 discharge to only discharge.
      IF (PTS.LE.0. .AND. ISTSS.EQ.1) ISTSS=0 ! Transition from charge only
C                                                 to standby.
      IF (PTS .LE. 0.0) GO TO 30
C
C  Check the power sent to storage to see if it exceeds the maximum
C  rate or is less than the minimum.
C
C CHANGE 1/9/87 DJA TOL ADDED TO THIS IF STATEMENT  
      IF ((PTS-(PTSMAX+TOL)) .LE. 0.) GO TO 10
      SUPTS = PTS-PTSMAX  !  Calculate the amount PTS must be decremented
C                              so as not to exceed the charge limit.
	ISURP = 2  ! Charge rate > max. charge rate
      RETURN
C
C CHANGE 1/9/87 TOL ADDED TO THIS IF STATEMENT
   10 IF ((PTS+TOL-PTSMIN) .GE. 0.) GO TO 30
      SUPTS = PTS ! All the energy sent to thermal storage is
C                     not acceptable.
	ISURP = 1   ! Charge rate < min. charge rate
	RETURN
   30 CONTINUE
C--------------------------------------------------------------------------
C                        EXTRACTION POWER CHECKS
C--------------------------------------------------------------------------
C
C
C  Check if thermal energy is being demanded by the turbine
C
      IF ((PFS.LE.0.) .AND. (ISTSS.EQ.3)) ISTSS=1
      IF ((PFS.LE.0.) .AND. (ISTSS.EQ.2)) ISTSS=0
      IF (PFS .LE. 0.) GO TO 60
C
C  Check if thermal power demanded by the turbine exceeds the maximum
C  storage output capability or is less than the minimum storage output
C  capacity
C
C CHANGE 1/9/87 DJA TOL ADDED TO THIS IF STATEMENT
      IF (PFS .LE. PFSMAX+TOL) GO TO 40
      UPFS = PFS-PFSMAX  !  Calculate the amount that the demand
C                             exceeds capability
	ISURP = 3  ! Demand > max. possible
      RETURN
C
C CHANGE 1/9/87 DJA TOL ADDED TO THIS IF STATEMENT
   40 IF (PFS +TOL.GE. PFSMIN) GO TO 60
      UPFS = PFS  !  None of the power demanded can be supplied
	ISURP = 4   ! Demand < min. possible
      RETURN
C
C  Check if there is energy in the thermal storage tanks
C
   50 IF (ES .GT. EMIN) GO TO 60
      UPFS = PFS
	ISURP = 5  ! Storage is empty
      RETURN
C
C--------------------------------------------------------------------
C               CALCULATE LOST THERMAL POWERS
C--------------------------------------------------------------------
C
C  Compute the thermal power loss during charging
C
   60 CONTINUE
      IF (LS .EQ. 1) TPLDC = CLF
      IF ((LS.EQ.2) .OR. (LS.EQ.3)) TPLDC = CLF*(PTSMAX/REFPC)**0.3333
C
C  Compute storage tank thermal loss rate
C
      IF ((LS.EQ.1) .OR. (LS.EQ.3)) TPLFT = TNKLF
      IF (LS .EQ. 2) TPLFT = ES/TNKLF
C
C  Compute the energy loss due to thermocline degradation
C
      IF ((LS.EQ.1) .OR. (LS.EQ.3)) TPLBTC = 0.0
      IF (LS .EQ. 2) TPLBTC = A(1)+A(2)*ES+A(3)*ES*ES
C
C  Compute thermal power loss during discharge
C
      TPLDD = DLF*(PFSMAX/REFPC)**0.3333
C
C-------------------------------------------------------------------------
C                        CHARGING STARTUP
C-------------------------------------------------------------------------
C
C  Check status of storage charging - handle transition if one is
C  detected.
C CHANGE 1/23/87 DJA
C ONE TRANSITION THAT WASN'T CONSIDERED IS THE CASE WHERE THE CHARGING HX
C IS IN STARTUP (ITRNC=1) AND THE RECEIVER HAS BEEN SHUT DOWN DUE TO A 
C WEATHER OUTAGE (PTS=0)
C NEW LINES ADDED:
	IF(PTS.EQ.0. .AND. ITRNC.EQ.1)THEN
C TERMINATE THE STARTUP OF THE CHARGING HX
C RESET THE STARTUP PARAMETERS 
	    TSTC = 0.
	    ESTC = 0.
	    ITRNC = 0
	END IF
C         If steady-state, bypass
      IF (ISTSS.EQ.1 .OR. ISTSS.EQ.3 .OR. PTS.LE.0.) GO TO 70
      IF (TSTC.GE.TSTCR .AND. ESTC.GE.ESTCR) GO TO 64  !  Check to see if
C                                        startup requirements have been met
C CHANGE 1/8/87 DJA
C TOL ADDED TO THE FOLLOWING IF STATEMENT 
      IF (PTS .LE. (PWARMC+TPLDC+TOL)) GO TO 31  !  Check if too much power is
C                                     being sent to thermal storage for startup
      SUPTS = PTS-PWARMC-TPLDC  ! Calculate surplus
	ISURP = 2
      RETURN
C
   31 IF (ITRNC .EQ. 1) GO TO 62  !  Check if transition has just started
      ITRNC = 1  !  If so, initialize startup variables
      TSTC = DELT
      PSHXC = PTS-TPLDC
      IF (PSHXC .LT. 0.) PSHXC = 0.
      ESTC = PSHXC*DELT
      GO TO 70
   62 CONTINUE
      TSTC = TSTC+DELT  !  update startup variables
      PSHXC = PTS-TPLDC
      IF (PSHXC .LT. 0.) PSHXC = 0.
      ESTC = ESTC+PSHXC*DELT
      GO TO 70
   64 ITRNC = 0  !  reset startup variables and set the status variable
      TSTC = 0.  !  to its correct value
      ESTC = 0.
      IF (ISTSS .EQ. 0) ISTSS = 1
      IF (ISTSS .EQ. 2) ISTSS = 3
      GO TO 70
C
C----------------------------------------------------------------------------
C                           EXTRACTION STARTUP
C----------------------------------------------------------------------------
C
C  Check status of storage discharging - handle transition if one
C  is detected.
   70 CONTINUE
C
      IF (ISTSS.EQ.2 .OR. ISTSS.EQ.3 .OR. PFS.LE.0.) GO TO 80
C           If steady state, bypass
      IF (TSTD.GE.TSTDR .AND. ESTD.GE.ESTDR) THEN
	   ITURNON = 1
	   GO TO 74  !  Check to see if the startup requirements are met.
	ELSE
	   PFS = 0.  !  No power is sent to turbine during startup
	   ITURNON = 1
	END IF
      IF (ITRND .EQ. 1) GO TO 72  ! Check to see if transition is just starting
      ITRND = 1  !  If so initialize the startup variables
      TSTD = DELT
      PSHXD = PWARMD
      ESTD = PSHXD*DELT
      GO TO 80
   72 CONTINUE
      TSTD = TSTD+DELT  !  Update the startup variables
      PSHXD = PWARMD
      ESTD = ESTD+PSHXD*DELT
      GO TO 80
   74 ITRND = 0   !  Reset all the variables and set the status
      TSTD = 0.   !  variables to the correct value.
      ESTD = 0.
      IF (ISTSS .EQ. 0) ISTSS = 2
      IF (ISTSS .EQ. 1) ISTSS = 3
C
C--------------------------------------------------------------------------
C
C  Compute the powers actually sent to and extracted from the storage
C  tanks during steady-state
C
   80 CONTINUE
      PTS2 = PTS
      IF (ISTSS.EQ.1 .OR. ISTSS.EQ.3) PTS2 = PTS-TPLDC
      IF (ITRNC .EQ. 1) PTS2 = PTS-TPLDC-PSHXC
	IF (ITRNC .EQ. 1) CHRGST = PSHXC  ! Accumulate power to start charge tra
C
      PFS2 = PFS
      IF (ISTSS.EQ.2 .OR. ISTSS.EQ.3) PFS2 = PFS+TPLDD
      IF (ITRND .EQ. 1) PFS2 = PSHXD+TPLDD
	IF (ITRND .EQ. 1) EXTRST = PSHXD  ! Accumulate power to start extr train
C
   90 CONTINUE
C
C-------------------------------------------------------------
C             STORED ENERGY CALCULATIONS                     !
C-------------------------------------------------------------
C
C  Compute the new tank energy for the following cases:
C             1 - Charge only
C             2 - Discharge only
C             3 - Combined charge and discharge
C             4 - Complete storage system shutdown
C
C                Charge Only
C
      GO TO (400,100,200,300)(ISTSS+1)
  100 CONTINUE
C
      ENEW = ES+(PTS2-PFS2-TPLFT-TPLBTC)*DELT
C
C CHANGE ONE LINE ADDED
C DURING CHARGING, IF DISCHARGE ISN'T STARTING UP, SET LOSS TO ZERO
      IF(ITRND.EQ. 0)TPLDD = 0. 
C
      IF (ENEW .LE. (EMAX+TOL)) GO TO 110 !  The new energy level is
C                                              checked against the maximum.
C
C  If the maximum allowable storage energy is exceeded, then compute the
C  power level that completely fills storage and the excess power currently
C  being sent to storage.
C
      PTSN = (EMAX-ES)/DELT+PFS2+TPLFT+TPLBTC+TPLDC+PSHXC
      SUPTS = PTS-PTSN  !  Amount by which PTS must be reduced for
C                          the next pass through this subroutine.
	ISURP = 2
      RETURN
C
C  All is well, update the value of ES to the current amount of energy in storag
C
  110 ES = ENEW
      GO TO 450
C
C  Discharge Only
C
  200 CONTINUE
C
      ENEW = ES+(-TPLFT-PFS2-TPLBTC)*DELT
C
C  CHANGE ONE LINE ADDED
C DURING DISCHARGING, IF CHARGE ISN'T STARTING UP, SET LOSS TO ZERO
      IF(ITRNC.EQ.0)TPLDC = 0.
C
      IF (ENEW .GE. (EMIN-TOL)) GO TO 210  !  The new energy level is
C                                               checked against the minimum.
C
C  If the new level of stored energy is less than the minimum allowed,
C  then compute a new power from storage that just exhausts the stored
C  energy.
C
      PFSN = (ES-EMIN)/DELT-TPLFT-TPLBTC-TPLDD-PSHXD
      IF (PFSN .LT. 0.) PFSN = 0.
      UPFS = PFS-PFSN  !  Amount by which thermal storage fails
C                           to meet the turbine's demand
	ISURP = 3
      RETURN
C
C  All is well, update the value of ES to the current amount of energy
C  in storage.
C
  210 ES = ENEW
      GO TO 450
C
C  Simultaneous Charge and Discharge:
C
  300 CONTINUE
C
      ENEW = ES+(PTS2-TPLFT-PFS2-TPLBTC)*DELT
C
C  Check to see if the new value of the stored energy is between
C  the maximum and minimum allowable.
C
      IF (ENEW.LE.(EMAX+TOL) .AND. ENEW.GE.(EMIN-TOL)) GO TO 310
C
C  At this point, the new storage energy level is outside of the
C  acceptable range. If either the extraction or charging heat exchangers
C  were starting up, then the startup energy/time accumulators were
C  incremented. Since this pass through STRG was not successful, these
C  accumulators must be set back to their original values.
C
      IF (ITRNC .EQ. 1) THEN
	 IF ((ESTC .GT. 0.0) .OR. (TSTC .GT. 0.0)) THEN
	    TSTC = TSTC - DELT
	    ESTC = ESTC - PSHXC*DELT
	    IF (TSTC .LT. 0.0) TSTC = 0.0
	    IF (ESTC .LT. 0.0) ESTC = 0.0
	    ENDIF
	 ELSE
	    IF (ITRND .EQ. 1) THEN
	       IF ((ESTD .GT. 0.0) .OR. (TSTD .GT. 0.0)) THEN
		  TSTD = TSTD - DELT
		  ESTD = ESTD - PSHXD*DELT
		  IF (TSTD .LT. 0.0) TSTD = 0.0
		  IF (ESTD .LT. 0.0) ESTD = 0.0
		  ENDIF
	    ELSE
	       CONTINUE
	    ENDIF
	 ENDIF
C
C  Check to see if the new value of storage energy is above or below EMAX
C  or EMIN, respectively, and branch accordingly to the appropriate code.
C
      IF (ENEW .LT. (EMIN+TOL)) GO TO 320
C
C  If the maximum allowable is exceeded, then compute the power level that
C  completely fills storage and the excess power currently being sent to
C  storage.
C
      PTSN = (EMAX-ES)/DELT+PFS2+TPLFT+TPLBTC+TPLDC+PSHXC
      SUPTS = PTS-PTSN  !  Amount by which PTS must be reduced for
C                            the next pass through this subroutine.
	ISURP = 2
      RETURN
C
C  If the new level of stored energy is less than the minimum allowed, then
C  compute a new power from storage that just exhausts the stored energy.
C
  320 PFSN = (ES-EMIN)/DELT+PTS2-TPLFT-TPLBTC-TPLDD-PSHXD
      IF (PFSN .LT. 0.) PFSN = 0.
      UPFS = PFS-PFSN  !  Amount by which thermal storage fails
C                           to meet the turbine's demand
	ISURP = 3
      RETURN
C
C  All is well, update the value of ES to the current amount of energy
C  in storage.
C
  310 ES = ENEW
      GO TO 450
C
C  Complete Storage System Shutdown:
C
  400 CONTINUE
C
C CHANGE TWO LINES ADDED
C DURING CHARGING, IF DISCHARGE ISN'T STARTING UP, SET LOSS TO ZERO
      IF(ITRNC.EQ.0)TPLDC = 0.
C DURING DISCHARGING, IF CHARGE ISN'T STARTING UP, SET LOSS TO ZERO
      IF(ITRND.EQ.0)TPLDD = 0.
C
      ES = ES-(TPLFT+TPLBTC)*DELT
      IF (ITRND .EQ. 1) ES = ES-PFS2*DELT
C
  450 CONTINUE
      RETURN
      END
C
C
      SUBROUTINE HANDLER(K,NDA,NFLAG)
C
C     The subroutine HANDLER is called if either of the storage variables
C  SUPTS or UPFS are non-negative, that is, if the thermal storage system
C  either cannot meet the demands from the turbine or if it cannot
C  accept the power delivered by the receiver system.  HANDLER calculates
C  the required reductions in PTR (power delivered by the collector
C  field), PTWF (power delivered by the receiver to the working fluid),
C  and PWF (power in the working fluid after piping losses) when
C  appropriate.
C
C     The value of ISURP is determined by the exit condition in STRG.
C  The variable ITURNON indicates that the thermal storage/turbine system
C  is in startup.
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
      COMMON /PLANT/ IFOUT(50), ISOUT(50), IFORC, ISCHED, GPOWER
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
      COMMON /COMCOLF/IDAYMX,FMAX,FS,TLIML,TLIMU,ELIM,WSLIM,RFLCTY 

C
      GO TO (10, 20, 30, 40, 40), ISURP
      IF (ITURNON .EQ. 1) GO TO 50
C
   10 CONTINUE   ! ISURP = 1.  Power from receiver is less than minimum
C                  allowable storage rate - shut receiver down or put
C                  filled receiver on hold.
      SUPTS = PTS  ! Power that storage cannot accept
      SPTS = SUPTS
C CHANGE2 THIS CHANGE WAS IN ERROR
C CHANGE DJA 3/5/87
C ONE LINE ADDED FOR THE CASE WHERE ISURP=2 CAUSES RECEIVER TO BE SHUT DOWN
C      SUPTR = 0.0
C EXCESS ENERGY IS PUT IN SUPTR AND IS CHARGED AGAINST THE STORAGE SYSTEM
C RATHER THAN THE RECEIVER
      SUPTR = SUPTR + PTR(K)
      PTR(K)=0
C END CHANGE 2
C
      PTS = 0.0
      PTWF = 0.
      PWF = 0.0
      GO TO (12, 14), IFILL
C
   12 CONTINUE   ! Filled receiver goes on hold
C
      IRSHUT = 0
      IHOLD = 1
      IRSU = 1
      IDRO = 0
      IRO = 0
      MFLG = 1
      NFLG = 0
      THOLD = TIM(K)
      WTIME = DELT  ! Holding is a weather penalty
C CHANGE2 TWO LINES REMOVED - REDUNDANT
C      PLRMF = PTR(K)
C      PTR(K) = 0.0  ! Put heliostats on standby
      ISURP = 0
      CALL STRG (K, NDA, NFLAG)
      RETURN
C
   14 CONTINUE  ! Drained receiver shuts down
C
      IRSHUT = 1
      IHOLD = 0
      IRSU = 0
      IDRO = 0
      IRO = 0
      MFLG = 0
      NFLG = 0
      TRSHUT = DELT
      WTIME = DELT
C CHANGE2 TWO LINES REMOVED - REDUNDANT
C      PLRMF = PTR(K)
C      PTR(K) = 0.
      ISURP = 0
      CALL STRG (K, NDA, NFLAG)
      RETURN
C
   20 CONTINUE  ! ISURP = 2.  Maximum storage charge rate is exceeded,
C                 or too much power is being sent to storage for startup,
C                 or storage is full and cannot accept all input.
C                 Action:  Reduce power to storage (PTS).
C
C  To account for the case where both (ISURP .NE. 0) and
C  (ITURNON .EQ. 1) the PFS request is repeated.  It is zeroed
C  out in the first pass through STRG:
C
      IF (ITURNON .EQ. 1) PFS = TMFS * TPFSL
C
      SPTS = SUPTS  ! Storage cannot accept all power from receiver
      PTS = PTS - SUPTS  ! Reduce power to storage
      PWF = PTS
      PTWF = PWF + RS * XLP (DBT(K),K,NDA)  ! Piping losses
      PTRNEW = (PTWF + XLR (WS(K))) / EPS   ! Back calculate reduction
C                                             in power from heliostat field
C CHANGE 1/9/87  DJA
C THE FOLLOWING LINE WAS REMOVED
C      SUPTR = PTR(K) - PTRNEW  ! Calculate surplus power to receiver
C SURPLUS POWER TO RECEIVER CAN OCCUR MORE THAN ONCE IN A TIME STEP.
C FOR EXAMPLE, FIRST THE POWER MAY EXCEED THE MAXIMUM POWER TO STORAGE (PTSMAX)
C SO THE POWER IS REDUCED TO THE MAXIMUM. THEN, THE  CHARGING HX MIGHT BE
C IN STARTUP SO THE POWER MUST BE REDUCED A SECOND TIME. (THIS SCENARIO MIGHT
C OCCUR FROM A CLOUD TRANSIENT.) THEREFORE SUPTR MUST ACCUMULATE
C THE SURPLUS POWER HANDLED BY ALL THE CALLS TO  HANDLER IN A SINGLE TIME STEP.
C N.B. SUPTR IS RE-INITIALIZED AT THE BEGINNING OF EACH TIME STEP.
C
      SUPTR = SUPTR + (PTR(K) - PTRNEW) 
C END CHANGE 1/9/87
      PTR(K) = PTRNEW
      SP0 = PTWF/RS
      SPPR = PA(1)*FS + PA(3) + PA(4)*SP0 + PA(5)*SP0**2 + PA(6)*SP0**3
C Convert parasitics (MWe) back to thermal power equivalent
      AUXCOST = SPPR / EPSS (74., 1.)
C
C CHANGE 1/9/87 DJA
C THE FOLLOWING LINES WERE REPLACED
C      IF (PTWF .GT. AUXCOST) GO TO 22
C      IF (PTWF .GT. XLR(WS(K))) GO TO 24
C      GO TO 10  ! Power reduction will cause negative power on receiver
C
C THE NEW LINES START WITH THE MOST CONSTRAINING
C DOES POWER REDUCTION FORCE RECEIVER SHUTDOWN?
      IF (PTWF .LE. RS*RMF) GO TO 10  
C
C DOES POWER REDUCTION FORCE RECEIVER TO DERATED OPERATION?
      IF(PTWF .LE. AUXCOST) GO TO 24
C
C END CHANGE 1/9/87
C
   22 CONTINUE  ! There is still enough power for rated rcvr operation
C
      IRO = 1
      IDRO = 0
      ISURP = 0
      CALL STRG (K, NDA, NFLAG)
      RETURN
C
   24 CONTINUE  ! There is enough power for derated rcvr operation
C
      IRO = 0
      IDRO = 1
      ISURP = 0
      CALL STRG (K, NDA, NFLAG)
      RETURN
C
   30 CONTINUE  ! ISURP = 3.  Turbine demand exceeds maximum extraction
C                 rate or storage cannot supply all of the turbine demand
C                 due to low level. Action:  Reduce demand (PFS).
C
      PFS = PFS - UPFS  ! Reduce demand from turbine
      IF (IDISP .EQ .0) CALL GONOGO (K,NDA,NFLAG)
      IF (IDISP .EQ. 1) CALL MAXOUT (K,NDA,NFLAG)
      ISURP = 0
      CALL STRG (K, NDA, NFLAG)
      RETURN
C
   40 CONTINUE  ! Turbine demands less than storage minimum discharge rate
C                 or the storage tank is empty.
C                 Action:  Eliminate the demand.
C
      PFS = 0.
      IF (IDISP .EQ. 0) CALL GONOGO (K,NDA,NFLAG)
      IF (IDISP .EQ. 1) CALL MAXOUT (K,NDA,NFLAG)
      ISURP = 0
      CALL STRG (K, NDA, NFLAG)
      RETURN
C
   50 CONTINUE  ! ITURNON = 1 corresponds to the case where storage discharge
C       and the turbine are starting up. The purpose of this option is to
C       hold off the turbine transition to rated operation. The startup
C       of storage discharge produces no power to the turbine, so the
C       turbine actually gets no power with which to warm up. The turbine
C       startup is therefore executed twice in GONOGO, although only the
C       second pass through the startup allows the turbine to transition
C       to rated conditions.
C
      PFS = 0.
      IF ((ITRND .EQ. 0) .AND. (ITURNON .EQ. 1)) THEN
	 ICAN = 1  ! Now beginning actual turbine startup
	 IF (IDISP .EQ. 0) CALL GONOGO (K,NDA,NFLAG)
	 IF (IDISP .EQ. 1) CALL MAXOUT (K,NDA,NFLAG)
	 ISURP = 0
	 ITURNON = 0
	 IF (ES .EQ. EOLD) CALL STRG (K,NDA,NFLAG)
	 RETURN
      ELSE
	 RETURN
      END IF
      END
C
C
      SUBROUTINE TRBN(K,NDA,NFLAG)
C
C     The TRBN subroutine uses the power supplied from thermal
C  storage as input (PFS = PTT) to the turbine. It then calculates
C  the electrical power generated by the turbine with a call to
C  EPSS. Parasitics are also computed in TRBN.
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
      COMMON /DATA2/ PTWF, PWF, PTS, PFS, PFT, PTT
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /STRGE/ SUPTS, UPFS, ESMAXP, ISTSS, ITRNC, ITRND
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
      COMMON /PWRL/ SPTR, SPTS, SUPTR, PLRMF, ISURP, ITURNON
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
C CHANGE FOUR MORE VARIABLES ADDED TO THIS COMMON
      COMMON /STRTP/ RCVRST, CHRGST, EXTRST, TRBNST,TPLDC,TPLDD,
     1 TPLBTC,TPLFT
C
      IF (ISBT .EQ. 1) IDECIDE = 1
      IF (ISUT .EQ. 1) IDECIDE = 2
      IF (IROT .EQ. 1) IDECIDE = 3
      IF (IDROT .EQ. 1) IDECIDE = 4
C
      GO TO (10, 20, 30, 40), IDECIDE
C
   10 CONTINUE  ! Turbine is at standby
C TURBINE IS SHUT DOWN
C
      PFS = 0.
      PTT = 0.
      PFT = 0.
      RETURN
C
   20 CONTINUE  ! Turbine is in startup
C
	IF (ITURNON .EQ. 1) THEN
	  WRITE(*,*)'IN TRBN - ITURNON = ',ITURNON
	  WRITE(*,*)'DAY = ',NDA
	  ISURP = 0
	  ITURNON = 0
	  PTT = PFS
	  TRBNST = PTT
	  PFT = 0.
	  RETURN
	ELSE
C CHANGE 3/27/87 DJA
C THE NEXT SECTION CHANGED
C          PM = 0.
C          IF (TIM(K) .GT. TS1) PM = PMX * EPSS(WBT(K),1.) * TPFSL
C RATHER THAN PMX, FULL TURBINE FLOW WAS ASSUMED TO ESTIMATE POWER 
C THESE LINES ADDED:
	  PTT = PFS
	  IF (TIM(K) .GT. TS1) THEN
C           THE SYNC DELAY IS OVER, ELECTRIC POWER PRODUCTION IS POSSIBLE
	    PMX = (TIM(K) - TS1) / (TS2 - TS1)
C
C CHANGE2 NEXT LINE CHANGED
C IN SOME MAXOUT CASES, THE TURBINE MAY NOT BE RAMPED UP TO FULL POWER
	    PFT = AMIN1(PTT,PMX*TPFSL) * 
     1          EPSS(WBT(K),AMIN1(PTT/TPFSL,PMX))
	    IF(PTT.GT.PMX*TPFSL) THEN
C             SOME OF THE POWER TO TURBINE IS NOT BEING USED TO PRODUCE POWER
	      TRBNST = PTT - PMX*TPFSL  
	    END IF
	  ELSE 
C         DURING THE SYNC DELAY, NO ELECTRIC POWER IS PRODUCED 
	    PFT = 0.
	    TRBNST = PTT
	  END IF
C
C  Calculate the amount of this power that is being used for turbine
C  startup, rather than for power generation:
C
C CHANGE THIS NEXT SECTION REMOVED, TOO
C            TEMP = PM / EPSS(WBT(K),1.)
C            TRBNST = PTT - TEMP
C            IF (TRBNST .LT. 0) TRBNST = 0.
C
	  RETURN
	END IF
C
   30 CONTINUE  ! Turbine is at rated operation
C
      PTT = PFS
      PFT = EPSS (WBT(K),1.) * TPFSL
      RETURN
C
   40 CONTINUE  ! Turbine is at derated operation
C
      PTT = PFS
	FMF = PFS / TPFSL
      PFT = EPSS (WBT(K),FMF) * PTT
      RETURN
      END
C
C
      SUBROUTINE PARASI(K,NDA)
C
C     This subroutine calculates the plant parasitics, depending upon
C  the mode of plant operation.  The operational parasitics are calculated
C  for three major plant portions:  the balance of plant, the turbine
C  plant, and the solar plant.  There are two equations for nonoperational
C  parasitics:  one is used for daily weather outages and for nighttime
C  shutdown (PMPAR) and the other (SDPAR) is used for the times when there
C  is a scheduled outage or the plant has been on an extended weather
C  outage.  
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *
C  *  Operational Parasitics:
C  *
C  *  BOPPAR -  Balance of plant parasitics.  Accounts for all plant
C  *            operational parasitics that are not included in TPPAR
C  *            or SPPAR.
C  *  TPPAR  -  Turbine plant parasitics.  Accounts for the condenser
C  *            and heat rejection system.  Used when the turbine begins
C  *            operation.  And the steam generator sytem.
C  *  SPPAR  -  Solar plant parasitics.  Accounts for the collector field,
C  *            receiver.
C  *
C  *  Nonoperational Parasitics:
C  *
C  *  PMPAR  -  Nighttime and normal weather outage parasitics and forced
c  *            outage.
C  *  SDPAR  -  Shutdown parasitics.  Occurs only during extended weather
C  *            outaged or scheduled shutdown.
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
c gjk change 1/19/94 added ttsb to tstatus for pc version
      COMMON /TSTATUS/ IRSHUT,ISBT,ISUT,IROT,IDROT,ITSTART,ION,TTSB
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /PLANT/ IFOUT(50), ISOUT(50), IFORC, ISCHED, GPOWER
C CHANGE 8/25/93 ADD RCVR STARTUP PARASITICS
      COMMON /PARAS/ BOPPAR, TPPAR, SPPAR, PMPAR, SDPAR,PA(30),
     1 PAHR(15), RCVPAT(16), RCVPAE(16), STRPAT, STRPAE
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      common /conesta/sunmx,exfac
      COMMON /DATA1/TIM(193),NPTS,PTR(193),WBT(193),DELT
      COMMON /DATA2/PTWF,PWF,PTS,PFS,PFT,PTT
      COMMON /COMCOLF/IDAYMX,FMAX,FS,TLIML,TLIMU,ELIM,WSLIM,RFLCTY 
      COMMON /PRSTC2/STWPAR,CSPAR,HSPAR,DCPAR,DTHRS
C
      DIMENSION IDMON(12)
      DATA IDMON / 31,59,90,120,151,181,212,243,273,304,334,366/
C 
C  IDMON IS A VECTOR THAT HAS THE JULIAN DAY OF THE LAST DAY OF EACH MONTH
C  E.G. THE LAST DAY OF JANUARY IS 31, THE LAST DAY OF FEBRUARY IS 59, ETC.
C
C  CHECK FOR SCHEDULED OUTAGE:
      IF (ISCHED .EQ. 1) THEN

C THIS IS A SCHEDULED OUTAGE, SHUTDOWN PARASITICS IN MW
C
	 SDPAR = PA(29)
	 PMPAR = 0.
	 BOPPAR = 0.
	 TPPAR = 0.
	 SPPAR = 0.
	 RETURN
C
      ELSE
C
C  THIS IS NOT A SCHEDULED OUTAGE
C
	 SDPAR = 0.   
C
      END IF
C
C  INITIALIZE THE DAILY HOURS OF TURBINE OPERATION TO 0.
C  RESET THE ONCE A DAY PARASITICS TO ZERO (STOW/UNSTOW AND DRY COOLING)
C
      IF(K .EQ. 2) THEN
	DTHRS = 0.
	STWPAR = 0.0
	DCPAR = 0.0
      END IF
C
C  IS THE SOLAR PLANT IN OPERATION?
C
C
      IF (IRSHUT .EQ. 0) THEN   
C
C  RECEIVER IS IN STARTUP OR OPERATION, CALCULATE SOLAR PLANT PARASITICS IN MW
C
C  THE MINIMUM FLOW TO THE RECEIVER IS RMF
C    THIS MINIMUM FLOW IS ASSUMED FOR STARTUP AND WEATHER HOLDS
C 
c         SP0=AMAX1(RMF,PTWF/RS)
c cold pump parasitic based on running full flow through clouds
c flow based on clear sky ptwf -- divide out actual dni and insert clear dni
c dni is read once per day and stored as a vector
	 if(dni(k).eq.0)then
	    sp0=rmf
	 else
	   SP0=AMAX1(RMF,(PTWF*sunmx)/(dni(k)*RS))
	 end if
C
C CSPAR IS THE PARASITICS FOR THE COLD SALT PUMP
C
	 CSPAR = PA(3) + PA(4)*SP0 + PA(5)*(SP0**2) + PA(6)*(SP0**3)
C         
C CHANGE 8/25/93 ADD STRPAE TO NEXT LINE
	 SPPAR = PA(1)*FS + CSPAR + STRPAE
C
      ELSE  
C
C  RECEIVER IS NOT IN OPERATION
C
	CSPAR = 0.0
	SPPAR = 0.0
C
      END IF
C
C  IS THE TURBINE PLANT IN OPERATION?
C
      IF(ISBT.EQ.0)THEN
C
C  THE TURBINE PLANT IS IN OPERATION
C
C   ACCUMULATE HOURS OF TURBINE OPERATION
C
	DTHRS = DTHRS + DELT 
C
C CHECK TO SEE HOW MANY HOT SALT PUMPS ARE NEEDED (IS THE OUTPUT OF THE
C  RECEIVER SUFFICIENT TO OPERATE THE STEAM GENERATOR?)
C
C CALCULATE AN INSTANTANEOUS SOLAR MULTIPLE
C  NOTE SM1 IS THE SAME AS PTWF/TPFSL
C
	SM1 = PA(9)*PTWF/RS
C
	IF(SM1 .LE. 0.6)THEN
C
C  TWO HOT SALT PUMPS NEEDED
C
	  HSPAR = PA(10)

	ELSE IF(SM1 .LE. 1.1)THEN
C
C  ONE HOT SALT PUMP NEEDED
	  HSPAR = PA(11)
C
	ELSE
C
C  HOT SALT PUMPS NOT NEEDED; INSTEAD USE HEAD-RECOVERY TANK TO SUPPLY THE
C   STEAM GENERATOR
C
	   HSPAR = PA(12)
C
	END IF
C
C CALULATE TOTAL TURBINE PARASITICS (MW)
C
	TPPAR = HSPAR + PA(7) + PA(8)*PFT/GPOWER
C
C  BALANCE OF PLANT PAR FOR CONDENSATE PUMP (MW)
C
	BOPPAR = PA(13)
C
      ELSE
C
C  TURBINE PLANT NOT IN OPERATION
C
	HSPAR = 0.0
	TPPAR = 0.0
	BOPPAR = 0.0
C
      END IF
C
C  IF NEITHER THE RECEIVER NOR TURBINE ARE IN OPERATION THEN THE PLANT IS
C  SAID TO BE IN PM SHUTDOWN
C
      IF(IRSHUT+ISBT .EQ. 2 ) THEN
C
C  NOTHING IS IN OPERATION, EITHER OVERNIGHT, WEATHER OUTAGE, OR FORCED OUTAGE
C  PARASITICS ARE IN MW
C
	PMPAR = PA(28)
C
      ELSE
C
ccc gjk 7/5/94 change definition of pm parasitics to a baseline parasitic on operational days
ccc   	PMPAR = 0.0
        PMPAR = PA(28)
C
      END IF
C
C  CERTAIN PARASITICS ARE CALCULATED ONCE A DAY AT THE LAST TIME STEP
C
      IF(K .EQ. NPTS)THEN
C
C  THIS IS THE LAST TIME STEP OF THE DAY
C 
C  IF THE SOLAR PLANT WAS OPERATED TODAY, ADD PARASITICS FOR WAKING UP AND 
C   STOWING THE HELIOSTAT FIELD IN MW
C
	IF(IDAYOP .GT. 0) THEN
C
C  THE SOLAR PLANT WAS OPERATED TODAY
C
C   ***** TO BE CONSISTENT WITH OTHER SOLERGY INPUT, PA(2) HAS THE UNITS
C   ***** OF POWER, NOT ENERGY
C
	  STWPAR = PA(2) * FS
	  SPPAR  = STWPAR
C
	END IF
C
C  FOR THE DRY COOLING SYSTEM, ALL OF THE COOLING IS SAID TO BE DONE AT THE
C   LAST TIME STEP OF THE DAY
C
C  THE NUMBER OF HOURS THE FANS MUST RUN FOR COOLING CONDENSATE
C
	FANHRS =  DTHRS * PA(30)
C
C  THE CONDENSATE PUMPS ARE ALSO RUNNING 
C
	CONPHR = FANHRS
C
C  HOWEVER THE PUMPS SOMETIMES ARE ALSO RUNNING WITH TURBINE SO TO AVOID 
C  DOUBLE COUNTING OF THESE HOURS, 

	IF(CONPHR + DTHRS .GT. 24.) THEN
C
	   CONPHR = 24. - DTHRS  
C
	END IF
C
C   TO CALCULATE THE FAN PARASITICS WE NEED TO KNOW HOW MANY FANS ARE IN 
C   USE.  THIS IS A FUNCTION OF THE MONTH OF THE YEAR
C
C    WHAT MONTH IS IT?
C
	 DO 100 I = 1,12
	    IF(NDA .LE. IDMON(I) )THEN
C
	      IMON = I
	      GO TO 200
	    END IF 
  100    CONTINUE
C
  200    CONTINUE
C
C  THE PARASITICS FOR THE FAN ARE STORED BY MONTH IN PA(14 TO 25)
C  EACH MONTH HAS A DIFFERENT NUMBER OF FANS RUNNING
C
	 DCPAR = FANHRS * PA(IMON + 13) + CONPHR * PA(13)
	 BOPPAR  = DCPAR
C
C  THIS BOPPAR IS IN ENERGY AND MUST BE CONVERTED BACK TO EQUIVALENT POWER 
C   FOR A SINGLE TIME STEP
C
	 BOPPAR = BOPPAR/DELT
	 DCPAR = DCPAR/DELT
C
      END IF
C
      RETURN
      END
C
      SUBROUTINE ADJPRE(K,KSET)
C
C    ADJPRE performs an adjustment of the insolation prediction to account
C  for the insolation observed for the present k time interval of the day.
C  The adjustment is equal to the difference between the predicted and the
C  observed insolation and is applied to the entire prediction for the
C  remainder of the day.  The prediction is limited to values in SUNMAX*.
C
C  *  *  *  *  *  *  *  Local Variables  *  *  *  *  *  *  *  *  *  *
C  *
C  *  DIFF   -  predicted - observed conditions for the k time interval
C  *  KSET   -  time interval after sunset
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C
C  The difference between the predicted insolation and the measured
C  insolation is calculated:
C
      DIFF = SUNAP(K)-DNI(K)
C
C  The prediction is adjusted from the current time until the end of
C  the day, based on actual weather conditions:
C
      DO 10 I = K, KSET
      SUNAP(I) = SUNAP(I)-DIFF
      IF (SUNAP(I) .GT. SUNMAX(I)) SUNAP(I) = SUNMAX(I)
   10 IF (SUNAP(I) .LT. 0.) SUNAP(I) = 0.
C
      RETURN
      END
C
C
      SUBROUTINE ALLEN(NDA,KRISE,KSET)
C
C     ALLEN calculates SUNMAX* maximum insolation values using a method
C  developed by Allen and described and referenced in the DELSOL manual.
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *
C  *  AMC    - Air mass correction
C  *  BETA   - An exponent
C  *  ET     - Extraterrestrial insolation, W/sq. meter
C  *  GAMMA  - An exponent
C  *  KRISE  - Time interval preceding sunrise
C  *  KSET   - Time interval following sunset
C  *  PRAT   - Ratio of atmospheric to sea level pressures
C  *  RAIN   - Precipitable water overhead, mm
C  *  ZEN    - Zenith angle, degrees
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C
      DPR = 57.296
      PRAT = 1.0  ! For Barstow, CA
      RAIN = 20.  ! For Barstow, CA
      GAMMA = .367*(RAIN+11.53)/(RAIN+7.88)
      ET = 1.353+.045*COS(6.283*FLOAT(NDA+10)/FLOAT(NDAYSY)) 
      COEF = .263*(RAIN+2.72)/(RAIN+5.)
C
      DO 10 K = KRISE, KSET
      ZEN = 90.-EL(K)  ! Degrees
      BETA = .000849854*ABS(EL(K))**2.-.04117341*ABS(EL(K))-2.0936381
      IF (ZEN .LT. 60.) AMC = 1./COS(ZEN/DPR)
      IF (ZEN .GE. 60.) THEN
	 IF (COS(ZEN/DPR) .LT. .001) AMC = 10.
	 IF (COS(ZEN/DPR) .GE. .001) AMC = 1./ABS(COS(ZEN/DPR))-
     1                 41.972213*ABS(EL(K))**BETA
      END IF
      SUNMAX(K) = ET*(1.-COEF*ABS(AMC*PRAT)**GAMMA)
   10 CONTINUE
      RETURN
      END
C
C
      SUBROUTINE PREDICT(K,KSET)
C
C     PREDICT estimates how much energy PHBT, is available from the field
C  at the base of the tower from the beginning of the K time interval until
C  sunset and how much energy PHBTS, is available from the beginning of
C  the K time interval through startup
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE IDAYMX ADDED
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C
C  The power at the base of the tower, PHBT, from the current time until
C  sunset is calculated. EFFIC gives EFF, the collector field efficiency,
C  and the receiver THERMAL LOSS AT DESIGN POINT (XLRDP AND EPS) is assumed 
C  for the purposes of this estimation.
C
      PHBT = 0.
      DO 10 I = K, KSET
C CHANGE 1/15/87 DJA - FIELD EFFICIENCY (EFF) DOESN'T NEED TO BE RECALCULATED.
C USE THE AVAILABLE VALUE OF FIELD EFFICIENCY: EF(I) 
C THIS LINE REMOVED:
C     CALL EFFIC (AZ(I),EL(I),EFF,WS(I),RFLCTY)
      EFF = EF(I)
C CHANGE2 THE NEXT LINES CHANGED BECAUSE RS IS RECEIVER OUTPUT 
C FOR THIS ESTIMATE, THE DESIGN-POINT RECEIVER EFFICIENCY (XLRDP) IS USED
C PREDEWF IS PREDICTED ENERGY IN WORKING FLUID AT TIME STEP I
      PREDEWF = DELT*(EFF*SUNAP(I)*FS*.001*EPS - XLRDP)
      IF(PREDEWF.LT.RS*RMF*DELT)PREDEWF=0.
      PHBT = PHBT + PREDEWF
   10 CONTINUE
C
C  The power available from the receiver during the startup period
C  based on the weather prediction.
C
      PHBTS = 0.
      KSTUR = K+INT(TSTUR/DELT)+INT(.251/DELT)
      KSTUR = MIN0(KSTUR,KSET)
      DO 20 I = K, KSTUR
C CHANGE 1/15/87 DJA - FIELD EFFICIENCY DOESN'T NEED TO BE RECALCULATED.
C USE THE AVAILABLE VALUE OF FIELD EFFICIENCY: EF(I) 
C THIS LINE REMOVED:
C     CALL EFFIC (AZ(I),EL(I),EFF,WS(I),RFLCTY)
      EFF = EF(I)
C CHANGE2 THE NEXT LINE CHANGED BECAUSE RS IS RECEIVER OUTPUT 
C FOR THIS ESTIMATE, THE DESIGN-POINT RECEIVER THERMAL LOSS XLRDP IS USED
C CALCULATE PREDICTED ENERGY IN WORKING FLUID
C PREDEWF IS PREDICTED ENERGY IN WORKING FLUID AT TIME STEP I
      PREDEWF = DELT*(EFF*SUNAP(I)*FS*.001*EPS - XLRDP) 
      IF(PREDEWF.LT.RS*RMF*DELT)PREDEWF=0.
      PHBTS = PHBTS + PREDEWF
   20 CONTINUE
C
      RETURN
      END
C
C
      SUBROUTINE SCOVER(KRISE,KSET,NDA,SMAX)
C
C     SCOVER calculates the amount of storage SMAX, that will be required
C  to avoid discard assuming that the plant uses exactly the amount of
C  energy available at the base of the tower for that day.  This amount
C  of energy is estimated using a prediction of solar insolation.  The
C  turbine is started and run at full power so that the solar energy is
C  exhausted at the end of the peak period.
C
C N.B. SCOVER IS USED TO ESTIMATE THE REQUIRED STORAGE LEVEL FOR BOTH THE
C  CURRENT DAY (NDA) AND THE NEXT DAY (NDAY+1 = NEXD). HOWEVER, IN BOTH
C  CASES THE  ESTIMATE IS BASED ON THE VALUES OF FIELD EFFICIENCY (EF) FOR
C  ONLY THE CURRENT DAY - DJA (MAKES INSIGNIFICANT DIFFERENCE TO ANSWER)
C
C  *  *  *  *  *  *  *  *  *  *  Variables  *  *  *  *  *  *  *  *  *  *
C  *
C  *  DUM    - Dummy variables
C  *  KRISE  - Integer time for sunrise
C  *  KSET   - Integer time for sunset
C  *  NDUM   - Dummy variable
C  *  PERE   - End of the peak period
C  *  PHBT   - Predicted heat at the base of the tower for the IDAY day, MWht
C  *  ITTST
C  *  SM     - Solar multiple
C  *  TTST
C  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *
C
      COMMON /DATA/ AZ(193), EL(193), DNI(193), WD(193), WS(193),
     1 DBT(193), DPT(193), EF(193), SP(193)
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE IDAYMX ADDED
      COMMON /COMCOLF/IDAYMX,FMAX,FS, TLIML, TLIMU, ELIM, WSLIM, RFLCTY
C CHANGE2 XLRDP ADDED TO COMMON
      COMMON /COMRCVR/ EPS, RS, ALPHAR, TREQD, EREQD, RMF,
     1 STIME, WTIME, MFLG, NFLG, THOLD, TRSHUT,
     1 IFILL, IHOLD, IRSU, IDRO, IRO, IDAYOP,XLRDP 
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
C
      STLE = 0.
      SMAX = 0.
      PERX = PERE(NDA,1)
      KTTST = INT((PERX-PHBT/TPFSL)/DELT)+INT(1.001/DELT)
      KTTST = MAX0(KTTST,KRISE+INT(1.501/DELT))
      SM = RS/TPFSL
      HLRATE = 0.97**(DELT/24.)
      DO 10 K = KRISE, KSET
      STLE = STLE*HLRATE
C CHANGE 1/15/87 DJA - FIELD EFFICIENCY DOESN'T NEED TO BE RECALCULATED.
C USE THE AVAILABLE VALUE OF FIELD EFFICIENCY: EF(K) 
C THIS LINE REMOVED:
C      CALL EFFIC (AZ(K),EL(K),EFF,WS(K),RFLCTY)
      EFF = EF(K)
C CHANGE2 THE NEXT LINE CHANGED BECAUSE RS IS RECEIVER OUTPUT 
C FOR THIS ESTIMATE, THE DESIGN-POINT RECEIVER THERMAL LOSS (XLRDP) IS USED
C HBT IS PREDICTED ENERGY IN WORKING FLUID AT TIME STEP I
      HBT = DELT*(EFF*SUNP(K)*FS*.001*EPS - XLRDP)
      IF(HBT.LT.RS*RMF*DELT)HBT=0.
      IF (K .GE. KTTST) STLE = STLE+HBT-TPFSL*DELT
      IF (K .LT. KTTST) STLE = STLE+HBT
      IF (STLE .GT. SMAX) SMAX = STLE
   10 CONTINUE
C
C  SMAX is increased to allow for days when the actual insolation
C  exceeds the predicted insolation.
C
      SMAX = SMAX+(SM-1.)*TPFSL*3.0 !3.0 was determined by trial and
C                                   !comparison
C
      RETURN
      END
C CHANGE3 NEW SUBROUTINE ADDED
      SUBROUTINE PERIODS
C CHANGE3 NOWYEAR REMOVED FROM COMMON
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
      COMMON /DATA1/ TIM(193), NPTS, PTR(193), WBT(193), DELT
C CHANGE3 COMMON BLOCK SHORTEND AND RENAMED
C      COMMON /CONST/ PI, TPI, TORAD, TODEG, SUNR, SUNS
      COMMON /COMSUN/SUNR,SUNS
C
C CHANGE3 ADDITIONAL COMMON BLOCK FOR MAXOUT DISPATCH
      COMMON /DISPATCH2/ NVAC,IVAC(10),IDYLT1,IDYLT2,ISUMR1,ISUMR2,IWEEK

      WRITE(*,*)' SMART DISPATCH SELECTED, TIME PERIODS FOR SCE IN 1985'
      WRITE(9,*)' SMART DISPATCH SELECTED, TIME PERIODS FOR SCE IN 1985'
C
C  The starting and ending times of the peak, midpeak, and offpeak generating
C  times are now set:  ie. PERS(IDAY, 1) is the start of a peak generating
C  period, PERE(IDAY,2) is the end of a midpeak generating period, 
C  PERS(IDAY,3) is the beginning of the off peak period on IDAY day, etc.
C
C RATE PERIODS ARE SET FOR A FULL YEAR EVEN THOUGH ONLY DAYS UP TO NDAL+2
C  WILL  EVER BE USED.
C
      DO 100 IDAY=1,NDAYSY
	DT=0.
C CHECK FOR DAYLIGHT SAVINGS TIME, (DT=1)
	IF(IDAY.GE.IDYLT1.AND.IDAY.LE.IDYLT2)DT=1.
C
C INCREMENT DAY OF THE WEEK MONDAY=1 SUNDAY=7
	IWEEK=IWEEK+1
	IF(IWEEK.GT.7)IWEEK=1
C CHECK FOR SCE'S SUMMER SEASON
	IF(IDAY.GE.ISUMR1.AND.IDAY.LE.ISUMR2)THEN
C        Summertime
	  IF(IWEEK.LE.5)THEN
C          weekday SUMMER SEASON
C SET PERIOD START AND END
	    PERS(IDAY,1)=12.-DT
	    PERE(IDAY,1)=18.-DT
	    PERS(IDAY,2)=8.-DT
	    PERE(IDAY,2)=23.-DT
	    PERS(IDAY,3)=0.
	    PERE(IDAY,3)=24.
	  ELSE 
C           weekend SUMMER SEASON
	    PERS(IDAY,1)=0.
	    PERE(IDAY,1)=0.
	    PERS(IDAY,2)=0.
	    PERE(IDAY,2)=0.
	    PERS(IDAY,3)=0.
	    PERE(IDAY,3)=24.
	  END IF
	ELSE
C         Wintertime
	  IF(IWEEK.LE.5)THEN
C           Weekday WINTER SEASON
C PERIOD START AND END
	    PERS(IDAY,1)=17.-DT
	    PERE(IDAY,1)=21.-DT
	    PERS(IDAY,2)=8.-DT
	    PERE(IDAY,2)=21.-DT
	    PERS(IDAY,3)=0.
	    PERE(IDAY,3)=24.
	  ELSE 
C           Weekend WINTER SEASON
	    PERS(IDAY,1)=0.
	    PERE(IDAY,1)=0.
	    PERS(IDAY,2)=0.
	    PERE(IDAY,2)=0.
	    PERS(IDAY,3)=0.
	    PERE(IDAY,3)=24.
	  END IF
	END IF
  100 CONTINUE
c
c  holidays DO NOT HAVE A PEAK OR MIDPEAK 
c
      DO 200 L=1,NVAC  
	PERS(IVAC(L),1) = 0. 
	PERE(IVAC(L),1) = 0.
	PERS(IVAC(L),2) = 0.
	PERE(IVAC(L),2) = 0.
  200 CONTINUE
C
C  Conditions are initialized for the first day. The subroutine ALLEN
C  calculates the day's predicted insolation, contained in the SUNP matrix.
C
C THE VALUE MAXIMIZING ROUTINE USES A PREDICITON OF THE DAY'S INSOLATION (SUNP)
C THE PREDICTION IS BASED ON THE TWO PREVIOUS DAYS. HOWEVER, FOR JANUARY 1
C THE CLEAR SKY MODEL IS SUBSTITUTED FOR THE PREDICTION.
C CALL INPUT2 TO GET SUNRISE AND SUNSET FOR JANUARY 1.
      CALL INPUT2(1,0)
C RESET INSOLATION FILE TO THE BEGINNING AND REREAD HEADER LINE
      REWIND 2
      READ(2,*)IYR
      KRISE=INT(SUNR/DELT)+INT(.751/DELT)
      KSET=INT(SUNS/DELT)+INT(.251/DELT)
      CALL ALLEN(1,KRISE,KSET)
      DO 300 K=KRISE,KSET
  300 SUNP(K)=SUNMAX(K)
      RETURN
      END
C
      SUBROUTINE DISP(NDA,KRISE,KSET)
C CHANGE3
C NEW SUBROUTINE FOR USE WITH THE MAXOUT DISPATCH STRATEGY (IDISP=1)
C
      COMMON /DISPATCH/ PERS(366,3),PERE(366,3),SUNAP(193),SUNP(193),
     1SCO1,SCO2,SCO3,IDISP,TSTUR,PSTFR,PHBT,SUNMAX(193),PHBTS,IDF1,
     2IDF2,NDAYSY,ILEAP
      COMMON /COMTRBN/ TBHWS, TBWCS, ESMIN1, ESMIN2, ESMAX1, ESMAX2,
     1 TPFSL, TMFS, ICAN, TS1, TS2, SDH, SDW, SDC, RDH, RDW, RDC
      COMMON /COMSTRG/ PTSMAX, PFSMAX, PTSMIN, PFSMIN, EMAX, EMIN, ES,
     1 A(3), CLF, DLF, TNKLF, LS, REFPC, EOLD, TSTCR, ESTCR,
     1 TSTDR, ESTDR, PWARMC, PWARMD
      COMMON /COMSUN/SUNR,SUNS
C
C SET ADJUSTABLE PREDICTION EQUAL TO FIXED DAILY PREDICTION
      DO 100 K = KRISE,KSET  
  100 SUNAP(K) = SUNP(K)
C
C  If the tomorrow or the day after tomorrow is an off peak day, then
C  set the period start and end times for the peak and mid peak periods
C  equal to the sunset time.  
C
      NEXD = NDA + 1
      IF (NEXD .EQ. 367) NEXD=1
      NEXXD = NEXD + 1
      IF (NEXXD .EQ. 367) NEXXD=1
C
      IF(PERE(NDA,1) .EQ. 0.) THEN
C  TODAY IS AN OFFPEAK DAY  
C Set PERE and PERS equal to SUNSET
	   PERE(NDA,1) = SUNS
	   PERE(NDA,2) = SUNS
	   PERS(NDA,1) = SUNS
	   PERS(NDA,2) = SUNS
      END IF
      IF(PERE(NEXD,1) .EQ. 0.) THEN
C  TOMORROW IS AN OFF PEAK DAY
	   PERE(NEXD,1) = SUNS
	   PERE(NEXD,2) = SUNS
	   PERS(NEXD,1) = SUNS
	   PERS(NEXD,2) = SUNS
      END IF
      IF(PERE(NEXXD,1) .EQ. 0.) THEN
C THE DAY AFTER TOMORROW IS AN OFF PEAK DAY
	   PERE(NEXXD,1) = SUNS
	   PERE(NEXXD,2) = SUNS
	   PERS(NEXXD,1) = SUNS
	   PERS(NEXXD,2) = SUNS
      END IF
C
C  Set the carryover storage levels SCO1, SCO2, and SCO3.  SCO1 is that 
C  level of storage not required to avoid discard for today, assuming 
C  that the turbine uses exactly PHBT amount of heat today such that
C  PHBT is exhausted at the end of the peak period (or sunset for an
C  off peak day).  SCO2 is SCO1 but for tomorrow and is therefore
C  equal to SCO1 when PERE(NDA,1) is equal to PERE(NEXD,1).  SCO3 is 
C  SCO2 augmented by that amount of heat greater than PHBT that is 
C  required to run the turbine at full power from the beginning of the 
C  mid peak period through the end of the peak period tomorrow or the 
C  day after tomorrow, whichever may be the larger amount of heat.  If 
C  PHBT alone is sufficient to run the turbine for this period of time 
C  (both tomorrow and the day after), then SCO3=SCO2.  SCO3, of course, 
C  must be less than EMAX.
C  
      CALL PREDICT(KRISE,KSET)
      PHBTS = 0.
      CALL ALLEN(NDA,KRISE,KSET)
      CALL SCOVER(KRISE,KSET,NDA,SMAX)
C CHANGE2 
C THE NEXT TWO LINES CHANGED TO REFINE MAXOUT DISPATCH 1 MAY 87
      SCO1 = EMAX-SMAX
      SCO2 = AMAX1(0.,SCO1)
      IF (ABS(PERE(NDA,1)-PERE(NEXD,1)) .GT. .1) THEN
C SMAX for tomorrow
	   CALL SCOVER(KRISE,KSET,NEXD,SMAX)
C Carryover storage for tomorrow
	   SCO2 = AMAX1(0.,EMAX-SMAX)
      END IF
C
C  SCO3 is used to shift off peak generation to mid or to on peak
C  periods provided that PHBT is not sufficient to run the turbine
C  during the mid and peak periods tomorrow or the day after tomorrow.
C
      SCO3 = AMAX1(0.,TPFSL*(PERE(NEXD,1)-PERS(NEXD,2))-PHBT,
     1             TPFSL*(PERE(NEXXD,1)-PERS(NEXXD,2))-PHBT)+SCO2
      SCO3 = AMIN1(EMAX,SCO3)
      IF(NDA.GE.IDF1.AND.NDA.LE.IDF2)THEN
C PRINT OF DETAILED DISPATCH ON DISPAT.TRC
	   WRITE(5,1000)NDA
	   WRITE(5,2000)1,PERS(NDA,1),PERE(NDA,1),PERS(NEXD,1),
     1               PERE(NEXD,1),PERS(NEXXD,1),PERE(NEXXD,1)
	   WRITE(5,2000)2,PERS(NDA,2),PERE(NDA,2),PERS(NEXD,2),
     1               PERE(NEXD,2),PERS(NEXXD,2),PERE(NEXXD,2)
	   WRITE(5,2000)3,PERS(NDA,3),PERE(NDA,3),PERS(NEXD,3),
     1               PERE(NEXD,3),PERS(NEXXD,3),PERE(NEXXD,3)
	   WRITE(5,3000)NDA,PHBT/TPFSL,ES/TPFSL
	   WRITE(5,4000)SCO1/TPFSL,SCO2/TPFSL,SCO3/TPFSL,SMAX/TPFSL
      END IF
 1000 FORMAT(' ****************** DAY',I5,' ****************')
 2000 FORMAT(' PERIOD ',I2,' NDA:',2F6.2,'   NEXD:',2F6.2,'   NEXXD:',
     1       2F6.2)
 3000 FORMAT(/' IN NDA LOOP: NDA,PHBT,ES=',I4,2F10.3)
 4000 FORMAT(' SCO1,SCO2,SCO3,SMAX=',4F10.3)
      RETURN
      END
C
C
      SUBROUTINE SPLIFT (X,Y,YP,YPP,N,W,IERR,ISX,A1,B1,AN,BN)
C
C     Sandia Mathematical Program Library
C     Applied Mathematics Division 2646
C     Sandia Laboratories
C     Albuquerque, New Mexico  87185
C
C     Written by Rondall E. Jones
C
C     Abstract:
C         SPLIFT fits an interpolating cubic spline to the N data points
C         given in X and Y and returns the first and second derivatives
C         in YP AND YPP.  The resulting spline (defined by X, Y, and
C         YPP) and its first and second derivatives may then be
C         evaluated using SPLINT.
C
C     Description of arguments:
C         The user must dimension all arrays appearing in the call list,
C         e.g.   X(N), Y(N), YP(N), YPP(N), W(3N)
C
C     Input:
C
C         X    - Array of abscissas of data (in increasing order)
C         Y    - Array of ordinates of data
C         N    - The number of data points.  The arrays X, Y, YP, and
C                YPP must be dimensioned at least N.  (N .GE. 4)
C         ISX  - Must be zero on the initial call to SPLIFT.
C                If a spline is to be fitted to a second set of data
C                that has the same set of abscissas as a previous set,
C                and if the contents of W have not been changed since
C                that previous fit was computed, then ISX may be
C                set to one for faster execution.
C         A1,B1,AN,BN - Specify the end conditions for the spline which
C                are expressed as constraints on the second derivative
C                of the spline at the end points (see YPP).
C                The end condition constraints are:
C
C                and
C
C                where:
C
C
C                The smoothest spline (i.e., least integral of square
C                of second derivative) is obtained by A1=B1=AN=BN=0.
C                In this case there is an inflection at X(1) and X(N).
C                If the data are to be extrapolated (say, by using SPLINT
C                to evaluate the spline outside the range X(1) to X(N)),
C                then taking A1=AN=0.5 and B1=BN=0 may yield better
C                results.  In this case there is an inflection
C                at X(1) - (X(2)-X(1)) and at X(N) + (X(N)-X(N-1)).
C                In the more general case of A1=AN=A  and B1=BN=0,
C                there is an inflection at X(1) - (X(2)-X(1))*A/(1.0-A)
C                and at X(N) + (X(N)-X(N-1))*A/(1.0-A).
C
C                A spline that has a given first derivative YP1 at X(1)
C                and YPN at Y(N) may be defined by using the
C                following conditions:
C
C                A1=-0.5
C
C                B1= 3.0*((Y(2)-Y(1))/(X(2)-X(1))-YP1)/(X(2)-X(1))
C
C                AN=-0.5
C
C                BN=-3.0*((Y(N)-Y(N-1))/(X(N)-X(N-1))-YPN)/(X(N)-X(N-1))
C
C       Output:
C
C         YP   - Array of first derivatives of spline (at the X(I))
C         YPP  - Array of second derivatives of spline (at the X(I))
C         IERR - A status code:
C              --Normal code
C                 1 means that the requested spline was computed.
C              --Abnormal codes
C                 2 means that N, the number of points, was .LT. 4.
C                 3 means the abscissas were not strictly increasing.
C
C       Work:
C
C         W    - Array of working storage dimensioned at least 3N.
C
      DIMENSION X(N),Y(N),YP(N),YPP(N),W(N,3)
C
      IF (N.LT.4) GO TO 200
      NM1  = N-1
      NM2  = N-2
      IF (ISX.GT.0) GO TO 40
      DO 5 I=2,N
      IF (X(I)-X(I-1)) 300,300,5
    5 CONTINUE
C
C     Define the tridiagonal matrix
C
      W(1,3) = X(2)-X(1)
      DO 10 I=2,NM1
      W(I,2) = W(I-1,3)
      W(I,3) = X(I+1)-X(I)
   10 W(I,1) = 2.0*(W(I,2)+W(I,3))
      W(1,1) = 4.0
      W(1,3) =-4.0*A1
      W(N,1) = 4.0
      W(N,2) =-4.0*AN
C
C     L U Decomposition
C
      DO 30 I=2,N
      W(I-1,3) = W(I-1,3)/W(I-1,1)
   30 W(I,1)   = W(I,1) - W(I,2)*W(I-1,3)
C
C     Define *CONSTANT* vector
C
   40 YPP(1) = 4.0*B1
      DOLD   = (Y(2)-Y(1))/W(2,2)
      DO 50 I=2,NM2
      DNEW   = (Y(I+1) - Y(I))/W(I+1,2)
      YPP(I) = 6.0*(DNEW - DOLD)
      YP(I)  = DOLD
   50 DOLD   = DNEW
      DNEW   = (Y(N)-Y(N-1))/(X(N)-X(N-1))
      YPP(NM1) = 6.0*(DNEW - DOLD)
      YPP(N) = 4.0*BN
      YP(NM1)= DOLD
      YP(N)  = DNEW
C
C     Forward substitution
C
      YPP(1) = YPP(1)/W(1,1)
      DO 60 I=2,N
   60 YPP(I) = (YPP(I) - W(I,2)*YPP(I-1))/W(I,1)
C
C     Backward substitution
C
      DO 70 J=1,NM1
      I = N-J
   70 YPP(I) = YPP(I) - W(I,3)*YPP(I+1)
C
C     Compute first derivatives
C
      YP(1)  = (Y(2)-Y(1))/(X(2)-X(1)) - (X(2)-X(1))*(2.0*YPP(1)
     1         + YPP(2))/6.0
      DO 80 I=2,NM1
   80 YP(I)  = YP(I) + W(I,2)*(YPP(I-1) + 2.0*YPP(I))/6.0
      YP(N)  = YP(N) + (X(N)-X(NM1))*(YPP(NM1) + 2.0*YPP(N))/6.0
C
      IERR = 1
      RETURN
  200 IERR = 2
      WRITE(*,*)' SPLIFT-THERE WERE LESS THAN 4 DATA VALUES.'
      RETURN
  300 IERR = 3
      WRITE(*,*)' SPLIFT-THE ABSCISSAS WERE NOT STRICTLY INCREASING.'
      RETURN
      END
C
C
      SUBROUTINE SPLINT (X,Y,YPP,N,XI,YI,YPI,YPPI,NI,KERR)
C
C     Sandia Mathematical Program Library
C     Applied Mathematics Division 2646
C     Sandia National Laboratories
C     Albuquerque, New Mexico  87185
C
C     Written by Rondall E. Jones
C
C     Abstract:
C
C         SPLINT evaluates a cubic spline and its first and second
C         derivatives at the abscissas in XI.  The spline (which
C         is defined by X, Y, and YPP) may have been determined by
C         SPLIFT or SMOO or any other spline fitting routine that
C         provides second derivatives.
C
C     Description of arguments:
C         The user must dimension all arrays appearing in the call list,
C         e.g.  X(N), Y(N), YPP(N), XI(NI), YI(NI), YPI(NI), YPPI(NI)
C
C     Input:
C
C         X   - Array of abscissas (in increasing order) that define the
C               spline.  Usually X is the same as X in SPLIFT or SMOO.
C         Y   - Array of ordinates that define the spline.  Usually Y is
C               the same as Y in SPLIFT or as R in SMOO.
C         YPP - Array of second derivatives that define the spline.
C               usually YPP is the same as YPP in SPLIFT or R2 in SMOO.
C         N   - The number of data points that define the spline.
C               the arrays X, Y, and YPP must be dimensioned at least N.
C               N must be greater than or equal to 2.
C         XI  - The abscissa or array of abscissas (in arbitrary order)
C               at which the spline is to be evaluated.
C               Each XI(K) that lies between X(1) and X`(N) is a case of
C               interpolation.  Each XI(K) that does not lie between
C               X(1) and X(N) is a case of extrapolation.  Both cases
C               are allowed.  See description of KERR.
C         NI  - The number of abscissas at which the spline is to be
C               evaluated.  If NI is greater than 1, then XI, YI, YPI,
C               and YPPI must be arrays dimensioned at least NI.
C               NI must be greater than or equal to 1.
C
C     Output:
C
C         YI   - Array of values of the spline (ordinates) at XI.
C         YPI  - Array of values of the first derivative of spline at XI.
C         YPPI - Array of values of second derivatives of spline at XI.
C         KERR - A status code
C             -- Normal codes
C                1 means that the spline was evaluated at each abscissa
C                  in XI using only interpolation.
C                2 means that the spline was evaluated at each abscissa
C                  in XI, but at least one extrapolation was performed.
C             -- Abnormal code
C                3 means that the requested number of evaluations, NI,
C                  was not positive.
C
      DIMENSION X(N),Y(N),YPP(N),XI(NI),YI(NI),YPI(NI),YPPI(NI)
C
C     Check input:
C
      IF (NI) 1,1,2
    1 WRITE(*,*)' SPLINT-THE REQUESTED NUMBER OF INTERPOLATIONS WAS'
      WRITE(*,*)' NOT POSITIVE.'
      KERR = 3
      RETURN
    2 KERR = 1
      NM1= N-1
C
C     K is index on value of XI being worked on.  XX is that value.
C     I is current index into X array.
C
      K  = 1
      XX = XI(1)
      IF (XX.LT.X(1)) GO TO 90
      IF (XX.GT.X(N)) GO TO 80
      IL = 1
      IR = N
C
C     Bisection search:
C
   10 I  = (IL+IR)/2
      IF (I.EQ.IL) GO TO 100
      IF (XX-X(I)) 20,100,30
   20 IR = I
      GO TO 10
   30 IL = I
      GO TO 10
C
C     Linear forward search:
C
   50 IF (XX-X(I+1)) 100,100,60
   60 IF (I.GE.NM1) GO TO 80
      I  = I+1
      GO TO 50
C
C     Extrapolation:
C
   80 KERR = 2
      I  = NM1
      GO TO 100
   90 KERR = 2
      I  = 1
C
C     Interpolation:
C
  100 H  = X(I+1) - X(I)
      H2 = H*H
      XR = (X(I+1)-XX)/H
      XR2= XR*XR
      XR3= XR*XR2
      XL = (XX-X(I))/H
      XL2= XL*XL
      XL3= XL*XL2
      YI(K) = Y(I)*XR + Y(I+1)*XL
     1       -H2*(YPP(I)*(XR-XR3) + YPP(I+1)*(XL-XL3))/6.0
      YPI(K) = (Y(I+1)-Y(I))/H
     1        +H*(YPP(I)*(1.0-3.0*XR2) - YPP(I+1)*(1.0-3.0*XL2))/6.0
      YPPI(K) = YPP(I)*XR + YPP(I+1)*XL
C
C     Next point:
C
      IF (K.GE.NI) RETURN
      K = K+1
      XX = XI(K)
      IF (XX.LT.X(1)) GO TO 90
      IF (XX.GT.X(N)) GO TO 80
      IF (XX-XI(K-1)) 110,100,50
  110 IL = 1
      IR = I+1
      GO TO 10
C
      END
C
C
	SUBROUTINE TSPLIN(XV,NX,YV,NY,ZV,X0,Y0,Z0,IERR)
C
C  Subroutine TSPLIN uses the one-dimensional spline fit routines of
C  SPLIFT and SPLINT to provide nearly equivalent two-dimensional
C  spline fits.  Subroutine TSPLIN is provided to replace the
C  two-dimensional spline fit subroutines available in the IMSL math
C  package, a commercial software product, which are used in
C  SOLERGY.
C
C  XV     - array of X coordinate values
C  NX     - number of X coordinate values
C  YV     - array of Y coordinate values
C  NY     - number of Y coordinate values
C  ZV     - array of Z values for each pair of XV, YV values
C  X0, Y0 - x,y pair for which an interpolated z value is sought
C  Z0     - the interpolated z value for the given X0, Y0
C  IERR   - error value, 0 = no error
C  Q,R    - temporary z-value vectors
C
C
C
	DIMENSION XV(NX),YV(NY),ZV(NX,NY),Q(20),R(20)
	DIMENSION YP(20),YPP(20),W(20,3),YPI(20),YPPI(20)
	DIMENSION YP2(20),YPP2(20),W2(20,3),YPI2(20),YPPI2(20)
C
C
	A1=0
	B1=0
	AB=0
	BN=0
	ISX=0
	IERR=0
C
C  Check to see if the requested x,y pair is within the
C  domain of XV and YV
C
	IF(X0.LT.XV(1).OR.X0.GT.XV(NX))GO TO 8100
	IF(Y0.LT.YV(1).OR.Y0.GT.YV(NY))GO TO 8200
C
C  Check to see if ZV is two dimensional
C
	IF(NX.LT.2.OR.NY.LT.2)GO TO 8300
C
C  Check to see if XV or YV array is too big
C
	IF(NX.GT.20.OR.NY.GT.20)GO TO 8800
C
C  Interpolate along each constant YV axis to find the temporary Z
C  values at (X0,YV)
C
	DO 100 J=1,NY
	DO 110 I=1,NX
	Q(I)=ZV(I,J) ! Create a 1-D array of ZV values
110     CONTINUE
	IERR=0
	CALL SPLIFT(XV,Q,YP,YPP,NX,W,IERR,ISX,A1,B1,AN,BN)
	IF(IERR.NE.1)GO TO 8400
	IERR=0
	CALL SPLINT(XV,Q,YPP,NX,X0,Q0,YPI,YPPI,1,IERR)
	IF(IERR.NE.1)GO TO 8500
	R(J)=Q0 ! Temporary Z value
100     CONTINUE
C
C  Now interpolate the temporary Z values (R) to find Z0 at
C  (Y0,X0)
C
	A1=0
	B1=0
	AB=0
	BN=0
	ISX=0
	IERR=0
	CALL SPLIFT(YV,R,YP2,YPP2,NY,W2,IERR,ISX,A1,B1,AN,BN)
	IF(IERR.NE.1)GO TO 8600
C
	IERR=0
	CALL SPLINT(YV,R,YPP2,NY,Y0,Z0,YPI2,YPPI2,1,IERR)
	IF(IERR.NE.1)GO TO 8700
C
	IERR=0
	RETURN
C
8100    CONTINUE
	IERR=1
	WRITE(*,*) ' X VALUE OUT OF RANGE'
	RETURN
8200    CONTINUE
	IERR=2
	WRITE(*,*) 'Y VALUE OUT OF RANGE'
	RETURN
8300    CONTINUE
	IERR=3
	WRITE(*,*) 'NUMBER OF X OR Y VALUES IS ONE OR LESS'
	RETURN
8400    CONTINUE
	IERR=4
	WRITE(*,*) 'ERROR IN LEVEL ONE SPLIFT'
	RETURN
8500    CONTINUE
	IERR=5
	WRITE(*,*) 'ERROR IN LEVEL ONE SPLINT'
	RETURN
8600    CONTINUE
	IERR=6
	WRITE(*,*) 'ERROR IN LEVEL TWO SPLIFT'
	RETURN
8700    CONTINUE
	IERR=7
	WRITE(*,*) 'ERROR IN LEVEL TWO SPLINT'
	RETURN
8800    CONTINUE
	IERR=8
	WRITE(*,*) 'ONE DIMENSION OF THE ARRAY OF VALUES EXCEEDS 20'
	RETURN
	END
