/**
 * JAva GUi for Applied Research (JAGUAR)
 * Copyright 2009 Sandia Corporation.
 * This software is distributed under the BSD license.
 * For more information, see COPYRIGHT and LICENSE distributed with JAGUAR.
 */

package gov.sandia.dart.jaguar.intro;

import gov.sandia.dart.jaguar.JaguarPreferencePage;

import java.util.Properties;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

/**
 * Intro/Welcome page calls Wizard
 */

public class OpenPreferencesPage implements IIntroAction {

	public void run(final IIntroSite site, final Properties params) {


		final IPreferencePage page = new JaguarPreferencePage();
		final PreferenceManager mgr = new PreferenceManager();
		final IPreferenceNode node = new PreferenceNode("gov.sandia.dart.jaguar.preferencesolo", page);
		mgr.addToRoot(node);
		final PreferenceDialog dialog = new PreferenceDialog(site.getShell(), mgr);
		dialog.create();
		dialog.setMessage(page.getTitle());
		dialog.open();

	}
}
