/**
 * JAva GUi for Applied Research (JAGUAR)
 * Copyright 2009 Sandia Corporation.
 * This software is distributed under the BSD license.
 * For more information, see COPYRIGHT and LICENSE distributed with JAGUAR.
 */

package gov.sandia.dart.jaguar.intro;

import gov.sandia.dart.jaguar.wizard.newInputDeck.NewInputDeck;

import java.util.Properties;

import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

/**
 * Intro/Welcome page calls Wizard
 * 
 */

public class NewInputDeckWizard implements IIntroAction {

	public void run(IIntroSite site, Properties params) {
		NewInputDeck wizard = new NewInputDeck();
		wizard.init(site.getWorkbenchWindow().getWorkbench(), null);
		// Instantiates the wizard container with the wizard and opens it
		WizardDialog dialog = new WizardDialog(site.getShell(), wizard);
		dialog.create();
		int ret = dialog.open();

		// close intro
		if (ret == WizardDialog.OK) {
			IIntroManager intro = PlatformUI.getWorkbench().getIntroManager();
			intro.closeIntro(intro.getIntro());
		}
	}

}
