/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.FiltersConfigurationDialog;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerColumnLabelProvider;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.internal.views.markers.MarkerCopyHandler;
import org.eclipse.ui.internal.views.markers.MarkerEntry;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerResourceUtil;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.internal.views.markers.MarkerViewerContentProvider;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.internal.views.markers.MarkersTreeViewer;
import org.eclipse.ui.internal.views.markers.UIUpdateJob;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ContentGeneratorDescriptor;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;

public class ExtendedMarkersView
extends ViewPart {
    public final Object MARKERSVIEW_UPDATE_JOB_FAMILY = new Object();
    private static int instanceCount = 1;
    private static final String TAG_GENERATOR = "markerContentGenerator";
    private static final String MARKER_FIELD = "MARKER_FIELD";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_PART_NAME = "partName";
    private static final String TAG_COLUMN_WIDTHS = "columnWidths";
    private MarkerContentGenerator generator;
    private CachedMarkerBuilder builder;
    private Collection categoriesToExpand;
    private UIUpdateJob uiUpdateJob;
    private MarkersTreeViewer viewer;
    private ISelectionListener pageSelectionListener;
    private IPartListener2 partListener;
    private Clipboard clipboard;
    private IMemento memento;
    private String[] defaultGeneratorIds = new String[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ExtendedMarkersView(String contentGeneratorId) {
        this.defaultGeneratorIds = new String[]{contentGeneratorId};
    }

    private void addAllConcreteItems(MarkerSupportItem markerItem, Collection allMarkers) {
        if (markerItem.isConcrete()) {
            allMarkers.add(markerItem);
            return;
        }
        MarkerSupportItem[] children = markerItem.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addAllConcreteItems(children[i], allMarkers);
            ++i;
        }
    }

    void addExpandedCategory(MarkerCategory category) {
        this.getCategoriesToExpand().add(category.getName());
    }

    private void addMarkers(MarkerSupportItem markerItem, Collection allMarkers) {
        if (markerItem.getMarker() != null) {
            allMarkers.add(markerItem.getMarker());
        }
        MarkerSupportItem[] children = markerItem.getChildren();
        int i = 0;
        while (i < children.length) {
            this.addMarkers(children[i], allMarkers);
            ++i;
        }
    }

    private void createViewer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.viewer = new MarkersTreeViewer(new Tree(parent, 66306));
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setUseHashlookup(true);
        this.createColumns(new TreeColumn[0]);
        this.viewer.setContentProvider(this.getContentProvider());
    }

    private void createColumns(TreeColumn[] currentColumns) {
        Tree tree = this.viewer.getTree();
        TableLayout layout = new TableLayout();
        MarkerField[] fields = this.generator.getVisibleFields();
        IMemento columnWidths = null;
        if (this.memento != null) {
            columnWidths = this.memento.getChild(TAG_COLUMN_WIDTHS);
        }
        int i = 0;
        while (i < fields.length) {
            Integer value;
            TreeViewerColumn column;
            MarkerField markerField = fields[i];
            if (i < currentColumns.length) {
                column = new TreeViewerColumn((TreeViewer)this.viewer, currentColumns[i]);
            } else {
                column = new TreeViewerColumn((TreeViewer)this.viewer, 0);
                column.getColumn().setResizable(true);
                column.getColumn().setMoveable(true);
                column.getColumn().addSelectionListener(this.getHeaderListener());
            }
            column.getColumn().setData(MARKER_FIELD, (Object)markerField);
            column.setLabelProvider((CellLabelProvider)new MarkerColumnLabelProvider(markerField));
            column.getColumn().setText(markerField.getColumnHeaderText());
            column.getColumn().setToolTipText(markerField.getColumnTooltipText());
            column.getColumn().setImage(markerField.getColumnHeaderImage());
            EditingSupport support = markerField.getEditingSupport((ColumnViewer)this.viewer);
            if (support != null) {
                column.setEditingSupport(support);
            }
            if (this.builder.getPrimarySortField().equals(markerField)) {
                this.updateDirectionIndicator(column.getColumn(), markerField);
            }
            int columnWidth = -1;
            if (i == 0) {
                GC gc = new GC((Drawable)tree);
                gc.setFont(tree.getFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                gc.dispose();
                columnWidth = Math.max(markerField.getDefaultColumnWidth((Control)tree), fontMetrics.getAverageCharWidth() * 5);
            }
            if (columnWidths != null && (value = columnWidths.getInteger(this.getFieldId(column.getColumn()))) != null && value > 0) {
                columnWidth = value;
            }
            if (columnWidth < 0) {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(markerField.getDefaultColumnWidth((Control)tree), true, true));
            } else {
                layout.addColumnData((ColumnLayoutData)new ColumnPixelData(columnWidth, true));
            }
            ++i;
        }
        if (currentColumns.length > fields.length) {
            i = fields.length;
            while (i < currentColumns.length) {
                currentColumns[i].dispose();
                ++i;
            }
        }
        this.viewer.getTree().setLayout((Layout)layout);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.layout(true);
    }

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.addPageAndPartSelectionListener();
        this.addLinkWithEditorSupport();
        this.addExpansionListener();
        this.addHelpListener();
        this.addSelectionListener();
        this.registerContextMenu();
        this.initDragAndDrop();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.startView();
    }

    private void startView() {
        this.viewer.setInput(this.builder.getMarkers());
        IContentProvider contentProvider = this.viewer.getContentProvider();
        Markers clone = this.createViewerInputClone();
        if (clone == null) {
            clone = this.builder.getMarkers().getClone();
        }
        contentProvider.inputChanged((Viewer)this.viewer, (Object)this.getViewerInput(), (Object)clone);
        this.builder.start();
    }

    private void addPageAndPartSelectionListener() {
        this.pageSelectionListener = new ViewerPageSelectionListener(this);
        this.getSite().getPage().addPostSelectionListener(this.pageSelectionListener);
        this.partListener = this.getPartListener();
        this.getSite().getPage().addPartListener(this.partListener);
        this.pageSelectionListener.selectionChanged(this.getSite().getPage().getActivePart(), this.getSite().getPage().getSelection());
    }

    private void addSelectionListener() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    ExtendedMarkersView.this.updateStatusLine((IStructuredSelection)selection);
                }
            }
        });
    }

    private void addHelpListener() {
        this.viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                Object provider;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.help.IContextProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((provider = ExtendedMarkersView.this.getAdapter(clazz)) == null) {
                    return;
                }
                IContext context = ((IContextProvider)provider).getContext((Object)ExtendedMarkersView.this.viewer.getControl());
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
            }
        });
    }

    private void addExpansionListener() {
        this.viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                ExtendedMarkersView.this.removeExpandedCategory((MarkerCategory)e.item.getData());
            }

            public void treeExpanded(TreeEvent e) {
                ExtendedMarkersView.this.addExpandedCategory((MarkerCategory)e.item.getData());
            }
        });
    }

    private void addLinkWithEditorSupport() {
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    ExtendedMarkersView.this.openSelectedMarkers();
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                ExtendedMarkersView.this.openSelectedMarkers();
            }
        };
    }

    void disableAllFilters() {
        this.generator.disableAllFilters();
    }

    public void dispose() {
        this.builder.cancelUpdate();
        this.cancelQueuedUpdates();
        this.builder.dispose();
        this.generator.dispose();
        if (instanceCount > 1) {
            --instanceCount;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.getSite().getPage().removePostSelectionListener(this.pageSelectionListener);
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    MarkerSupportItem[] getAllConcreteItems() {
        MarkerSupportItem[] elements = this.getActiveViewerInputClone().getElements();
        ArrayList allMarkers = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            this.addAllConcreteItems(elements[i], allMarkers);
            ++i;
        }
        MarkerSupportItem[] markers = new MarkerSupportItem[allMarkers.size()];
        allMarkers.toArray(markers);
        return markers;
    }

    Collection getAllFilters() {
        return this.generator.getAllFilters();
    }

    IMarker[] getAllMarkers() {
        MarkerSupportItem[] elements = this.getActiveViewerInputClone().getElements();
        ArrayList allMarkers = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            this.addMarkers(elements[i], allMarkers);
            ++i;
        }
        IMarker[] markers = new IMarker[allMarkers.size()];
        allMarkers.toArray(markers);
        return markers;
    }

    CachedMarkerBuilder getBuilder() {
        return this.builder;
    }

    Collection getCategoriesToExpand() {
        if (this.categoriesToExpand == null) {
            IMemento expanded;
            this.categoriesToExpand = new HashSet();
            if (this.memento != null && (expanded = this.memento.getChild(TAG_EXPANDED)) != null) {
                IMemento[] mementoCategories = expanded.getChildren(TAG_CATEGORY);
                MarkerCategory[] markerCategories = this.getActiveViewerInputClone().getCategories();
                if (markerCategories != null) {
                    int i = 0;
                    while (i < markerCategories.length) {
                        int j = 0;
                        while (j < mementoCategories.length) {
                            if (markerCategories[i].getName().equals(mementoCategories[j].getID())) {
                                this.categoriesToExpand.add(markerCategories[i].getName());
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
        return this.categoriesToExpand;
    }

    MarkerGroup getCategoryGroup() {
        return this.builder.getCategoryGroup();
    }

    Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new Clipboard(this.viewer.getControl().getDisplay());
        }
        return this.clipboard;
    }

    private IContentProvider getContentProvider() {
        return new MarkerViewerContentProvider();
    }

    private String getFieldId(TreeColumn treeColumn) {
        return ((MarkerField)treeColumn.getData(MARKER_FIELD)).getConfigurationElement().getAttribute("id");
    }

    String[] getGeneratorIds() {
        return this.defaultGeneratorIds;
    }

    private SelectionListener getHeaderListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeColumn column = (TreeColumn)e.widget;
                MarkerField field = (MarkerField)column.getData(ExtendedMarkersView.MARKER_FIELD);
                ExtendedMarkersView.this.setPrimarySortField(field, column);
            }
        };
    }

    private IPartListener2 getPartListener() {
        return new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals(ExtendedMarkersView.this.getSite().getId())) {
                    ExtendedMarkersView.this.pageSelectionListener.selectionChanged(ExtendedMarkersView.this.getSite().getPage().getActivePart(), ExtendedMarkersView.this.getSite().getPage().getSelection());
                }
            }
        };
    }

    public IMarker[] getSelectedMarkers() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Iterator elements = structured.iterator();
            ArrayList<IMarker> result = new ArrayList<IMarker>();
            while (elements.hasNext()) {
                MarkerSupportItem next = (MarkerSupportItem)elements.next();
                if (!next.isConcrete()) continue;
                result.add(((MarkerEntry)next).getMarker());
            }
            if (result.isEmpty()) {
                return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
            }
            IMarker[] markers = new IMarker[result.size()];
            result.toArray(markers);
            return markers;
        }
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ARRAY;
    }

    public boolean getSortAscending() {
        return this.viewer.getTree().getSortDirection() == 128;
    }

    private String getStatusMessage() {
        Markers markers = this.getActiveViewerInputClone();
        String status = "";
        int totalCount = this.builder.getTotalMarkerCount(markers);
        int filteredCount = 0;
        MarkerCategory[] categories = markers.getCategories();
        if (categories != null && this.builder.isShowingHierarchy()) {
            int markerLimit = MarkerSupportInternalUtilities.getMarkerLimit();
            int i = 0;
            while (i < categories.length) {
                filteredCount += markerLimit < 0 ? ((MarkerSupportItem)categories[i]).getChildrenCount() : Math.min(((MarkerSupportItem)categories[i]).getChildrenCount(), markerLimit);
                ++i;
            }
        } else {
            filteredCount = MarkerSupportInternalUtilities.getMarkerLimit();
        }
        Object[] counts = markers.getMarkerCounts();
        if (counts[0] == 0 && counts[1] == 0) {
            status = filteredCount < 0 || filteredCount >= totalCount ? NLS.bind((String)MarkerMessages.filter_itemsMessage, (Object)new Integer(totalCount)) : NLS.bind((String)MarkerMessages.filter_matchedMessage, (Object)new Integer(filteredCount), (Object)new Integer(totalCount));
            return status;
        }
        counts = new Integer[]{counts[0], counts[1], new Integer(counts[2] + counts[3])};
        if (filteredCount < 0 || filteredCount >= totalCount) {
            return MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])counts);
        }
        return NLS.bind((String)MarkerMessages.problem_filter_matchedMessage, (Object[])new Object[]{MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])counts), new Integer(filteredCount), new Integer(totalCount)});
    }

    Markers getViewerInput() {
        return (Markers)this.viewer.getInput();
    }

    Markers getActiveViewerInputClone() {
        return this.builder.getClonedMarkers();
    }

    Markers createViewerInputClone() {
        return this.builder.createMarkersClone();
    }

    MarkerField[] getVisibleFields() {
        return this.generator.getVisibleFields();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Object service;
        super.init(site, memento);
        ContentGeneratorDescriptor generatorDescriptor = null;
        if (memento != null) {
            generatorDescriptor = MarkerSupportRegistry.getInstance().getContentGenDescriptor(memento.getString(TAG_GENERATOR));
        }
        if (generatorDescriptor == null && this.defaultGeneratorIds.length > 0 && (generatorDescriptor = MarkerSupportRegistry.getInstance().getContentGenDescriptor(this.defaultGeneratorIds[0])) == null) {
            this.logInvalidGenerator(this.defaultGeneratorIds[0]);
        }
        if (generatorDescriptor == null) {
            generatorDescriptor = MarkerSupportRegistry.getInstance().getDefaultContentGenDescriptor();
        }
        this.builder = new CachedMarkerBuilder(this);
        this.generator = new MarkerContentGenerator(generatorDescriptor, this.builder, this.getViewsEffectiveId());
        this.generator.restoreState(memento);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)site.getService((Class)clazz);
        menuService.populateContributionManager((ContributionManager)site.getActionBars().getMenuManager(), "menu:org.eclipse.ui.ide.MarkersView");
        menuService.populateContributionManager((ContributionManager)site.getActionBars().getToolBarManager(), "toolbar:org.eclipse.ui.ide.MarkersView");
        this.builder.restoreState(memento);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((service = site.getAdapter((Class)clazz2)) != null) {
            this.builder.setProgressService((IWorkbenchSiteProgressService)service);
        }
        this.memento = memento;
        if (memento == null || memento.getString(TAG_PART_NAME) == null) {
            return;
        }
        this.setPartName(memento.getString(TAG_PART_NAME));
    }

    String getViewsEffectiveId() {
        IViewSite site = (IViewSite)this.getSite();
        String viewId = site.getId();
        if (site.getSecondaryId() != null) {
            viewId = String.valueOf(viewId) + site.getSecondaryId();
        }
        return viewId;
    }

    String getViewsPrimaryId() {
        IViewSite site = (IViewSite)this.getSite();
        return site.getId();
    }

    String getViewsSecondaryId() {
        IViewSite site = (IViewSite)this.getSite();
        return site.getSecondaryId();
    }

    void initializeTitle(String name) {
        this.setPartName(name);
    }

    boolean isEnabled(MarkerFieldFilterGroup group) {
        return this.generator.getEnabledFilters().contains(group);
    }

    boolean isPrimarySortField(MarkerField field) {
        return this.builder.getPrimarySortField().equals(field);
    }

    boolean isShowing(MarkerContentGenerator generator) {
        return generator != null ? generator.equals(generator) : false;
    }

    void internalSetGenerator(MarkerContentGenerator generator) {
        this.generator = generator;
    }

    MarkerContentGenerator getGenerator() {
        return this.generator;
    }

    void logInvalidGenerator(String id) {
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.ui.ide", NLS.bind((String)"Invalid markerContentGenerator {0} ", (Object)id)));
    }

    void openFiltersDialog() {
        FiltersConfigurationDialog dialog = new FiltersConfigurationDialog(this.getSite().getWorkbenchWindow().getShell(), this.generator);
        if (dialog.open() == 0) {
            this.generator.updateFilters(dialog.getFilters(), dialog.andFilters());
        }
    }

    void openSelectedMarkers() {
        IMarker[] markers = this.getSelectedMarkers();
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IWorkbenchPage page = this.getSite().getPage();
            ExtendedMarkersView.openMarkerInEditor(marker, page);
            ++i;
        }
    }

    void reexpandCategories() {
        if (!this.getCategoriesToExpand().isEmpty() && this.builder.isShowingHierarchy()) {
            MarkerSupportItem[] items = this.getActiveViewerInputClone().getElements();
            IContentProvider provider = this.viewer.getContentProvider();
            int i = 0;
            while (i < items.length) {
                String name = ((MarkerCategory)items[i]).getName();
                if (this.getCategoriesToExpand().contains(name)) {
                    if (provider instanceof ILazyTreeContentProvider) {
                        ((ILazyTreeContentProvider)provider).updateElement((Object)this.builder.getMarkers(), i);
                        this.viewer.setExpandedState(items[i], true);
                    } else if (!this.viewer.getExpandedState(items[i])) {
                        this.viewer.expandToLevel(items[i], 2);
                    }
                }
                ++i;
            }
        }
    }

    private void registerContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)this.viewer);
        if (!this.getSite().getId().equals("org.eclipse.ui.ide.MarkersView")) {
            this.getSite().registerContextMenu("org.eclipse.ui.ide.MarkersView", contextMenu, (ISelectionProvider)this.viewer);
        }
        Control control = this.viewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
    }

    void removeExpandedCategory(MarkerCategory category) {
        this.getCategoriesToExpand().remove(category.getName());
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(TAG_PART_NAME, this.getPartName());
        if (this.generator != null) {
            memento.putString(TAG_GENERATOR, this.builder.getGenerator().getId());
        }
        if (!this.getCategoriesToExpand().isEmpty()) {
            IMemento expanded = memento.createChild(TAG_EXPANDED);
            Iterator categories = this.getCategoriesToExpand().iterator();
            while (categories.hasNext()) {
                expanded.createChild(TAG_CATEGORY, (String)categories.next());
            }
        }
        IMemento columnEntry = memento.createChild(TAG_COLUMN_WIDTHS);
        MarkerField[] fields = new MarkerField[this.viewer.getTree().getColumnCount()];
        int[] positions = this.viewer.getTree().getColumnOrder();
        int i = 0;
        while (i < fields.length) {
            TreeColumn column = this.viewer.getTree().getColumn(i);
            columnEntry.putInteger(this.getFieldId(column), column.getWidth());
            fields[positions[i]] = (MarkerField)column.getData(MARKER_FIELD);
            ++i;
        }
        if (this.generator != null) {
            this.generator.saveSate(memento, fields);
        }
        this.builder.saveState(memento);
    }

    void selectAll() {
        this.viewer.getTree().selectAll();
    }

    void setCategoryGroup(MarkerGroup group) {
        this.getCategoriesToExpand().clear();
        this.builder.setCategoryGroup(group);
    }

    void setContentGenerator(MarkerContentGenerator generator) {
        this.viewer.setSelection((ISelection)new StructuredSelection());
        this.viewer.removeAndClearAll();
        this.internalSetGenerator(generator);
        this.createColumns(this.viewer.getTree().getColumns());
        this.builder.setGenerator(generator);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void setPrimarySortField(MarkerField field) {
        TreeColumn[] columns = this.viewer.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            if (columns[i].getData(MARKER_FIELD).equals(field)) {
                this.setPrimarySortField(field, treeColumn);
                return;
            }
            ++i;
        }
        StatusManager.getManager().handle(StatusUtil.newStatus(2, "Sorting by non visible field " + field.getName(), null));
    }

    private void setPrimarySortField(MarkerField field, TreeColumn column) {
        this.builder.setPrimarySortField(field);
        IViewSite iViewSite = this.getViewSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)iViewSite.getAdapter((Class)clazz);
        this.builder.refreshContents(service);
        this.updateDirectionIndicator(column, field);
    }

    void setSelection(StructuredSelection structuredSelection, boolean reveal) {
        ArrayList<MarkerItem> newSelection = new ArrayList<MarkerItem>(structuredSelection.size());
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            MarkerItem marker;
            Object next = i.next();
            if (!(next instanceof IMarker) || (marker = this.builder.getMarkers().getMarkerItem((IMarker)next)) == null) continue;
            newSelection.add(marker);
        }
        StructuredSelection structured = new StructuredSelection(newSelection);
        this.viewer.setSelection((ISelection)structured, reveal);
        this.updateStatusLine((IStructuredSelection)structured);
    }

    void toggleFilter(MarkerFieldFilterGroup group) {
        this.generator.toggleFilter(group);
    }

    void toggleSortDirection() {
        this.setPrimarySortField(this.builder.getPrimarySortField());
    }

    void updateDirectionIndicator(TreeColumn column, MarkerField field) {
        this.viewer.getTree().setSortColumn(column);
        if (this.builder.getSortDirection(field) == 1) {
            this.viewer.getTree().setSortDirection(128);
        } else {
            this.viewer.getTree().setSortDirection(1024);
        }
    }

    void updateStatusLine(IStructuredSelection newSelection) {
        String message;
        if (newSelection == null || newSelection.size() == 0) {
            message = "";
        } else if (newSelection.size() == 1) {
            message = ((MarkerSupportItem)newSelection.getFirstElement()).getDescription();
        } else {
            Iterator elements = newSelection.iterator();
            ArrayList<MarkerSupportItem> result = new ArrayList<MarkerSupportItem>();
            while (elements.hasNext()) {
                MarkerSupportItem next = (MarkerSupportItem)elements.next();
                if (!next.isConcrete()) continue;
                result.add(next);
            }
            MarkerEntry[] entries = new MarkerEntry[result.size()];
            result.toArray(entries);
            message = this.getStatusSummary(entries);
        }
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    private String getStatusSummary(MarkerEntry[] entries) {
        Object[] counts = Markers.getMarkerCounts(entries);
        if ((counts = new Integer[]{counts[0], counts[1], new Integer(counts[2] + counts[3])})[0] == 0 && counts[1] == 0) {
            return MessageFormat.format((String)MarkerMessages.marker_statusSelectedCount, (Object[])new Object[]{new Integer(entries.length)});
        }
        return MessageFormat.format((String)MarkerMessages.marker_statusSummarySelected, (Object[])new Object[]{new Integer(entries.length), MessageFormat.format((String)MarkerMessages.errorsAndWarningsSummaryBreakdown, (Object[])counts)});
    }

    void updateTitle() {
        this.setContentDescription(this.getStatusMessage());
    }

    private void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                ExtendedMarkersView.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        this.viewer.addDragSupport(operations, transferTypes, (DragSourceListener)listener);
    }

    private void performDragSetData(DragSourceEvent event) {
        IMarker[] markers;
        if (MarkerTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSelectedMarkers();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType) && (markers = this.getSelectedMarkers()) != null) {
            event.data = MarkerCopyHandler.createMarkerReport(this, markers);
        }
    }

    Object[] getHiddenFields() {
        return this.generator.getHiddenFields();
    }

    void setVisibleFields(Collection visible) {
        this.generator.setVisibleFields(visible);
        this.createColumns(this.viewer.getTree().getColumns());
        this.scheduleUpdate(0L);
    }

    TreeViewer getViewer() {
        return this.viewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelQueuedUpdates() {
        Object object = this.builder.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            if (this.uiUpdateJob != null) {
                this.uiUpdateJob.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UIUpdateJob scheduleUpdate(long delay) {
        Object object = this.builder.getUpdateScheduler().getSchedulingLock();
        synchronized (object) {
            IWorkbenchSiteProgressService progressService;
            if (this.uiUpdateJob == null) {
                this.uiUpdateJob = new UIUpdateJob(this);
                this.uiUpdateJob.setSystem(true);
            }
            if ((progressService = this.builder.getProgressService()) != null) {
                progressService.schedule((Job)this.uiUpdateJob, delay);
            } else {
                this.uiUpdateJob.schedule(delay);
            }
            return this.uiUpdateJob;
        }
    }

    long getLastUIRefreshTime() {
        if (this.uiUpdateJob != null) {
            return this.uiUpdateJob.getLastUpdateTime();
        }
        return -1L;
    }

    boolean isUIUpdating() {
        return this.uiUpdateJob != null ? this.uiUpdateJob.isUpdating() : false;
    }

    static String newSecondaryID(IViewPart part) {
        while (part.getSite().getPage().findViewReference(part.getSite().getId(), String.valueOf(instanceCount)) != null) {
            ++instanceCount;
        }
        return String.valueOf(instanceCount);
    }

    public static void openMarkerInEditor(IMarker marker, IWorkbenchPage page) {
        IEditorInput input;
        IFile file;
        IEditorPart editor = page.getActiveEditor();
        if (editor != null && (file = ResourceUtil.getFile(input = editor.getEditorInput())) != null && marker.getResource().equals((Object)file) && OpenStrategy.activateOnOpen()) {
            page.activate((IWorkbenchPart)editor);
        }
        if (marker != null && marker.getResource() instanceof IFile) {
            try {
                IDE.openEditor(page, marker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                IStatus status = e.getStatus();
                if (status != null && status.getException() instanceof CoreException) {
                    status = ((CoreException)status.getException()).getStatus();
                }
                if (status == null) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(4, e.getMessage(), (Throwable)e), 2);
                }
                StatusManager.getManager().handle(status, 2);
            }
        }
    }

    private class ViewerPageSelectionListener
    implements ISelectionListener {
        private ExtendedMarkersView view;

        ViewerPageSelectionListener(ExtendedMarkersView view) {
            this.view = view;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == ExtendedMarkersView.this || !ExtendedMarkersView.this.getSite().getPage().isPartVisible(part)) {
                return;
            }
            ArrayList<Object> objectsToAdapt = new ArrayList<Object>();
            if (part instanceof IEditorPart) {
                IEditorPart editor = (IEditorPart)part;
                objectsToAdapt.add(editor.getEditorInput());
            } else if (selection instanceof IStructuredSelection) {
                Iterator iterator = ((IStructuredSelection)selection).iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    objectsToAdapt.add(object);
                }
            }
            ArrayList<Object> selectedElements = new ArrayList<Object>();
            Iterator iterator = objectsToAdapt.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                Object resElement = MarkerResourceUtil.adapt2ResourceElement(object);
                if (resElement == null) continue;
                selectedElements.add(resElement);
            }
            MarkerContentGenerator generator = this.view.getGenerator();
            generator.updateSelectedResource(selectedElements.toArray());
        }
    }
}

