function [ dconc ] = subtractFprior(towerObs, Phi64Lower48, priorWeights, ...
                                 Hmatrices, nTowers, nPeriods)
%subtractFprior Calculate the tower observations  that cannot be estimated
%from fprior
%   [ dconc ] = subtractFprior(towerObs, Phi64Lower48, priorWeights, ...
%                           Hmatrices, nPeriods)
% Calculates the observations [co2], ppmv, that cannot be explained by
% prior fluxes.
%
% INPUTS:
%  towerObs   : a cell array containing the observations at each tower.
%               There are nTower cells; each cell has a column vector that
%               is nPeriods * nObsPerPeriod long.
%  Phi64Lower48 : a matrix, that is ncellsLower48 X nwavelets in shape
%  priorWeights : a vector nwavelets x 1 in size
%  Hmatrices    : cell array, nTower long. Each cell contains a matrix 
%                 (nObsPerPeriod*nPeriod) x (ncellsLower48*nPeriods) in
%                 shape.
%  nTowers, nPeriods : How many towers, how many 8-day periods
%
% OUTPUT :
%   dconc    : A cell array, nTowers long. Each cell contains a (nPeriods *
%              nObsPerPeriod) column vector containing the concentration at
%              towers that cannot be explained by the prior emissions.
%
% Jaideep Ray, 1/12/13
% -------------------------------------------------------------------------

% ---- Create an empty cell array exactly as long as towerObs
dconc = cell(size(towerObs)) ;
assert(length(dconc) == nTowers) ;

% ---- Create the fprior and the repmat it to cover the nPeriods
fprior = Phi64Lower48 * priorWeights ;
F      = repmat(fprior, nPeriods, 1) ;

% ---- Loop over all the towers
for itower = 1 : length(dconc)
   % ---- calc conc at towers due to F and subtract from known observations
   yprior = Hmatrices{itower} * F ;
   dconc{itower} = towerObs{itower} - yprior ;
end
end

