function [ fl48, latlon48, fcl48, latloncl48 ] = ...
                                   splitBasisSet( Phi64, latlon, Hlatlon )
%splitBasisSet Function to split bases on a 64^2 dyadic grid into a part
%that models Lower48 emissions and another part that models it in the
%complement (canada, mexico and the oceans).
%   [ fl48, latlon48, fcl48, latloncl48 ] = ...
%                                   splitBasisSet( Phi64, latlon, Hlatlon )
%  Function to split the basis set on 64x64 mesh into a part that models
%  emissions on Lower48 states and a part that models it elsewhere. 
% 
% INPUTS :
%
%   Phi64 : Basis set on 64x64 mesh. Is a 4096 x 1054 matrix, such that
%           emissions = Phi64 * wavelet_coeffs
%   latlon : [lat, lon] of the cell-centers where emissions are predicted
%   Hlatlon : [lat, lon] of the cell-centers of the grid-boxes inside
%             Lower48.
%
% OUTPUTS:
%
%   fl48       = Phi64 for the lower 38 states. A 816 x 1054 matrix
%   latlon48   = [lat, lon] of the cell-centers of gridboxes where fl48
%                models emissions. identical to Hlatlon
%   fcl48      = Phi64 - fl48 (set subtraction)
%   latloncl48 = latlon - Hlatlon (set subtraction)
%
% Jaideep Ray, 5/30/2012
% -------------------------------------------------------------------------

% ---- Get the emission in the lower 48 states. Also, the indices, such
% that fl49 = Phi64(ind, :) ;
[fl48, latlon48, ind] = getFieldInLower48( Phi64, latlon, Hlatlon ) ;

% ---- Identify the rows from Phi64 that did not make it into fl48
indcl48 = setdiff(1 : size(Phi64, 1), ind) ;

% ---- Now, pull out the rows in Phi64 that are not in ind
fcl48 = Phi64(indcl48, :) ;
latloncl48 = latlon(indcl48, :);
end

