function res = saveWaveletCoeffsToDisk(trueVal, usefulSol, oDir, periods, ...
                                       prob) 
%writeWaveletCoeffsToDisk Save true and reconstructed wavelet coeffs to
%disk
%   This function writes true and reconstructed wavelt coeffs to disk, in a
%   file called coeffsTrue_Px-Py.dat and coeffsRecons_Px-Py.dat, where x and y are
%   the start and end of the duration of reconstruction (kept in periods
%   vector)
%
%   The data stored are periods (down a file) and coeffs (across the file)
%   The coeff names are written too. Use hdrload to read the file.
% 
%   INPUTS:
%   trueVal   : long vector of wavelet coeffs ncoeffsPerPeriod x nPeriods long 
%   usefulSol: ditto. no buffer periods are contained
%   oDir     : which dir do we dump our files
%   periods  : start and end periods
%   prob     : info about our problem
%
%  Jaideep Ray
%  ------------------------------------------------------------------------

nPers = prob.info.nPeriods - 2*prob.info.buffer ;
ncoeffPerPeriod = size(prob.Phi, 2) ;

% reshape the true and reconstructed values so that coeffs belonging to a
% give period are in the same column
trueVal   = reshape(trueVal  , ncoeffPerPeriod, nPers) ;
usefulSol = reshape(usefulSol, ncoeffPerPeriod, nPers) ;

% transpose them so that separate periods are separate rows
trueVal   = transpose(trueVal) ;
usefulSol = transpose(usefulSol) ;
periodList = periods(1) :  periods(2);

% dummy array
d = zeros(size(trueVal, 1), size(trueVal, 2)+1) ;
d(:, 1) = periodList ;
d(:, 2:end) = trueVal ;

%% Create the true-values-of-wavelet-coeffs-file. Name it, open it, write in header
str = sprintf('/coeffsTrue_P%02d-P%02d.dat', periods(1), periods(2)) ;
filename = [oDir '/' str] ;

% Open the file, write out header
fid = fopen(filename, 'w');
fprintf(fid, '# Period  Coeffs -->\n') ;
fclose(fid) ;

% Write out observations
save(filename, 'd', '-ascii', '-append') ;

%% Create the reconstructed-values-of-wavelet-coeffs file. Name it, open it, write in header

d(:, 2:end) = usefulSol;
str = sprintf('/coeffsRecons_P%02d-P%02d.dat', periods(1), periods(2)) ;
filename = [oDir '/' str] ;

% Open the file, write out header
fid = fopen(filename, 'w');
fprintf(fid, '# Period  Coeffs -->\n') ;
fclose(fid) ;

% Write out observations
save(filename, 'd', '-ascii', '-append') ;

%% all ok
res = 0 ;

end

