function [answer] = outputEmissionsToFile(emissionsLower48, ...
                                       emissionsPreds, latlonLower48, ...
                                       oDir)
%outputEmissionsToFile Dump time-variant emissions to file (true and
%estimated)
%   answer = outputEmissionsToFile(emissionsLower48, ...
%                                  emissionsPreds, latlonLower48, oDir)
%   writes emissions to file, to be used for further analyses.
%
% INPUTS :
%    emissionsLower48 : ncellsLower48 x nPeriods matrix of true emissions
%    emissionsPreds   : ncellsLower48 x nPeriods matrix of est. emissions
%    latlonLower48    : ncellsLower48 x 2 matrix of [lat, lon] of US
%                       gridcells
%    odir             : which dir to dump the data
%
% OUTPUTS
%   answer            : names of the files where we dumped the data
%
% Jaideep Ray, 6/28/2012
%
% -------------------------------------------------------------------------

% ---- Output files
answer{1} = 'EmissionsTrue.dat' ;
answer{2} = 'EmissionsEst.dat' ;

% ---- Loop over the datasets that have to be dumped 
for i = 1 : length(answer)
    
    % ---- Make the output file name 
    ofname = [ oDir '/', answer{i} ] ; fprintf('Saving file %s\n', ofname) ;
    
    % ---- Open file and write header
    fid = fopen(ofname, 'w') ;
    fprintf(fid, '## Lat  Lon  Emissions per 8-day week (%d weeks worth)\n', ...
            size(emissionsLower48, 2)) ;
    fclose(fid) ;
    
    % ---- Make the dataset that has to be dumped
    if ( i == 1 ) 
        tmp = [latlonLower48(:, 1), latlonLower48(:, 2), emissionsLower48(:, :)] ;
    end
    
    if ( i == 2 )
        tmp = [latlonLower48(:, 1), latlonLower48(:, 2), emissionsPreds(:, :)] ;
    end
    
    % ---- Save the file
    save(ofname, 'tmp', '-ascii', '-append');
end

end

