function [ towerPreds, emissionsPreds ] = getReconstruction(sol, prob)
%getReconstruction Reconstruct tower concentrations and emissions using
%solution
%   [ towerPreds, emissionsPreds ] = getReconstruction(usefulSol, prob)
%   reconstructs the tower measurements and emissions, given the solution
%
%  INPUTS :
%   sol : vector, ncoeffsPerPeriod * nPeriods in size, which is the
%   final solution.
%   prob : struct with H, Phi, G matrices, and the info struct
%
%  OUTPUTS
%  towerPreds : cell array, nTowers long. Each cell has an array
%               nObsPerPeriod * nPeriods long, with CO2 concentrations.
%  emissionPreds : 2D array nUSCells x nPeriod in size, with reconstructed
%                  emissions
%
%  Jaideep Ray, 3/22/2012
%--------------------------------------------------------------------------

%% Some params
ncoeffs = size(prob.Phi, 2) ;
nPeriods = prob.info.nPeriods ;
emissionsPreds = zeros(prob.info.nUSCells, nPeriods);


%% Reconstruct tower observations
for i = 1 : nPeriods 
    iend = i * ncoeffs ;
    coeffs = sol(iend - ncoeffs + 1 : iend) ;
    emissionsPreds(:, i) = prob.Phi * coeffs ;
end

%% Reconstruct the tower concentration measurements
for i = 1 : prob.info.nTowers
    towerPreds{i} = prob.H{i} * emissionsPreds(:) ;
end

