function [ R ] = genRandomMatrixForCompSampling(nrows, ncols)
%genRandomMatrixForCompSampling Generate a random matrix that can be used
%for randomly sampling a vector
%   [ R ] = genRandomMatrixForCompSampling(nrows, ncols) calculates a
%   random matrix that can be used for sampling a vector i.e. y = Rx gives
%   me compressive samples of x. Each row of the R matrix should have norm
%   = 1.
%   
% Jaideep Ray, 5/30/2012 
% =========================================================================

% ---- The way we'll make the random matrix is this. we'll make each row of
% the matrix the coordinates of a random point chosen at the surface of a
% ncol-dim unit sphere. We will up a random matrix and normalize each row
% to be magnitude = 1.
R = randn(nrows, ncols) ; % random numbers

% -- figure out magnitudes of each row
mag = sum( R .* R, 2) ;
denom = 1 ./ sqrt(mag) ;  % denom = 1/sqrt(mag)
scale = diag(denom) ;
R = scale * R ;  % R normalized with unit vectors
end

