function [emissionsTrue2D, emissionsRecons2D] = convertTo2DArray(emissions, ...
                               elatlon, emissionsPreds, topcorner, ...
                               botcorner, prob)                            
%convertTo2DArray Convert 1D array of emissions over multiple Periods into
%2D arrays that can be plotted using imagesc.
%   
%  INPUTS
%   emissions : is a 1D array, nUSCells*nPeriods long
%   elatlon   : is a nUSCells x 2 matrix with lat/lon of US cells
%   emissionPreds : nUSCells x nPeriods matrix of reconstructed emissions
%   topcorner, botcorner : lat/lon of NW and SE corner for output
%   prob :  the problem data struct to get some params
%
%  OUTPUTS :
%  emissions[True, Recons]2D : a 3D array, 29 x 64 x nPeriods in size
%
% Jaideep Ray, 3/22/2012
% -------------------------------------------------------------------------

nPeriods = size(emissionsPreds, 2) ;
nRows  = topcorner(1) - botcorner(1) + 1 ;
nCols  = botcorner(2) - topcorner(2) + 1 ;

emissionsTrue2D   = zeros(nRows, nCols, nPeriods) ;
emissionsRecons2D = zeros(nRows, nCols, nPeriods) ;

origin = [botcorner(1), topcorner(2)];
indices(:, 1) = elatlon(:, 1) - origin(1) + 1 ; % indices run from 1, not zero
indices(:, 2) = elatlon(:, 2) - origin(2) + 1 ;
for i = 1 : nPeriods
    iend = i * prob.info.nUSCells ;
    indx = sub2ind( size(emissionsTrue2D), indices(:, 1), indices(:, 2), ...
                    i*ones(prob.info.nUSCells, 1)) ;
    tmp  = emissions(iend - prob.info.nUSCells + 1: iend) ;
    emissionsTrue2D(indx) = tmp ;
    tmp  = emissionsPreds(iend - prob.info.nUSCells + 1: iend) ;
    emissionsRecons2D(indx) = tmp ;
end

