function [Gtowers, GCS] = computeAugmentedGainMatrices(Hmatrices, ...
                                      Phi64Lower48, R, Phi64Clower48, info) 
%computeAugmentedGainMatrices() Computes the gain matrix for towers and
%compressive sampling
%   Gtowers, GCS] = computeAugmentedGainMatrices(Hmatrices, ...
%                                      Phi64Lower48, R, Phi64Clower48, info) 
%  Computes the gain matrices for all towers and compressive sampled
%  emissions. A gain matrix is such that y^(I) = G^(I) w, where y^(I) is a
%  vector containing the [CO2] concentrations measured at tower I over a
%  whole year, G^(I) = H^(I) * Phi64Lower48 is the gain matrix for tower I
%  and w are wavelet weights. For the "fake" tower, which is really a
%  compressive sampling of emissions overs canada, mexico and oceans,
%  G^(II) = R * Phi64Clower48 and 0 = R * Phi64Clower48 * w.
%
%  INPUTS :
%   Hmatrices : cell array, 35 long, for the H matrices for 35 towers
%   Phi64Lower48 : 816 x 1054 martrix, mapping wavelet coeffs to emissions
%   in lower48 states
%   R         : random matrix to act as H matrix to samples emissions
%               outside lower48 states
%   Phi64Clower48 : bases vector for gridcells outside lower48 states
%   info : struct with some info about # of cells inside US, # of
%                 observations per periods etc
%
% Jaideep Ray, 5/30/2012
% =========================================================================

% Compute the gain matrix for the towers
prob.H    = Hmatrices ;
prob.Phi  = Phi64Lower48 ;
prob.info = info ;
Gtowers = computeGain(prob) ;

% Compute the gain matrix for 1 period
tmp = R * Phi64Clower48 ;

% Replicate it for nperiods
nperiods = size(Hmatrices{1}, 2) / info.nUSCells ;
GCS     = repmat(tmp, 1, nperiods) ;
GCS = sparse(GCS) ;
end

