#ifndef graphDBHSeen
#define graphDBHSeen

/**
   This is a header for a class that stores graphs, expressed in
   Ali's compressed notation in ascr-graph/src/EdgeFlip/graph.h

   Jaideep Ray

   7/25/2011
*/

#include <string>
#include <vector>
#include "graph.h"

class graphDB
{
  public :

  /* Constructor */
  graphDB() ;

  /* Destructor */
  virtual ~graphDB() ;


  /**
     Make a copy of the graph supplied and store it
     @param pG pointer to the graph to be store in DB
     @return 0 if all OK ; -ve  number if not
  */
  int insertGraph(struct graph *pG) ;

  /**
     Return how many graphs are in the DB
     @return number of graphs in DB
  */
  int getNumGraphsInDB() ;

  /**
     Get a particular graph by index. This index  should be < = the
     number of graphs in the DB

     @param i, the realization you want
     @return p pointer to the graph in question. Do NOT delete the
     graph; we are not returning a copy. This is a reference to the 
     database entry.
  */
  struct graph * extractGraph(int i) ;

  /**
     Make a copy of the graph, specified by index
     
     @param i, the realization you want
     @return p pointer to the graph in question. This is a copy and
     the caller is in charge of destroying the memeory
  */
  struct graph * extractCopyOfGraph(int i) ;

  /**
     Write all the graphs in the DB in a file as edge-lists
     
     @param Stub of the filename e.g. 'dolphin' will create
     dolphin.0001, dolphin.0002, ...... files, each with 1 graph in
     it.
     @return 0, if we could open the file, -ve if not
  */
  int writeGraphsToFiles(std::string filename) ;

  /**
     Copy a thinned version of the database into a separate
     database.
     @param  ndb, an  empty database that'll be filled up with a 
                  thinned version of this database.
     @param  thin_factor, an integer, that'll be used for thinning. We'll pick
             every "thin" instance of the stored graphs.
     @return 0 if OK, -1 if thin is less than the number of graphs in the database
  */
  int createThinnedVersionOfDatabase(graphDB &ndb, int thin_factor) ;

  /**
     Clear the database and get ready to store a completely new dataset
  */
  void clear() ;

 private :

  std::vector< struct graph * > allGraphs_ ;
} ;
#endif
