#include "mcconv.h"
/*
  thin                                       
                                                                      
  This subroutine takes the integer-valued vector series of length    
  iteracnt and outputs elements 1,1+kthin,1+2kthin,1+3kthin,... in    
  the result vector.                                                  
                                                                      
  Inputs:                                                             
                                                                      
    series   = an integer vector containing the sequence of numbers   
               from which this subroutine is to select every kthin'th 
               number to be copied to the output vector, starting     
               with the first number.  There are iteracnt elements in 
               this vector.                                           
                                                                      
    iteracnt = an integer containing the number of elements in the    
               input vector of numbers to be thinned, series.  If     
               kthin can be as little as 1, the output result vector  
               must also contain iteracnt elements.                   
                                                                      
    kthin    = an integer specifying the interval between elements of 
               the input data vector, series, which are to be copied  
               to the output vector, result.  If kthin is 1, then all 
               of series is to be copied to result.  If kthin is 2,   
               then only every other element of series is to be       
               copied to result.  If kthin is 3, then every third     
               element is copied and so forth.                        
                            
  Outputs:                                                            
                                                                      
    result   = an integer vector containing the thinned subset of the 
               input data vector, series, starting with the first     
               element and copying every kthin'th from there on.  The 
               number of meaningful elements in this vector will be   
               returned as thincnt.                                   
                                                                      
    thincnt  = an integer containing the number of elements actually  
               copied to the result vector.                           
                                                                      
*/
void thin(int *series,int n,int kthin,int *result,int *thincnt)
{
  int from, i1 ;

  (*thincnt) = 0 ;
  for ( i1 = 0; i1 < n; i1++ )
  {
    from = i1 * kthin ;
    if (from > n-1 ) break ;
    result[i1] = series[from] ;
    (*thincnt)++;
  }

  return ;

}
