#include "mcconv.h"
void ssort(double *x, double *y,int n,int kflag)
{
  /* sort function in C adapted from the original fortran version */
  /*
     abstract
         ssort sorts array x and optionally makes the same
         interchanges in array y.  the array x may be sorted in
         increasing order or decreasing order.  a slightly modified
         quicksort algorithm is used.

     reference
         singleton,r.c., algorithm 347, an efficient algorithm for
         sorting with minimal storage, cacm,12(3),1969,185-7.

     description of parameters
         x - array of values to be sorted (usually abscissas)
         y - array to be (optionally) carried along
         n - number of values in array x to be sorted
         kflag - control parameter
             =2  means sort x in increasing order and carry y along.
             =1  means sort x in increasing order (ignoring y)
             =-1 means sort x in decreasing order (ignoring y)
             =-2 means sort x in decreasing order and carry y along.

         singleton,r.c., algorithm 347, an efficient algorithm for
         sorting with minimal storage, cacm,12(3),1969,185-7.
*/
  int i, ij, il[21], iu[21], j, k, kk, l, m, nn ;
  double r, t, tt, tty, ty ;

  nn = n ;
  kk = abs(kflag) ;

  /* alter array x to get decreasing order if needed */
  if ( kflag < 1 )
    for ( i=0; i<nn; i++ ) x[i] = -x[i] ;
 
  if ( kk == 1 )
  {
    /* sort x only */
    m = 0     ; 
    i = 0     ;
    j = nn-1  ;
    r = 0.375 ;
  l110: 
    if ( i == j ) goto l155;
    if ( r <= 0.5898437 ) 
      r = r+3.90625e-2 ;
    else
      r = r-0.21875 ;
  l125:
    k = i ;
    /* 
       select a central element of the
       array and save it in location t 
    */
    ij = i + (int) ( ((double) (j-i)) * r ) ;
    t = x[ij] ;
    /*
       if first element of array is greater
       than t, interchange with t
    */
    if ( x[i] > t )
    {
      x[ij] = x[i ] ;
      x[i ] = t     ;
      t     = x[ij] ;
    }
    l = j ;
    /*
       if last element of array is less than
       t, interchange with t
    */
    if (x[j] >= t) goto l140 ;
    x[ij] = x[j ] ;
    x[j ] = t     ;
    t     = x[ij] ;
    /*
      if first element of array is greater
      than t, interchange with t
    */
    if ( x[i] <= t ) goto l140 ;
    x[ij] = x[i ] ;
    x[i ] = t     ;
    t     = x[ij] ;
    goto l140 ;
  l135: 
    tt   = x[l] ;
    x[l] = x[k] ;
    x[k] = tt   ;
    /*
      find an element in the second half of
      the array which is smaller than t
    */
  l140: 
    l-- ;
    if (x[l] > t) goto l140;
    /*
      find an element in the first half of
      the array which is greater than t
    */
  l145: 
    k++ ;
    if ( x[k] < t ) goto l145 ;
    /* interchange these elements */
    if ( k <= l ) goto l135 ;
    /*
      save upper and lower subscripts of
      the array yet to be sorted
    */
    if ( l-i <= j-k ) goto l150 ;
    il[m] = i ; 
    iu[m] = l ;
    i = k ;
    m++ ;
    goto l160 ;
  l150:
    il[m] = k ;
    iu[m] = j ;
    j = l ;
    m++ ;
    goto l160 ;
    /*
       begin again on another portion of
       the unsorted array
    */
  l155:
    m-- ;
    if (m < 0) goto l300 ;
    i = il[m] ;
    j = iu[m] ;
  l160:
    if (j-i >= 1) goto l125 ;
    if (i   == 0) goto l110 ;
    i-- ;
  l165:
    i++ ;
    if (i == j) goto l155 ;
    t = x[i+1] ;
    if (x[i] <= t) goto l165 ;
    k = i ;
  l170:
    x[k+1] = x[k] ;
    k-- ;
    if (t < x[k]) goto l170 ;
    x[k+1] = t ;
    goto l165 ;
  }
  else
  {
    /* sort x and carry y along */
    m = 0     ;
    i = 0     ;
    j = nn-1  ;
    r = 0.375 ;
  l210:
    if (i == j) goto l255 ;
    if (r <= 0.5898437) 
      r = r+3.90625e-2 ;
    else
      r = r-0.21875 ;
  l225:
    k = i ;
    /*
       select a central element of the
       array and save it in location t
    */
    ij = i + (int) ( ((double)(j-i)) * r ) ;
    t = x[ij] ;
    ty = y[ij] ;
    /*
      if first element of array is greater
      than t, interchange with t
    */
    if (x[i] > t) 
    {
      x[ij] = x[i ] ;
      x[i ] = t     ;
      t     = x[ij] ;
      y[ij] = y[i ] ;
      y[i ] = ty    ;
      ty    = y[ij] ;
    }
    l = j ;
    /*
      if last element of array is less than
      t, interchange with t
    */
    if (x[j] >= t) goto l240 ;
    x[ij] = x[j ] ;
    x[j ] = t     ;
    t     = x[ij] ;
    y[ij] = y[j ] ;
    y[j ] = ty    ;
    ty    = y[ij] ;
    /*
      if first element of array is greater
      than t, interchange with t
    */
    if (x[i] <= t) goto l240 ;
    x[ij] = x[i ] ;
    x[i ] = t     ;
    t     = x[ij] ;
    y[ij] = y[i ] ;
    y[i ] = ty    ;
    ty    = y[ij] ;
    goto l240 ;
  l235: 
    tt   = x[l] ;
    x[l] = x[k] ;
    x[k] = tt   ;
    tty  = y[l] ;
    y[l] = y[k] ;
    y[k] = tty  ;
    /*
       find an element in the second half of
       the array which is smaller than t
    */
  l240:
    l -= 1 ;
    if (x[l] > t) goto l240 ;
    /*
       find an element in the first half of
       the array which is greater than t
    */
  l245:
    k++ ;
    if (x[k] < t) goto l245 ;
    /* interchange these elements */
    if (k <= l) goto l235 ;
    /*
       save upper and lower subscripts of
       the array yet to be sorted
    */
    if (l-i <= j-k) goto l250 ;
    il[m] = i ;
    iu[m] = l ;
    i = k ;
    m += 1 ;
    goto l260 ;
  l250: 
    il[m] = k ;
    iu[m] = j ;
    j = l ;
    m++ ;
    goto l260 ;
    /*
       begin again on another portion of
       the unsorted array
    */
  l255:
    m--; 
    if (m < 0) goto l300 ;
    i = il[m] ;
    j = iu[m] ; 
  l260:
    if (j-i >= 1) goto l225 ;
    if (i == 0) goto l210 ;
    i-- ;
  l265:
    i++;
    if (i == j) goto l255 ;
    t = x[i+1] ;
    ty = y[i+1] ;
    if (x[i] <= t) goto l265 ;
    k = i ;
  l270:
    x[k+1] = x[k] ;
    y[k+1] = y[k] ;
    k-- ;
    if (t < x[k]) goto l270 ;
    x[k+1] = t ;
    y[k+1] = ty ;
    goto l265 ;
  }

  /* clean up */
 l300:
  if (kflag < 1) 
    for ( i=0; i<nn; i++ ) x[i] = -x[i] ;

  return ;

}

