#include "mcconv.h"
double ppnd7( double p, int *ifault)
{
  /*
    algorithm as241 appl. statist. (1988) vol. 37, no. 3, 477-
    484.

    produces the normal deviate z corresponding to a given lower
    tail area of p; z is accurate to about 1 part in 10**7.

    the hash sums below are the sums of the mantissas of the
    coefficients.   they are included for use in checking
    transcription.
  */
  double zero, one, half, split1, split2, const1, const2, a0, a1,
         a2, a3, b1, b2, b3, c0, c1, c2, c3, d1, d2, e0, e1, e2,
    e3, f1, f2, q, r, ppnd7tmp ;

  zero = 0.0 ;
  one  = 1.0 ;
  half = 0.5 ;
  split1 = 0.425 ;
  split2 = 5.0   ;
  const1 = 0.180625 ;
  const2 = 1.6 ;

  /* coefficients for p close to 0.5 */
  a0 = 3.3871327179e+00 ;
  a1 = 5.0434271938e+01 ;
  a2 = 1.5929113202e+02 ;
  a3 = 5.9109374720e+01 ;
  b1 = 1.7895169469e+01 ; 
  b2 = 7.8757757664e+01 ;
  b3 = 6.7187563600e+01 ;
  /* hash sum ab 32.3184577772 */

  /* coefficients for p not close to 0, 0.5 or 1. */
  c0 = 1.4234372777e+00 ; 
  c1 = 2.7568153900e+00 ;
  c2 = 1.3067284816e+00 ;
  c3 = 1.7023821103e-01 ;
  d1 = 7.3700164250e-01 ; 
  d2 = 1.2021132975e-01 ;
  /* hash sum cd    15.76149 29821 */

  /* coefficients for p near 0 or 1. */
  e0 = 6.6579051150e+00 ;
  e1 = 3.0812263860e+00 ;
  e2 = 4.2868294337e-01 ; 
  e3 = 1.7337203997e-02 ;
  f1 = 2.4197894225e-01 ;
  f2 = 1.2258202635e-02 ;
  /* hash sum ef    19.40529 10204 */

  (*ifault) = 0 ;
  q = p - half ;
  if ( fabs( q ) <= split1 ) 
  {
    r = const1 - q * q ;
    ppnd7tmp = q * (((a3 * r + a2) * r + a1) * r + a0) /
              (((b3 * r + b2) * r + b1) * r + one) ;
    return ( ppnd7tmp ) ;
  }
  else
  {
    if ( q < zero) 
      r = p ;
    else
      r = one - p ;

    if ( r <= zero ) 
    {
      (*ifault) = 1 ;
      return ( zero ) ;
    }
    r = sqrt(-log(r)) ;
    if (r <= split2) 
    {
      r = r - const2 ;
      ppnd7tmp = (((c3 * r + c2) * r + c1) * r + c0) /
	((d2 * r + d1) * r + one) ;
    }
    else
    {
      r = r - split2 ;
      ppnd7tmp = (((e3 * r + e2) * r + e1) * r + e0) /
	((f2 * r + f1) * r + one) ;
    }
    if (q < zero) ppnd7tmp = - ppnd7tmp ;
    return (ppnd7tmp) ;
  }

}

double ppnd16(double p, int *ifault)
{
  /*

	algorithm as241  appl. statist. (1988) vol. 37, no. 3

	produces the normal deviate z corresponding to a given lower
	tail area of p; z is accurate to about 1 part in 10**16.

	the hash sums below are the sums of the mantissas of the
	coefficients.   they are included for use in checking
	transcription.

  */
  double  zero, one, half, split1, split2, const1,
          const2, a0, a1,a2, a3, a4, a5, a6, a7, b1, b2, b3,
          b4, b5, b6, b7,c0, c1, c2, c3, c4, c5, c6, c7, d1, d2, d3, d4, d5,
          d6, d7, e0, e1, e2, e3, e4, e5, e6, e7, f1, f2, f3,
    f4, f5, f6, f7, q, r, ppnd16tmp ;
  zero = 0.0 ;
  one  = 1.0 ;
  half = 0.5 ;
  split1 = 0.425 ;
  split2 = 5.0 ;
  const1 = 0.180625 ;
  const2 = 1.6 ;

  /* coefficients for p close to 0.5 */
  a0 = 3.3871328727963666080    ;
  a1 = 1.3314166789178437745e+2 ;
  a2 = 1.9715909503065514427e+3 ;
  a3 = 1.3731693765509461125e+4 ;
  a4 = 4.5921953931549871457e+4 ;
  a5 = 6.7265770927008700853e+4 ;
  a6 = 3.3430575583588128105e+4 ;
  a7 = 2.5090809287301226727e+3 ;
  b1 = 4.2313330701600911252e+1 ;
  b2 = 6.8718700749205790830e+2 ;
  b3 = 5.3941960214247511077e+3 ;
  b4 = 2.1213794301586595867e+4 ;
  b5 = 3.9307895800092710610e+4 ;
  b6 = 2.8729085735721942674e+4 ;
  b7 = 5.2264952788528545610e+3 ;
  /* hash sum ab    55.88319 28806 14901 4439 */

  /* coefficients for p not close to 0, 0.5 or 1. */
  c0 = 1.42343711074968357734e0 ;
  c1 = 4.63033784615654529590e0 ;
  c2 = 5.76949722146069140550e0 ;
  c3 = 3.64784832476320460504e0 ;
  c4 = 1.27045825245236838258e0 ;
  c5 = 2.41780725177450611770e-1 ;
  c6 = 2.27238449892691845833e-2 ;
  c7 = 7.74545014278341407640e-4 ;
  d1 = 2.05319162663775882187e0 ;
  d2 = 1.67638483018380384940e0 ;
  d3 = 6.89767334985100004550e-1 ;
  d4 = 1.48103976427480074590e-1 ;
  d5 = 1.51986665636164571966e-2 ;
  d6 = 5.47593808499534494600e-4 ;
  d7 = 1.05075007164441684324e-9 ;
  /* hash sum cd    49.33206 50330 16102 89036 */

  /* coefficients for p near 0 or 1. */
  e0 = 6.65790464350110377720e0 ;
  e1 = 5.46378491116411436990e0 ;
  e2 = 1.78482653991729133580e0 ;
  e3 = 2.96560571828504891230e-1 ;
  e4 = 2.65321895265761230930e-2 ;
  e5 = 1.24266094738807843860e-3 ;
  e6 = 2.71155556874348757815e-5 ;
  e7 = 2.01033439929228813265e-7 ;
  f1 = 5.99832206555887937690e-1 ;
  f2 = 1.36929880922735805310e-1 ;
  f3 = 1.48753612908506148525e-2 ;
  f4 = 7.86869131145613259100e-4 ;
  f5 = 1.84631831751005468180e-5 ;
  f6 = 1.42151175831644588870e-7 ;
  f7 = 2.04426310338993978564e-15 ;
  /* hash sum ef    47.52583 31754 92896 71629 */

  (*ifault) = 0 ;
  q = p - half ;
  if (fabs(q) <= split1) {
    r = const1 - q * q ;
    ppnd16tmp = q * (((((((a7 * r + a6) * r + a5) * r + a4) * r + a3)
			* r + a2) * r + a1) * r + a0) /
       (((((((b7 * r + b6) * r + b5) * r + b4) * r + b3)
	  * r + b2) * r + b1) * r + one) ;
     return (ppnd16tmp) ;
  }
  else
  {
    if (q < zero)
      r = p ;
    else
      r = one - p ;
    if (r <= zero) 
    {
      (*ifault) = 1 ;
      ppnd16tmp = zero ;
      return (ppnd16tmp);
    }
    r = sqrt(-log(r)) ;
    if (r <= split2)
    {
      r = r - const2 ;
      ppnd16tmp = (((((((c7 * r + c6) * r + c5) * r + c4) * r + c3)
		     * r + c2) * r + c1) * r + c0) /
	(((((((d7 * r + d6) * r + d5) * r + d4) * r + d3)
	   * r + d2) * r + d1) * r + one) ;
    }
    else
    {
      r = r - split2 ;
      ppnd16tmp = (((((((e7 * r + e6) * r + e5) * r + e4) * r + e3)
		     * r + e2) * r + e1) * r + e0) /
	(((((((f7 * r + f6) * r + f5) * r + f4) * r + f3)
	   * r + f2) * r + f1) * r + one) ;
    }
    if (q < zero) ppnd16tmp = - ppnd16tmp;
    return(ppnd16tmp) ;
  }

}

