#include "mcconv.h"
/*
  mctest                                               
                                                                      
  This subroutine tests for a first-order Markov chain against a      
  second-order Markov chain using the log-linear modeling             
  formulation.  Here the first-order model is the [12][23] model,     
  while the 2nd-order model is the saturated model.  The [12][23]     
  model has closed form estimates - see Bishop, Feinberg and Holland. 

  Inputs:                                                             
                                                                      
    data     = an integer vector containing the series of 0's and 1's 
               for which this subroutine is to determine whether a    
               first-order Markov chain is sufficient or whether a    
               second-order Markov chain is needed to model the data. 
               There must be at least datacnt elements in the data    
               vector.                                                
                                                                      
    datacnt  = an integer containing the number of elements in the    
               data argument.                                         
                
  Outputs:                                                            
                                                                      
    g2       = a double precision number in which this subroutine is  
               to return the log likelihood ratio statistic for       
               testing a second-order Markov chain against only a     
               first-order Markov chain.  Bishop, Feinberg and        
               Holland denote this statistic as G2.                   
                                                                      
    bic      = a double precision number in which this subroutine is  
               to return the BIC value corresponding to the log       
               likelihood ratio statistic, g2.                        
                                                                      
*/
void mctest(int *data, int n, double *g2, double *bic)
{

  double fitted, focus ;
  int    tran[8]={0,0,0,0,0,0,0,0}, i1, i2, i3 ;
  int    n1=2,n2=2,n3=2;

  /*
    Count up the number of occurrences of each possible type of    
    transition.  Keep these counts in the transition counts array. 
  */                                                             
  for ( i1=2; i1<n; i1++)
    tran[ MATINDX(data[i1-2],data[i1-1],data[i1],n1,n2,n3) ]++;

  /*
    Compute the log likelihood ratio statistic for testing a second-   
    order Markov chain against only a first-order Markov chain.  This  
    is Bishop, Feinberg and Holland's G2 statistic.                    
  */
  (*g2) = 0.0 ;
  for ( i1=0; i1<n1; i1++ )
    for ( i2=0; i2<n2; i2++ )
      for ( i3=0; i3<n3; i3++ )
        if ( tran[MATINDX(i1,i2,i3,n1,n2,n3)] != 0 )
        { 
	  fitted = ((double)( ( tran[MATINDX(i1,i2,0, n1,n2,n3)] 
                            +tran[MATINDX(i1,i2,1, n1,n2,n3)]) 
                          *( tran[MATINDX(0, i2,i3,n1,n2,n3)] 
			     +tran[MATINDX(1, i2,i3,n1,n2,n3)]) )) 
	    /((double)(  tran[MATINDX(0,i2,0,n1,n2,n3)]  
                          + tran[MATINDX(0,i2,1,n1,n2,n3)] 
			  + tran[MATINDX(1,i2,0,n1,n2,n3)]  
			 + tran[MATINDX(1,i2,1,n1,n2,n3)] )) ;
            focus = (double) tran[MATINDX(i1,i2,i3,n1,n2,n3)];
            (*g2) += log( focus / fitted ) * focus ;
	}
  (*g2) *= 2.0 ;

  /*
    Finally calculate the associated bic statistic and return to the caller.
  */                                                                   

  (*bic) = (*g2) - log( (double) (n-2) ) * 2.0 ;

  return ;

}
