#include "mcconv.h"
/*
  mcest                                                    
  Estimate the parameters of a first-order Markov chain (in the Cox   
  & Miller parametrization) from a series of binary, i.e. 0-1, data   
  passed in the data vector argument.                                             
                                                                      
  Inputs:                                                             
                                                                      
    data     = an integer vector containing the series of 0's and 1's 
               from which this subroutine is to calculate empirical   
               probabilities of a transition from a 0 to a 1 or a     
               transition from a 1 to a 0.  There must be at least    
               datacnt elements in this vector.                       
                                                                      
    n       = an integer containing the number of elements in the    
               data argument.                                         
                                                                      
                                                                      
  Outputs:                                                            
                                                                      
    alpha    = a double precision number in which this subroutine is  
               to return the empirical probability of a 1 following   
               a 0 in the input data vector.                          
                                                                      
    beta     = a double precision number in which this subroutine is  
               to return the empirical probability of a 0 following   
               a 1 in the input data vector.                          
                                                                      
*/

void mcest(int *data, int n, double *alpha, double *beta)
{
  int tran[4]={0,0,0,0}, i1 ;
  int n1=2, n2=2; 

  /*  
    Count up the number of occurrences of each possible type of        
    transition.  Keep these counts in the transition counts array.      
  */
  for ( i1 = 1; i1<n; i1++ )
    tran[ MATINDX(data[i1-1],data[i1],0,n1,n2,1) ]++; 

  /*
    Calculate the empirical transition probabilities between 0's and    *
    1's in the input (returned in alpha) and between 1's and 0's in the *
    input (returned in beta).                                           *
  */
  (*alpha) = ((double)tran[MATINDX(0,1,0,n1,n2,1)] ) 
    / ( (double) ( tran[MATINDX(0,0,0,n1,n2,1)] + tran[MATINDX(0,1,0,n1,n2,1)] )) ;
  (*beta)  = ((double)tran[MATINDX(1,0,0,n1,n2,1)] ) 
    / ( (double) ( tran[MATINDX(1,0,0,n1,n2,1)] + tran[MATINDX(1,1,0,n1,n2,1)] )) ;

  return ;
}
