#include "mcconv.h"
/*
  empquant                                            
                                                                      
  This function finds the q-th empirical quantile of the input double 
  precsion series, data, of length n.                          
                                                                      
  The algorithm used by this subroutine is the one used in the SPLUS  
  quantile function.                                                  
                                                                      
  Inputs:                                                             
                                                                      
    data     = a double precision vector of numbers whose q-th        
               empirical quantile is to be calculated.                
                                                                      
    n        = an integer containing the number of elements in the    
               input data vector, data.  There must also be this      
               many elements in the work vector.                      
                                                                      
    q        = a double precision number between 0.0d0 and 1.0d0,     
               inclusive, specifying which empirical quantile is      
               wanted.                                                
                                                                      
    work     = a double precision vector to be used as a work area    
               for the sort subroutine called by empquant.  This      
               vector must contain at least n elements.        
                          
  Outputs:                                                            
                                                                      
    empquant = a double precision number corresponding to the q-th    
               level of the sorted vector of input values.            
                                                                      
*/
double empquant(double *data,int n, double q, double *work)
{
  double order, fract ;
  int    low, high, i1 ;

  /*
  Copy the input series of double precision numbers into the work     
  area provided by the caller.  In this way the original input will   
  not be modified by this subroutine.                                 
  */                                                                      
  for ( i1=0; i1<n; i1++ ) work[i1] = data[i1] ;

  /* Sort the input series into ascending order. */
  ssort(work,work,n,1) ;

  /*
  Now locate the q-th empirical quantile.  This apparently longer  
  than necessary calculation is used so as to appropriately handle  
  the case where there are two or more identical values at the     
  requested quantile.                                                 
  */

  order = ((double)(n-1)) * q ;
  fract = order - (double) ((int) order) ;
  low   = MAX( ((int) order), 0) ;
  high  = MIN( low+1, n-1) ;

  return ( (1.0 - fract) * work[low] + fract * work[high] );

}
