#include "mcconv.h"
/*
  dichot 
                                                                      
  This subroutine takes a double precision vector, data, of length    
  n and converts it into a 0-1 series in zt, depending on      
  which elements of data are less than or greater than cutpt.         
                                                                      
  Inputs:                                                             
                                                                      
    data     = a double precision vector containing a series of       
               numbers which are to be compared to cutpt in order to  
               determine which elements of zt are to be set to 1 and  
               which are to be set to 0.                              
                                                                      
    n        = an integer containing the number of elements in the    
               input data vector.                                     
                                                                      
    cutpt    = a double precision number indicating the boundary      
               about which the input data vector is to be dichoto-    
               mized, i.e. set to 1 when less than or equal to the    
               cutpoint and to 0 when greater than the cutpoint.      
                                            
  Outputs:                                                            
                                                                      
    zt       = an integer vector containing zeros and ones depending  
               on whether or not the corresponding elements of data   
               were less than the cutpoint or not.                    
                                                                      

*/
void dichot(double *data, int n, double cutpt, int *zt)
{
  int i1 ;

  for ( i1 = 0; i1<n; i1++ )
    if ( data[i1] <= cutpt )
      zt[i1] = 1;
    else
      zt[i1] = 0;

  return ;
}
