#include "mix.h" 
#include "macros.h"

/* ------------------------------------------------------------------------- */
/*
  mix_jdd(struct graph *G, int X)

  Given a graph G, flip edges X times, randomly 
*/
void mix_jdd(struct graph *G, int X)
{
  int *d, d1,i, j,k,N, *degptr, *degind, *tmp; 
  int u1, u2, v1, v2;
  
  
  N = G->V;
  degptr = (int *) malloc( sizeof(int) * (N+1) );
  degind = (int *) malloc( sizeof(int) * N );
  d = (int *) malloc( sizeof(int) * N );

  memset( degptr, 0, sizeof(int)*(N+1) );
  for (i = 0; i < N; i++)
  {
    d[i] = G->ptr[i+1] - G->ptr[i];
    degptr[ d[i] ]++;
  }

  degptr[0] = 0;
  for ( i = 1; i <= N; i++)
    degptr[i] += degptr[i-1];
  
  for (i = 0; i < N; i++)
    if ( d[i] > 0 )
    {
      degind[ degptr[ d[i]-1 ] ] = i;
      degptr[ d[i] - 1 ]++;
    }

  for (i = N-1; i >= 1; i--) degptr[i] = degptr[i-1];
  degptr[0]=0;

  /*
    Keep a tmp pointer pointed at the original array.
    Then move the pointer back one entity so that we don't
    have to access it as degptr[ d[i] - 1 ] but can go ahead
    and access as degptr[ d[i] ]. Note that d[i] can be 1 or more,
    so this trick works. degptr[ 0 ] would have accessed uninitialized
    memory.

    Use tmp to deallocate the memory, not degptr.
  */
  tmp = degptr ;
  degptr--; 
  
  while  (X>0) 
  {
    /*    pick v from G->ptr */
    j  = myrandom(G->E);
    u1 = BinSearch(G->ptr, G->V+1, j);
    v1 = G->ind[j];
    d1 = G->ptr[u1+1] - G->ptr[u1];

#ifdef MIX_DEBUG
    printf(" 1st pick %d %d %d %d %d\n",u1,v1,d1,degptr[d1+1],degptr[d1]); 
#endif
    
    /* pick u from dind;  */
    k = myrandom( degptr[d1+1] - degptr[d1]) + degptr[d1];

    u2 = degind[k];

    /* pick an edge of u; */
    k = myrandom( G->ptr[u2+1] - G->ptr[u2]) + G->ptr[u2] ;
    v2 = G->ind[k]; 

    /* printf(" 2nd pick %d %d %d\n",u2,v2,G->ptr[u2+1]-G->ptr[u2]); */
    if (!is_adjacent(G,u1,v2) && !is_adjacent(G,u2,v1) && u1 != v2 &&  u2!= v1 ) 
    {
      G->ind[j] = v2;
      G->ind[k] = v1;
      replace(G, v2, u2, u1);
      replace(G, v1, u1, u2);
      X--;
    } /* End of if */
  } /* End of while */

  free( degind ) ; 
  free( tmp ) ; degptr = 0 ;
  free( d ) ;
}
