#ifndef MIXHSeen
#define MIXHSeen 

#include "graph.h" 

/**
   JDD related functions 
*/

void mix_jdd(struct graph *G, int X);

/*
  make_JDD(struct graph *G,  int ***J)

  Given a graph G, construct the joint-degree-distribution and stick it into
  J. The matrix J, nrows x 3 cols, is allocated here, but someone else has to
  deallocate it.

  G : incoming graph
  J ; matrix allocated here but the caller has to deallocate it.
*/
int make_JDD(struct graph *G,  int ***J);

void SortJDD(int **JDD, int jN, int *t);

int compareJDD(int **J, int jN, int *t, int **J2, int jN2, int *t2);

int  compareG2JDD(struct graph *G, int **J, int jN);

void compare_JDD2(struct graph *G,  int **J, int jlen);

/*
  make_bdd(struct  graph *G, int *sptr, int *rptr, int u, int v, int m);

  Add m edges in a graph between nodes of degree u and nodes of degree v
  
  G       The graph
  sptr[]  Array, where sptr[i] contains the starting node_id of nodes of degree i
  rptr[]  Array, where rptr[i] contains the endinf node_id of nodes with degree i
  u, v    We want to add edges between nodes of degree u and v
  m       We want to add this many edges
*/
int make_bdd(struct  graph *G, int *sptr, int *rptr, int u, int v, int m);

/*
  GenEdges (struct graph *G, int **JDM, int jlen, int *d, int N, int M)

  Given a Joint Degree Matrix JDM and a degree distribution vector,
  create a graph

  JDM:  Represents the (jlen x 3) Joint Degree Matrix
        JDM[i][0] and JDM[i][1] correspond to the  degrees of the ith edge's end vertices
        JDM[i][2] is the multiplicity of sucgh an edge    
    
  jlen:  is the  #rows in the JDM matrix 
  d   : Degree distribution vector  d[i] is the number of vertces of degree i.  
  N   : number of vertices.
  M   : number of edges 
*/
int GenEdges (struct graph *G, int **JDM, int jlen, int *d, int N, int M);

int BinSearch(int *A,int N, int x);

/*
  gen_jdd() Function to generate a graph, when we are only given 
  - a joint-degree-distribution in a matrix J
  - jN, the number of rows in the matrix J. It has 3 columns.
  - N, the number of nodes in the graph.
  G will contain the final graph
*/
void gen_jdd(struct graph *G, int **J, int jN, int N);

int count(struct graph *G, int x,int y);

/*
  read_JDM_vector() 

  Function to read in a file that specifies a joint degree distribution.
  
  (*J)    : Pointer to a 2D array, to serve as the holder for the joint degree distribution.
            This array is allocated in this function, but has to be deallocated elsewhere.

  (*jlen) : number of rows of joint degree distribution array. number of columns is always 3.
            The number is read from file and returned to the caller.

  (*N)    : Number of nodes in the graph. Also returned to the caller.

  fname   : String; filename where the joint degree distribution (JDD) can be found.
            Supplied by the caller.
*/
void read_JDM_vector (int ***J, int *jlen, int *N, char *fname);

/*
  edges2gr (char *fname, struct graph *G)

  Given a list of edges i.e. M pairs like [emanating_node_id, terminating_node_id],
  create a graph in the format that we have.

  fname : file with the edge list. The top 2 number are numNodes and numEdges

  G     : The graph struct that will be contructed with the edge list
*/
void edges2gr (char *fname, struct graph *G);

/**
   Degree-distribution preserving functions 
*/

/**
   mixdd(void mixdd(struct graph *G, int N)

   Function that filps edges of a graph N times, without changing the
   degree distribution of the graph

   - G, a graph that has to be modified. The modified graph is stored back in G

   - N, number of edges that have to be flipped.
*/
void mixdd(struct graph *G, int N) ;
#endif
