#ifndef GRAPHHSeen
#define GRAPHHSeen

#include <stdlib.h> 
#include <stdio.h> 
#include <math.h>
#include <time.h>
#include <memory.h>

struct graph 
{
  int V;
  int E;	
  int *ind; 
  int *ptr;
};
 
/*
  alloc_gr(struct graph *G, int V, int E)

  Allocate memory for a graph with V nodes and E edges
*/
void alloc_gr(struct graph *G, int V, int E);

void read_graph(struct graph *G, char *fname);

void write_graph(struct graph *G);

int is_adjacent(struct graph *G, int u, int v); 

void replace(struct graph *G, int u, int v1, int v2);

void mixdd(struct graph *G, int N); 

int  generate (struct graph *G, int *d, int N);

/*
  check_simple (struct graph  *G)

  Check if the graph
  - has no self loops
  - does not have repeated edges between the same pair of nodes

  if not simple, return 1; if repeated edges, return 2; if ok, return 0
*/
int check_simple(struct graph *G);
#endif
