#include "graph.h" 

/* ----------------------------------------------------------------------- */
int int_cmp(const void *a, const void *b) 
{ 
  const int *ia = (const int *)a; /* casting pointer types  */
  const int *ib = (const int *)b;
  return *ia  - *ib; 
  /* 
     integer comparison: returns negative if b > a 
     and positive if a > b 
  */ 
} 

/* ----------------------------------------------------------------------- */
/*
  check_simple (struct graph  *G)

  Check if the graph
  - has no self loops
  - does not have repeated edges between the same pair of nodes

  if not simple, return 1; if repeated edges, return 2; if ok, return 0
*/
int check_simple (struct graph  *G)
{
  int i,j;

#ifdef MIX_VERBOSE
  printf(" check simplicity \n");
#endif

  for (i = 0; i < G->V; i++) 
  {
    qsort(G->ind+G->ptr[i], G->ptr[i+1]-G->ptr[i], sizeof(int),int_cmp);
    if (G->ind[G->ptr[i]]==i) 
    {
      printf(" Self loop at %d \n", i);
	return (1);
    }
    for (j=G->ptr[i]+1;j<G->ptr[i+1];j++)
    {
      if (G->ind[j]==i) 
      {
	printf(" Self loop at %d \n", i);
	return (1);
      }
      else if (G->ind[j-1]== G->ind[j])	
      {
	printf(" Repeated edge between %d and %d \n", i, G->ind[j]);
	return (2);
      }
    }
  } /* End of loop over edges */
  return(0);		
}

/* ----------------------------------------------------------------------- */
/*
  alloc_gr(struct graph *G, int V, int E)

  Allocate memory for a graph with V nodes and E edges
*/
void alloc_gr(struct graph *G, int V, int E)
{
  /* 
     A struct that has :
     V - number of vertices
     E - number of edges
     ptr[] - an array, V long, with ptr[i] storing the starting value of the edge_ids incident on it.
     ind[] - an array, 2*E long, containg the nodes that the edges from i are incident on.

     ptr[i] contains the starting value of the edge_ids leaving from node i. (ptr[i+1]-1) is the ending value
     Thus ptr[i+1] - ptr[i] = m are the number of edges leaving from node i.

     These edges impinge on other other nodes. ind[ ptr[i] ] :  ind[ ptr[i] + m - 1 ] contain the node_ids of 
     the nodes that these edges impinge on.
  */
  G->V = V;
  G->E = E;
  G->ptr =(int *) malloc(sizeof(int)*(V+1));	
  G->ind =(int *) malloc(sizeof(int)*E*2);
}

/* ----------------------------------------------------------------------- */
void read_graph(struct graph *G, char *fname)
{ 
  int V,E, x,i,j;
  FILE *fp;
  
  fp=fopen(fname, "r");	
  fscanf(fp, "%d %d", &V, &E);
  alloc_gr(G,V,E);
  G->ptr[0]=0;
  for (j=i=0;i<V;i++) {		
    fscanf(fp,"%d", &x);	
    G->ptr[i+1]=G->ptr[i]+x;
    for(;j<G->ptr[i+1];j++)
      fscanf(fp,"%d",&(G->ind[j]));
  }
  write_graph(G);
}

/* ----------------------------------------------------------------------- */
void write_graph(struct graph *G)
{
  int i,j;

  printf("%d %d\n", G->V, G->ptr[G->V]);
  for (i=0;i<G->V;i++){
    printf("%d %d ",i, G->ptr[i+1]-G->ptr[i]); 
    for(j=G->ptr[i];j<G->ptr[i+1];j++)
      printf("%d ",G->ind[j]);
    printf("\n");
  }
}
	
/* ----------------------------------------------------------------------- */
int is_adjacent(struct graph *G, int u, int v) 
{
  int x,y,j; 
  x=v;
  y=u;
  if (G->ptr[v+1]-G->ptr[v] > G->ptr[u+1]-G->ptr[u]) {
    x=u;	y=v;
  }		
  for (j=G->ptr[x];j<G->ptr[x+1] && G->ind[j]!=y;j++);		
  if (j== G->ptr[x+1])
    return (0);
  return(1);
}

/* ----------------------------------------------------------------------- */
void  replace(struct graph *G, int u, int old, int new)
{
  int j; 
  for (j=G->ptr[u];j<G->ptr[u+1] && G->ind[j]!=old; j++);		
  if ( G->ind[j] == old)
    G->ind[j]=new;
  else {
    printf("error in replace %d %d %d \n",u,old,new);
   
  }
} 


