c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!====================================================================
!
      subroutine x_intp_cf_vc
     &    (f,d0f,orderi,orderb,
     &     biL, biR, bjL, bjR, bkL, bkR,
     &     fiL, fiR, fjL, fjR, fkL, fkR,
     &     iiL, iiR, ijL, ijR, ikL, ikR,
     &     dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &     iperx,ipery,iperz,ierror,error)
!
      include 'der0_1D_cf_vc_include.h'
!
      call der0_1D_cf_vc_pre( ierror, error,
     &   xbegin,xend,ybegin,yend,zbegin,zend,
     &   bnd4A, bnd6A, bnd8A, bnd6B, bnd8B, bnd8C,
     &   bnd10A, bnd10B, bnd10C, bnd10D,
! JR_CHANGE Leave the data structures for 12th order intact; will
! add later
     &   bnd12A, bnd12B, bnd12C, bnd12D, bnd12E,
     &   iperx,ipery,iperz, orderi, orderb,
     &   biL, biR, bjL, bjR, bkL, bkR,
     &   fiL, fiR, fjL, fjR, fkL, fkR,
     &   iiL, iiR, ijL, ijR, ikL, ikR,
     &   piL, piR, pjL, pjR, pkL, pkR,
     &   dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &   nproLx,nproRx,nproLy,nproRy,nproLz,nproRz,
     &   proL,proR,promax, width)
!
      if ( ierror .lt. 0) return 

      if( width .gt. piR-piL+1) then
        ierror = -100
        error = 'DER_0_1D: Stencil is wider than the f domain'
        return
      endif
!
! Zero-out interpolant
!
      do k = ikL, ikR
        do j = ijL, ijR
          do i = iiL, iiR-1
            d0f(i,j,k) = 0.0
          end do
        end do
      end do
!
! Written by Chris Kennedy in Dec. 2001 (Initial draft)
!
!========================================================================
! CENTERED DIFFERENCE OPERATORS
!
!-----------------------------
!  2nd-order
!
      if ( orderi .eq. 2 ) then
!
        ae  =  1.d0/ 2.d0
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ijL, ijR
            do i = xbegin, xend
              d0f(i,j,k) = ae *( f(i+1,j,k)+f(i-0,j,k) )
            end do   
          end do
        end do
!
      end if
!
!-----------------------------
!  4th order
!
!
      if ( orderi .eq. 4 ) then

         ae  =  9.d0/16.d0
         be  = -1.d0/16.d0
!
!  Internal nodes:
!
         do k = ikL, ikR
            do j = ijL, ijR
               do i = xbegin, xend
                  d0f(i,j,k) = ae *( f(i+1,j,k)+f(i-0,j,k) )
     &                 + be *( f(i+2,j,k)+f(i-1,j,k) )
               end do   
            end do   
         end do
!     
!  Boundary nodes:
!
         if( orderb .eq. 4 ) then
!
!   Left side
!
            if ( nproLx .eq. 1 ) then
               do k = ikL, ikR
                  do j = ijL, ijR
                     d0f(xbegin-1,j,k) = (bnd4A(1)*f(xbegin-1,j,k) +
     &                    bnd4A(2)*f(xbegin+0,j,k) +
     &                    bnd4A(3)*f(xbegin+1,j,k) +
     &                    bnd4A(4)*f(xbegin+2,j,k))
                  end do
               end do
            end if
!     
!   Right side:
!     
            if ( nproRx .eq. 1 ) then
               do k = ikL, ikR
                  do j = ijL, ijR
                     d0f(xend+1,j,k) = (bnd4A(1)*f(xend+2,j,k) +
     &                    bnd4A(2)*f(xend+1,j,k) +
     &                    bnd4A(3)*f(xend+0,j,k) +
     &                    bnd4A(4)*f(xend-1,j,k))
                  end do
               end do
            end if
!     
         end if
      end if
!
!-----------------------------
!  6th order
!
      if ( orderi .eq. 6 ) then
!
        ae  = 150.d0/256.d0
        be  = -25.d0/256.d0
        ce  =   3.d0/256.d0
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ijL, ijR
            do i = xbegin, xend
              d0f(i,j,k) = ae *( f(i+1,j,k)+f(i-0,j,k) )
     &                   + be *( f(i+2,j,k)+f(i-1,j,k) )
     &                   + ce *( f(i+3,j,k)+f(i-2,j,k) ) 
            end do    
          end do    
        end do    
!
!  Boundary nodes:
!
        if( orderb .eq. 6 ) then
!
!   Left side:
!
        if ( nproLx .ge. 1 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-1,j,k) = (bnd6B(1)*f(xbegin-2,j,k) +
     &                             bnd6B(2)*f(xbegin-1,j,k) +
     &                             bnd6B(3)*f(xbegin+0,j,k) +
     &                             bnd6B(4)*f(xbegin+1,j,k) +
     &                             bnd6B(5)*f(xbegin+2,j,k) +
     &                             bnd6B(6)*f(xbegin+3,j,k))
            end do
          end do
        end if
!
        if ( nproLx .eq. 2 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-2,j,k) = (bnd6A(1)*f(xbegin-2,j,k) +
     &                             bnd6A(2)*f(xbegin-1,j,k) +
     &                             bnd6A(3)*f(xbegin+0,j,k) +
     &                             bnd6A(4)*f(xbegin+1,j,k) +
     &                             bnd6A(5)*f(xbegin+2,j,k) +
     &                             bnd6A(6)*f(xbegin+3,j,k))
            end do
          end do
        end if
!
!   Right side:
!
        if ( nproRx .ge. 1 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+1,j,k) = (bnd6B(1)*f(xend+3,j,k) +
     &                           bnd6B(2)*f(xend+2,j,k) +
     &                           bnd6B(3)*f(xend+1,j,k) +
     &                           bnd6B(4)*f(xend+0,j,k) +
     &                           bnd6B(5)*f(xend-1,j,k) +
     &                           bnd6B(6)*f(xend-2,j,k))
            end do
          end do
        end if
!
        if ( nproRx .eq. 2 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+2,j,k) = (bnd6A(1)*f(xend+3,j,k) +
     &                           bnd6A(2)*f(xend+2,j,k) +
     &                           bnd6A(3)*f(xend+1,j,k) +
     &                           bnd6A(4)*f(xend+0,j,k) +
     &                           bnd6A(5)*f(xend-1,j,k) +
     &                           bnd6A(6)*f(xend-2,j,k))
            end do
          end do
        end if
!
      end if
      end if
!-----------------------------
!  8th order
!
      if ( orderi .eq. 8 ) then
!
        ae  = +1225.d0/2048.d0
        be  = - 245.d0/2048.d0
        ce  = +  49.d0/2048.d0
        de  = -   5.d0/2048.d0
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ijL, ijR
            do i = xbegin, xend
              d0f(i,j,k) = ae *( f(i+1,j,k)+f(i-0,j,k) )
     &                   + be *( f(i+2,j,k)+f(i-1,j,k) )
     &                   + ce *( f(i+3,j,k)+f(i-2,j,k) ) 
     &                   + de *( f(i+4,j,k)+f(i-3,j,k) ) 
            end do    
          end do    
        end do    
!
!  Boundary nodes:
!
        if( orderb .eq. 8 ) then
!
!   Left side:
!
        if ( nproLx .ge. 1 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-1,j,k) = (bnd8C(1)*f(xbegin-3,j,k) +
     &                             bnd8C(2)*f(xbegin-2,j,k) +
     &                             bnd8C(3)*f(xbegin-1,j,k) +
     &                             bnd8C(4)*f(xbegin+0,j,k) +
     &                             bnd8C(5)*f(xbegin+1,j,k) +
     &                             bnd8C(6)*f(xbegin+2,j,k) +
     &                             bnd8C(7)*f(xbegin+3,j,k) +
     &                             bnd8C(8)*f(xbegin+4,j,k))
            end do
          end do
        end if
!
        if ( nproLx .ge. 2 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-2,j,k) = (bnd8B(1)*f(xbegin-3,j,k) +
     &                             bnd8B(2)*f(xbegin-2,j,k) +
     &                             bnd8B(3)*f(xbegin-1,j,k) +
     &                             bnd8B(4)*f(xbegin+0,j,k) +
     &                             bnd8B(5)*f(xbegin+1,j,k) +
     &                             bnd8B(6)*f(xbegin+2,j,k) +
     &                             bnd8B(7)*f(xbegin+3,j,k) +
     &                             bnd8B(8)*f(xbegin+4,j,k))
            end do
          end do
        end if
!
        if ( nproLx .eq. 3 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-3,j,k) = (bnd8A(1)*f(xbegin-3,j,k) +
     &                             bnd8A(2)*f(xbegin-2,j,k) +
     &                             bnd8A(3)*f(xbegin-1,j,k) +
     &                             bnd8A(4)*f(xbegin+0,j,k) +
     &                             bnd8A(5)*f(xbegin+1,j,k) +
     &                             bnd8A(6)*f(xbegin+2,j,k) +
     &                             bnd8A(7)*f(xbegin+3,j,k) +
     &                             bnd8A(8)*f(xbegin+4,j,k))
            end do
          end do
        end if
!
!   Right side:
!
        if ( nproRx .ge. 1 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+1,j,k) = (bnd8C(1)*f(xend+4,j,k) +
     &                           bnd8C(2)*f(xend+3,j,k) +
     &                           bnd8C(3)*f(xend+2,j,k) +
     &                           bnd8C(4)*f(xend+1,j,k) +
     &                           bnd8C(5)*f(xend+0,j,k) +
     &                           bnd8C(6)*f(xend-1,j,k) +
     &                           bnd8C(7)*f(xend-2,j,k) +
     &                           bnd8C(8)*f(xend-3,j,k))
            end do
          end do
        end if
!
        if ( nproRx .ge. 2 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+2,j,k) = (bnd8B(1)*f(xend+4,j,k) +
     &                           bnd8B(2)*f(xend+3,j,k) +
     &                           bnd8B(3)*f(xend+2,j,k) +
     &                           bnd8B(4)*f(xend+1,j,k) +
     &                           bnd8B(5)*f(xend+0,j,k) +
     &                           bnd8B(6)*f(xend-1,j,k) +
     &                           bnd8B(7)*f(xend-2,j,k) +
     &                           bnd8B(8)*f(xend-3,j,k))
            end do
          end do
        end if
!
        if ( nproRx .eq. 3 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+3,j,k) = (bnd8A(1)*f(xend+4,j,k) +
     &                           bnd8A(2)*f(xend+3,j,k) +
     &                           bnd8A(3)*f(xend+2,j,k) +
     &                           bnd8A(4)*f(xend+1,j,k) +
     &                           bnd8A(5)*f(xend+0,j,k) +
     &                           bnd8A(6)*f(xend-1,j,k) +
     &                           bnd8A(7)*f(xend-2,j,k) +
     &                           bnd8A(8)*f(xend-3,j,k))
            end do
          end do
        end if
!
      end if
      end if
!-----------------------------
!  10th order
!
      if ( orderi .eq. 10 ) then
!
        ae  = +39690.d0/65536.d0
        be  = - 8820.d0/65536.d0
        ce  = + 2268.d0/65536.d0
        de  = -  405.d0/65536.d0
        ee  = +   35.d0/65536.d0
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ijL, ijR
            do i = xbegin, xend
              d0f(i,j,k) = ae *( f(i+1,j,k)+f(i-0,j,k) )
     &                   + be *( f(i+2,j,k)+f(i-1,j,k) )
     &                   + ce *( f(i+3,j,k)+f(i-2,j,k) )
     &                   + de *( f(i+4,j,k)+f(i-3,j,k) )
     &                   + ee *( f(i+5,j,k)+f(i-4,j,k) )
            end do
          end do
        end do
!
!  Boundary nodes:
!
        if( orderb .eq. 10 ) then
!
!   Left side:
!
        if ( nproLx .ge. 1 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-1,j,k) = (bnd10D( 1)*f(xbegin-4,j,k) +
     &                             bnd10D( 2)*f(xbegin-3,j,k) +
     &                             bnd10D( 3)*f(xbegin-2,j,k) +
     &                             bnd10D( 4)*f(xbegin-1,j,k) +
     &                             bnd10D( 5)*f(xbegin+0,j,k) +
     &                             bnd10D( 6)*f(xbegin+1,j,k) +
     &                             bnd10D( 7)*f(xbegin+2,j,k) +
     &                             bnd10D( 8)*f(xbegin+3,j,k) +
     &                             bnd10D( 9)*f(xbegin+4,j,k) +
     &                             bnd10D(10)*f(xbegin+5,j,k))
            end do
          end do
        end if
!
        if ( nproLx .ge. 2 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-2,j,k) = (bnd10C( 1)*f(xbegin-4,j,k) +
     &                             bnd10C( 2)*f(xbegin-3,j,k) +
     &                             bnd10C( 3)*f(xbegin-2,j,k) +
     &                             bnd10C( 4)*f(xbegin-1,j,k) +
     &                             bnd10C( 5)*f(xbegin+0,j,k) +
     &                             bnd10C( 6)*f(xbegin+1,j,k) +
     &                             bnd10C( 7)*f(xbegin+2,j,k) +
     &                             bnd10C( 8)*f(xbegin+3,j,k) +
     &                             bnd10C( 9)*f(xbegin+4,j,k) +
     &                             bnd10C(10)*f(xbegin+5,j,k))
            end do
          end do
        end if
!
        if ( nproLx .ge. 3 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-3,j,k) = (bnd10B( 1)*f(xbegin-4,j,k) +
     &                             bnd10B( 2)*f(xbegin-3,j,k) +
     &                             bnd10B( 3)*f(xbegin-2,j,k) +
     &                             bnd10B( 4)*f(xbegin-1,j,k) +
     &                             bnd10B( 5)*f(xbegin+0,j,k) +
     &                             bnd10B( 6)*f(xbegin+1,j,k) +
     &                             bnd10B( 7)*f(xbegin+2,j,k) +
     &                             bnd10B( 8)*f(xbegin+3,j,k) +
     &                             bnd10B( 9)*f(xbegin+4,j,k) +
     &                             bnd10B(10)*f(xbegin+5,j,k))
            end do
          end do
        end if
!
        if ( nproLx .eq. 4 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xbegin-4,j,k) = (bnd10A( 1)*f(xbegin-4,j,k) +
     &                             bnd10A( 2)*f(xbegin-3,j,k) +
     &                             bnd10A( 3)*f(xbegin-2,j,k) +
     &                             bnd10A( 4)*f(xbegin-1,j,k) +
     &                             bnd10A( 5)*f(xbegin+0,j,k) +
     &                             bnd10A( 6)*f(xbegin+1,j,k) +
     &                             bnd10A( 7)*f(xbegin+2,j,k) +
     &                             bnd10A( 8)*f(xbegin+3,j,k) +
     &                             bnd10A( 9)*f(xbegin+4,j,k) +
     &                             bnd10A(10)*f(xbegin+5,j,k))
            end do
          end do
        end if
!
!   Right side:  
!
        if ( nproRx .ge. 1 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+1,j,k) = (bnd10D( 1)*f(xend+5,j,k) +
     &                           bnd10D( 2)*f(xend+4,j,k) +
     &                           bnd10D( 3)*f(xend+3,j,k) +
     &                           bnd10D( 4)*f(xend+2,j,k) +
     &                           bnd10D( 5)*f(xend+1,j,k) +
     &                           bnd10D( 6)*f(xend+0,j,k) +
     &                           bnd10D( 7)*f(xend-1,j,k) +
     &                           bnd10D( 8)*f(xend-2,j,k) +
     &                           bnd10D( 9)*f(xend-3,j,k) +
     &                           bnd10D(10)*f(xend-4,j,k))
            end do
          end do
        end if
!
        if ( nproRx .ge. 2 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+2,j,k) = (bnd10C( 1)*f(xend+5,j,k) +
     &                           bnd10C( 2)*f(xend+4,j,k) +
     &                           bnd10C( 3)*f(xend+3,j,k) +
     &                           bnd10C( 4)*f(xend+2,j,k) +
     &                           bnd10C( 5)*f(xend+1,j,k) +
     &                           bnd10C( 6)*f(xend+0,j,k) +
     &                           bnd10C( 7)*f(xend-1,j,k) +
     &                           bnd10C( 8)*f(xend-2,j,k) +
     &                           bnd10C( 9)*f(xend-3,j,k) +
     &                           bnd10C(10)*f(xend-4,j,k))
            end do
          end do
        end if
!
        if ( nproRx .ge. 3 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+3,j,k) = (bnd10B( 1)*f(xend+5,j,k) +
     &                           bnd10B( 2)*f(xend+4,j,k) +
     &                           bnd10B( 3)*f(xend+3,j,k) +
     &                           bnd10B( 4)*f(xend+2,j,k) +
     &                           bnd10B( 5)*f(xend+1,j,k) +
     &                           bnd10B( 6)*f(xend+0,j,k) +
     &                           bnd10B( 7)*f(xend-1,j,k) +
     &                           bnd10B( 8)*f(xend-2,j,k) +
     &                           bnd10B( 9)*f(xend-3,j,k) +
     &                           bnd10B(10)*f(xend-4,j,k))
            end do
          end do
        end if
!
        if ( nproRx .eq. 4 ) then
          do k = ikL, ikR
            do j = ijL, ijR
              d0f(xend+4,j,k) = (bnd10A( 1)*f(xend+5,j,k) +
     &                           bnd10A( 2)*f(xend+4,j,k) +
     &                           bnd10A( 3)*f(xend+3,j,k) +
     &                           bnd10A( 4)*f(xend+2,j,k) +
     &                           bnd10A( 5)*f(xend+1,j,k) +
     &                           bnd10A( 6)*f(xend+0,j,k) +
     &                           bnd10A( 7)*f(xend-1,j,k) +
     &                           bnd10A( 8)*f(xend-2,j,k) +
     &                           bnd10A( 9)*f(xend-3,j,k) +
     &                           bnd10A(10)*f(xend-4,j,k))
            end do
          end do
        end if
!
        end if
      end if
!-----------------------------
!  12th order
!
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!
!      if ( orderi .eq. 12 ) then
!
!        ae  = +320166.d0/524288.d0
!
!
!  Internal nodes:
!
!        do k = ikL, ikR
!          do j = ijL, ijR
!            do i = xbegin, xend
!              d0f(i,j,k) = ae *( f(i+1,j,k)+f(i-0,j,k) )
!     <stuff deleted>
!            end do
!          end do
!        end do
!
!  Boundary nodes:
!
!        if( orderb .eq. 12 ) then
!
!   Left side:
!
!        if ( nproLx .ge. 1 ) then
!          do k = ikL, ikR
!            do j = ijL, ijR
!              d0f(xbegin-1,j,k) = (bnd12E( 1)*f(xbegin-5,j,k) +
!     &                             bnd12E( 2)*f(xbegin-4,j,k) +
!
!
! End Centered Difference Operators
!
      return
      end
!====================================================================
