c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!===========================================================================
!
      subroutine der0_2D_cf_vc_pre( ierror, error, 
     &   xbegin,xend,ybegin,yend,zbegin,zend,
! CAK 26DEC05 - Why isn't this array included here??
!    &   bnd2AA,
     &   bnd4AA, bnd4AB, bnd4I,
     &   bnd6AA, bnd6AB, bnd6AC, 
     &   bnd6BB, bnd6BC, bnd6I,
     &   bnd8AA, bnd8AB, bnd8AC, bnd8AD, 
     &   bnd8BB, bnd8BC, bnd8BD, 
     &   bnd8CC, bnd8CD, bnd8I, 
     &   bnd10AA, bnd10AB, bnd10AC, bnd10AD, bnd10AE,
     &   bnd10BB, bnd10BC, bnd10BD, bnd10BE,
     &   bnd10CC, bnd10CD, bnd10CE, 
     &   bnd10DD, bnd10DE, bnd10I,
! JR_CHANGE 04/15/06. Even if 12th-order is not being provided, keep its
! data structures around. We will add that later.
     &   bnd12AA, bnd12AB, bnd12AC, bnd12AD, bnd12AE, bnd12AF,
     &   bnd12BB, bnd12BC, bnd12BD, bnd12BE, bnd12BF,
     &   bnd12CC, bnd12CD, bnd12CE, bnd12CF,
     &   bnd12DD, bnd12DE, bnd12DF,
     &   bnd12EE, bnd12EF, bnd12I,
     &   iperx,ipery,iperz, orderi, orderb,
     &   biL, biR, bjL, bjR, bkL, bkR,
     &   fiL, fiR, fjL, fjR, fkL, fkR,
     &   iiL, iiR, ijL, ijR, ikL, ikR,
     &   piL, piR, pjL, pjR, pkL, pkR,
     &   dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &   nproLx,nproRx,nproLy,nproRy,nproLz,nproRz,
     &   proL,proR,promax,width)
!
      include 'der0_2D_cf_vc_include.h'
!
!======================================================================
!
! Initialize IERROR to zero implying no errors
!
      ierror = 0
!
! Boundaries of usable f patch
      piL = iiL - biL
      piR = iiR + biR
      pjL = ijL - bjL
      pjR = ijR + bjR
      pkL = ikL - bkL
      pkR = ikR + bkR
!
! Is the usable patch width larger than the width of f?
      if( min0(piL-fiL,fiR-piR,pjL-fjL,fjR-pjR,pkL-fkL,fkR-pkR)
     &   .lt. 0) then
        ierror = -10
        error = 'DER_0_2D: Interior + Green width > function width' 
        return
      endif
!
! Is the interior width larger than the width of df?
      if( min0(iiL-dfiL,dfiR-iiR,ijL-dfjL,dfjR-ijR,ikL-dfkL,dfkR-ikR)
     &   .lt. 0) then
        ierror = -20
        error = 'DER_0_2D: Interior width > derivative width' 
        return
      endif
!
! Have the number of green cells gone negative anywhere?
      if( min0(biL,biR,bjL,bjR,bkL,bkR) .lt. 0 ) then
        ierror = -40
        error = 'DER_0_2D: Green cell width < zero' 
        return
      endif
!
! Has the interior width gone negative?
      if( min0(iiR-iiL,ijR-ijL,ikR-ikL) .lt. 0 ) then
        ierror = -50
        error = 'DER_0_2D: Interior Width < zero' 
        return
      endif
!
! Has the boundary order been chosen properly??
!
      if( orderi .eq. 4) then
        if(orderb.ne.4) then
          ierror = -60
          error = 'DER_0_2D: No such boundary order: orderb '
          return
        endif
      elseif( orderi .eq. 6) then
        if(orderb.ne.6) then
          ierror = -61
          error = 'DER_0_2D: No such boundary order: orderb '
          return
        endif
      elseif( orderi .eq. 8) then
        if(orderb.ne.8) then
          ierror = -62
          error = 'DER_0_2D: No such boundary order: orderb '
          return
        endif
      elseif( orderi .eq. 10) then
        if(orderb.ne.10) then
          ierror = -63
          error = 'DER_0_2D: No such boundary order: orderb '
          return
        endif
c     JR_CHANGE 04/15/06. Nope, not yet. No 12th order.
c      elseif( orderi .eq. 12) then
c        if(orderb.ne.12) then
c          ierror = -64
c          error = 'DER_0_2D: No such boundary order: orderb '
c          return
c        endif
      endif
!
! Stencil Widths
!
!   Centered stencils
!
      proL = -1
      proR = -1
!
      if( orderi .eq. 2 ) then
        proL = 0
        proR = 0
      elseif( orderi .eq. 4 ) then
        proL = 1
        proR = 1
      elseif( orderi .eq. 6 ) then
        proL = 2
        proR = 2
      elseif( orderi .eq. 8 ) then
        proL = 3
        proR = 3
      elseif( orderi .eq. 10 ) then
        proL = 4
        proR = 4
c     JR_CHANGE 04/15/06. Nope, not yet. No 12th order.
c      elseif( orderi .eq. 12 ) then
c        proL = 5
c        proR = 5
      endif
      width = proL + proR + 2
!
      if( ( proL .lt. 0) .or. ( proR .lt. 0) ) then
        ierror = -80
         error = 'DER_0_2D: No such scheme'
        return
      endif
!
      if( (iperx .lt. 0) .or. ( iperx .gt. 1) .or.
     &    (ipery .lt. 0) .or. ( ipery .gt. 1) .or.
     &    (iperz .lt. 0) .or. ( iperz .gt. 1) ) then
          ierror = -90
          error = 'DER_0_2D: Periodicity flags are set incorrectly'
          return
      endif
!
! Find maximum protrusion. 
!
      promax = max0( proL, proR )
!
! Determine where to begin Interior DO loops and how many
! boundary points need to be closed. Periodic domains
! will always (better) have enough green cells.
!
! X-direction
      if(( biL .ge. promax ) .or. (iperx .eq. 1)) then
        nproLx = 0
        xbegin = iiL
      else
        nproLx = promax - biL
        xbegin = iiL + nproLx
      endif
!
      if(( biR .ge. promax ) .or. (iperx .eq. 1)) then
        nproRx = 0
        xend = iiR - 1
      else
        nproRx = promax - biR
        xend   = iiR - nproRx - 1
      endif
!
! Y-direction
!
      if(( bjL .ge. promax ) .or. (ipery .eq. 1)) then
        nproLy = 0
        ybegin = ijL
      else
        nproLy = promax - bjL
        ybegin = ijL + nproLy
      endif
!
      if(( bjR .ge. promax ) .or. (ipery .eq. 1)) then
        nproRy = 0
        yend = ijR - 1
      else
        nproRy = promax - bjR
        yend   = ijR - nproRy - 1
      endif
!
! Z-direction
!
      if(( bkL .ge. promax ) .or. (iperz .eq. 1)) then
        nproLz = 0
        zbegin = ikL
      else
        nproLz = promax - bkL
        zbegin = ikL + nproLz
      endif
!
      if(( bkR .ge. promax ) .or. (iperz .eq. 1)) then
        nproRz = 0
        zend = ikR - 1
      else
        nproRz = promax - bkR
        zend   = ikR - nproRz - 1
      endif
!
! Set up Boundary stencil coefficients
!
! 2nd-order
!
! CAK 26DEC05 - Why isn't this called simply bnd2I(i,j)??
      bnd2AA(1,1) =  1.d0/4.d0
      bnd2AA(1,2) =  1.d0/4.d0
      bnd2AA(2,1) =  1.d0/4.d0
      bnd2AA(2,2) =  1.d0/4.d0
!
! 4th-order
!
      bnd4AA(1,1) =  25.d0/256.d0
      bnd4AA(1,2) =  75.d0/256.d0
      bnd4AA(1,3) = -25.d0/256.d0
      bnd4AA(1,4) =   5.d0/256.d0
      bnd4AA(2,1) =  75.d0/256.d0
      bnd4AA(2,2) = 225.d0/256.d0
      bnd4AA(2,3) = -75.d0/256.d0
      bnd4AA(2,4) =  15.d0/256.d0
      bnd4AA(3,1) = -25.d0/256.d0
      bnd4AA(3,2) = -75.d0/256.d0
      bnd4AA(3,3) =  25.d0/256.d0
      bnd4AA(3,4) =  -5.d0/256.d0
      bnd4AA(4,1) =   5.d0/256.d0
      bnd4AA(4,2) =  15.d0/256.d0
      bnd4AA(4,3) =  -5.d0/256.d0
      bnd4AA(4,4) =   1.d0/256.d0
!
      bnd4AB(1,1) =  -5.d0/256.d0
      bnd4AB(1,2) =  45.d0/256.d0
      bnd4AB(1,3) =  45.d0/256.d0
      bnd4AB(1,4) =  -5.d0/256.d0
      bnd4AB(2,1) = -15.d0/256.d0
      bnd4AB(2,2) = 135.d0/256.d0
      bnd4AB(2,3) = 135.d0/256.d0
      bnd4AB(2,4) = -15.d0/256.d0
      bnd4AB(3,1) =   5.d0/256.d0
      bnd4AB(3,2) = -45.d0/256.d0
      bnd4AB(3,3) = -45.d0/256.d0
      bnd4AB(3,4) =   5.d0/256.d0
      bnd4AB(4,1) =  -1.d0/256.d0
      bnd4AB(4,2) =   9.d0/256.d0
      bnd4AB(4,3) =   9.d0/256.d0
      bnd4AB(4,4) =  -1.d0/256.d0
!
      bnd4I(1,1) =   1.d0/256.d0
      bnd4I(1,2) =  -9.d0/256.d0
      bnd4I(1,3) =  -9.d0/256.d0
      bnd4I(1,4) =   1.d0/256.d0
      bnd4I(2,1) =  -9.d0/256.d0
      bnd4I(2,2) =  81.d0/256.d0
      bnd4I(2,3) =  81.d0/256.d0
      bnd4I(2,4) =  -9.d0/256.d0
      bnd4I(3,1) =  -9.d0/256.d0
      bnd4I(3,2) =  81.d0/256.d0
      bnd4I(3,3) =  81.d0/256.d0
      bnd4I(3,4) =  -9.d0/256.d0
      bnd4I(4,1) =   1.d0/256.d0
      bnd4I(4,2) =  -9.d0/256.d0
      bnd4I(4,3) =  -9.d0/256.d0
      bnd4I(4,4) =   1.d0/256.d0
!
! 6th-order
!
      bnd6AA(1,1) =   3969.d0/65536.d0
      bnd6AA(1,2) =  19845.d0/65536.d0
      bnd6AA(1,3) = -13230.d0/65536.d0
      bnd6AA(1,4) =   7938.d0/65536.d0
      bnd6AA(1,5) =  -2835.d0/65536.d0
      bnd6AA(1,6) =    441.d0/65536.d0
      bnd6AA(2,1) =  19845.d0/65536.d0
      bnd6AA(2,2) =  99225.d0/65536.d0
      bnd6AA(2,3) = -66150.d0/65536.d0
      bnd6AA(2,4) =  39690.d0/65536.d0
      bnd6AA(2,5) = -14175.d0/65536.d0
      bnd6AA(2,6) =   2205.d0/65536.d0
      bnd6AA(3,1) = -13230.d0/65536.d0
      bnd6AA(3,2) = -66150.d0/65536.d0
      bnd6AA(3,3) =  44100.d0/65536.d0
      bnd6AA(3,4) = -26460.d0/65536.d0
      bnd6AA(3,5) =   9450.d0/65536.d0
      bnd6AA(3,6) =  -1470.d0/65536.d0
      bnd6AA(4,1) =   7938.d0/65536.d0
      bnd6AA(4,2) =  39690.d0/65536.d0
      bnd6AA(4,3) = -26460.d0/65536.d0
      bnd6AA(4,4) =  15876.d0/65536.d0
      bnd6AA(4,5) =  -5670.d0/65536.d0
      bnd6AA(4,6) =    882.d0/65536.d0
      bnd6AA(5,1) =  -2835.d0/65536.d0
      bnd6AA(5,2) = -14175.d0/65536.d0
      bnd6AA(5,3) =   9450.d0/65536.d0
      bnd6AA(5,4) =  -5670.d0/65536.d0
      bnd6AA(5,5) =   2025.d0/65536.d0
      bnd6AA(5,6) =   -315.d0/65536.d0
      bnd6AA(6,1) =    441.d0/65536.d0
      bnd6AA(6,2) =   2205.d0/65536.d0
      bnd6AA(6,3) =  -1470.d0/65536.d0
      bnd6AA(6,4) =    882.d0/65536.d0
      bnd6AA(6,5) =   -315.d0/65536.d0
      bnd6AA(6,6) =     49.d0/65536.d0
!
      bnd6AB(1,1) =   -441.d0/65536.d0
      bnd6AB(1,2) =   6615.d0/65536.d0
      bnd6AB(1,3) =  13230.d0/65536.d0
      bnd6AB(1,4) =  -4410.d0/65536.d0
      bnd6AB(1,5) =   1323.d0/65536.d0
      bnd6AB(1,6) =   -189.d0/65536.d0
      bnd6AB(2,1) =  -2205.d0/65536.d0
      bnd6AB(2,2) =  33075.d0/65536.d0
      bnd6AB(2,3) =  66150.d0/65536.d0
      bnd6AB(2,4) = -22050.d0/65536.d0
      bnd6AB(2,5) =   6615.d0/65536.d0
      bnd6AB(2,6) =   -945.d0/65536.d0
      bnd6AB(3,1) =   1470.d0/65536.d0
      bnd6AB(3,2) = -22050.d0/65536.d0
      bnd6AB(3,3) = -44100.d0/65536.d0
      bnd6AB(3,4) =  14700.d0/65536.d0
      bnd6AB(3,5) =  -4410.d0/65536.d0
      bnd6AB(3,6) =    630.d0/65536.d0
      bnd6AB(4,1) =   -882.d0/65536.d0
      bnd6AB(4,2) =  13230.d0/65536.d0
      bnd6AB(4,3) =  26460.d0/65536.d0
      bnd6AB(4,4) =  -8820.d0/65536.d0
      bnd6AB(4,5) =   2646.d0/65536.d0
      bnd6AB(4,6) =   -378.d0/65536.d0
      bnd6AB(5,1) =    315.d0/65536.d0
      bnd6AB(5,2) =  -4725.d0/65536.d0
      bnd6AB(5,3) =  -9450.d0/65536.d0
      bnd6AB(5,4) =   3150.d0/65536.d0
      bnd6AB(5,5) =   -945.d0/65536.d0
      bnd6AB(5,6) =    135.d0/65536.d0
      bnd6AB(6,1) =    -49.d0/65536.d0
      bnd6AB(6,2) =    735.d0/65536.d0
      bnd6AB(6,3) =   1470.d0/65536.d0
      bnd6AB(6,4) =   -490.d0/65536.d0
      bnd6AB(6,5) =    147.d0/65536.d0
      bnd6AB(6,6) =    -21.d0/65536.d0
!
      bnd6AC(1,1) =    189.d0/65536.d0
      bnd6AC(1,2) =  -1575.d0/65536.d0
      bnd6AC(1,3) =   9450.d0/65536.d0
      bnd6AC(1,4) =   9450.d0/65536.d0
      bnd6AC(1,5) =  -1575.d0/65536.d0
      bnd6AC(1,6) =    189.d0/65536.d0
      bnd6AC(2,1) =    945.d0/65536.d0
      bnd6AC(2,2) =  -7875.d0/65536.d0
      bnd6AC(2,3) =  47250.d0/65536.d0
      bnd6AC(2,4) =  47250.d0/65536.d0
      bnd6AC(2,5) =  -7875.d0/65536.d0
      bnd6AC(2,6) =    945.d0/65536.d0
      bnd6AC(3,1) =   -630.d0/65536.d0
      bnd6AC(3,2) =   5250.d0/65536.d0
      bnd6AC(3,3) = -31500.d0/65536.d0
      bnd6AC(3,4) = -31500.d0/65536.d0
      bnd6AC(3,5) =   5250.d0/65536.d0
      bnd6AC(3,6) =   -630.d0/65536.d0
      bnd6AC(4,1) =    378.d0/65536.d0
      bnd6AC(4,2) =  -3150.d0/65536.d0
      bnd6AC(4,3) =  18900.d0/65536.d0
      bnd6AC(4,4) =  18900.d0/65536.d0
      bnd6AC(4,5) =  -3150.d0/65536.d0
      bnd6AC(4,6) =    378.d0/65536.d0
      bnd6AC(5,1) =   -135.d0/65536.d0
      bnd6AC(5,2) =   1125.d0/65536.d0
      bnd6AC(5,3) =  -6750.d0/65536.d0
      bnd6AC(5,4) =  -6750.d0/65536.d0
      bnd6AC(5,5) =   1125.d0/65536.d0
      bnd6AC(5,6) =   -135.d0/65536.d0
      bnd6AC(6,1) =     21.d0/65536.d0
      bnd6AC(6,2) =   -175.d0/65536.d0
      bnd6AC(6,3) =   1050.d0/65536.d0
      bnd6AC(6,4) =   1050.d0/65536.d0
      bnd6AC(6,5) =   -175.d0/65536.d0
      bnd6AC(6,6) =     21.d0/65536.d0
!
      bnd6BB(1,1) =     49.d0/65536.d0
      bnd6BB(1,2) =   -735.d0/65536.d0
      bnd6BB(1,3) =  -1470.d0/65536.d0
      bnd6BB(1,4) =    490.d0/65536.d0
      bnd6BB(1,5) =   -147.d0/65536.d0
      bnd6BB(1,6) =     21.d0/65536.d0
      bnd6BB(2,1) =   -735.d0/65536.d0
      bnd6BB(2,2) =  11025.d0/65536.d0
      bnd6BB(2,3) =  22050.d0/65536.d0
      bnd6BB(2,4) =  -7350.d0/65536.d0
      bnd6BB(2,5) =   2205.d0/65536.d0
      bnd6BB(2,6) =   -315.d0/65536.d0
      bnd6BB(3,1) =  -1470.d0/65536.d0
      bnd6BB(3,2) =  22050.d0/65536.d0
      bnd6BB(3,3) =  44100.d0/65536.d0
      bnd6BB(3,4) = -14700.d0/65536.d0
      bnd6BB(3,5) =   4410.d0/65536.d0
      bnd6BB(3,6) =   -630.d0/65536.d0
      bnd6BB(4,1) =    490.d0/65536.d0
      bnd6BB(4,2) =  -7350.d0/65536.d0
      bnd6BB(4,3) = -14700.d0/65536.d0
      bnd6BB(4,4) =   4900.d0/65536.d0
      bnd6BB(4,5) =  -1470.d0/65536.d0
      bnd6BB(4,6) =    210.d0/65536.d0
      bnd6BB(5,1) =   -147.d0/65536.d0
      bnd6BB(5,2) =   2205.d0/65536.d0
      bnd6BB(5,3) =   4410.d0/65536.d0
      bnd6BB(5,4) =  -1470.d0/65536.d0
      bnd6BB(5,5) =    441.d0/65536.d0
      bnd6BB(5,6) =    -63.d0/65536.d0
      bnd6BB(6,1) =     21.d0/65536.d0
      bnd6BB(6,2) =   -315.d0/65536.d0
      bnd6BB(6,3) =   -630.d0/65536.d0
      bnd6BB(6,4) =    210.d0/65536.d0
      bnd6BB(6,5) =    -63.d0/65536.d0
      bnd6BB(6,6) =      9.d0/65536.d0
!
      bnd6BC(1,1) =    -21.d0/65536.d0
      bnd6BC(1,2) =    175.d0/65536.d0
      bnd6BC(1,3) =  -1050.d0/65536.d0
      bnd6BC(1,4) =  -1050.d0/65536.d0
      bnd6BC(1,5) =    175.d0/65536.d0
      bnd6BC(1,6) =    -21.d0/65536.d0
      bnd6BC(2,1) =    315.d0/65536.d0
      bnd6BC(2,2) =  -2625.d0/65536.d0
      bnd6BC(2,3) =  15750.d0/65536.d0
      bnd6BC(2,4) =  15750.d0/65536.d0
      bnd6BC(2,5) =  -2625.d0/65536.d0
      bnd6BC(2,6) =    315.d0/65536.d0
      bnd6BC(3,1) =    630.d0/65536.d0
      bnd6BC(3,2) =  -5250.d0/65536.d0
      bnd6BC(3,3) =  31500.d0/65536.d0
      bnd6BC(3,4) =  31500.d0/65536.d0
      bnd6BC(3,5) =  -5250.d0/65536.d0
      bnd6BC(3,6) =    630.d0/65536.d0
      bnd6BC(4,1) =   -210.d0/65536.d0
      bnd6BC(4,2) =   1750.d0/65536.d0
      bnd6BC(4,3) = -10500.d0/65536.d0
      bnd6BC(4,4) = -10500.d0/65536.d0
      bnd6BC(4,5) =   1750.d0/65536.d0
      bnd6BC(4,6) =   -210.d0/65536.d0
      bnd6BC(5,1) =     63.d0/65536.d0
      bnd6BC(5,2) =   -525.d0/65536.d0
      bnd6BC(5,3) =   3150.d0/65536.d0
      bnd6BC(5,4) =   3150.d0/65536.d0
      bnd6BC(5,5) =   -525.d0/65536.d0
      bnd6BC(5,6) =     63.d0/65536.d0
      bnd6BC(6,1) =     -9.d0/65536.d0
      bnd6BC(6,2) =     75.d0/65536.d0
      bnd6BC(6,3) =   -450.d0/65536.d0
      bnd6BC(6,4) =   -450.d0/65536.d0
      bnd6BC(6,5) =     75.d0/65536.d0
      bnd6BC(6,6) =     -9.d0/65536.d0
!
      bnd6I(1,1) = 9.d0/65536.d0
      bnd6I(1,2) = -75.d0/65536.d0
      bnd6I(1,3) = 450.d0/65536.d0
      bnd6I(1,4) = 450.d0/65536.d0
      bnd6I(1,5) = -75.d0/65536.d0
      bnd6I(1,6) = 9.d0/65536.d0
      bnd6I(2,1) = -75.d0/65536.d0
      bnd6I(2,2) = 625.d0/65536.d0
      bnd6I(2,3) = -3750.d0/65536.d0
      bnd6I(2,4) = -3750.d0/65536.d0
      bnd6I(2,5) = 625.d0/65536.d0
      bnd6I(2,6) = -75.d0/65536.d0
      bnd6I(3,1) = 450.d0/65536.d0
      bnd6I(3,2) = -3750.d0/65536.d0
      bnd6I(3,3) = 22500.d0/65536.d0
      bnd6I(3,4) = 22500.d0/65536.d0
      bnd6I(3,5) = -3750.d0/65536.d0
      bnd6I(3,6) = 450.d0/65536.d0
      bnd6I(4,1) = 450.d0/65536.d0
      bnd6I(4,2) = -3750.d0/65536.d0
      bnd6I(4,3) = 22500.d0/65536.d0
      bnd6I(4,4) = 22500.d0/65536.d0
      bnd6I(4,5) = -3750.d0/65536.d0
      bnd6I(4,6) = 450.d0/65536.d0
      bnd6I(5,1) = -75.d0/65536.d0
      bnd6I(5,2) = 625.d0/65536.d0
      bnd6I(5,3) = -3750.d0/65536.d0
      bnd6I(5,4) = -3750.d0/65536.d0
      bnd6I(5,5) = 625.d0/65536.d0
      bnd6I(5,6) = -75.d0/65536.d0
      bnd6I(6,1) = 9.d0/65536.d0
      bnd6I(6,2) = -75.d0/65536.d0
      bnd6I(6,3) = 450.d0/65536.d0
      bnd6I(6,4) = 450.d0/65536.d0
      bnd6I(6,5) = -75.d0/65536.d0
      bnd6I(6,6) = 9.d0/65536.d0
!
! 8th-order
!
      bnd8AA(1,1) = 184041.d0/4194304.d0
      bnd8AA(1,2) = 1288287.d0/4194304.d0
      bnd8AA(1,3) = -1288287.d0/4194304.d0
      bnd8AA(1,4) = 1288287.d0/4194304.d0
      bnd8AA(1,5) = -920205.d0/4194304.d0
      bnd8AA(1,6) = 429429.d0/4194304.d0
      bnd8AA(1,7) = -117117.d0/4194304.d0
      bnd8AA(1,8) = 14157.d0/4194304.d0
      bnd8AA(2,1) = 1288287.d0/4194304.d0
      bnd8AA(2,2) = 9018009.d0/4194304.d0
      bnd8AA(2,3) = -9018009.d0/4194304.d0
      bnd8AA(2,4) = 9018009.d0/4194304.d0
      bnd8AA(2,5) = -6441435.d0/4194304.d0
      bnd8AA(2,6) = 3006003.d0/4194304.d0
      bnd8AA(2,7) = -819819.d0/4194304.d0
      bnd8AA(2,8) = 99099.d0/4194304.d0
      bnd8AA(3,1) = -1288287.d0/4194304.d0
      bnd8AA(3,2) = -9018009.d0/4194304.d0
      bnd8AA(3,3) = 9018009.d0/4194304.d0
      bnd8AA(3,4) = -9018009.d0/4194304.d0
      bnd8AA(3,5) = 6441435.d0/4194304.d0
      bnd8AA(3,6) = -3006003.d0/4194304.d0
      bnd8AA(3,7) = 819819.d0/4194304.d0
      bnd8AA(3,8) = -99099.d0/4194304.d0
      bnd8AA(4,1) = 1288287.d0/4194304.d0
      bnd8AA(4,2) = 9018009.d0/4194304.d0
      bnd8AA(4,3) = -9018009.d0/4194304.d0
      bnd8AA(4,4) = 9018009.d0/4194304.d0
      bnd8AA(4,5) = -6441435.d0/4194304.d0
      bnd8AA(4,6) = 3006003.d0/4194304.d0
      bnd8AA(4,7) = -819819.d0/4194304.d0
      bnd8AA(4,8) = 99099.d0/4194304.d0
      bnd8AA(5,1) = -920205.d0/4194304.d0
      bnd8AA(5,2) = -6441435.d0/4194304.d0
      bnd8AA(5,3) = 6441435.d0/4194304.d0
      bnd8AA(5,4) = -6441435.d0/4194304.d0
      bnd8AA(5,5) = 4601025.d0/4194304.d0
      bnd8AA(5,6) = -2147145.d0/4194304.d0
      bnd8AA(5,7) = 585585.d0/4194304.d0
      bnd8AA(5,8) = -70785.d0/4194304.d0
      bnd8AA(6,1) = 429429.d0/4194304.d0
      bnd8AA(6,2) = 3006003.d0/4194304.d0
      bnd8AA(6,3) = -3006003.d0/4194304.d0
      bnd8AA(6,4) = 3006003.d0/4194304.d0
      bnd8AA(6,5) = -2147145.d0/4194304.d0
      bnd8AA(6,6) = 1002001.d0/4194304.d0
      bnd8AA(6,7) = -273273.d0/4194304.d0
      bnd8AA(6,8) = 33033.d0/4194304.d0
      bnd8AA(7,1) = -117117.d0/4194304.d0
      bnd8AA(7,2) = -819819.d0/4194304.d0
      bnd8AA(7,3) = 819819.d0/4194304.d0
      bnd8AA(7,4) = -819819.d0/4194304.d0
      bnd8AA(7,5) = 585585.d0/4194304.d0
      bnd8AA(7,6) = -273273.d0/4194304.d0
      bnd8AA(7,7) = 74529.d0/4194304.d0
      bnd8AA(7,8) = -9009.d0/4194304.d0
      bnd8AA(8,1) = 14157.d0/4194304.d0
      bnd8AA(8,2) = 99099.d0/4194304.d0
      bnd8AA(8,3) = -99099.d0/4194304.d0
      bnd8AA(8,4) = 99099.d0/4194304.d0
      bnd8AA(8,5) = -70785.d0/4194304.d0
      bnd8AA(8,6) = 33033.d0/4194304.d0
      bnd8AA(8,7) = -9009.d0/4194304.d0
      bnd8AA(8,8) = 1089.d0/4194304.d0
!
      bnd8AB(1,1) = -14157.d0/4194304.d0
      bnd8AB(1,2) = 297297.d0/4194304.d0
      bnd8AB(1,3) = 891891.d0/4194304.d0
      bnd8AB(1,4) = -495495.d0/4194304.d0
      bnd8AB(1,5) = 297297.d0/4194304.d0
      bnd8AB(1,6) = -127413.d0/4194304.d0
      bnd8AB(1,7) = 33033.d0/4194304.d0
      bnd8AB(1,8) = -3861.d0/4194304.d0
      bnd8AB(2,1) = -99099.d0/4194304.d0
      bnd8AB(2,2) = 2081079.d0/4194304.d0
      bnd8AB(2,3) = 6243237.d0/4194304.d0
      bnd8AB(2,4) = -3468465.d0/4194304.d0
      bnd8AB(2,5) = 2081079.d0/4194304.d0
      bnd8AB(2,6) = -891891.d0/4194304.d0
      bnd8AB(2,7) = 231231.d0/4194304.d0
      bnd8AB(2,8) = -27027.d0/4194304.d0
      bnd8AB(3,1) = 99099.d0/4194304.d0
      bnd8AB(3,2) = -2081079.d0/4194304.d0
      bnd8AB(3,3) = -6243237.d0/4194304.d0
      bnd8AB(3,4) = 3468465.d0/4194304.d0
      bnd8AB(3,5) = -2081079.d0/4194304.d0
      bnd8AB(3,6) = 891891.d0/4194304.d0
      bnd8AB(3,7) = -231231.d0/4194304.d0
      bnd8AB(3,8) = 27027.d0/4194304.d0
      bnd8AB(4,1) = -99099.d0/4194304.d0
      bnd8AB(4,2) = 2081079.d0/4194304.d0
      bnd8AB(4,3) = 6243237.d0/4194304.d0
      bnd8AB(4,4) = -3468465.d0/4194304.d0
      bnd8AB(4,5) = 2081079.d0/4194304.d0
      bnd8AB(4,6) = -891891.d0/4194304.d0
      bnd8AB(4,7) = 231231.d0/4194304.d0
      bnd8AB(4,8) = -27027.d0/4194304.d0
      bnd8AB(5,1) = 70785.d0/4194304.d0
      bnd8AB(5,2) = -1486485.d0/4194304.d0
      bnd8AB(5,3) = -4459455.d0/4194304.d0
      bnd8AB(5,4) = 2477475.d0/4194304.d0
      bnd8AB(5,5) = -1486485.d0/4194304.d0
      bnd8AB(5,6) = 637065.d0/4194304.d0
      bnd8AB(5,7) = -165165.d0/4194304.d0
      bnd8AB(5,8) = 19305.d0/4194304.d0
      bnd8AB(6,1) = -33033.d0/4194304.d0
      bnd8AB(6,2) = 693693.d0/4194304.d0
      bnd8AB(6,3) = 2081079.d0/4194304.d0
      bnd8AB(6,4) = -1156155.d0/4194304.d0
      bnd8AB(6,5) = 693693.d0/4194304.d0
      bnd8AB(6,6) = -297297.d0/4194304.d0
      bnd8AB(6,7) = 77077.d0/4194304.d0
      bnd8AB(6,8) = -9009.d0/4194304.d0
      bnd8AB(7,1) = 9009.d0/4194304.d0
      bnd8AB(7,2) = -189189.d0/4194304.d0
      bnd8AB(7,3) = -567567.d0/4194304.d0
      bnd8AB(7,4) = 315315.d0/4194304.d0
      bnd8AB(7,5) = -189189.d0/4194304.d0
      bnd8AB(7,6) = 81081.d0/4194304.d0
      bnd8AB(7,7) = -21021.d0/4194304.d0
      bnd8AB(7,8) = 2457.d0/4194304.d0
      bnd8AB(8,1) = -1089.d0/4194304.d0
      bnd8AB(8,2) = 22869.d0/4194304.d0
      bnd8AB(8,3) = 68607.d0/4194304.d0
      bnd8AB(8,4) = -38115.d0/4194304.d0
      bnd8AB(8,5) = 22869.d0/4194304.d0
      bnd8AB(8,6) = -9801.d0/4194304.d0
      bnd8AB(8,7) = 2541.d0/4194304.d0
      bnd8AB(8,8) = -297.d0/4194304.d0
!
      bnd8AC(1,1) = 3861.d0/4194304.d0
      bnd8AC(1,2) = -45045.d0/4194304.d0
      bnd8AC(1,3) = 405405.d0/4194304.d0
      bnd8AC(1,4) = 675675.d0/4194304.d0
      bnd8AC(1,5) = -225225.d0/4194304.d0
      bnd8AC(1,6) = 81081.d0/4194304.d0
      bnd8AC(1,7) = -19305.d0/4194304.d0
      bnd8AC(1,8) = 2145.d0/4194304.d0
      bnd8AC(2,1) = 27027.d0/4194304.d0
      bnd8AC(2,2) = -315315.d0/4194304.d0
      bnd8AC(2,3) = 2837835.d0/4194304.d0
      bnd8AC(2,4) = 4729725.d0/4194304.d0
      bnd8AC(2,5) = -1576575.d0/4194304.d0
      bnd8AC(2,6) = 567567.d0/4194304.d0
      bnd8AC(2,7) = -135135.d0/4194304.d0
      bnd8AC(2,8) = 15015.d0/4194304.d0
      bnd8AC(3,1) = -27027.d0/4194304.d0
      bnd8AC(3,2) = 315315.d0/4194304.d0
      bnd8AC(3,3) = -2837835.d0/4194304.d0
      bnd8AC(3,4) = -4729725.d0/4194304.d0
      bnd8AC(3,5) = 1576575.d0/4194304.d0
      bnd8AC(3,6) = -567567.d0/4194304.d0
      bnd8AC(3,7) = 135135.d0/4194304.d0
      bnd8AC(3,8) = -15015.d0/4194304.d0
      bnd8AC(4,1) = 27027.d0/4194304.d0
      bnd8AC(4,2) = -315315.d0/4194304.d0
      bnd8AC(4,3) = 2837835.d0/4194304.d0
      bnd8AC(4,4) = 4729725.d0/4194304.d0
      bnd8AC(4,5) = -1576575.d0/4194304.d0
      bnd8AC(4,6) = 567567.d0/4194304.d0
      bnd8AC(4,7) = -135135.d0/4194304.d0
      bnd8AC(4,8) = 15015.d0/4194304.d0
      bnd8AC(5,1) = -19305.d0/4194304.d0
      bnd8AC(5,2) = 225225.d0/4194304.d0
      bnd8AC(5,3) = -2027025.d0/4194304.d0
      bnd8AC(5,4) = -3378375.d0/4194304.d0
      bnd8AC(5,5) = 1126125.d0/4194304.d0
      bnd8AC(5,6) = -405405.d0/4194304.d0
      bnd8AC(5,7) = 96525.d0/4194304.d0
      bnd8AC(5,8) = -10725.d0/4194304.d0
      bnd8AC(6,1) = 9009.d0/4194304.d0
      bnd8AC(6,2) = -105105.d0/4194304.d0
      bnd8AC(6,3) = 945945.d0/4194304.d0
      bnd8AC(6,4) = 1576575.d0/4194304.d0
      bnd8AC(6,5) = -525525.d0/4194304.d0
      bnd8AC(6,6) = 189189.d0/4194304.d0
      bnd8AC(6,7) = -45045.d0/4194304.d0
      bnd8AC(6,8) = 5005.d0/4194304.d0
      bnd8AC(7,1) = -2457.d0/4194304.d0
      bnd8AC(7,2) = 28665.d0/4194304.d0
      bnd8AC(7,3) = -257985.d0/4194304.d0
      bnd8AC(7,4) = -429975.d0/4194304.d0
      bnd8AC(7,5) = 143325.d0/4194304.d0
      bnd8AC(7,6) = -51597.d0/4194304.d0
      bnd8AC(7,7) = 12285.d0/4194304.d0
      bnd8AC(7,8) = -1365.d0/4194304.d0
      bnd8AC(8,1) = 297.d0/4194304.d0
      bnd8AC(8,2) = -3465.d0/4194304.d0
      bnd8AC(8,3) = 31185.d0/4194304.d0
      bnd8AC(8,4) = 51975.d0/4194304.d0
      bnd8AC(8,5) = -17325.d0/4194304.d0
      bnd8AC(8,6) = 6237.d0/4194304.d0
      bnd8AC(8,7) = -1485.d0/4194304.d0
      bnd8AC(8,8) = 165.d0/4194304.d0
!
      bnd8AD(1,1) = -2145.d0/4194304.d0
      bnd8AD(1,2) = 21021.d0/4194304.d0
      bnd8AD(1,3) = -105105.d0/4194304.d0
      bnd8AD(1,4) = 525525.d0/4194304.d0
      bnd8AD(1,5) = 525525.d0/4194304.d0
      bnd8AD(1,6) = -105105.d0/4194304.d0
      bnd8AD(1,7) = 21021.d0/4194304.d0
      bnd8AD(1,8) = -2145.d0/4194304.d0
      bnd8AD(2,1) = -15015.d0/4194304.d0
      bnd8AD(2,2) = 147147.d0/4194304.d0
      bnd8AD(2,3) = -735735.d0/4194304.d0
      bnd8AD(2,4) = 3678675.d0/4194304.d0
      bnd8AD(2,5) = 3678675.d0/4194304.d0
      bnd8AD(2,6) = -735735.d0/4194304.d0
      bnd8AD(2,7) = 147147.d0/4194304.d0
      bnd8AD(2,8) = -15015.d0/4194304.d0
      bnd8AD(3,1) = 15015.d0/4194304.d0
      bnd8AD(3,2) = -147147.d0/4194304.d0
      bnd8AD(3,3) = 735735.d0/4194304.d0
      bnd8AD(3,4) = -3678675.d0/4194304.d0
      bnd8AD(3,5) = -3678675.d0/4194304.d0
      bnd8AD(3,6) = 735735.d0/4194304.d0
      bnd8AD(3,7) = -147147.d0/4194304.d0
      bnd8AD(3,8) = 15015.d0/4194304.d0
      bnd8AD(4,1) = -15015.d0/4194304.d0
      bnd8AD(4,2) = 147147.d0/4194304.d0
      bnd8AD(4,3) = -735735.d0/4194304.d0
      bnd8AD(4,4) = 3678675.d0/4194304.d0
      bnd8AD(4,5) = 3678675.d0/4194304.d0
      bnd8AD(4,6) = -735735.d0/4194304.d0
      bnd8AD(4,7) = 147147.d0/4194304.d0
      bnd8AD(4,8) = -15015.d0/4194304.d0
      bnd8AD(5,1) = 10725.d0/4194304.d0
      bnd8AD(5,2) = -105105.d0/4194304.d0
      bnd8AD(5,3) = 525525.d0/4194304.d0
      bnd8AD(5,4) = -2627625.d0/4194304.d0
      bnd8AD(5,5) = -2627625.d0/4194304.d0
      bnd8AD(5,6) = 525525.d0/4194304.d0
      bnd8AD(5,7) = -105105.d0/4194304.d0
      bnd8AD(5,8) = 10725.d0/4194304.d0
      bnd8AD(6,1) = -5005.d0/4194304.d0
      bnd8AD(6,2) = 49049.d0/4194304.d0
      bnd8AD(6,3) = -245245.d0/4194304.d0
      bnd8AD(6,4) = 1226225.d0/4194304.d0
      bnd8AD(6,5) = 1226225.d0/4194304.d0
      bnd8AD(6,6) = -245245.d0/4194304.d0
      bnd8AD(6,7) = 49049.d0/4194304.d0
      bnd8AD(6,8) = -5005.d0/4194304.d0
      bnd8AD(7,1) = 1365.d0/4194304.d0
      bnd8AD(7,2) = -13377.d0/4194304.d0
      bnd8AD(7,3) = 66885.d0/4194304.d0
      bnd8AD(7,4) = -334425.d0/4194304.d0
      bnd8AD(7,5) = -334425.d0/4194304.d0
      bnd8AD(7,6) = 66885.d0/4194304.d0
      bnd8AD(7,7) = -13377.d0/4194304.d0
      bnd8AD(7,8) = 1365.d0/4194304.d0
      bnd8AD(8,1) = -165.d0/4194304.d0
      bnd8AD(8,2) = 1617.d0/4194304.d0
      bnd8AD(8,3) = -8085.d0/4194304.d0
      bnd8AD(8,4) = 40425.d0/4194304.d0
      bnd8AD(8,5) = 40425.d0/4194304.d0
      bnd8AD(8,6) = -8085.d0/4194304.d0
      bnd8AD(8,7) = 1617.d0/4194304.d0
      bnd8AD(8,8) = -165.d0/4194304.d0
!
      bnd8BB(1,1) = 1089.d0/4194304.d0
      bnd8BB(1,2) = -22869.d0/4194304.d0
      bnd8BB(1,3) = -68607.d0/4194304.d0
      bnd8BB(1,4) = 38115.d0/4194304.d0
      bnd8BB(1,5) = -22869.d0/4194304.d0
      bnd8BB(1,6) = 9801.d0/4194304.d0
      bnd8BB(1,7) = -2541.d0/4194304.d0
      bnd8BB(1,8) = 297.d0/4194304.d0
      bnd8BB(2,1) = -22869.d0/4194304.d0
      bnd8BB(2,2) = 480249.d0/4194304.d0
      bnd8BB(2,3) = 1440747.d0/4194304.d0
      bnd8BB(2,4) = -800415.d0/4194304.d0
      bnd8BB(2,5) = 480249.d0/4194304.d0
      bnd8BB(2,6) = -205821.d0/4194304.d0
      bnd8BB(2,7) = 53361.d0/4194304.d0
      bnd8BB(2,8) = -6237.d0/4194304.d0
      bnd8BB(3,1) = -68607.d0/4194304.d0
      bnd8BB(3,2) = 1440747.d0/4194304.d0
      bnd8BB(3,3) = 4322241.d0/4194304.d0
      bnd8BB(3,4) = -2401245.d0/4194304.d0
      bnd8BB(3,5) = 1440747.d0/4194304.d0
      bnd8BB(3,6) = -617463.d0/4194304.d0
      bnd8BB(3,7) = 160083.d0/4194304.d0
      bnd8BB(3,8) = -18711.d0/4194304.d0
      bnd8BB(4,1) = 38115.d0/4194304.d0
      bnd8BB(4,2) = -800415.d0/4194304.d0
      bnd8BB(4,3) = -2401245.d0/4194304.d0
      bnd8BB(4,4) = 1334025.d0/4194304.d0
      bnd8BB(4,5) = -800415.d0/4194304.d0
      bnd8BB(4,6) = 343035.d0/4194304.d0
      bnd8BB(4,7) = -88935.d0/4194304.d0
      bnd8BB(4,8) = 10395.d0/4194304.d0
      bnd8BB(5,1) = -22869.d0/4194304.d0
      bnd8BB(5,2) = 480249.d0/4194304.d0
      bnd8BB(5,3) = 1440747.d0/4194304.d0
      bnd8BB(5,4) = -800415.d0/4194304.d0
      bnd8BB(5,5) = 480249.d0/4194304.d0
      bnd8BB(5,6) = -205821.d0/4194304.d0
      bnd8BB(5,7) = 53361.d0/4194304.d0
      bnd8BB(5,8) = -6237.d0/4194304.d0
      bnd8BB(6,1) = 9801.d0/4194304.d0
      bnd8BB(6,2) = -205821.d0/4194304.d0
      bnd8BB(6,3) = -617463.d0/4194304.d0
      bnd8BB(6,4) = 343035.d0/4194304.d0
      bnd8BB(6,5) = -205821.d0/4194304.d0
      bnd8BB(6,6) = 88209.d0/4194304.d0
      bnd8BB(6,7) = -22869.d0/4194304.d0
      bnd8BB(6,8) = 2673.d0/4194304.d0
      bnd8BB(7,1) = -2541.d0/4194304.d0
      bnd8BB(7,2) = 53361.d0/4194304.d0
      bnd8BB(7,3) = 160083.d0/4194304.d0
      bnd8BB(7,4) = -88935.d0/4194304.d0
      bnd8BB(7,5) = 53361.d0/4194304.d0
      bnd8BB(7,6) = -22869.d0/4194304.d0
      bnd8BB(7,7) = 5929.d0/4194304.d0
      bnd8BB(7,8) = -693.d0/4194304.d0
      bnd8BB(8,1) = 297.d0/4194304.d0
      bnd8BB(8,2) = -6237.d0/4194304.d0
      bnd8BB(8,3) = -18711.d0/4194304.d0
      bnd8BB(8,4) = 10395.d0/4194304.d0
      bnd8BB(8,5) = -6237.d0/4194304.d0
      bnd8BB(8,6) = 2673.d0/4194304.d0
      bnd8BB(8,7) = -693.d0/4194304.d0
      bnd8BB(8,8) = 81.d0/4194304.d0
!
      bnd8BC(1,1) = -297.d0/4194304.d0
      bnd8BC(1,2) = 3465.d0/4194304.d0
      bnd8BC(1,3) = -31185.d0/4194304.d0
      bnd8BC(1,4) = -51975.d0/4194304.d0
      bnd8BC(1,5) = 17325.d0/4194304.d0
      bnd8BC(1,6) = -6237.d0/4194304.d0
      bnd8BC(1,7) = 1485.d0/4194304.d0
      bnd8BC(1,8) = -165.d0/4194304.d0
      bnd8BC(2,1) = 6237.d0/4194304.d0
      bnd8BC(2,2) = -72765.d0/4194304.d0
      bnd8BC(2,3) = 654885.d0/4194304.d0
      bnd8BC(2,4) = 1091475.d0/4194304.d0
      bnd8BC(2,5) = -363825.d0/4194304.d0
      bnd8BC(2,6) = 130977.d0/4194304.d0
      bnd8BC(2,7) = -31185.d0/4194304.d0
      bnd8BC(2,8) = 3465.d0/4194304.d0
      bnd8BC(3,1) = 18711.d0/4194304.d0
      bnd8BC(3,2) = -218295.d0/4194304.d0
      bnd8BC(3,3) = 1964655.d0/4194304.d0
      bnd8BC(3,4) = 3274425.d0/4194304.d0
      bnd8BC(3,5) = -1091475.d0/4194304.d0
      bnd8BC(3,6) = 392931.d0/4194304.d0
      bnd8BC(3,7) = -93555.d0/4194304.d0
      bnd8BC(3,8) = 10395.d0/4194304.d0
      bnd8BC(4,1) = -10395.d0/4194304.d0
      bnd8BC(4,2) = 121275.d0/4194304.d0
      bnd8BC(4,3) = -1091475.d0/4194304.d0
      bnd8BC(4,4) = -1819125.d0/4194304.d0
      bnd8BC(4,5) = 606375.d0/4194304.d0
      bnd8BC(4,6) = -218295.d0/4194304.d0
      bnd8BC(4,7) = 51975.d0/4194304.d0
      bnd8BC(4,8) = -5775.d0/4194304.d0
      bnd8BC(5,1) = 6237.d0/4194304.d0
      bnd8BC(5,2) = -72765.d0/4194304.d0
      bnd8BC(5,3) = 654885.d0/4194304.d0
      bnd8BC(5,4) = 1091475.d0/4194304.d0
      bnd8BC(5,5) = -363825.d0/4194304.d0
      bnd8BC(5,6) = 130977.d0/4194304.d0
      bnd8BC(5,7) = -31185.d0/4194304.d0
      bnd8BC(5,8) = 3465.d0/4194304.d0
      bnd8BC(6,1) = -2673.d0/4194304.d0
      bnd8BC(6,2) = 31185.d0/4194304.d0
      bnd8BC(6,3) = -280665.d0/4194304.d0
      bnd8BC(6,4) = -467775.d0/4194304.d0
      bnd8BC(6,5) = 155925.d0/4194304.d0
      bnd8BC(6,6) = -56133.d0/4194304.d0
      bnd8BC(6,7) = 13365.d0/4194304.d0
      bnd8BC(6,8) = -1485.d0/4194304.d0
      bnd8BC(7,1) = 693.d0/4194304.d0
      bnd8BC(7,2) = -8085.d0/4194304.d0
      bnd8BC(7,3) = 72765.d0/4194304.d0
      bnd8BC(7,4) = 121275.d0/4194304.d0
      bnd8BC(7,5) = -40425.d0/4194304.d0
      bnd8BC(7,6) = 14553.d0/4194304.d0
      bnd8BC(7,7) = -3465.d0/4194304.d0
      bnd8BC(7,8) = 385.d0/4194304.d0
      bnd8BC(8,1) = -81.d0/4194304.d0
      bnd8BC(8,2) = 945.d0/4194304.d0
      bnd8BC(8,3) = -8505.d0/4194304.d0
      bnd8BC(8,4) = -14175.d0/4194304.d0
      bnd8BC(8,5) = 4725.d0/4194304.d0
      bnd8BC(8,6) = -1701.d0/4194304.d0
      bnd8BC(8,7) = 405.d0/4194304.d0
      bnd8BC(8,8) = -45.d0/4194304.d0
!
      bnd8BD(1,1) = 165.d0/4194304.d0
      bnd8BD(1,2) = -1617.d0/4194304.d0
      bnd8BD(1,3) = 8085.d0/4194304.d0
      bnd8BD(1,4) = -40425.d0/4194304.d0
      bnd8BD(1,5) = -40425.d0/4194304.d0
      bnd8BD(1,6) = 8085.d0/4194304.d0
      bnd8BD(1,7) = -1617.d0/4194304.d0
      bnd8BD(1,8) = 165.d0/4194304.d0
      bnd8BD(2,1) = -3465.d0/4194304.d0
      bnd8BD(2,2) = 33957.d0/4194304.d0
      bnd8BD(2,3) = -169785.d0/4194304.d0
      bnd8BD(2,4) = 848925.d0/4194304.d0
      bnd8BD(2,5) = 848925.d0/4194304.d0
      bnd8BD(2,6) = -169785.d0/4194304.d0
      bnd8BD(2,7) = 33957.d0/4194304.d0
      bnd8BD(2,8) = -3465.d0/4194304.d0
      bnd8BD(3,1) = -10395.d0/4194304.d0
      bnd8BD(3,2) = 101871.d0/4194304.d0
      bnd8BD(3,3) = -509355.d0/4194304.d0
      bnd8BD(3,4) = 2546775.d0/4194304.d0
      bnd8BD(3,5) = 2546775.d0/4194304.d0
      bnd8BD(3,6) = -509355.d0/4194304.d0
      bnd8BD(3,7) = 101871.d0/4194304.d0
      bnd8BD(3,8) = -10395.d0/4194304.d0
      bnd8BD(4,1) = 5775.d0/4194304.d0
      bnd8BD(4,2) = -56595.d0/4194304.d0
      bnd8BD(4,3) = 282975.d0/4194304.d0
      bnd8BD(4,4) = -1414875.d0/4194304.d0
      bnd8BD(4,5) = -1414875.d0/4194304.d0
      bnd8BD(4,6) = 282975.d0/4194304.d0
      bnd8BD(4,7) = -56595.d0/4194304.d0
      bnd8BD(4,8) = 5775.d0/4194304.d0
      bnd8BD(5,1) = -3465.d0/4194304.d0
      bnd8BD(5,2) = 33957.d0/4194304.d0
      bnd8BD(5,3) = -169785.d0/4194304.d0
      bnd8BD(5,4) = 848925.d0/4194304.d0
      bnd8BD(5,5) = 848925.d0/4194304.d0
      bnd8BD(5,6) = -169785.d0/4194304.d0
      bnd8BD(5,7) = 33957.d0/4194304.d0
      bnd8BD(5,8) = -3465.d0/4194304.d0
      bnd8BD(6,1) = 1485.d0/4194304.d0
      bnd8BD(6,2) = -14553.d0/4194304.d0
      bnd8BD(6,3) = 72765.d0/4194304.d0
      bnd8BD(6,4) = -363825.d0/4194304.d0
      bnd8BD(6,5) = -363825.d0/4194304.d0
      bnd8BD(6,6) = 72765.d0/4194304.d0
      bnd8BD(6,7) = -14553.d0/4194304.d0
      bnd8BD(6,8) = 1485.d0/4194304.d0
      bnd8BD(7,1) = -385.d0/4194304.d0
      bnd8BD(7,2) = 3773.d0/4194304.d0
      bnd8BD(7,3) = -18865.d0/4194304.d0
      bnd8BD(7,4) = 94325.d0/4194304.d0
      bnd8BD(7,5) = 94325.d0/4194304.d0
      bnd8BD(7,6) = -18865.d0/4194304.d0
      bnd8BD(7,7) = 3773.d0/4194304.d0
      bnd8BD(7,8) = -385.d0/4194304.d0
      bnd8BD(8,1) = 45.d0/4194304.d0
      bnd8BD(8,2) = -441.d0/4194304.d0
      bnd8BD(8,3) = 2205.d0/4194304.d0
      bnd8BD(8,4) = -11025.d0/4194304.d0
      bnd8BD(8,5) = -11025.d0/4194304.d0
      bnd8BD(8,6) = 2205.d0/4194304.d0
      bnd8BD(8,7) = -441.d0/4194304.d0
      bnd8BD(8,8) = 45.d0/4194304.d0
!
      bnd8CC(1,1) = 81.d0/4194304.d0
      bnd8CC(1,2) = -945.d0/4194304.d0
      bnd8CC(1,3) = 8505.d0/4194304.d0
      bnd8CC(1,4) = 14175.d0/4194304.d0
      bnd8CC(1,5) = -4725.d0/4194304.d0
      bnd8CC(1,6) = 1701.d0/4194304.d0
      bnd8CC(1,7) = -405.d0/4194304.d0
      bnd8CC(1,8) = 45.d0/4194304.d0
      bnd8CC(2,1) = -945.d0/4194304.d0
      bnd8CC(2,2) = 11025.d0/4194304.d0
      bnd8CC(2,3) = -99225.d0/4194304.d0
      bnd8CC(2,4) = -165375.d0/4194304.d0
      bnd8CC(2,5) = 55125.d0/4194304.d0
      bnd8CC(2,6) = -19845.d0/4194304.d0
      bnd8CC(2,7) = 4725.d0/4194304.d0
      bnd8CC(2,8) = -525.d0/4194304.d0
      bnd8CC(3,1) = 8505.d0/4194304.d0
      bnd8CC(3,2) = -99225.d0/4194304.d0
      bnd8CC(3,3) = 893025.d0/4194304.d0
      bnd8CC(3,4) = 1488375.d0/4194304.d0
      bnd8CC(3,5) = -496125.d0/4194304.d0
      bnd8CC(3,6) = 178605.d0/4194304.d0
      bnd8CC(3,7) = -42525.d0/4194304.d0
      bnd8CC(3,8) = 4725.d0/4194304.d0
      bnd8CC(4,1) = 14175.d0/4194304.d0
      bnd8CC(4,2) = -165375.d0/4194304.d0
      bnd8CC(4,3) = 1488375.d0/4194304.d0
      bnd8CC(4,4) = 2480625.d0/4194304.d0
      bnd8CC(4,5) = -826875.d0/4194304.d0
      bnd8CC(4,6) = 297675.d0/4194304.d0
      bnd8CC(4,7) = -70875.d0/4194304.d0
      bnd8CC(4,8) = 7875.d0/4194304.d0
      bnd8CC(5,1) = -4725.d0/4194304.d0
      bnd8CC(5,2) = 55125.d0/4194304.d0
      bnd8CC(5,3) = -496125.d0/4194304.d0
      bnd8CC(5,4) = -826875.d0/4194304.d0
      bnd8CC(5,5) = 275625.d0/4194304.d0
      bnd8CC(5,6) = -99225.d0/4194304.d0
      bnd8CC(5,7) = 23625.d0/4194304.d0
      bnd8CC(5,8) = -2625.d0/4194304.d0
      bnd8CC(6,1) = 1701.d0/4194304.d0
      bnd8CC(6,2) = -19845.d0/4194304.d0
      bnd8CC(6,3) = 178605.d0/4194304.d0
      bnd8CC(6,4) = 297675.d0/4194304.d0
      bnd8CC(6,5) = -99225.d0/4194304.d0
      bnd8CC(6,6) = 35721.d0/4194304.d0
      bnd8CC(6,7) = -8505.d0/4194304.d0
      bnd8CC(6,8) = 945.d0/4194304.d0
      bnd8CC(7,1) = -405.d0/4194304.d0
      bnd8CC(7,2) = 4725.d0/4194304.d0
      bnd8CC(7,3) = -42525.d0/4194304.d0
      bnd8CC(7,4) = -70875.d0/4194304.d0
      bnd8CC(7,5) = 23625.d0/4194304.d0
      bnd8CC(7,6) = -8505.d0/4194304.d0
      bnd8CC(7,7) = 2025.d0/4194304.d0
      bnd8CC(7,8) = -225.d0/4194304.d0
      bnd8CC(8,1) = 45.d0/4194304.d0
      bnd8CC(8,2) = -525.d0/4194304.d0
      bnd8CC(8,3) = 4725.d0/4194304.d0
      bnd8CC(8,4) = 7875.d0/4194304.d0
      bnd8CC(8,5) = -2625.d0/4194304.d0
      bnd8CC(8,6) = 945.d0/4194304.d0
      bnd8CC(8,7) = -225.d0/4194304.d0
      bnd8CC(8,8) = 25.d0/4194304.d0
!
      bnd8CD(1,1) = -45.d0/4194304.d0
      bnd8CD(1,2) = 441.d0/4194304.d0
      bnd8CD(1,3) = -2205.d0/4194304.d0
      bnd8CD(1,4) = 11025.d0/4194304.d0
      bnd8CD(1,5) = 11025.d0/4194304.d0
      bnd8CD(1,6) = -2205.d0/4194304.d0
      bnd8CD(1,7) = 441.d0/4194304.d0
      bnd8CD(1,8) = -45.d0/4194304.d0
      bnd8CD(2,1) = 525.d0/4194304.d0
      bnd8CD(2,2) = -5145.d0/4194304.d0
      bnd8CD(2,3) = 25725.d0/4194304.d0
      bnd8CD(2,4) = -128625.d0/4194304.d0
      bnd8CD(2,5) = -128625.d0/4194304.d0
      bnd8CD(2,6) = 25725.d0/4194304.d0
      bnd8CD(2,7) = -5145.d0/4194304.d0
      bnd8CD(2,8) = 525.d0/4194304.d0
      bnd8CD(3,1) = -4725.d0/4194304.d0
      bnd8CD(3,2) = 46305.d0/4194304.d0
      bnd8CD(3,3) = -231525.d0/4194304.d0
      bnd8CD(3,4) = 1157625.d0/4194304.d0
      bnd8CD(3,5) = 1157625.d0/4194304.d0
      bnd8CD(3,6) = -231525.d0/4194304.d0
      bnd8CD(3,7) = 46305.d0/4194304.d0
      bnd8CD(3,8) = -4725.d0/4194304.d0
      bnd8CD(4,1) = -7875.d0/4194304.d0
      bnd8CD(4,2) = 77175.d0/4194304.d0
      bnd8CD(4,3) = -385875.d0/4194304.d0
      bnd8CD(4,4) = 1929375.d0/4194304.d0
      bnd8CD(4,5) = 1929375.d0/4194304.d0
      bnd8CD(4,6) = -385875.d0/4194304.d0
      bnd8CD(4,7) = 77175.d0/4194304.d0
      bnd8CD(4,8) = -7875.d0/4194304.d0
      bnd8CD(5,1) = 2625.d0/4194304.d0
      bnd8CD(5,2) = -25725.d0/4194304.d0
      bnd8CD(5,3) = 128625.d0/4194304.d0
      bnd8CD(5,4) = -643125.d0/4194304.d0
      bnd8CD(5,5) = -643125.d0/4194304.d0
      bnd8CD(5,6) = 128625.d0/4194304.d0
      bnd8CD(5,7) = -25725.d0/4194304.d0
      bnd8CD(5,8) = 2625.d0/4194304.d0
      bnd8CD(6,1) = -945.d0/4194304.d0
      bnd8CD(6,2) = 9261.d0/4194304.d0
      bnd8CD(6,3) = -46305.d0/4194304.d0
      bnd8CD(6,4) = 231525.d0/4194304.d0
      bnd8CD(6,5) = 231525.d0/4194304.d0
      bnd8CD(6,6) = -46305.d0/4194304.d0
      bnd8CD(6,7) = 9261.d0/4194304.d0
      bnd8CD(6,8) = -945.d0/4194304.d0
      bnd8CD(7,1) = 225.d0/4194304.d0
      bnd8CD(7,2) = -2205.d0/4194304.d0
      bnd8CD(7,3) = 11025.d0/4194304.d0
      bnd8CD(7,4) = -55125.d0/4194304.d0
      bnd8CD(7,5) = -55125.d0/4194304.d0
      bnd8CD(7,6) = 11025.d0/4194304.d0
      bnd8CD(7,7) = -2205.d0/4194304.d0
      bnd8CD(7,8) = 225.d0/4194304.d0
      bnd8CD(8,1) = -25.d0/4194304.d0
      bnd8CD(8,2) = 245.d0/4194304.d0
      bnd8CD(8,3) = -1225.d0/4194304.d0
      bnd8CD(8,4) = 6125.d0/4194304.d0
      bnd8CD(8,5) = 6125.d0/4194304.d0
      bnd8CD(8,6) = -1225.d0/4194304.d0
      bnd8CD(8,7) = 245.d0/4194304.d0
      bnd8CD(8,8) = -25.d0/4194304.d0
!
      bnd8I(1,1) = 25.d0/4194304.d0
      bnd8I(1,2) = -245.d0/4194304.d0
      bnd8I(1,3) = 1225.d0/4194304.d0
      bnd8I(1,4) = -6125.d0/4194304.d0
      bnd8I(1,5) = -6125.d0/4194304.d0
      bnd8I(1,6) = 1225.d0/4194304.d0
      bnd8I(1,7) = -245.d0/4194304.d0
      bnd8I(1,8) = 25.d0/4194304.d0
      bnd8I(2,1) = -245.d0/4194304.d0
      bnd8I(2,2) = 2401.d0/4194304.d0
      bnd8I(2,3) = -12005.d0/4194304.d0
      bnd8I(2,4) = 60025.d0/4194304.d0
      bnd8I(2,5) = 60025.d0/4194304.d0
      bnd8I(2,6) = -12005.d0/4194304.d0
      bnd8I(2,7) = 2401.d0/4194304.d0
      bnd8I(2,8) = -245.d0/4194304.d0
      bnd8I(3,1) = 1225.d0/4194304.d0
      bnd8I(3,2) = -12005.d0/4194304.d0
      bnd8I(3,3) = 60025.d0/4194304.d0
      bnd8I(3,4) = -300125.d0/4194304.d0
      bnd8I(3,5) = -300125.d0/4194304.d0
      bnd8I(3,6) = 60025.d0/4194304.d0
      bnd8I(3,7) = -12005.d0/4194304.d0
      bnd8I(3,8) = 1225.d0/4194304.d0
      bnd8I(4,1) = -6125.d0/4194304.d0
      bnd8I(4,2) = 60025.d0/4194304.d0
      bnd8I(4,3) = -300125.d0/4194304.d0
      bnd8I(4,4) = 1500625.d0/4194304.d0
      bnd8I(4,5) = 1500625.d0/4194304.d0
      bnd8I(4,6) = -300125.d0/4194304.d0
      bnd8I(4,7) = 60025.d0/4194304.d0
      bnd8I(4,8) = -6125.d0/4194304.d0
      bnd8I(5,1) = -6125.d0/4194304.d0
      bnd8I(5,2) = 60025.d0/4194304.d0
      bnd8I(5,3) = -300125.d0/4194304.d0
      bnd8I(5,4) = 1500625.d0/4194304.d0
      bnd8I(5,5) = 1500625.d0/4194304.d0
      bnd8I(5,6) = -300125.d0/4194304.d0
      bnd8I(5,7) = 60025.d0/4194304.d0
      bnd8I(5,8) = -6125.d0/4194304.d0
      bnd8I(6,1) = 1225.d0/4194304.d0
      bnd8I(6,2) = -12005.d0/4194304.d0
      bnd8I(6,3) = 60025.d0/4194304.d0
      bnd8I(6,4) = -300125.d0/4194304.d0
      bnd8I(6,5) = -300125.d0/4194304.d0
      bnd8I(6,6) = 60025.d0/4194304.d0
      bnd8I(6,7) = -12005.d0/4194304.d0
      bnd8I(6,8) = 1225.d0/4194304.d0
      bnd8I(7,1) = -245.d0/4194304.d0
      bnd8I(7,2) = 2401.d0/4194304.d0
      bnd8I(7,3) = -12005.d0/4194304.d0
      bnd8I(7,4) = 60025.d0/4194304.d0
      bnd8I(7,5) = 60025.d0/4194304.d0
      bnd8I(7,6) = -12005.d0/4194304.d0
      bnd8I(7,7) = 2401.d0/4194304.d0
      bnd8I(7,8) = -245.d0/4194304.d0
      bnd8I(8,1) = 25.d0/4194304.d0
      bnd8I(8,2) = -245.d0/4194304.d0
      bnd8I(8,3) = 1225.d0/4194304.d0
      bnd8I(8,4) = -6125.d0/4194304.d0
      bnd8I(8,5) = -6125.d0/4194304.d0
      bnd8I(8,6) = 1225.d0/4194304.d0
      bnd8I(8,7) = -245.d0/4194304.d0
      bnd8I(8,8) = 25.d0/4194304.d0
!
! 10th-order
!
      bnd10AA(1,1) = 147744025.d0/4294967296.d0
      bnd10AA(1,2) = 1329696225.d0/4294967296.d0
      bnd10AA(1,3) = -1772928300.d0/4294967296.d0
      bnd10AA(1,4) = 2482099620.d0/4294967296.d0
      bnd10AA(1,5) = -2659392450.d0/4294967296.d0
      bnd10AA(1,6) = 2068416350.d0/4294967296.d0
      bnd10AA(1,7) = -1128227100.d0/4294967296.d0
      bnd10AA(1,8) = 409137300.d0/4294967296.d0
      bnd10AA(1,9) = -88646415.d0/4294967296.d0
      bnd10AA(1,10) = 8690825.d0/4294967296.d0
      bnd10AA(2,1) = 1329696225.d0/4294967296.d0
      bnd10AA(2,2) = 11967266025.d0/4294967296.d0
      bnd10AA(2,3) = -15956354700.d0/4294967296.d0
      bnd10AA(2,4) = 22338896580.d0/4294967296.d0
      bnd10AA(2,5) = -23934532050.d0/4294967296.d0
      bnd10AA(2,6) = 18615747150.d0/4294967296.d0
      bnd10AA(2,7) = -10154043900.d0/4294967296.d0
      bnd10AA(2,8) = 3682235700.d0/4294967296.d0
      bnd10AA(2,9) = -797817735.d0/4294967296.d0
      bnd10AA(2,10) = 78217425.d0/4294967296.d0
      bnd10AA(3,1) = -1772928300.d0/4294967296.d0
      bnd10AA(3,2) = -15956354700.d0/4294967296.d0
      bnd10AA(3,3) = 21275139600.d0/4294967296.d0
      bnd10AA(3,4) = -29785195440.d0/4294967296.d0
      bnd10AA(3,5) = 31912709400.d0/4294967296.d0
      bnd10AA(3,6) = -24820996200.d0/4294967296.d0
      bnd10AA(3,7) = 13538725200.d0/4294967296.d0
      bnd10AA(3,8) = -4909647600.d0/4294967296.d0
      bnd10AA(3,9) = 1063756980.d0/4294967296.d0
      bnd10AA(3,10) = -104289900.d0/4294967296.d0
      bnd10AA(4,1) = 2482099620.d0/4294967296.d0
      bnd10AA(4,2) = 22338896580.d0/4294967296.d0
      bnd10AA(4,3) = -29785195440.d0/4294967296.d0
      bnd10AA(4,4) = 41699273616.d0/4294967296.d0
      bnd10AA(4,5) = -44677793160.d0/4294967296.d0
      bnd10AA(4,6) = 34749394680.d0/4294967296.d0
      bnd10AA(4,7) = -18954215280.d0/4294967296.d0
      bnd10AA(4,8) = 6873506640.d0/4294967296.d0
      bnd10AA(4,9) = -1489259772.d0/4294967296.d0
      bnd10AA(4,10) = 146005860.d0/4294967296.d0
      bnd10AA(5,1) = -2659392450.d0/4294967296.d0
      bnd10AA(5,2) = -23934532050.d0/4294967296.d0
      bnd10AA(5,3) = 31912709400.d0/4294967296.d0
      bnd10AA(5,4) = -44677793160.d0/4294967296.d0
      bnd10AA(5,5) = 47869064100.d0/4294967296.d0
      bnd10AA(5,6) = -37231494300.d0/4294967296.d0
      bnd10AA(5,7) = 20308087800.d0/4294967296.d0
      bnd10AA(5,8) = -7364471400.d0/4294967296.d0
      bnd10AA(5,9) = 1595635470.d0/4294967296.d0
      bnd10AA(5,10) = -156434850.d0/4294967296.d0
      bnd10AA(6,1) = 2068416350.d0/4294967296.d0
      bnd10AA(6,2) = 18615747150.d0/4294967296.d0
      bnd10AA(6,3) = -24820996200.d0/4294967296.d0
      bnd10AA(6,4) = 34749394680.d0/4294967296.d0
      bnd10AA(6,5) = -37231494300.d0/4294967296.d0
      bnd10AA(6,6) = 28957828900.d0/4294967296.d0
      bnd10AA(6,7) = -15795179400.d0/4294967296.d0
      bnd10AA(6,8) = 5727922200.d0/4294967296.d0
      bnd10AA(6,9) = -1241049810.d0/4294967296.d0
      bnd10AA(6,10) = 121671550.d0/4294967296.d0
      bnd10AA(7,1) = -1128227100.d0/4294967296.d0
      bnd10AA(7,2) = -10154043900.d0/4294967296.d0
      bnd10AA(7,3) = 13538725200.d0/4294967296.d0
      bnd10AA(7,4) = -18954215280.d0/4294967296.d0
      bnd10AA(7,5) = 20308087800.d0/4294967296.d0
      bnd10AA(7,6) = -15795179400.d0/4294967296.d0
      bnd10AA(7,7) = 8615552400.d0/4294967296.d0
      bnd10AA(7,8) = -3124321200.d0/4294967296.d0
      bnd10AA(7,9) = 676936260.d0/4294967296.d0
      bnd10AA(7,10) = -66366300.d0/4294967296.d0
      bnd10AA(8,1) = 409137300.d0/4294967296.d0
      bnd10AA(8,2) = 3682235700.d0/4294967296.d0
      bnd10AA(8,3) = -4909647600.d0/4294967296.d0
      bnd10AA(8,4) = 6873506640.d0/4294967296.d0
      bnd10AA(8,5) = -7364471400.d0/4294967296.d0
      bnd10AA(8,6) = 5727922200.d0/4294967296.d0
      bnd10AA(8,7) = -3124321200.d0/4294967296.d0
      bnd10AA(8,8) = 1132995600.d0/4294967296.d0
      bnd10AA(8,9) = -245482380.d0/4294967296.d0
      bnd10AA(8,10) = 24066900.d0/4294967296.d0
      bnd10AA(9,1) = -88646415.d0/4294967296.d0
      bnd10AA(9,2) = -797817735.d0/4294967296.d0
      bnd10AA(9,3) = 1063756980.d0/4294967296.d0
      bnd10AA(9,4) = -1489259772.d0/4294967296.d0
      bnd10AA(9,5) = 1595635470.d0/4294967296.d0
      bnd10AA(9,6) = -1241049810.d0/4294967296.d0
      bnd10AA(9,7) = 676936260.d0/4294967296.d0
      bnd10AA(9,8) = -245482380.d0/4294967296.d0
      bnd10AA(9,9) = 53187849.d0/4294967296.d0
      bnd10AA(9,10) = -5214495.d0/4294967296.d0
      bnd10AA(10,1) = 8690825.d0/4294967296.d0
      bnd10AA(10,2) = 78217425.d0/4294967296.d0
      bnd10AA(10,3) = -104289900.d0/4294967296.d0
      bnd10AA(10,4) = 146005860.d0/4294967296.d0
      bnd10AA(10,5) = -156434850.d0/4294967296.d0
      bnd10AA(10,6) = 121671550.d0/4294967296.d0
      bnd10AA(10,7) = -66366300.d0/4294967296.d0
      bnd10AA(10,8) = 24066900.d0/4294967296.d0
      bnd10AA(10,9) = -5214495.d0/4294967296.d0
      bnd10AA(10,10) = 511225.d0/4294967296.d0
!
      bnd10AB(1,1) = -8690825.d0/4294967296.d0
      bnd10AB(1,2) = 234652275.d0/4294967296.d0
      bnd10AB(1,3) = 938609100.d0/4294967296.d0
      bnd10AB(1,4) = -730029300.d0/4294967296.d0
      bnd10AB(1,5) = 657026370.d0/4294967296.d0
      bnd10AB(1,6) = -469304550.d0/4294967296.d0
      bnd10AB(1,7) = 243343100.d0/4294967296.d0
      bnd10AB(1,8) = -85328100.d0/4294967296.d0
      bnd10AB(1,9) = 18050175.d0/4294967296.d0
      bnd10AB(1,10) = -1738165.d0/4294967296.d0
      bnd10AB(2,1) = -78217425.d0/4294967296.d0
      bnd10AB(2,2) = 2111870475.d0/4294967296.d0
      bnd10AB(2,3) = 8447481900.d0/4294967296.d0
      bnd10AB(2,4) = -6570263700.d0/4294967296.d0
      bnd10AB(2,5) = 5913237330.d0/4294967296.d0
      bnd10AB(2,6) = -4223740950.d0/4294967296.d0
      bnd10AB(2,7) = 2190087900.d0/4294967296.d0
      bnd10AB(2,8) = -767952900.d0/4294967296.d0
      bnd10AB(2,9) = 162451575.d0/4294967296.d0
      bnd10AB(2,10) = -15643485.d0/4294967296.d0
      bnd10AB(3,1) = 104289900.d0/4294967296.d0
      bnd10AB(3,2) = -2815827300.d0/4294967296.d0
      bnd10AB(3,3) = -11263309200.d0/4294967296.d0
      bnd10AB(3,4) = 8760351600.d0/4294967296.d0
      bnd10AB(3,5) = -7884316440.d0/4294967296.d0
      bnd10AB(3,6) = 5631654600.d0/4294967296.d0
      bnd10AB(3,7) = -2920117200.d0/4294967296.d0
      bnd10AB(3,8) = 1023937200.d0/4294967296.d0
      bnd10AB(3,9) = -216602100.d0/4294967296.d0
      bnd10AB(3,10) = 20857980.d0/4294967296.d0
      bnd10AB(4,1) = -146005860.d0/4294967296.d0
      bnd10AB(4,2) = 3942158220.d0/4294967296.d0
      bnd10AB(4,3) = 15768632880.d0/4294967296.d0
      bnd10AB(4,4) = -12264492240.d0/4294967296.d0
      bnd10AB(4,5) = 11038043016.d0/4294967296.d0
      bnd10AB(4,6) = -7884316440.d0/4294967296.d0
      bnd10AB(4,7) = 4088164080.d0/4294967296.d0
      bnd10AB(4,8) = -1433512080.d0/4294967296.d0
      bnd10AB(4,9) = 303242940.d0/4294967296.d0
      bnd10AB(4,10) = -29201172.d0/4294967296.d0
      bnd10AB(5,1) = 156434850.d0/4294967296.d0
      bnd10AB(5,2) = -4223740950.d0/4294967296.d0
      bnd10AB(5,3) = -16894963800.d0/4294967296.d0
      bnd10AB(5,4) = 13140527400.d0/4294967296.d0
      bnd10AB(5,5) = -11826474660.d0/4294967296.d0
      bnd10AB(5,6) = 8447481900.d0/4294967296.d0
      bnd10AB(5,7) = -4380175800.d0/4294967296.d0
      bnd10AB(5,8) = 1535905800.d0/4294967296.d0
      bnd10AB(5,9) = -324903150.d0/4294967296.d0
      bnd10AB(5,10) = 31286970.d0/4294967296.d0
      bnd10AB(6,1) = -121671550.d0/4294967296.d0
      bnd10AB(6,2) = 3285131850.d0/4294967296.d0
      bnd10AB(6,3) = 13140527400.d0/4294967296.d0
      bnd10AB(6,4) = -10220410200.d0/4294967296.d0
      bnd10AB(6,5) = 9198369180.d0/4294967296.d0
      bnd10AB(6,6) = -6570263700.d0/4294967296.d0
      bnd10AB(6,7) = 3406803400.d0/4294967296.d0
      bnd10AB(6,8) = -1194593400.d0/4294967296.d0
      bnd10AB(6,9) = 252702450.d0/4294967296.d0
      bnd10AB(6,10) = -24334310.d0/4294967296.d0
      bnd10AB(7,1) = 66366300.d0/4294967296.d0
      bnd10AB(7,2) = -1791890100.d0/4294967296.d0
      bnd10AB(7,3) = -7167560400.d0/4294967296.d0
      bnd10AB(7,4) = 5574769200.d0/4294967296.d0
      bnd10AB(7,5) = -5017292280.d0/4294967296.d0
      bnd10AB(7,6) = 3583780200.d0/4294967296.d0
      bnd10AB(7,7) = -1858256400.d0/4294967296.d0
      bnd10AB(7,8) = 651596400.d0/4294967296.d0
      bnd10AB(7,9) = -137837700.d0/4294967296.d0
      bnd10AB(7,10) = 13273260.d0/4294967296.d0
      bnd10AB(8,1) = -24066900.d0/4294967296.d0
      bnd10AB(8,2) = 649806300.d0/4294967296.d0
      bnd10AB(8,3) = 2599225200.d0/4294967296.d0
      bnd10AB(8,4) = -2021619600.d0/4294967296.d0
      bnd10AB(8,5) = 1819457640.d0/4294967296.d0
      bnd10AB(8,6) = -1299612600.d0/4294967296.d0
      bnd10AB(8,7) = 673873200.d0/4294967296.d0
      bnd10AB(8,8) = -236293200.d0/4294967296.d0
      bnd10AB(8,9) = 49985100.d0/4294967296.d0
      bnd10AB(8,10) = -4813380.d0/4294967296.d0
      bnd10AB(9,1) = 5214495.d0/4294967296.d0
      bnd10AB(9,2) = -140791365.d0/4294967296.d0
      bnd10AB(9,3) = -563165460.d0/4294967296.d0
      bnd10AB(9,4) = 438017580.d0/4294967296.d0
      bnd10AB(9,5) = -394215822.d0/4294967296.d0
      bnd10AB(9,6) = 281582730.d0/4294967296.d0
      bnd10AB(9,7) = -146005860.d0/4294967296.d0
      bnd10AB(9,8) = 51196860.d0/4294967296.d0
      bnd10AB(9,9) = -10830105.d0/4294967296.d0
      bnd10AB(9,10) = 1042899.d0/4294967296.d0
      bnd10AB(10,1) = -511225.d0/4294967296.d0
      bnd10AB(10,2) = 13803075.d0/4294967296.d0
      bnd10AB(10,3) = 55212300.d0/4294967296.d0
      bnd10AB(10,4) = -42942900.d0/4294967296.d0
      bnd10AB(10,5) = 38648610.d0/4294967296.d0
      bnd10AB(10,6) = -27606150.d0/4294967296.d0
      bnd10AB(10,7) = 14314300.d0/4294967296.d0
      bnd10AB(10,8) = -5019300.d0/4294967296.d0
      bnd10AB(10,9) = 1061775.d0/4294967296.d0
      bnd10AB(10,10) = -102245.d0/4294967296.d0
!
      bnd10AC(1,1) = 1738165.d0/4294967296.d0
      bnd10AC(1,2) = -26072475.d0/4294967296.d0
      bnd10AC(1,3) = 312869700.d0/4294967296.d0
      bnd10AC(1,4) = 730029300.d0/4294967296.d0
      bnd10AC(1,5) = -365014650.d0/4294967296.d0
      bnd10AC(1,6) = 219008790.d0/4294967296.d0
      bnd10AC(1,7) = -104289900.d0/4294967296.d0
      bnd10AC(1,8) = 34763300.d0/4294967296.d0
      bnd10AC(1,9) = -7110675.d0/4294967296.d0
      bnd10AC(1,10) = 668525.d0/4294967296.d0
      bnd10AC(2,1) = 15643485.d0/4294967296.d0
      bnd10AC(2,2) = -234652275.d0/4294967296.d0
      bnd10AC(2,3) = 2815827300.d0/4294967296.d0
      bnd10AC(2,4) = 6570263700.d0/4294967296.d0
      bnd10AC(2,5) = -3285131850.d0/4294967296.d0
      bnd10AC(2,6) = 1971079110.d0/4294967296.d0
      bnd10AC(2,7) = -938609100.d0/4294967296.d0
      bnd10AC(2,8) = 312869700.d0/4294967296.d0
      bnd10AC(2,9) = -63996075.d0/4294967296.d0
      bnd10AC(2,10) = 6016725.d0/4294967296.d0
      bnd10AC(3,1) = -20857980.d0/4294967296.d0
      bnd10AC(3,2) = 312869700.d0/4294967296.d0
      bnd10AC(3,3) = -3754436400.d0/4294967296.d0
      bnd10AC(3,4) = -8760351600.d0/4294967296.d0
      bnd10AC(3,5) = 4380175800.d0/4294967296.d0
      bnd10AC(3,6) = -2628105480.d0/4294967296.d0
      bnd10AC(3,7) = 1251478800.d0/4294967296.d0
      bnd10AC(3,8) = -417159600.d0/4294967296.d0
      bnd10AC(3,9) = 85328100.d0/4294967296.d0
      bnd10AC(3,10) = -8022300.d0/4294967296.d0
      bnd10AC(4,1) = 29201172.d0/4294967296.d0
      bnd10AC(4,2) = -438017580.d0/4294967296.d0
      bnd10AC(4,3) = 5256210960.d0/4294967296.d0
      bnd10AC(4,4) = 12264492240.d0/4294967296.d0
      bnd10AC(4,5) = -6132246120.d0/4294967296.d0
      bnd10AC(4,6) = 3679347672.d0/4294967296.d0
      bnd10AC(4,7) = -1752070320.d0/4294967296.d0
      bnd10AC(4,8) = 584023440.d0/4294967296.d0
      bnd10AC(4,9) = -119459340.d0/4294967296.d0
      bnd10AC(4,10) = 11231220.d0/4294967296.d0
      bnd10AC(5,1) = -31286970.d0/4294967296.d0
      bnd10AC(5,2) = 469304550.d0/4294967296.d0
      bnd10AC(5,3) = -5631654600.d0/4294967296.d0
      bnd10AC(5,4) = -13140527400.d0/4294967296.d0
      bnd10AC(5,5) = 6570263700.d0/4294967296.d0
      bnd10AC(5,6) = -3942158220.d0/4294967296.d0
      bnd10AC(5,7) = 1877218200.d0/4294967296.d0
      bnd10AC(5,8) = -625739400.d0/4294967296.d0
      bnd10AC(5,9) = 127992150.d0/4294967296.d0
      bnd10AC(5,10) = -12033450.d0/4294967296.d0
      bnd10AC(6,1) = 24334310.d0/4294967296.d0
      bnd10AC(6,2) = -365014650.d0/4294967296.d0
      bnd10AC(6,3) = 4380175800.d0/4294967296.d0
      bnd10AC(6,4) = 10220410200.d0/4294967296.d0
      bnd10AC(6,5) = -5110205100.d0/4294967296.d0
      bnd10AC(6,6) = 3066123060.d0/4294967296.d0
      bnd10AC(6,7) = -1460058600.d0/4294967296.d0
      bnd10AC(6,8) = 486686200.d0/4294967296.d0
      bnd10AC(6,9) = -99549450.d0/4294967296.d0
      bnd10AC(6,10) = 9359350.d0/4294967296.d0
      bnd10AC(7,1) = -13273260.d0/4294967296.d0
      bnd10AC(7,2) = 199098900.d0/4294967296.d0
      bnd10AC(7,3) = -2389186800.d0/4294967296.d0
      bnd10AC(7,4) = -5574769200.d0/4294967296.d0
      bnd10AC(7,5) = 2787384600.d0/4294967296.d0
      bnd10AC(7,6) = -1672430760.d0/4294967296.d0
      bnd10AC(7,7) = 796395600.d0/4294967296.d0
      bnd10AC(7,8) = -265465200.d0/4294967296.d0
      bnd10AC(7,9) = 54299700.d0/4294967296.d0
      bnd10AC(7,10) = -5105100.d0/4294967296.d0
      bnd10AC(8,1) = 4813380.d0/4294967296.d0
      bnd10AC(8,2) = -72200700.d0/4294967296.d0
      bnd10AC(8,3) = 866408400.d0/4294967296.d0
      bnd10AC(8,4) = 2021619600.d0/4294967296.d0
      bnd10AC(8,5) = -1010809800.d0/4294967296.d0
      bnd10AC(8,6) = 606485880.d0/4294967296.d0
      bnd10AC(8,7) = -288802800.d0/4294967296.d0
      bnd10AC(8,8) = 96267600.d0/4294967296.d0
      bnd10AC(8,9) = -19691100.d0/4294967296.d0
      bnd10AC(8,10) = 1851300.d0/4294967296.d0
      bnd10AC(9,1) = -1042899.d0/4294967296.d0
      bnd10AC(9,2) = 15643485.d0/4294967296.d0
      bnd10AC(9,3) = -187721820.d0/4294967296.d0
      bnd10AC(9,4) = -438017580.d0/4294967296.d0
      bnd10AC(9,5) = 219008790.d0/4294967296.d0
      bnd10AC(9,6) = -131405274.d0/4294967296.d0
      bnd10AC(9,7) = 62573940.d0/4294967296.d0
      bnd10AC(9,8) = -20857980.d0/4294967296.d0
      bnd10AC(9,9) = 4266405.d0/4294967296.d0
      bnd10AC(9,10) = -401115.d0/4294967296.d0
      bnd10AC(10,1) = 102245.d0/4294967296.d0
      bnd10AC(10,2) = -1533675.d0/4294967296.d0
      bnd10AC(10,3) = 18404100.d0/4294967296.d0
      bnd10AC(10,4) = 42942900.d0/4294967296.d0
      bnd10AC(10,5) = -21471450.d0/4294967296.d0
      bnd10AC(10,6) = 12882870.d0/4294967296.d0
      bnd10AC(10,7) = -6134700.d0/4294967296.d0
      bnd10AC(10,8) = 2044900.d0/4294967296.d0
      bnd10AC(10,9) = -418275.d0/4294967296.d0
      bnd10AC(10,10) = 39325.d0/4294967296.d0
!
      bnd10AD(1,1) = -668525.d0/4294967296.d0
      bnd10AD(1,2) = 8423415.d0/4294967296.d0
      bnd10AD(1,3) = -56156100.d0/4294967296.d0
      bnd10AD(1,4) = 393092700.d0/4294967296.d0
      bnd10AD(1,5) = 589639050.d0/4294967296.d0
      bnd10AD(1,6) = -196546350.d0/4294967296.d0
      bnd10AD(1,7) = 78618540.d0/4294967296.d0
      bnd10AD(1,8) = -24066900.d0/4294967296.d0
      bnd10AD(1,9) = 4679675.d0/4294967296.d0
      bnd10AD(1,10) = -425425.d0/4294967296.d0
      bnd10AD(2,1) = -6016725.d0/4294967296.d0
      bnd10AD(2,2) = 75810735.d0/4294967296.d0
      bnd10AD(2,3) = -505404900.d0/4294967296.d0
      bnd10AD(2,4) = 3537834300.d0/4294967296.d0
      bnd10AD(2,5) = 5306751450.d0/4294967296.d0
      bnd10AD(2,6) = -1768917150.d0/4294967296.d0
      bnd10AD(2,7) = 707566860.d0/4294967296.d0
      bnd10AD(2,8) = -216602100.d0/4294967296.d0
      bnd10AD(2,9) = 42117075.d0/4294967296.d0
      bnd10AD(2,10) = -3828825.d0/4294967296.d0
      bnd10AD(3,1) = 8022300.d0/4294967296.d0
      bnd10AD(3,2) = -101080980.d0/4294967296.d0
      bnd10AD(3,3) = 673873200.d0/4294967296.d0
      bnd10AD(3,4) = -4717112400.d0/4294967296.d0
      bnd10AD(3,5) = -7075668600.d0/4294967296.d0
      bnd10AD(3,6) = 2358556200.d0/4294967296.d0
      bnd10AD(3,7) = -943422480.d0/4294967296.d0
      bnd10AD(3,8) = 288802800.d0/4294967296.d0
      bnd10AD(3,9) = -56156100.d0/4294967296.d0
      bnd10AD(3,10) = 5105100.d0/4294967296.d0
      bnd10AD(4,1) = -11231220.d0/4294967296.d0
      bnd10AD(4,2) = 141513372.d0/4294967296.d0
      bnd10AD(4,3) = -943422480.d0/4294967296.d0
      bnd10AD(4,4) = 6603957360.d0/4294967296.d0
      bnd10AD(4,5) = 9905936040.d0/4294967296.d0
      bnd10AD(4,6) = -3301978680.d0/4294967296.d0
      bnd10AD(4,7) = 1320791472.d0/4294967296.d0
      bnd10AD(4,8) = -404323920.d0/4294967296.d0
      bnd10AD(4,9) = 78618540.d0/4294967296.d0
      bnd10AD(4,10) = -7147140.d0/4294967296.d0
      bnd10AD(5,1) = 12033450.d0/4294967296.d0
      bnd10AD(5,2) = -151621470.d0/4294967296.d0
      bnd10AD(5,3) = 1010809800.d0/4294967296.d0
      bnd10AD(5,4) = -7075668600.d0/4294967296.d0
      bnd10AD(5,5) = -10613502900.d0/4294967296.d0
      bnd10AD(5,6) = 3537834300.d0/4294967296.d0
      bnd10AD(5,7) = -1415133720.d0/4294967296.d0
      bnd10AD(5,8) = 433204200.d0/4294967296.d0
      bnd10AD(5,9) = -84234150.d0/4294967296.d0
      bnd10AD(5,10) = 7657650.d0/4294967296.d0
      bnd10AD(6,1) = -9359350.d0/4294967296.d0
      bnd10AD(6,2) = 117927810.d0/4294967296.d0
      bnd10AD(6,3) = -786185400.d0/4294967296.d0
      bnd10AD(6,4) = 5503297800.d0/4294967296.d0
      bnd10AD(6,5) = 8254946700.d0/4294967296.d0
      bnd10AD(6,6) = -2751648900.d0/4294967296.d0
      bnd10AD(6,7) = 1100659560.d0/4294967296.d0
      bnd10AD(6,8) = -336936600.d0/4294967296.d0
      bnd10AD(6,9) = 65515450.d0/4294967296.d0
      bnd10AD(6,10) = -5955950.d0/4294967296.d0
      bnd10AD(7,1) = 5105100.d0/4294967296.d0
      bnd10AD(7,2) = -64324260.d0/4294967296.d0
      bnd10AD(7,3) = 428828400.d0/4294967296.d0
      bnd10AD(7,4) = -3001798800.d0/4294967296.d0
      bnd10AD(7,5) = -4502698200.d0/4294967296.d0
      bnd10AD(7,6) = 1500899400.d0/4294967296.d0
      bnd10AD(7,7) = -600359760.d0/4294967296.d0
      bnd10AD(7,8) = 183783600.d0/4294967296.d0
      bnd10AD(7,9) = -35735700.d0/4294967296.d0
      bnd10AD(7,10) = 3248700.d0/4294967296.d0
      bnd10AD(8,1) = -1851300.d0/4294967296.d0
      bnd10AD(8,2) = 23326380.d0/4294967296.d0
      bnd10AD(8,3) = -155509200.d0/4294967296.d0
      bnd10AD(8,4) = 1088564400.d0/4294967296.d0
      bnd10AD(8,5) = 1632846600.d0/4294967296.d0
      bnd10AD(8,6) = -544282200.d0/4294967296.d0
      bnd10AD(8,7) = 217712880.d0/4294967296.d0
      bnd10AD(8,8) = -66646800.d0/4294967296.d0
      bnd10AD(8,9) = 12959100.d0/4294967296.d0
      bnd10AD(8,10) = -1178100.d0/4294967296.d0
      bnd10AD(9,1) = 401115.d0/4294967296.d0
      bnd10AD(9,2) = -5054049.d0/4294967296.d0
      bnd10AD(9,3) = 33693660.d0/4294967296.d0
      bnd10AD(9,4) = -235855620.d0/4294967296.d0
      bnd10AD(9,5) = -353783430.d0/4294967296.d0
      bnd10AD(9,6) = 117927810.d0/4294967296.d0
      bnd10AD(9,7) = -47171124.d0/4294967296.d0
      bnd10AD(9,8) = 14440140.d0/4294967296.d0
      bnd10AD(9,9) = -2807805.d0/4294967296.d0
      bnd10AD(9,10) = 255255.d0/4294967296.d0
      bnd10AD(10,1) = -39325.d0/4294967296.d0
      bnd10AD(10,2) = 495495.d0/4294967296.d0
      bnd10AD(10,3) = -3303300.d0/4294967296.d0
      bnd10AD(10,4) = 23123100.d0/4294967296.d0
      bnd10AD(10,5) = 34684650.d0/4294967296.d0
      bnd10AD(10,6) = -11561550.d0/4294967296.d0
      bnd10AD(10,7) = 4624620.d0/4294967296.d0
      bnd10AD(10,8) = -1415700.d0/4294967296.d0
      bnd10AD(10,9) = 275275.d0/4294967296.d0
      bnd10AD(10,10) = -25025.d0/4294967296.d0
!
      bnd10AE(1,1) = 425425.d0/4294967296.d0
      bnd10AE(1,2) = -4922775.d0/4294967296.d0
      bnd10AE(1,3) = 27567540.d0/4294967296.d0
      bnd10AE(1,4) = -107207100.d0/4294967296.d0
      bnd10AE(1,5) = 482431950.d0/4294967296.d0
      bnd10AE(1,6) = 482431950.d0/4294967296.d0
      bnd10AE(1,7) = -107207100.d0/4294967296.d0
      bnd10AE(1,8) = 27567540.d0/4294967296.d0
      bnd10AE(1,9) = -4922775.d0/4294967296.d0
      bnd10AE(1,10) = 425425.d0/4294967296.d0
      bnd10AE(2,1) = 3828825.d0/4294967296.d0
      bnd10AE(2,2) = -44304975.d0/4294967296.d0
      bnd10AE(2,3) = 248107860.d0/4294967296.d0
      bnd10AE(2,4) = -964863900.d0/4294967296.d0
      bnd10AE(2,5) = 4341887550.d0/4294967296.d0
      bnd10AE(2,6) = 4341887550.d0/4294967296.d0
      bnd10AE(2,7) = -964863900.d0/4294967296.d0
      bnd10AE(2,8) = 248107860.d0/4294967296.d0
      bnd10AE(2,9) = -44304975.d0/4294967296.d0
      bnd10AE(2,10) = 3828825.d0/4294967296.d0
      bnd10AE(3,1) = -5105100.d0/4294967296.d0
      bnd10AE(3,2) = 59073300.d0/4294967296.d0
      bnd10AE(3,3) = -330810480.d0/4294967296.d0
      bnd10AE(3,4) = 1286485200.d0/4294967296.d0
      bnd10AE(3,5) = -5789183400.d0/4294967296.d0
      bnd10AE(3,6) = -5789183400.d0/4294967296.d0
      bnd10AE(3,7) = 1286485200.d0/4294967296.d0
      bnd10AE(3,8) = -330810480.d0/4294967296.d0
      bnd10AE(3,9) = 59073300.d0/4294967296.d0
      bnd10AE(3,10) = -5105100.d0/4294967296.d0
      bnd10AE(4,1) = 7147140.d0/4294967296.d0
      bnd10AE(4,2) = -82702620.d0/4294967296.d0
      bnd10AE(4,3) = 463134672.d0/4294967296.d0
      bnd10AE(4,4) = -1801079280.d0/4294967296.d0
      bnd10AE(4,5) = 8104856760.d0/4294967296.d0
      bnd10AE(4,6) = 8104856760.d0/4294967296.d0
      bnd10AE(4,7) = -1801079280.d0/4294967296.d0
      bnd10AE(4,8) = 463134672.d0/4294967296.d0
      bnd10AE(4,9) = -82702620.d0/4294967296.d0
      bnd10AE(4,10) = 7147140.d0/4294967296.d0
      bnd10AE(5,1) = -7657650.d0/4294967296.d0
      bnd10AE(5,2) = 88609950.d0/4294967296.d0
      bnd10AE(5,3) = -496215720.d0/4294967296.d0
      bnd10AE(5,4) = 1929727800.d0/4294967296.d0
      bnd10AE(5,5) = -8683775100.d0/4294967296.d0
      bnd10AE(5,6) = -8683775100.d0/4294967296.d0
      bnd10AE(5,7) = 1929727800.d0/4294967296.d0
      bnd10AE(5,8) = -496215720.d0/4294967296.d0
      bnd10AE(5,9) = 88609950.d0/4294967296.d0
      bnd10AE(5,10) = -7657650.d0/4294967296.d0
      bnd10AE(6,1) = 5955950.d0/4294967296.d0
      bnd10AE(6,2) = -68918850.d0/4294967296.d0
      bnd10AE(6,3) = 385945560.d0/4294967296.d0
      bnd10AE(6,4) = -1500899400.d0/4294967296.d0
      bnd10AE(6,5) = 6754047300.d0/4294967296.d0
      bnd10AE(6,6) = 6754047300.d0/4294967296.d0
      bnd10AE(6,7) = -1500899400.d0/4294967296.d0
      bnd10AE(6,8) = 385945560.d0/4294967296.d0
      bnd10AE(6,9) = -68918850.d0/4294967296.d0
      bnd10AE(6,10) = 5955950.d0/4294967296.d0
      bnd10AE(7,1) = -3248700.d0/4294967296.d0
      bnd10AE(7,2) = 37592100.d0/4294967296.d0
      bnd10AE(7,3) = -210515760.d0/4294967296.d0
      bnd10AE(7,4) = 818672400.d0/4294967296.d0
      bnd10AE(7,5) = -3684025800.d0/4294967296.d0
      bnd10AE(7,6) = -3684025800.d0/4294967296.d0
      bnd10AE(7,7) = 818672400.d0/4294967296.d0
      bnd10AE(7,8) = -210515760.d0/4294967296.d0
      bnd10AE(7,9) = 37592100.d0/4294967296.d0
      bnd10AE(7,10) = -3248700.d0/4294967296.d0
      bnd10AE(8,1) = 1178100.d0/4294967296.d0
      bnd10AE(8,2) = -13632300.d0/4294967296.d0
      bnd10AE(8,3) = 76340880.d0/4294967296.d0
      bnd10AE(8,4) = -296881200.d0/4294967296.d0
      bnd10AE(8,5) = 1335965400.d0/4294967296.d0
      bnd10AE(8,6) = 1335965400.d0/4294967296.d0
      bnd10AE(8,7) = -296881200.d0/4294967296.d0
      bnd10AE(8,8) = 76340880.d0/4294967296.d0
      bnd10AE(8,9) = -13632300.d0/4294967296.d0
      bnd10AE(8,10) = 1178100.d0/4294967296.d0
      bnd10AE(9,1) = -255255.d0/4294967296.d0
      bnd10AE(9,2) = 2953665.d0/4294967296.d0
      bnd10AE(9,3) = -16540524.d0/4294967296.d0
      bnd10AE(9,4) = 64324260.d0/4294967296.d0
      bnd10AE(9,5) = -289459170.d0/4294967296.d0
      bnd10AE(9,6) = -289459170.d0/4294967296.d0
      bnd10AE(9,7) = 64324260.d0/4294967296.d0
      bnd10AE(9,8) = -16540524.d0/4294967296.d0
      bnd10AE(9,9) = 2953665.d0/4294967296.d0
      bnd10AE(9,10) = -255255.d0/4294967296.d0
      bnd10AE(10,1) = 25025.d0/4294967296.d0
      bnd10AE(10,2) = -289575.d0/4294967296.d0
      bnd10AE(10,3) = 1621620.d0/4294967296.d0
      bnd10AE(10,4) = -6306300.d0/4294967296.d0
      bnd10AE(10,5) = 28378350.d0/4294967296.d0
      bnd10AE(10,6) = 28378350.d0/4294967296.d0
      bnd10AE(10,7) = -6306300.d0/4294967296.d0
      bnd10AE(10,8) = 1621620.d0/4294967296.d0
      bnd10AE(10,9) = -289575.d0/4294967296.d0
      bnd10AE(10,10) = 25025.d0/4294967296.d0
!
      bnd10BB(1,1) = 511225.d0/4294967296.d0
      bnd10BB(1,2) = -13803075.d0/4294967296.d0
      bnd10BB(1,3) = -55212300.d0/4294967296.d0
      bnd10BB(1,4) = 42942900.d0/4294967296.d0
      bnd10BB(1,5) = -38648610.d0/4294967296.d0
      bnd10BB(1,6) = 27606150.d0/4294967296.d0
      bnd10BB(1,7) = -14314300.d0/4294967296.d0
      bnd10BB(1,8) = 5019300.d0/4294967296.d0
      bnd10BB(1,9) = -1061775.d0/4294967296.d0
      bnd10BB(1,10) = 102245.d0/4294967296.d0
      bnd10BB(2,1) = -13803075.d0/4294967296.d0
      bnd10BB(2,2) = 372683025.d0/4294967296.d0
      bnd10BB(2,3) = 1490732100.d0/4294967296.d0
      bnd10BB(2,4) = -1159458300.d0/4294967296.d0
      bnd10BB(2,5) = 1043512470.d0/4294967296.d0
      bnd10BB(2,6) = -745366050.d0/4294967296.d0
      bnd10BB(2,7) = 386486100.d0/4294967296.d0
      bnd10BB(2,8) = -135521100.d0/4294967296.d0
      bnd10BB(2,9) = 28667925.d0/4294967296.d0
      bnd10BB(2,10) = -2760615.d0/4294967296.d0
      bnd10BB(3,1) = -55212300.d0/4294967296.d0
      bnd10BB(3,2) = 1490732100.d0/4294967296.d0
      bnd10BB(3,3) = 5962928400.d0/4294967296.d0
      bnd10BB(3,4) = -4637833200.d0/4294967296.d0
      bnd10BB(3,5) = 4174049880.d0/4294967296.d0
      bnd10BB(3,6) = -2981464200.d0/4294967296.d0
      bnd10BB(3,7) = 1545944400.d0/4294967296.d0
      bnd10BB(3,8) = -542084400.d0/4294967296.d0
      bnd10BB(3,9) = 114671700.d0/4294967296.d0
      bnd10BB(3,10) = -11042460.d0/4294967296.d0
      bnd10BB(4,1) = 42942900.d0/4294967296.d0
      bnd10BB(4,2) = -1159458300.d0/4294967296.d0
      bnd10BB(4,3) = -4637833200.d0/4294967296.d0
      bnd10BB(4,4) = 3607203600.d0/4294967296.d0
      bnd10BB(4,5) = -3246483240.d0/4294967296.d0
      bnd10BB(4,6) = 2318916600.d0/4294967296.d0
      bnd10BB(4,7) = -1202401200.d0/4294967296.d0
      bnd10BB(4,8) = 421621200.d0/4294967296.d0
      bnd10BB(4,9) = -89189100.d0/4294967296.d0
      bnd10BB(4,10) = 8588580.d0/4294967296.d0
      bnd10BB(5,1) = -38648610.d0/4294967296.d0
      bnd10BB(5,2) = 1043512470.d0/4294967296.d0
      bnd10BB(5,3) = 4174049880.d0/4294967296.d0
      bnd10BB(5,4) = -3246483240.d0/4294967296.d0
      bnd10BB(5,5) = 2921834916.d0/4294967296.d0
      bnd10BB(5,6) = -2087024940.d0/4294967296.d0
      bnd10BB(5,7) = 1082161080.d0/4294967296.d0
      bnd10BB(5,8) = -379459080.d0/4294967296.d0
      bnd10BB(5,9) = 80270190.d0/4294967296.d0
      bnd10BB(5,10) = -7729722.d0/4294967296.d0
      bnd10BB(6,1) = 27606150.d0/4294967296.d0
      bnd10BB(6,2) = -745366050.d0/4294967296.d0
      bnd10BB(6,3) = -2981464200.d0/4294967296.d0
      bnd10BB(6,4) = 2318916600.d0/4294967296.d0
      bnd10BB(6,5) = -2087024940.d0/4294967296.d0
      bnd10BB(6,6) = 1490732100.d0/4294967296.d0
      bnd10BB(6,7) = -772972200.d0/4294967296.d0
      bnd10BB(6,8) = 271042200.d0/4294967296.d0
      bnd10BB(6,9) = -57335850.d0/4294967296.d0
      bnd10BB(6,10) = 5521230.d0/4294967296.d0
      bnd10BB(7,1) = -14314300.d0/4294967296.d0
      bnd10BB(7,2) = 386486100.d0/4294967296.d0
      bnd10BB(7,3) = 1545944400.d0/4294967296.d0
      bnd10BB(7,4) = -1202401200.d0/4294967296.d0
      bnd10BB(7,5) = 1082161080.d0/4294967296.d0
      bnd10BB(7,6) = -772972200.d0/4294967296.d0
      bnd10BB(7,7) = 400800400.d0/4294967296.d0
      bnd10BB(7,8) = -140540400.d0/4294967296.d0
      bnd10BB(7,9) = 29729700.d0/4294967296.d0
      bnd10BB(7,10) = -2862860.d0/4294967296.d0
      bnd10BB(8,1) = 5019300.d0/4294967296.d0
      bnd10BB(8,2) = -135521100.d0/4294967296.d0
      bnd10BB(8,3) = -542084400.d0/4294967296.d0
      bnd10BB(8,4) = 421621200.d0/4294967296.d0
      bnd10BB(8,5) = -379459080.d0/4294967296.d0
      bnd10BB(8,6) = 271042200.d0/4294967296.d0
      bnd10BB(8,7) = -140540400.d0/4294967296.d0
      bnd10BB(8,8) = 49280400.d0/4294967296.d0
      bnd10BB(8,9) = -10424700.d0/4294967296.d0
      bnd10BB(8,10) = 1003860.d0/4294967296.d0
      bnd10BB(9,1) = -1061775.d0/4294967296.d0
      bnd10BB(9,2) = 28667925.d0/4294967296.d0
      bnd10BB(9,3) = 114671700.d0/4294967296.d0
      bnd10BB(9,4) = -89189100.d0/4294967296.d0
      bnd10BB(9,5) = 80270190.d0/4294967296.d0
      bnd10BB(9,6) = -57335850.d0/4294967296.d0
      bnd10BB(9,7) = 29729700.d0/4294967296.d0
      bnd10BB(9,8) = -10424700.d0/4294967296.d0
      bnd10BB(9,9) = 2205225.d0/4294967296.d0
      bnd10BB(9,10) = -212355.d0/4294967296.d0
      bnd10BB(10,1) = 102245.d0/4294967296.d0
      bnd10BB(10,2) = -2760615.d0/4294967296.d0
      bnd10BB(10,3) = -11042460.d0/4294967296.d0
      bnd10BB(10,4) = 8588580.d0/4294967296.d0
      bnd10BB(10,5) = -7729722.d0/4294967296.d0
      bnd10BB(10,6) = 5521230.d0/4294967296.d0
      bnd10BB(10,7) = -2862860.d0/4294967296.d0
      bnd10BB(10,8) = 1003860.d0/4294967296.d0
      bnd10BB(10,9) = -212355.d0/4294967296.d0
      bnd10BB(10,10) = 20449.d0/4294967296.d0
!
      bnd10BC(1,1) = -102245.d0/4294967296.d0
      bnd10BC(1,2) = 1533675.d0/4294967296.d0
      bnd10BC(1,3) = -18404100.d0/4294967296.d0
      bnd10BC(1,4) = -42942900.d0/4294967296.d0
      bnd10BC(1,5) = 21471450.d0/4294967296.d0
      bnd10BC(1,6) = -12882870.d0/4294967296.d0
      bnd10BC(1,7) = 6134700.d0/4294967296.d0
      bnd10BC(1,8) = -2044900.d0/4294967296.d0
      bnd10BC(1,9) = 418275.d0/4294967296.d0
      bnd10BC(1,10) = -39325.d0/4294967296.d0
      bnd10BC(2,1) = 2760615.d0/4294967296.d0
      bnd10BC(2,2) = -41409225.d0/4294967296.d0
      bnd10BC(2,3) = 496910700.d0/4294967296.d0
      bnd10BC(2,4) = 1159458300.d0/4294967296.d0
      bnd10BC(2,5) = -579729150.d0/4294967296.d0
      bnd10BC(2,6) = 347837490.d0/4294967296.d0
      bnd10BC(2,7) = -165636900.d0/4294967296.d0
      bnd10BC(2,8) = 55212300.d0/4294967296.d0
      bnd10BC(2,9) = -11293425.d0/4294967296.d0
      bnd10BC(2,10) = 1061775.d0/4294967296.d0
      bnd10BC(3,1) = 11042460.d0/4294967296.d0
      bnd10BC(3,2) = -165636900.d0/4294967296.d0
      bnd10BC(3,3) = 1987642800.d0/4294967296.d0
      bnd10BC(3,4) = 4637833200.d0/4294967296.d0
      bnd10BC(3,5) = -2318916600.d0/4294967296.d0
      bnd10BC(3,6) = 1391349960.d0/4294967296.d0
      bnd10BC(3,7) = -662547600.d0/4294967296.d0
      bnd10BC(3,8) = 220849200.d0/4294967296.d0
      bnd10BC(3,9) = -45173700.d0/4294967296.d0
      bnd10BC(3,10) = 4247100.d0/4294967296.d0
      bnd10BC(4,1) = -8588580.d0/4294967296.d0
      bnd10BC(4,2) = 128828700.d0/4294967296.d0
      bnd10BC(4,3) = -1545944400.d0/4294967296.d0
      bnd10BC(4,4) = -3607203600.d0/4294967296.d0
      bnd10BC(4,5) = 1803601800.d0/4294967296.d0
      bnd10BC(4,6) = -1082161080.d0/4294967296.d0
      bnd10BC(4,7) = 515314800.d0/4294967296.d0
      bnd10BC(4,8) = -171771600.d0/4294967296.d0
      bnd10BC(4,9) = 35135100.d0/4294967296.d0
      bnd10BC(4,10) = -3303300.d0/4294967296.d0
      bnd10BC(5,1) = 7729722.d0/4294967296.d0
      bnd10BC(5,2) = -115945830.d0/4294967296.d0
      bnd10BC(5,3) = 1391349960.d0/4294967296.d0
      bnd10BC(5,4) = 3246483240.d0/4294967296.d0
      bnd10BC(5,5) = -1623241620.d0/4294967296.d0
      bnd10BC(5,6) = 973944972.d0/4294967296.d0
      bnd10BC(5,7) = -463783320.d0/4294967296.d0
      bnd10BC(5,8) = 154594440.d0/4294967296.d0
      bnd10BC(5,9) = -31621590.d0/4294967296.d0
      bnd10BC(5,10) = 2972970.d0/4294967296.d0
      bnd10BC(6,1) = -5521230.d0/4294967296.d0
      bnd10BC(6,2) = 82818450.d0/4294967296.d0
      bnd10BC(6,3) = -993821400.d0/4294967296.d0
      bnd10BC(6,4) = -2318916600.d0/4294967296.d0
      bnd10BC(6,5) = 1159458300.d0/4294967296.d0
      bnd10BC(6,6) = -695674980.d0/4294967296.d0
      bnd10BC(6,7) = 331273800.d0/4294967296.d0
      bnd10BC(6,8) = -110424600.d0/4294967296.d0
      bnd10BC(6,9) = 22586850.d0/4294967296.d0
      bnd10BC(6,10) = -2123550.d0/4294967296.d0
      bnd10BC(7,1) = 2862860.d0/4294967296.d0
      bnd10BC(7,2) = -42942900.d0/4294967296.d0
      bnd10BC(7,3) = 515314800.d0/4294967296.d0
      bnd10BC(7,4) = 1202401200.d0/4294967296.d0
      bnd10BC(7,5) = -601200600.d0/4294967296.d0
      bnd10BC(7,6) = 360720360.d0/4294967296.d0
      bnd10BC(7,7) = -171771600.d0/4294967296.d0
      bnd10BC(7,8) = 57257200.d0/4294967296.d0
      bnd10BC(7,9) = -11711700.d0/4294967296.d0
      bnd10BC(7,10) = 1101100.d0/4294967296.d0
      bnd10BC(8,1) = -1003860.d0/4294967296.d0
      bnd10BC(8,2) = 15057900.d0/4294967296.d0
      bnd10BC(8,3) = -180694800.d0/4294967296.d0
      bnd10BC(8,4) = -421621200.d0/4294967296.d0
      bnd10BC(8,5) = 210810600.d0/4294967296.d0
      bnd10BC(8,6) = -126486360.d0/4294967296.d0
      bnd10BC(8,7) = 60231600.d0/4294967296.d0
      bnd10BC(8,8) = -20077200.d0/4294967296.d0
      bnd10BC(8,9) = 4106700.d0/4294967296.d0
      bnd10BC(8,10) = -386100.d0/4294967296.d0
      bnd10BC(9,1) = 212355.d0/4294967296.d0
      bnd10BC(9,2) = -3185325.d0/4294967296.d0
      bnd10BC(9,3) = 38223900.d0/4294967296.d0
      bnd10BC(9,4) = 89189100.d0/4294967296.d0
      bnd10BC(9,5) = -44594550.d0/4294967296.d0
      bnd10BC(9,6) = 26756730.d0/4294967296.d0
      bnd10BC(9,7) = -12741300.d0/4294967296.d0
      bnd10BC(9,8) = 4247100.d0/4294967296.d0
      bnd10BC(9,9) = -868725.d0/4294967296.d0
      bnd10BC(9,10) = 81675.d0/4294967296.d0
      bnd10BC(10,1) = -20449.d0/4294967296.d0
      bnd10BC(10,2) = 306735.d0/4294967296.d0
      bnd10BC(10,3) = -3680820.d0/4294967296.d0
      bnd10BC(10,4) = -8588580.d0/4294967296.d0
      bnd10BC(10,5) = 4294290.d0/4294967296.d0
      bnd10BC(10,6) = -2576574.d0/4294967296.d0
      bnd10BC(10,7) = 1226940.d0/4294967296.d0
      bnd10BC(10,8) = -408980.d0/4294967296.d0
      bnd10BC(10,9) = 83655.d0/4294967296.d0
      bnd10BC(10,10) = -7865.d0/4294967296.d0
!
      bnd10BD(1,1) = 39325.d0/4294967296.d0
      bnd10BD(1,2) = -495495.d0/4294967296.d0
      bnd10BD(1,3) = 3303300.d0/4294967296.d0
      bnd10BD(1,4) = -23123100.d0/4294967296.d0
      bnd10BD(1,5) = -34684650.d0/4294967296.d0
      bnd10BD(1,6) = 11561550.d0/4294967296.d0
      bnd10BD(1,7) = -4624620.d0/4294967296.d0
      bnd10BD(1,8) = 1415700.d0/4294967296.d0
      bnd10BD(1,9) = -275275.d0/4294967296.d0
      bnd10BD(1,10) = 25025.d0/4294967296.d0
      bnd10BD(2,1) = -1061775.d0/4294967296.d0
      bnd10BD(2,2) = 13378365.d0/4294967296.d0
      bnd10BD(2,3) = -89189100.d0/4294967296.d0
      bnd10BD(2,4) = 624323700.d0/4294967296.d0
      bnd10BD(2,5) = 936485550.d0/4294967296.d0
      bnd10BD(2,6) = -312161850.d0/4294967296.d0
      bnd10BD(2,7) = 124864740.d0/4294967296.d0
      bnd10BD(2,8) = -38223900.d0/4294967296.d0
      bnd10BD(2,9) = 7432425.d0/4294967296.d0
      bnd10BD(2,10) = -675675.d0/4294967296.d0
      bnd10BD(3,1) = -4247100.d0/4294967296.d0
      bnd10BD(3,2) = 53513460.d0/4294967296.d0
      bnd10BD(3,3) = -356756400.d0/4294967296.d0
      bnd10BD(3,4) = 2497294800.d0/4294967296.d0
      bnd10BD(3,5) = 3745942200.d0/4294967296.d0
      bnd10BD(3,6) = -1248647400.d0/4294967296.d0
      bnd10BD(3,7) = 499458960.d0/4294967296.d0
      bnd10BD(3,8) = -152895600.d0/4294967296.d0
      bnd10BD(3,9) = 29729700.d0/4294967296.d0
      bnd10BD(3,10) = -2702700.d0/4294967296.d0
      bnd10BD(4,1) = 3303300.d0/4294967296.d0
      bnd10BD(4,2) = -41621580.d0/4294967296.d0
      bnd10BD(4,3) = 277477200.d0/4294967296.d0
      bnd10BD(4,4) = -1942340400.d0/4294967296.d0
      bnd10BD(4,5) = -2913510600.d0/4294967296.d0
      bnd10BD(4,6) = 971170200.d0/4294967296.d0
      bnd10BD(4,7) = -388468080.d0/4294967296.d0
      bnd10BD(4,8) = 118918800.d0/4294967296.d0
      bnd10BD(4,9) = -23123100.d0/4294967296.d0
      bnd10BD(4,10) = 2102100.d0/4294967296.d0
      bnd10BD(5,1) = -2972970.d0/4294967296.d0
      bnd10BD(5,2) = 37459422.d0/4294967296.d0
      bnd10BD(5,3) = -249729480.d0/4294967296.d0
      bnd10BD(5,4) = 1748106360.d0/4294967296.d0
      bnd10BD(5,5) = 2622159540.d0/4294967296.d0
      bnd10BD(5,6) = -874053180.d0/4294967296.d0
      bnd10BD(5,7) = 349621272.d0/4294967296.d0
      bnd10BD(5,8) = -107026920.d0/4294967296.d0
      bnd10BD(5,9) = 20810790.d0/4294967296.d0
      bnd10BD(5,10) = -1891890.d0/4294967296.d0
      bnd10BD(6,1) = 2123550.d0/4294967296.d0
      bnd10BD(6,2) = -26756730.d0/4294967296.d0
      bnd10BD(6,3) = 178378200.d0/4294967296.d0
      bnd10BD(6,4) = -1248647400.d0/4294967296.d0
      bnd10BD(6,5) = -1872971100.d0/4294967296.d0
      bnd10BD(6,6) = 624323700.d0/4294967296.d0
      bnd10BD(6,7) = -249729480.d0/4294967296.d0
      bnd10BD(6,8) = 76447800.d0/4294967296.d0
      bnd10BD(6,9) = -14864850.d0/4294967296.d0
      bnd10BD(6,10) = 1351350.d0/4294967296.d0
      bnd10BD(7,1) = -1101100.d0/4294967296.d0
      bnd10BD(7,2) = 13873860.d0/4294967296.d0
      bnd10BD(7,3) = -92492400.d0/4294967296.d0
      bnd10BD(7,4) = 647446800.d0/4294967296.d0
      bnd10BD(7,5) = 971170200.d0/4294967296.d0
      bnd10BD(7,6) = -323723400.d0/4294967296.d0
      bnd10BD(7,7) = 129489360.d0/4294967296.d0
      bnd10BD(7,8) = -39639600.d0/4294967296.d0
      bnd10BD(7,9) = 7707700.d0/4294967296.d0
      bnd10BD(7,10) = -700700.d0/4294967296.d0
      bnd10BD(8,1) = 386100.d0/4294967296.d0
      bnd10BD(8,2) = -4864860.d0/4294967296.d0
      bnd10BD(8,3) = 32432400.d0/4294967296.d0
      bnd10BD(8,4) = -227026800.d0/4294967296.d0
      bnd10BD(8,5) = -340540200.d0/4294967296.d0
      bnd10BD(8,6) = 113513400.d0/4294967296.d0
      bnd10BD(8,7) = -45405360.d0/4294967296.d0
      bnd10BD(8,8) = 13899600.d0/4294967296.d0
      bnd10BD(8,9) = -2702700.d0/4294967296.d0
      bnd10BD(8,10) = 245700.d0/4294967296.d0
      bnd10BD(9,1) = -81675.d0/4294967296.d0
      bnd10BD(9,2) = 1029105.d0/4294967296.d0
      bnd10BD(9,3) = -6860700.d0/4294967296.d0
      bnd10BD(9,4) = 48024900.d0/4294967296.d0
      bnd10BD(9,5) = 72037350.d0/4294967296.d0
      bnd10BD(9,6) = -24012450.d0/4294967296.d0
      bnd10BD(9,7) = 9604980.d0/4294967296.d0
      bnd10BD(9,8) = -2940300.d0/4294967296.d0
      bnd10BD(9,9) = 571725.d0/4294967296.d0
      bnd10BD(9,10) = -51975.d0/4294967296.d0
      bnd10BD(10,1) = 7865.d0/4294967296.d0
      bnd10BD(10,2) = -99099.d0/4294967296.d0
      bnd10BD(10,3) = 660660.d0/4294967296.d0
      bnd10BD(10,4) = -4624620.d0/4294967296.d0
      bnd10BD(10,5) = -6936930.d0/4294967296.d0
      bnd10BD(10,6) = 2312310.d0/4294967296.d0
      bnd10BD(10,7) = -924924.d0/4294967296.d0
      bnd10BD(10,8) = 283140.d0/4294967296.d0
      bnd10BD(10,9) = -55055.d0/4294967296.d0
      bnd10BD(10,10) = 5005.d0/4294967296.d0
!
      bnd10BE(1,1) = -25025.d0/4294967296.d0
      bnd10BE(1,2) = 289575.d0/4294967296.d0
      bnd10BE(1,3) = -1621620.d0/4294967296.d0
      bnd10BE(1,4) = 6306300.d0/4294967296.d0
      bnd10BE(1,5) = -28378350.d0/4294967296.d0
      bnd10BE(1,6) = -28378350.d0/4294967296.d0
      bnd10BE(1,7) = 6306300.d0/4294967296.d0
      bnd10BE(1,8) = -1621620.d0/4294967296.d0
      bnd10BE(1,9) = 289575.d0/4294967296.d0
      bnd10BE(1,10) = -25025.d0/4294967296.d0
      bnd10BE(2,1) = 675675.d0/4294967296.d0
      bnd10BE(2,2) = -7818525.d0/4294967296.d0
      bnd10BE(2,3) = 43783740.d0/4294967296.d0
      bnd10BE(2,4) = -170270100.d0/4294967296.d0
      bnd10BE(2,5) = 766215450.d0/4294967296.d0
      bnd10BE(2,6) = 766215450.d0/4294967296.d0
      bnd10BE(2,7) = -170270100.d0/4294967296.d0
      bnd10BE(2,8) = 43783740.d0/4294967296.d0
      bnd10BE(2,9) = -7818525.d0/4294967296.d0
      bnd10BE(2,10) = 675675.d0/4294967296.d0
      bnd10BE(3,1) = 2702700.d0/4294967296.d0
      bnd10BE(3,2) = -31274100.d0/4294967296.d0
      bnd10BE(3,3) = 175134960.d0/4294967296.d0
      bnd10BE(3,4) = -681080400.d0/4294967296.d0
      bnd10BE(3,5) = 3064861800.d0/4294967296.d0
      bnd10BE(3,6) = 3064861800.d0/4294967296.d0
      bnd10BE(3,7) = -681080400.d0/4294967296.d0
      bnd10BE(3,8) = 175134960.d0/4294967296.d0
      bnd10BE(3,9) = -31274100.d0/4294967296.d0
      bnd10BE(3,10) = 2702700.d0/4294967296.d0
      bnd10BE(4,1) = -2102100.d0/4294967296.d0
      bnd10BE(4,2) = 24324300.d0/4294967296.d0
      bnd10BE(4,3) = -136216080.d0/4294967296.d0
      bnd10BE(4,4) = 529729200.d0/4294967296.d0
      bnd10BE(4,5) = -2383781400.d0/4294967296.d0
      bnd10BE(4,6) = -2383781400.d0/4294967296.d0
      bnd10BE(4,7) = 529729200.d0/4294967296.d0
      bnd10BE(4,8) = -136216080.d0/4294967296.d0
      bnd10BE(4,9) = 24324300.d0/4294967296.d0
      bnd10BE(4,10) = -2102100.d0/4294967296.d0
      bnd10BE(5,1) = 1891890.d0/4294967296.d0
      bnd10BE(5,2) = -21891870.d0/4294967296.d0
      bnd10BE(5,3) = 122594472.d0/4294967296.d0
      bnd10BE(5,4) = -476756280.d0/4294967296.d0
      bnd10BE(5,5) = 2145403260.d0/4294967296.d0
      bnd10BE(5,6) = 2145403260.d0/4294967296.d0
      bnd10BE(5,7) = -476756280.d0/4294967296.d0
      bnd10BE(5,8) = 122594472.d0/4294967296.d0
      bnd10BE(5,9) = -21891870.d0/4294967296.d0
      bnd10BE(5,10) = 1891890.d0/4294967296.d0
      bnd10BE(6,1) = -1351350.d0/4294967296.d0
      bnd10BE(6,2) = 15637050.d0/4294967296.d0
      bnd10BE(6,3) = -87567480.d0/4294967296.d0
      bnd10BE(6,4) = 340540200.d0/4294967296.d0
      bnd10BE(6,5) = -1532430900.d0/4294967296.d0
      bnd10BE(6,6) = -1532430900.d0/4294967296.d0
      bnd10BE(6,7) = 340540200.d0/4294967296.d0
      bnd10BE(6,8) = -87567480.d0/4294967296.d0
      bnd10BE(6,9) = 15637050.d0/4294967296.d0
      bnd10BE(6,10) = -1351350.d0/4294967296.d0
      bnd10BE(7,1) = 700700.d0/4294967296.d0
      bnd10BE(7,2) = -8108100.d0/4294967296.d0
      bnd10BE(7,3) = 45405360.d0/4294967296.d0
      bnd10BE(7,4) = -176576400.d0/4294967296.d0
      bnd10BE(7,5) = 794593800.d0/4294967296.d0
      bnd10BE(7,6) = 794593800.d0/4294967296.d0
      bnd10BE(7,7) = -176576400.d0/4294967296.d0
      bnd10BE(7,8) = 45405360.d0/4294967296.d0
      bnd10BE(7,9) = -8108100.d0/4294967296.d0
      bnd10BE(7,10) = 700700.d0/4294967296.d0
      bnd10BE(8,1) = -245700.d0/4294967296.d0
      bnd10BE(8,2) = 2843100.d0/4294967296.d0
      bnd10BE(8,3) = -15921360.d0/4294967296.d0
      bnd10BE(8,4) = 61916400.d0/4294967296.d0
      bnd10BE(8,5) = -278623800.d0/4294967296.d0
      bnd10BE(8,6) = -278623800.d0/4294967296.d0
      bnd10BE(8,7) = 61916400.d0/4294967296.d0
      bnd10BE(8,8) = -15921360.d0/4294967296.d0
      bnd10BE(8,9) = 2843100.d0/4294967296.d0
      bnd10BE(8,10) = -245700.d0/4294967296.d0
      bnd10BE(9,1) = 51975.d0/4294967296.d0
      bnd10BE(9,2) = -601425.d0/4294967296.d0
      bnd10BE(9,3) = 3367980.d0/4294967296.d0
      bnd10BE(9,4) = -13097700.d0/4294967296.d0
      bnd10BE(9,5) = 58939650.d0/4294967296.d0
      bnd10BE(9,6) = 58939650.d0/4294967296.d0
      bnd10BE(9,7) = -13097700.d0/4294967296.d0
      bnd10BE(9,8) = 3367980.d0/4294967296.d0
      bnd10BE(9,9) = -601425.d0/4294967296.d0
      bnd10BE(9,10) = 51975.d0/4294967296.d0
      bnd10BE(10,1) = -5005.d0/4294967296.d0
      bnd10BE(10,2) = 57915.d0/4294967296.d0
      bnd10BE(10,3) = -324324.d0/4294967296.d0
      bnd10BE(10,4) = 1261260.d0/4294967296.d0
      bnd10BE(10,5) = -5675670.d0/4294967296.d0
      bnd10BE(10,6) = -5675670.d0/4294967296.d0
      bnd10BE(10,7) = 1261260.d0/4294967296.d0
      bnd10BE(10,8) = -324324.d0/4294967296.d0
      bnd10BE(10,9) = 57915.d0/4294967296.d0
      bnd10BE(10,10) = -5005.d0/4294967296.d0
!
      bnd10CC(1,1) = 20449.d0/4294967296.d0
      bnd10CC(1,2) = -306735.d0/4294967296.d0
      bnd10CC(1,3) = 3680820.d0/4294967296.d0
      bnd10CC(1,4) = 8588580.d0/4294967296.d0
      bnd10CC(1,5) = -4294290.d0/4294967296.d0
      bnd10CC(1,6) = 2576574.d0/4294967296.d0
      bnd10CC(1,7) = -1226940.d0/4294967296.d0
      bnd10CC(1,8) = 408980.d0/4294967296.d0
      bnd10CC(1,9) = -83655.d0/4294967296.d0
      bnd10CC(1,10) = 7865.d0/4294967296.d0
      bnd10CC(2,1) = -306735.d0/4294967296.d0
      bnd10CC(2,2) = 4601025.d0/4294967296.d0
      bnd10CC(2,3) = -55212300.d0/4294967296.d0
      bnd10CC(2,4) = -128828700.d0/4294967296.d0
      bnd10CC(2,5) = 64414350.d0/4294967296.d0
      bnd10CC(2,6) = -38648610.d0/4294967296.d0
      bnd10CC(2,7) = 18404100.d0/4294967296.d0
      bnd10CC(2,8) = -6134700.d0/4294967296.d0
      bnd10CC(2,9) = 1254825.d0/4294967296.d0
      bnd10CC(2,10) = -117975.d0/4294967296.d0
      bnd10CC(3,1) = 3680820.d0/4294967296.d0
      bnd10CC(3,2) = -55212300.d0/4294967296.d0
      bnd10CC(3,3) = 662547600.d0/4294967296.d0
      bnd10CC(3,4) = 1545944400.d0/4294967296.d0
      bnd10CC(3,5) = -772972200.d0/4294967296.d0
      bnd10CC(3,6) = 463783320.d0/4294967296.d0
      bnd10CC(3,7) = -220849200.d0/4294967296.d0
      bnd10CC(3,8) = 73616400.d0/4294967296.d0
      bnd10CC(3,9) = -15057900.d0/4294967296.d0
      bnd10CC(3,10) = 1415700.d0/4294967296.d0
      bnd10CC(4,1) = 8588580.d0/4294967296.d0
      bnd10CC(4,2) = -128828700.d0/4294967296.d0
      bnd10CC(4,3) = 1545944400.d0/4294967296.d0
      bnd10CC(4,4) = 3607203600.d0/4294967296.d0
      bnd10CC(4,5) = -1803601800.d0/4294967296.d0
      bnd10CC(4,6) = 1082161080.d0/4294967296.d0
      bnd10CC(4,7) = -515314800.d0/4294967296.d0
      bnd10CC(4,8) = 171771600.d0/4294967296.d0
      bnd10CC(4,9) = -35135100.d0/4294967296.d0
      bnd10CC(4,10) = 3303300.d0/4294967296.d0
      bnd10CC(5,1) = -4294290.d0/4294967296.d0
      bnd10CC(5,2) = 64414350.d0/4294967296.d0
      bnd10CC(5,3) = -772972200.d0/4294967296.d0
      bnd10CC(5,4) = -1803601800.d0/4294967296.d0
      bnd10CC(5,5) = 901800900.d0/4294967296.d0
      bnd10CC(5,6) = -541080540.d0/4294967296.d0
      bnd10CC(5,7) = 257657400.d0/4294967296.d0
      bnd10CC(5,8) = -85885800.d0/4294967296.d0
      bnd10CC(5,9) = 17567550.d0/4294967296.d0
      bnd10CC(5,10) = -1651650.d0/4294967296.d0
      bnd10CC(6,1) = 2576574.d0/4294967296.d0
      bnd10CC(6,2) = -38648610.d0/4294967296.d0
      bnd10CC(6,3) = 463783320.d0/4294967296.d0
      bnd10CC(6,4) = 1082161080.d0/4294967296.d0
      bnd10CC(6,5) = -541080540.d0/4294967296.d0
      bnd10CC(6,6) = 324648324.d0/4294967296.d0
      bnd10CC(6,7) = -154594440.d0/4294967296.d0
      bnd10CC(6,8) = 51531480.d0/4294967296.d0
      bnd10CC(6,9) = -10540530.d0/4294967296.d0
      bnd10CC(6,10) = 990990.d0/4294967296.d0
      bnd10CC(7,1) = -1226940.d0/4294967296.d0
      bnd10CC(7,2) = 18404100.d0/4294967296.d0
      bnd10CC(7,3) = -220849200.d0/4294967296.d0
      bnd10CC(7,4) = -515314800.d0/4294967296.d0
      bnd10CC(7,5) = 257657400.d0/4294967296.d0
      bnd10CC(7,6) = -154594440.d0/4294967296.d0
      bnd10CC(7,7) = 73616400.d0/4294967296.d0
      bnd10CC(7,8) = -24538800.d0/4294967296.d0
      bnd10CC(7,9) = 5019300.d0/4294967296.d0
      bnd10CC(7,10) = -471900.d0/4294967296.d0
      bnd10CC(8,1) = 408980.d0/4294967296.d0
      bnd10CC(8,2) = -6134700.d0/4294967296.d0
      bnd10CC(8,3) = 73616400.d0/4294967296.d0
      bnd10CC(8,4) = 171771600.d0/4294967296.d0
      bnd10CC(8,5) = -85885800.d0/4294967296.d0
      bnd10CC(8,6) = 51531480.d0/4294967296.d0
      bnd10CC(8,7) = -24538800.d0/4294967296.d0
      bnd10CC(8,8) = 8179600.d0/4294967296.d0
      bnd10CC(8,9) = -1673100.d0/4294967296.d0
      bnd10CC(8,10) = 157300.d0/4294967296.d0
      bnd10CC(9,1) = -83655.d0/4294967296.d0
      bnd10CC(9,2) = 1254825.d0/4294967296.d0
      bnd10CC(9,3) = -15057900.d0/4294967296.d0
      bnd10CC(9,4) = -35135100.d0/4294967296.d0
      bnd10CC(9,5) = 17567550.d0/4294967296.d0
      bnd10CC(9,6) = -10540530.d0/4294967296.d0
      bnd10CC(9,7) = 5019300.d0/4294967296.d0
      bnd10CC(9,8) = -1673100.d0/4294967296.d0
      bnd10CC(9,9) = 342225.d0/4294967296.d0
      bnd10CC(9,10) = -32175.d0/4294967296.d0
      bnd10CC(10,1) = 7865.d0/4294967296.d0
      bnd10CC(10,2) = -117975.d0/4294967296.d0
      bnd10CC(10,3) = 1415700.d0/4294967296.d0
      bnd10CC(10,4) = 3303300.d0/4294967296.d0
      bnd10CC(10,5) = -1651650.d0/4294967296.d0
      bnd10CC(10,6) = 990990.d0/4294967296.d0
      bnd10CC(10,7) = -471900.d0/4294967296.d0
      bnd10CC(10,8) = 157300.d0/4294967296.d0
      bnd10CC(10,9) = -32175.d0/4294967296.d0
      bnd10CC(10,10) = 3025.d0/4294967296.d0
!
      bnd10CD(1,1) = -7865.d0/4294967296.d0
      bnd10CD(1,2) = 99099.d0/4294967296.d0
      bnd10CD(1,3) = -660660.d0/4294967296.d0
      bnd10CD(1,4) = 4624620.d0/4294967296.d0
      bnd10CD(1,5) = 6936930.d0/4294967296.d0
      bnd10CD(1,6) = -2312310.d0/4294967296.d0
      bnd10CD(1,7) = 924924.d0/4294967296.d0
      bnd10CD(1,8) = -283140.d0/4294967296.d0
      bnd10CD(1,9) = 55055.d0/4294967296.d0
      bnd10CD(1,10) = -5005.d0/4294967296.d0
      bnd10CD(2,1) = 117975.d0/4294967296.d0
      bnd10CD(2,2) = -1486485.d0/4294967296.d0
      bnd10CD(2,3) = 9909900.d0/4294967296.d0
      bnd10CD(2,4) = -69369300.d0/4294967296.d0
      bnd10CD(2,5) = -104053950.d0/4294967296.d0
      bnd10CD(2,6) = 34684650.d0/4294967296.d0
      bnd10CD(2,7) = -13873860.d0/4294967296.d0
      bnd10CD(2,8) = 4247100.d0/4294967296.d0
      bnd10CD(2,9) = -825825.d0/4294967296.d0
      bnd10CD(2,10) = 75075.d0/4294967296.d0
      bnd10CD(3,1) = -1415700.d0/4294967296.d0
      bnd10CD(3,2) = 17837820.d0/4294967296.d0
      bnd10CD(3,3) = -118918800.d0/4294967296.d0
      bnd10CD(3,4) = 832431600.d0/4294967296.d0
      bnd10CD(3,5) = 1248647400.d0/4294967296.d0
      bnd10CD(3,6) = -416215800.d0/4294967296.d0
      bnd10CD(3,7) = 166486320.d0/4294967296.d0
      bnd10CD(3,8) = -50965200.d0/4294967296.d0
      bnd10CD(3,9) = 9909900.d0/4294967296.d0
      bnd10CD(3,10) = -900900.d0/4294967296.d0
      bnd10CD(4,1) = -3303300.d0/4294967296.d0
      bnd10CD(4,2) = 41621580.d0/4294967296.d0
      bnd10CD(4,3) = -277477200.d0/4294967296.d0
      bnd10CD(4,4) = 1942340400.d0/4294967296.d0
      bnd10CD(4,5) = 2913510600.d0/4294967296.d0
      bnd10CD(4,6) = -971170200.d0/4294967296.d0
      bnd10CD(4,7) = 388468080.d0/4294967296.d0
      bnd10CD(4,8) = -118918800.d0/4294967296.d0
      bnd10CD(4,9) = 23123100.d0/4294967296.d0
      bnd10CD(4,10) = -2102100.d0/4294967296.d0
      bnd10CD(5,1) = 1651650.d0/4294967296.d0
      bnd10CD(5,2) = -20810790.d0/4294967296.d0
      bnd10CD(5,3) = 138738600.d0/4294967296.d0
      bnd10CD(5,4) = -971170200.d0/4294967296.d0
      bnd10CD(5,5) = -1456755300.d0/4294967296.d0
      bnd10CD(5,6) = 485585100.d0/4294967296.d0
      bnd10CD(5,7) = -194234040.d0/4294967296.d0
      bnd10CD(5,8) = 59459400.d0/4294967296.d0
      bnd10CD(5,9) = -11561550.d0/4294967296.d0
      bnd10CD(5,10) = 1051050.d0/4294967296.d0
      bnd10CD(6,1) = -990990.d0/4294967296.d0
      bnd10CD(6,2) = 12486474.d0/4294967296.d0
      bnd10CD(6,3) = -83243160.d0/4294967296.d0
      bnd10CD(6,4) = 582702120.d0/4294967296.d0
      bnd10CD(6,5) = 874053180.d0/4294967296.d0
      bnd10CD(6,6) = -291351060.d0/4294967296.d0
      bnd10CD(6,7) = 116540424.d0/4294967296.d0
      bnd10CD(6,8) = -35675640.d0/4294967296.d0
      bnd10CD(6,9) = 6936930.d0/4294967296.d0
      bnd10CD(6,10) = -630630.d0/4294967296.d0
      bnd10CD(7,1) = 471900.d0/4294967296.d0
      bnd10CD(7,2) = -5945940.d0/4294967296.d0
      bnd10CD(7,3) = 39639600.d0/4294967296.d0
      bnd10CD(7,4) = -277477200.d0/4294967296.d0
      bnd10CD(7,5) = -416215800.d0/4294967296.d0
      bnd10CD(7,6) = 138738600.d0/4294967296.d0
      bnd10CD(7,7) = -55495440.d0/4294967296.d0
      bnd10CD(7,8) = 16988400.d0/4294967296.d0
      bnd10CD(7,9) = -3303300.d0/4294967296.d0
      bnd10CD(7,10) = 300300.d0/4294967296.d0
      bnd10CD(8,1) = -157300.d0/4294967296.d0
      bnd10CD(8,2) = 1981980.d0/4294967296.d0
      bnd10CD(8,3) = -13213200.d0/4294967296.d0
      bnd10CD(8,4) = 92492400.d0/4294967296.d0
      bnd10CD(8,5) = 138738600.d0/4294967296.d0
      bnd10CD(8,6) = -46246200.d0/4294967296.d0
      bnd10CD(8,7) = 18498480.d0/4294967296.d0
      bnd10CD(8,8) = -5662800.d0/4294967296.d0
      bnd10CD(8,9) = 1101100.d0/4294967296.d0
      bnd10CD(8,10) = -100100.d0/4294967296.d0
      bnd10CD(9,1) = 32175.d0/4294967296.d0
      bnd10CD(9,2) = -405405.d0/4294967296.d0
      bnd10CD(9,3) = 2702700.d0/4294967296.d0
      bnd10CD(9,4) = -18918900.d0/4294967296.d0
      bnd10CD(9,5) = -28378350.d0/4294967296.d0
      bnd10CD(9,6) = 9459450.d0/4294967296.d0
      bnd10CD(9,7) = -3783780.d0/4294967296.d0
      bnd10CD(9,8) = 1158300.d0/4294967296.d0
      bnd10CD(9,9) = -225225.d0/4294967296.d0
      bnd10CD(9,10) = 20475.d0/4294967296.d0
      bnd10CD(10,1) = -3025.d0/4294967296.d0
      bnd10CD(10,2) = 38115.d0/4294967296.d0
      bnd10CD(10,3) = -254100.d0/4294967296.d0
      bnd10CD(10,4) = 1778700.d0/4294967296.d0
      bnd10CD(10,5) = 2668050.d0/4294967296.d0
      bnd10CD(10,6) = -889350.d0/4294967296.d0
      bnd10CD(10,7) = 355740.d0/4294967296.d0
      bnd10CD(10,8) = -108900.d0/4294967296.d0
      bnd10CD(10,9) = 21175.d0/4294967296.d0
      bnd10CD(10,10) = -1925.d0/4294967296.d0
!
      bnd10CE(1,1) = 5005.d0/4294967296.d0
      bnd10CE(1,2) = -57915.d0/4294967296.d0
      bnd10CE(1,3) = 324324.d0/4294967296.d0
      bnd10CE(1,4) = -1261260.d0/4294967296.d0
      bnd10CE(1,5) = 5675670.d0/4294967296.d0
      bnd10CE(1,6) = 5675670.d0/4294967296.d0
      bnd10CE(1,7) = -1261260.d0/4294967296.d0
      bnd10CE(1,8) = 324324.d0/4294967296.d0
      bnd10CE(1,9) = -57915.d0/4294967296.d0
      bnd10CE(1,10) = 5005.d0/4294967296.d0
      bnd10CE(2,1) = -75075.d0/4294967296.d0
      bnd10CE(2,2) = 868725.d0/4294967296.d0
      bnd10CE(2,3) = -4864860.d0/4294967296.d0
      bnd10CE(2,4) = 18918900.d0/4294967296.d0
      bnd10CE(2,5) = -85135050.d0/4294967296.d0
      bnd10CE(2,6) = -85135050.d0/4294967296.d0
      bnd10CE(2,7) = 18918900.d0/4294967296.d0
      bnd10CE(2,8) = -4864860.d0/4294967296.d0
      bnd10CE(2,9) = 868725.d0/4294967296.d0
      bnd10CE(2,10) = -75075.d0/4294967296.d0
      bnd10CE(3,1) = 900900.d0/4294967296.d0
      bnd10CE(3,2) = -10424700.d0/4294967296.d0
      bnd10CE(3,3) = 58378320.d0/4294967296.d0
      bnd10CE(3,4) = -227026800.d0/4294967296.d0
      bnd10CE(3,5) = 1021620600.d0/4294967296.d0
      bnd10CE(3,6) = 1021620600.d0/4294967296.d0
      bnd10CE(3,7) = -227026800.d0/4294967296.d0
      bnd10CE(3,8) = 58378320.d0/4294967296.d0
      bnd10CE(3,9) = -10424700.d0/4294967296.d0
      bnd10CE(3,10) = 900900.d0/4294967296.d0
      bnd10CE(4,1) = 2102100.d0/4294967296.d0
      bnd10CE(4,2) = -24324300.d0/4294967296.d0
      bnd10CE(4,3) = 136216080.d0/4294967296.d0
      bnd10CE(4,4) = -529729200.d0/4294967296.d0
      bnd10CE(4,5) = 2383781400.d0/4294967296.d0
      bnd10CE(4,6) = 2383781400.d0/4294967296.d0
      bnd10CE(4,7) = -529729200.d0/4294967296.d0
      bnd10CE(4,8) = 136216080.d0/4294967296.d0
      bnd10CE(4,9) = -24324300.d0/4294967296.d0
      bnd10CE(4,10) = 2102100.d0/4294967296.d0
      bnd10CE(5,1) = -1051050.d0/4294967296.d0
      bnd10CE(5,2) = 12162150.d0/4294967296.d0
      bnd10CE(5,3) = -68108040.d0/4294967296.d0
      bnd10CE(5,4) = 264864600.d0/4294967296.d0
      bnd10CE(5,5) = -1191890700.d0/4294967296.d0
      bnd10CE(5,6) = -1191890700.d0/4294967296.d0
      bnd10CE(5,7) = 264864600.d0/4294967296.d0
      bnd10CE(5,8) = -68108040.d0/4294967296.d0
      bnd10CE(5,9) = 12162150.d0/4294967296.d0
      bnd10CE(5,10) = -1051050.d0/4294967296.d0
      bnd10CE(6,1) = 630630.d0/4294967296.d0
      bnd10CE(6,2) = -7297290.d0/4294967296.d0
      bnd10CE(6,3) = 40864824.d0/4294967296.d0
      bnd10CE(6,4) = -158918760.d0/4294967296.d0
      bnd10CE(6,5) = 715134420.d0/4294967296.d0
      bnd10CE(6,6) = 715134420.d0/4294967296.d0
      bnd10CE(6,7) = -158918760.d0/4294967296.d0
      bnd10CE(6,8) = 40864824.d0/4294967296.d0
      bnd10CE(6,9) = -7297290.d0/4294967296.d0
      bnd10CE(6,10) = 630630.d0/4294967296.d0
      bnd10CE(7,1) = -300300.d0/4294967296.d0
      bnd10CE(7,2) = 3474900.d0/4294967296.d0
      bnd10CE(7,3) = -19459440.d0/4294967296.d0
      bnd10CE(7,4) = 75675600.d0/4294967296.d0
      bnd10CE(7,5) = -340540200.d0/4294967296.d0
      bnd10CE(7,6) = -340540200.d0/4294967296.d0
      bnd10CE(7,7) = 75675600.d0/4294967296.d0
      bnd10CE(7,8) = -19459440.d0/4294967296.d0
      bnd10CE(7,9) = 3474900.d0/4294967296.d0
      bnd10CE(7,10) = -300300.d0/4294967296.d0
      bnd10CE(8,1) = 100100.d0/4294967296.d0
      bnd10CE(8,2) = -1158300.d0/4294967296.d0
      bnd10CE(8,3) = 6486480.d0/4294967296.d0
      bnd10CE(8,4) = -25225200.d0/4294967296.d0
      bnd10CE(8,5) = 113513400.d0/4294967296.d0
      bnd10CE(8,6) = 113513400.d0/4294967296.d0
      bnd10CE(8,7) = -25225200.d0/4294967296.d0
      bnd10CE(8,8) = 6486480.d0/4294967296.d0
      bnd10CE(8,9) = -1158300.d0/4294967296.d0
      bnd10CE(8,10) = 100100.d0/4294967296.d0
      bnd10CE(9,1) = -20475.d0/4294967296.d0
      bnd10CE(9,2) = 236925.d0/4294967296.d0
      bnd10CE(9,3) = -1326780.d0/4294967296.d0
      bnd10CE(9,4) = 5159700.d0/4294967296.d0
      bnd10CE(9,5) = -23218650.d0/4294967296.d0
      bnd10CE(9,6) = -23218650.d0/4294967296.d0
      bnd10CE(9,7) = 5159700.d0/4294967296.d0
      bnd10CE(9,8) = -1326780.d0/4294967296.d0
      bnd10CE(9,9) = 236925.d0/4294967296.d0
      bnd10CE(9,10) = -20475.d0/4294967296.d0
      bnd10CE(10,1) = 1925.d0/4294967296.d0
      bnd10CE(10,2) = -22275.d0/4294967296.d0
      bnd10CE(10,3) = 124740.d0/4294967296.d0
      bnd10CE(10,4) = -485100.d0/4294967296.d0
      bnd10CE(10,5) = 2182950.d0/4294967296.d0
      bnd10CE(10,6) = 2182950.d0/4294967296.d0
      bnd10CE(10,7) = -485100.d0/4294967296.d0
      bnd10CE(10,8) = 124740.d0/4294967296.d0
      bnd10CE(10,9) = -22275.d0/4294967296.d0
      bnd10CE(10,10) = 1925.d0/4294967296.d0
!
      bnd10DD(1,1) = 3025.d0/4294967296.d0
      bnd10DD(1,2) = -38115.d0/4294967296.d0
      bnd10DD(1,3) = 254100.d0/4294967296.d0
      bnd10DD(1,4) = -1778700.d0/4294967296.d0
      bnd10DD(1,5) = -2668050.d0/4294967296.d0
      bnd10DD(1,6) = 889350.d0/4294967296.d0
      bnd10DD(1,7) = -355740.d0/4294967296.d0
      bnd10DD(1,8) = 108900.d0/4294967296.d0
      bnd10DD(1,9) = -21175.d0/4294967296.d0
      bnd10DD(1,10) = 1925.d0/4294967296.d0
      bnd10DD(2,1) = -38115.d0/4294967296.d0
      bnd10DD(2,2) = 480249.d0/4294967296.d0
      bnd10DD(2,3) = -3201660.d0/4294967296.d0
      bnd10DD(2,4) = 22411620.d0/4294967296.d0
      bnd10DD(2,5) = 33617430.d0/4294967296.d0
      bnd10DD(2,6) = -11205810.d0/4294967296.d0
      bnd10DD(2,7) = 4482324.d0/4294967296.d0
      bnd10DD(2,8) = -1372140.d0/4294967296.d0
      bnd10DD(2,9) = 266805.d0/4294967296.d0
      bnd10DD(2,10) = -24255.d0/4294967296.d0
      bnd10DD(3,1) = 254100.d0/4294967296.d0
      bnd10DD(3,2) = -3201660.d0/4294967296.d0
      bnd10DD(3,3) = 21344400.d0/4294967296.d0
      bnd10DD(3,4) = -149410800.d0/4294967296.d0
      bnd10DD(3,5) = -224116200.d0/4294967296.d0
      bnd10DD(3,6) = 74705400.d0/4294967296.d0
      bnd10DD(3,7) = -29882160.d0/4294967296.d0
      bnd10DD(3,8) = 9147600.d0/4294967296.d0
      bnd10DD(3,9) = -1778700.d0/4294967296.d0
      bnd10DD(3,10) = 161700.d0/4294967296.d0
      bnd10DD(4,1) = -1778700.d0/4294967296.d0
      bnd10DD(4,2) = 22411620.d0/4294967296.d0
      bnd10DD(4,3) = -149410800.d0/4294967296.d0
      bnd10DD(4,4) = 1045875600.d0/4294967296.d0
      bnd10DD(4,5) = 1568813400.d0/4294967296.d0
      bnd10DD(4,6) = -522937800.d0/4294967296.d0
      bnd10DD(4,7) = 209175120.d0/4294967296.d0
      bnd10DD(4,8) = -64033200.d0/4294967296.d0
      bnd10DD(4,9) = 12450900.d0/4294967296.d0
      bnd10DD(4,10) = -1131900.d0/4294967296.d0
      bnd10DD(5,1) = -2668050.d0/4294967296.d0
      bnd10DD(5,2) = 33617430.d0/4294967296.d0
      bnd10DD(5,3) = -224116200.d0/4294967296.d0
      bnd10DD(5,4) = 1568813400.d0/4294967296.d0
      bnd10DD(5,5) = 2353220100.d0/4294967296.d0
      bnd10DD(5,6) = -784406700.d0/4294967296.d0
      bnd10DD(5,7) = 313762680.d0/4294967296.d0
      bnd10DD(5,8) = -96049800.d0/4294967296.d0
      bnd10DD(5,9) = 18676350.d0/4294967296.d0
      bnd10DD(5,10) = -1697850.d0/4294967296.d0
      bnd10DD(6,1) = 889350.d0/4294967296.d0
      bnd10DD(6,2) = -11205810.d0/4294967296.d0
      bnd10DD(6,3) = 74705400.d0/4294967296.d0
      bnd10DD(6,4) = -522937800.d0/4294967296.d0
      bnd10DD(6,5) = -784406700.d0/4294967296.d0
      bnd10DD(6,6) = 261468900.d0/4294967296.d0
      bnd10DD(6,7) = -104587560.d0/4294967296.d0
      bnd10DD(6,8) = 32016600.d0/4294967296.d0
      bnd10DD(6,9) = -6225450.d0/4294967296.d0
      bnd10DD(6,10) = 565950.d0/4294967296.d0
      bnd10DD(7,1) = -355740.d0/4294967296.d0
      bnd10DD(7,2) = 4482324.d0/4294967296.d0
      bnd10DD(7,3) = -29882160.d0/4294967296.d0
      bnd10DD(7,4) = 209175120.d0/4294967296.d0
      bnd10DD(7,5) = 313762680.d0/4294967296.d0
      bnd10DD(7,6) = -104587560.d0/4294967296.d0
      bnd10DD(7,7) = 41835024.d0/4294967296.d0
      bnd10DD(7,8) = -12806640.d0/4294967296.d0
      bnd10DD(7,9) = 2490180.d0/4294967296.d0
      bnd10DD(7,10) = -226380.d0/4294967296.d0
      bnd10DD(8,1) = 108900.d0/4294967296.d0
      bnd10DD(8,2) = -1372140.d0/4294967296.d0
      bnd10DD(8,3) = 9147600.d0/4294967296.d0
      bnd10DD(8,4) = -64033200.d0/4294967296.d0
      bnd10DD(8,5) = -96049800.d0/4294967296.d0
      bnd10DD(8,6) = 32016600.d0/4294967296.d0
      bnd10DD(8,7) = -12806640.d0/4294967296.d0
      bnd10DD(8,8) = 3920400.d0/4294967296.d0
      bnd10DD(8,9) = -762300.d0/4294967296.d0
      bnd10DD(8,10) = 69300.d0/4294967296.d0
      bnd10DD(9,1) = -21175.d0/4294967296.d0
      bnd10DD(9,2) = 266805.d0/4294967296.d0
      bnd10DD(9,3) = -1778700.d0/4294967296.d0
      bnd10DD(9,4) = 12450900.d0/4294967296.d0
      bnd10DD(9,5) = 18676350.d0/4294967296.d0
      bnd10DD(9,6) = -6225450.d0/4294967296.d0
      bnd10DD(9,7) = 2490180.d0/4294967296.d0
      bnd10DD(9,8) = -762300.d0/4294967296.d0
      bnd10DD(9,9) = 148225.d0/4294967296.d0
      bnd10DD(9,10) = -13475.d0/4294967296.d0
      bnd10DD(10,1) = 1925.d0/4294967296.d0
      bnd10DD(10,2) = -24255.d0/4294967296.d0
      bnd10DD(10,3) = 161700.d0/4294967296.d0
      bnd10DD(10,4) = -1131900.d0/4294967296.d0
      bnd10DD(10,5) = -1697850.d0/4294967296.d0
      bnd10DD(10,6) = 565950.d0/4294967296.d0
      bnd10DD(10,7) = -226380.d0/4294967296.d0
      bnd10DD(10,8) = 69300.d0/4294967296.d0
      bnd10DD(10,9) = -13475.d0/4294967296.d0
      bnd10DD(10,10) = 1225.d0/4294967296.d0
!
      bnd10DE(1,1) = -1925.d0/4294967296.d0
      bnd10DE(1,2) = 22275.d0/4294967296.d0
      bnd10DE(1,3) = -124740.d0/4294967296.d0
      bnd10DE(1,4) = 485100.d0/4294967296.d0
      bnd10DE(1,5) = -2182950.d0/4294967296.d0
      bnd10DE(1,6) = -2182950.d0/4294967296.d0
      bnd10DE(1,7) = 485100.d0/4294967296.d0
      bnd10DE(1,8) = -124740.d0/4294967296.d0
      bnd10DE(1,9) = 22275.d0/4294967296.d0
      bnd10DE(1,10) = -1925.d0/4294967296.d0
      bnd10DE(2,1) = 24255.d0/4294967296.d0
      bnd10DE(2,2) = -280665.d0/4294967296.d0
      bnd10DE(2,3) = 1571724.d0/4294967296.d0
      bnd10DE(2,4) = -6112260.d0/4294967296.d0
      bnd10DE(2,5) = 27505170.d0/4294967296.d0
      bnd10DE(2,6) = 27505170.d0/4294967296.d0
      bnd10DE(2,7) = -6112260.d0/4294967296.d0
      bnd10DE(2,8) = 1571724.d0/4294967296.d0
      bnd10DE(2,9) = -280665.d0/4294967296.d0
      bnd10DE(2,10) = 24255.d0/4294967296.d0
      bnd10DE(3,1) = -161700.d0/4294967296.d0
      bnd10DE(3,2) = 1871100.d0/4294967296.d0
      bnd10DE(3,3) = -10478160.d0/4294967296.d0
      bnd10DE(3,4) = 40748400.d0/4294967296.d0
      bnd10DE(3,5) = -183367800.d0/4294967296.d0
      bnd10DE(3,6) = -183367800.d0/4294967296.d0
      bnd10DE(3,7) = 40748400.d0/4294967296.d0
      bnd10DE(3,8) = -10478160.d0/4294967296.d0
      bnd10DE(3,9) = 1871100.d0/4294967296.d0
      bnd10DE(3,10) = -161700.d0/4294967296.d0
      bnd10DE(4,1) = 1131900.d0/4294967296.d0
      bnd10DE(4,2) = -13097700.d0/4294967296.d0
      bnd10DE(4,3) = 73347120.d0/4294967296.d0
      bnd10DE(4,4) = -285238800.d0/4294967296.d0
      bnd10DE(4,5) = 1283574600.d0/4294967296.d0
      bnd10DE(4,6) = 1283574600.d0/4294967296.d0
      bnd10DE(4,7) = -285238800.d0/4294967296.d0
      bnd10DE(4,8) = 73347120.d0/4294967296.d0
      bnd10DE(4,9) = -13097700.d0/4294967296.d0
      bnd10DE(4,10) = 1131900.d0/4294967296.d0
      bnd10DE(5,1) = 1697850.d0/4294967296.d0
      bnd10DE(5,2) = -19646550.d0/4294967296.d0
      bnd10DE(5,3) = 110020680.d0/4294967296.d0
      bnd10DE(5,4) = -427858200.d0/4294967296.d0
      bnd10DE(5,5) = 1925361900.d0/4294967296.d0
      bnd10DE(5,6) = 1925361900.d0/4294967296.d0
      bnd10DE(5,7) = -427858200.d0/4294967296.d0
      bnd10DE(5,8) = 110020680.d0/4294967296.d0
      bnd10DE(5,9) = -19646550.d0/4294967296.d0
      bnd10DE(5,10) = 1697850.d0/4294967296.d0
      bnd10DE(6,1) = -565950.d0/4294967296.d0
      bnd10DE(6,2) = 6548850.d0/4294967296.d0
      bnd10DE(6,3) = -36673560.d0/4294967296.d0
      bnd10DE(6,4) = 142619400.d0/4294967296.d0
      bnd10DE(6,5) = -641787300.d0/4294967296.d0
      bnd10DE(6,6) = -641787300.d0/4294967296.d0
      bnd10DE(6,7) = 142619400.d0/4294967296.d0
      bnd10DE(6,8) = -36673560.d0/4294967296.d0
      bnd10DE(6,9) = 6548850.d0/4294967296.d0
      bnd10DE(6,10) = -565950.d0/4294967296.d0
      bnd10DE(7,1) = 226380.d0/4294967296.d0
      bnd10DE(7,2) = -2619540.d0/4294967296.d0
      bnd10DE(7,3) = 14669424.d0/4294967296.d0
      bnd10DE(7,4) = -57047760.d0/4294967296.d0
      bnd10DE(7,5) = 256714920.d0/4294967296.d0
      bnd10DE(7,6) = 256714920.d0/4294967296.d0
      bnd10DE(7,7) = -57047760.d0/4294967296.d0
      bnd10DE(7,8) = 14669424.d0/4294967296.d0
      bnd10DE(7,9) = -2619540.d0/4294967296.d0
      bnd10DE(7,10) = 226380.d0/4294967296.d0
      bnd10DE(8,1) = -69300.d0/4294967296.d0
      bnd10DE(8,2) = 801900.d0/4294967296.d0
      bnd10DE(8,3) = -4490640.d0/4294967296.d0
      bnd10DE(8,4) = 17463600.d0/4294967296.d0
      bnd10DE(8,5) = -78586200.d0/4294967296.d0
      bnd10DE(8,6) = -78586200.d0/4294967296.d0
      bnd10DE(8,7) = 17463600.d0/4294967296.d0
      bnd10DE(8,8) = -4490640.d0/4294967296.d0
      bnd10DE(8,9) = 801900.d0/4294967296.d0
      bnd10DE(8,10) = -69300.d0/4294967296.d0
      bnd10DE(9,1) = 13475.d0/4294967296.d0
      bnd10DE(9,2) = -155925.d0/4294967296.d0
      bnd10DE(9,3) = 873180.d0/4294967296.d0
      bnd10DE(9,4) = -3395700.d0/4294967296.d0
      bnd10DE(9,5) = 15280650.d0/4294967296.d0
      bnd10DE(9,6) = 15280650.d0/4294967296.d0
      bnd10DE(9,7) = -3395700.d0/4294967296.d0
      bnd10DE(9,8) = 873180.d0/4294967296.d0
      bnd10DE(9,9) = -155925.d0/4294967296.d0
      bnd10DE(9,10) = 13475.d0/4294967296.d0
      bnd10DE(10,1) = -1225.d0/4294967296.d0
      bnd10DE(10,2) = 14175.d0/4294967296.d0
      bnd10DE(10,3) = -79380.d0/4294967296.d0
      bnd10DE(10,4) = 308700.d0/4294967296.d0
      bnd10DE(10,5) = -1389150.d0/4294967296.d0
      bnd10DE(10,6) = -1389150.d0/4294967296.d0
      bnd10DE(10,7) = 308700.d0/4294967296.d0
      bnd10DE(10,8) = -79380.d0/4294967296.d0
      bnd10DE(10,9) = 14175.d0/4294967296.d0
      bnd10DE(10,10) = -1225.d0/4294967296.d0
!
      bnd10I(1,1) = 1225.d0/4294967296.d0
      bnd10I(1,2) = -14175.d0/4294967296.d0
      bnd10I(1,3) = 79380.d0/4294967296.d0
      bnd10I(1,4) = -308700.d0/4294967296.d0
      bnd10I(1,5) = 1389150.d0/4294967296.d0
      bnd10I(1,6) = 1389150.d0/4294967296.d0
      bnd10I(1,7) = -308700.d0/4294967296.d0
      bnd10I(1,8) = 79380.d0/4294967296.d0
      bnd10I(1,9) = -14175.d0/4294967296.d0
      bnd10I(1,10) = 1225.d0/4294967296.d0
      bnd10I(2,1) = -14175.d0/4294967296.d0
      bnd10I(2,2) = 164025.d0/4294967296.d0
      bnd10I(2,3) = -918540.d0/4294967296.d0
      bnd10I(2,4) = 3572100.d0/4294967296.d0
      bnd10I(2,5) = -16074450.d0/4294967296.d0
      bnd10I(2,6) = -16074450.d0/4294967296.d0
      bnd10I(2,7) = 3572100.d0/4294967296.d0
      bnd10I(2,8) = -918540.d0/4294967296.d0
      bnd10I(2,9) = 164025.d0/4294967296.d0
      bnd10I(2,10) = -14175.d0/4294967296.d0
      bnd10I(3,1) = 79380.d0/4294967296.d0
      bnd10I(3,2) = -918540.d0/4294967296.d0
      bnd10I(3,3) = 5143824.d0/4294967296.d0
      bnd10I(3,4) = -20003760.d0/4294967296.d0
      bnd10I(3,5) = 90016920.d0/4294967296.d0
      bnd10I(3,6) = 90016920.d0/4294967296.d0
      bnd10I(3,7) = -20003760.d0/4294967296.d0
      bnd10I(3,8) = 5143824.d0/4294967296.d0
      bnd10I(3,9) = -918540.d0/4294967296.d0
      bnd10I(3,10) = 79380.d0/4294967296.d0
      bnd10I(4,1) = -308700.d0/4294967296.d0
      bnd10I(4,2) = 3572100.d0/4294967296.d0
      bnd10I(4,3) = -20003760.d0/4294967296.d0
      bnd10I(4,4) = 77792400.d0/4294967296.d0
      bnd10I(4,5) = -350065800.d0/4294967296.d0
      bnd10I(4,6) = -350065800.d0/4294967296.d0
      bnd10I(4,7) = 77792400.d0/4294967296.d0
      bnd10I(4,8) = -20003760.d0/4294967296.d0
      bnd10I(4,9) = 3572100.d0/4294967296.d0
      bnd10I(4,10) = -308700.d0/4294967296.d0
      bnd10I(5,1) = 1389150.d0/4294967296.d0
      bnd10I(5,2) = -16074450.d0/4294967296.d0
      bnd10I(5,3) = 90016920.d0/4294967296.d0
      bnd10I(5,4) = -350065800.d0/4294967296.d0
      bnd10I(5,5) = 1575296100.d0/4294967296.d0
      bnd10I(5,6) = 1575296100.d0/4294967296.d0
      bnd10I(5,7) = -350065800.d0/4294967296.d0
      bnd10I(5,8) = 90016920.d0/4294967296.d0
      bnd10I(5,9) = -16074450.d0/4294967296.d0
      bnd10I(5,10) = 1389150.d0/4294967296.d0
      bnd10I(6,1) = 1389150.d0/4294967296.d0
      bnd10I(6,2) = -16074450.d0/4294967296.d0
      bnd10I(6,3) = 90016920.d0/4294967296.d0
      bnd10I(6,4) = -350065800.d0/4294967296.d0
      bnd10I(6,5) = 1575296100.d0/4294967296.d0
      bnd10I(6,6) = 1575296100.d0/4294967296.d0
      bnd10I(6,7) = -350065800.d0/4294967296.d0
      bnd10I(6,8) = 90016920.d0/4294967296.d0
      bnd10I(6,9) = -16074450.d0/4294967296.d0
      bnd10I(6,10) = 1389150.d0/4294967296.d0
      bnd10I(7,1) = -308700.d0/4294967296.d0
      bnd10I(7,2) = 3572100.d0/4294967296.d0
      bnd10I(7,3) = -20003760.d0/4294967296.d0
      bnd10I(7,4) = 77792400.d0/4294967296.d0
      bnd10I(7,5) = -350065800.d0/4294967296.d0
      bnd10I(7,6) = -350065800.d0/4294967296.d0
      bnd10I(7,7) = 77792400.d0/4294967296.d0
      bnd10I(7,8) = -20003760.d0/4294967296.d0
      bnd10I(7,9) = 3572100.d0/4294967296.d0
      bnd10I(7,10) = -308700.d0/4294967296.d0
      bnd10I(8,1) = 79380.d0/4294967296.d0
      bnd10I(8,2) = -918540.d0/4294967296.d0
      bnd10I(8,3) = 5143824.d0/4294967296.d0
      bnd10I(8,4) = -20003760.d0/4294967296.d0
      bnd10I(8,5) = 90016920.d0/4294967296.d0
      bnd10I(8,6) = 90016920.d0/4294967296.d0
      bnd10I(8,7) = -20003760.d0/4294967296.d0
      bnd10I(8,8) = 5143824.d0/4294967296.d0
      bnd10I(8,9) = -918540.d0/4294967296.d0
      bnd10I(8,10) = 79380.d0/4294967296.d0
      bnd10I(9,1) = -14175.d0/4294967296.d0
      bnd10I(9,2) = 164025.d0/4294967296.d0
      bnd10I(9,3) = -918540.d0/4294967296.d0
      bnd10I(9,4) = 3572100.d0/4294967296.d0
      bnd10I(9,5) = -16074450.d0/4294967296.d0
      bnd10I(9,6) = -16074450.d0/4294967296.d0
      bnd10I(9,7) = 3572100.d0/4294967296.d0
      bnd10I(9,8) = -918540.d0/4294967296.d0
      bnd10I(9,9) = 164025.d0/4294967296.d0
      bnd10I(9,10) = -14175.d0/4294967296.d0
      bnd10I(10,1) = 1225.d0/4294967296.d0
      bnd10I(10,2) = -14175.d0/4294967296.d0
      bnd10I(10,3) = 79380.d0/4294967296.d0
      bnd10I(10,4) = -308700.d0/4294967296.d0
      bnd10I(10,5) = 1389150.d0/4294967296.d0
      bnd10I(10,6) = 1389150.d0/4294967296.d0
      bnd10I(10,7) = -308700.d0/4294967296.d0
      bnd10I(10,8) = 79380.d0/4294967296.d0
      bnd10I(10,9) = -14175.d0/4294967296.d0
      bnd10I(10,10) = 1225.d0/4294967296.d0
!
! 12th-order
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!      bnd12AA(1,1) = 7775536041.d0/274877906944.d0
!      bnd12I(12,12) = 3969.d0/274877906944.d0

!
      return
      end
!====================================================================
