c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!  ======================================================================
!  XY_INTP_CF_VC, YZ_INTP_CF_VC, and ZX_INTP_CF_VC interpolate the value 
!    of f from a uniform grid to the midpoints of that uniform grid (also 
!    a uniform grid) using explicit finite differences. The routine is set 
!    up with the Coarse-to-Fine interpolation for Vertex-Centered AMR 
!    applications in mind. Each routine does 2D interpolation. In terms of
!    interpolants, centered stencils are provided that go as high as 
!    8th-order accuracy. Higher-order boundary closures are included 
!    but may give rise to time unstable spatial discretizations. As
!    there currently does not exist a theory of time-stable boundary 
!    closure to interpolants, caveat emptor. This routine does 
!    not allow for nonuniform grids but grid spacings (dx, dy, and dz) 
!    may be set arbitrarily. These interpolation routines are hardwired
!    for the same operator in all directions! 
!
!    It is assumed that the incoming variable, f, comes in on the grid
!    points ..., (x_{i-1},y_{i-1}), (x_{i},y_{i-1}), ..., (x_{i+1},y_{i+1})
!    , ... and that d0f is given on the grid points ..., (x_{i-1/2},y_{i-1/2}),
!    (x_{i+1/2},y_{i-1/2}), ..., (x_{i+3/2},y_{i+1/2}), etc. If N^2 values
!    of f enter this routine then it outputs (N-1)^2 values of d0f.
!    Ditto for the yz- and zx-directions.
!
!    This routine has been set up to be quite general. Arrays f and d0f,
!    are allowed to enter the routine having arbitrary array
!    bounds. The calling routine must additionally specify the number
!    of green cells that are provided on all six boundaries as well
!    as delineate the exact region where derivatives are needed. Note
!    that not all elements of array df will be filled with useful 
!    derivatives. This depends on what the user specified for the array 
!    bounds. The key point is that all arrays are dimensioned relative to
!    the same grid; something the calling routine needs to reconcile.
!
!    Green cells are grid points that have been added to the current mesh
!    level by interpolating variables from the next most coarse grid.
!    They are placed around the interior patch to allow for the avoidance 
!    of non-centered derivative operators. In the interior portions of the 
!    computation, GrACE will drop the necessary number of green cells so 
!    that skewed stencils are unnecessary but near physical boundaries, 
!    this may not be possible. In these cases, one needs to establish how 
!    many boundary points there are and close them properly. This is why 
!    left and right protrusions of stencils are considered. If the interior 
!    operator needs four boundary points closed but there are only three 
!    green cells then the net protrusion is one. This means that only one 
!    boundary point must be closed with one-sided derivatives. If CORNER
!    is false then 2D corners will assume that there are no green cells.
!
!    Here's how the 2D-interpolants are called:
!
!     subroutine xy_intp_cf_vc
!    &    (f,d0f,orderi,orderb,
!    &     biL, biR, bjL, bjR, bkL, bkR,
!    &     fiL, fiR, fjL, fjR, fkL, fkR,
!    &     iiL, iiR, ijL, ijR, ikL, ikR,
!    &     dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
!    &     iperx,ipery,iperz,ierror,error,
!    &     corner)
!
! INPUT
!  
!  f      - Function to be differentiated
!  orderi - Order of accuracy of the interior operator
!  orderb - Formal order of accuracy of the wall point boundary operator 
!           Currently not used!!
!  fiL    - Global coordinates for f ( Left side of x-direction)
!  fiR    - Global coordinates for f (Right side of x-direction)
!  fjL    - Global coordinates for f ( Left side of y-direction)
!  fjR    - Global coordinates for f (Right side of y-direction)
!  fkL    - Global coordinates for f ( Left side of z-direction)
!  fkR    - Global coordinates for f (Right side of z-direction)
!  dfiL   - Global coordinates for df patch ( Left side of x-direction)
!  dfiR   - Global coordinates for df patch (Right side of x-direction)
!  dfjL   - Global coordinates for df patch ( Left side of y-direction)
!  dfjR   - Global coordinates for df patch (Right side of y-direction)
!  dfkL   - Global coordinates for df patch ( Left side of z-direction)
!  dfkR   - Global coordinates for df patch (Right side of z-direction)
!  iiL    - Global coordinates for df ( Left side of x-direction)
!  iiR    - Global coordinates for df (Right side of x-direction)
!  ijL    - Global coordinates for df ( Left side of y-direction)
!  ijR    - Global coordinates for df (Right side of y-direction)
!  ikL    - Global coordinates for df ( Left side of z-direction)
!  ikR    - Global coordinates for df (Right side of z-direction)
!  viL    - Global coordinates for vel ( Left side of x-direction)
!  viR    - Global coordinates for vel (Right side of x-direction)
!  vjL    - Global coordinates for vel ( Left side of y-direction)
!  vjR    - Global coordinates for vel (Right side of y-direction)
!  vkL    - Global coordinates for vel ( Left side of z-direction)
!  vlR    - Global coordinates for vel (Right side of z-direction)
!  biL    - Number of green cells at left side of x-direction
!  biR    - Number of green cells at right side of x-direction
!  bjL    - Number of green cells at left side of y-direction
!  bjR    - Number of green cells at right side of y-direction
!  bkL    - Number of green cells at left side of z-direction
!  bkR    - Number of green cells at right side of z-direction
!  iperx  - Is the x-direction periodic -> (0) no, (1) yes
!  ipery  - Is the y-direction periodic -> (0) no, (1) yes
!  iperz  - Is the z-direction periodic -> (0) no, (1) yes
!  ierror - Error message - See below
!  corner - Are corner points available for interpolation?
!
! OUTPUT
!
!  d0f    - Interpolated Function
!
! LOCAL
!
!  proL   - Left protrusion of interior stencil
!  proR   - Right protrusion of interior stencil
!  promax - Maximum protrusion of interior stencil
!  nproL  - Net left protrusion of interior stencil
!  nproR  - Net right protrusion of interior stencil
!  width  - Total width of interior stencil
!  corner - Evaluate interpolants at corner points (.TRUE. or .FALSE.)
!  a1     - Explicit centered difference stencil coeff.
!  b1,b2  - Explicit centered difference stencil coeff.
!  c1,c2,c3 - Explicit centered difference stencil coeff.
!  d1,d2,d3,d4 - Explicit centered difference stencil coeff.
!  e1,e2,e3,e4,e5 - Explicit centered difference stencil coeff.
!  f1,f2,f3,f4,f5,f6 - Explicit centered difference stencil coeff.

!  Up     - Explicit centered difference stencil coeff. at (i +/- 0)
!  ae     - Explicit centered difference stencil coeff. at (i +/- 1)
!  be     - Explicit centered difference stencil coeff. at (i +/- 2)
!  ce     - Explicit centered difference stencil coeff. at (i +/- 3)
!  de     - Explicit centered difference stencil coeff. at (i +/- 4)
!  ee     - Explicit centered difference stencil coeff. at (i +/- 5)
!  fe     - Explicit centered difference stencil coeff. at (i +/- 6)
!  x,y,zbegin - Beginning index for interior stencil
!  x,y,zend   - Ending index for interior stencil
!  piL    - Global coordinates for df + green cells ( Left side of x-direction)
!  piR    - Global coordinates for df + green cells (Right side of x-direction)
!  pjL    - Global coordinates for df + green cells ( Left side of y-direction)
!  pjR    - Global coordinates for df + green cells (Right side of y-direction)
!  pkL    - Global coordinates for df + green cells ( Left side of z-direction)
!  pkR    - Global coordinates for df + green cells (Right side of z-direction)
!  piL    - Global coordinates for df + green cells ( Left side of x-direction)
!
! OPTIONS:
!  Centered Differences
!    2E [orderi= 2, orderb=none] (2E)
!    4E [orderi= 4, orderb= 4]              (4- 4E-4)
!    6E [orderi= 6, orderb= 6]            (6,6- 6E-6,6)
!    8E [orderi= 8, orderb= 8]          (8,8,8- 8E-8,8,8)
!   10E [orderi=10, orderb=10]    (10,10,10,10-10E-10,10,10,10)
!   12E [orderi=12, orderb=12] (12,12,12,12,12-12E-12,12,12,12,12)
!
! note: Formal overall order is unknown (to me!!)
!
! Initially written by Chris Kennedy in Dec. 2001
! Finished by Chris Kennedy in Feb. 2003
! Briefly upgraded to 10th and parts of 12th order by Chris Kennedy in Dec. 2005
!  ======================================================================
!
! Integer stuff
!
      implicit none
!
      integer proL,proR,promax,width
      integer nproLx, nproLy, nproLz
      integer nproRx, nproRy, nproRz
      integer nproLxC,nproLyC,nproLzC
      integer nproRxC,nproRyC,nproRzC
      integer   i,  j,  k
      integer  ii, jj, kk
      integer iii,jjj,kkk
      integer orderi,orderb
      integer ierror
      integer iperx, ipery, iperz
      integer xbegin,ybegin,zbegin
      integer xend,  yend,  zend
      integer  biL, biR, bjL, bjR, bkL, bkR
      integer  fiL, fiR, fjL, fjR, fkL, fkR
      integer  iiL, iiR, ijL, ijR, ikL, ikR
      integer  piL, piR, pjL, pjR, pkL, pkR
      integer dfiL,dfiR,dfjL,dfjR,dfkL,dfkR
!
      real*8    f( fiL: fiR, fjL:fjR , fkL: fkR)
      real*8  d0f(dfiL:dfiR,dfjL:dfjR,dfkL:dfkR)
      real*8 a1
      real*8 b1,b2
      real*8 c1,c2,c3
      real*8 d1,d2,d3,d4
      real*8 e1,e2,e3,e4,e5
      real*8 f1,f2,f3,f4,f5,f6
      real*8 sum
!
! CAK - This should have been bnd2I(2,2)
      real*8 bnd2AA(2,2)
!
      real*8 bnd4AA(4,4)
      real*8 bnd4AB(4,4)
      real*8 bnd4I(4,4)
!
      real*8 bnd6AA(6,6)
      real*8 bnd6AB(6,6)
      real*8 bnd6AC(6,6)
      real*8 bnd6BB(6,6)
      real*8 bnd6BC(6,6)
      real*8 bnd6I(6,6)
!
      real*8 bnd8AA(8,8)
      real*8 bnd8AB(8,8)
      real*8 bnd8AC(8,8)
      real*8 bnd8AD(8,8)
      real*8 bnd8BB(8,8)
      real*8 bnd8BC(8,8)
      real*8 bnd8BD(8,8)
      real*8 bnd8CC(8,8)
      real*8 bnd8CD(8,8)
      real*8 bnd8I(8,8)
!
      real*8 bnd10AA(10,10)
      real*8 bnd10AB(10,10)
      real*8 bnd10AC(10,10)
      real*8 bnd10AD(10,10)
      real*8 bnd10AE(10,10)
      real*8 bnd10BB(10,10)
      real*8 bnd10BC(10,10)
      real*8 bnd10BD(10,10)
      real*8 bnd10BE(10,10)
      real*8 bnd10CC(10,10)
      real*8 bnd10CD(10,10)
      real*8 bnd10CE(10,10)
      real*8 bnd10DD(10,10)
      real*8 bnd10DE(10,10)
      real*8 bnd10I(10,10)
!
!
! JR_CHANGE 04/15/06. Even if 12th-order is not being provided, keep its
! data structures around. We will add that later.
      real*8 bnd12AA(12,12)
      real*8 bnd12AB(12,12)
      real*8 bnd12AC(12,12)
      real*8 bnd12AD(12,12)
      real*8 bnd12AE(12,12)
      real*8 bnd12AF(12,12)
      real*8 bnd12BB(12,12)
      real*8 bnd12BC(12,12)
      real*8 bnd12BD(12,12)
      real*8 bnd12BE(12,12)
      real*8 bnd12BF(12,12)
      real*8 bnd12CC(12,12)
      real*8 bnd12CD(12,12)
      real*8 bnd12CE(12,12)
      real*8 bnd12CF(12,12)
      real*8 bnd12DD(12,12)
      real*8 bnd12DE(12,12)
      real*8 bnd12DF(12,12)
      real*8 bnd12EE(12,12)
      real*8 bnd12EF(12,12)
      real*8 bnd12I(12,12)
!
      character*60 error
!
      logical corner
