c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!===========================================================================
!
      subroutine der0_1D_cf_vc_pre( ierror, error, 
     &   xbegin,xend,ybegin,yend,zbegin,zend,
     &   bnd4A, bnd6A, bnd8A, bnd6B, bnd8B, bnd8C,
     &   bnd10A, bnd10B, bnd10C, bnd10D,
! JR_CHANGE 04/15/06. Even if 12th-order is not being provided, keep its
! data structures around. We will add that later.
     &   bnd12A, bnd12B, bnd12C, bnd12D, bnd12E,
     &   iperx,ipery,iperz, orderi, orderb,
     &   biL, biR, bjL, bjR, bkL, bkR,
     &   fiL, fiR, fjL, fjR, fkL, fkR,
     &   iiL, iiR, ijL, ijR, ikL, ikR,
     &   piL, piR, pjL, pjR, pkL, pkR,
     &   dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &   nproLx,nproRx,nproLy,nproRy,nproLz,nproRz,
     &   proL,proR,promax, jr_width)
!
      include 'der0_1D_cf_vc_include.h'
      integer jr_width
!
!======================================================================
!
! Initialize IERROR to zero implying no errors
!
      ierror = 0
!
! Boundaries of usable f patch
      piL = iiL - biL
      piR = iiR + biR
      pjL = ijL - bjL
      pjR = ijR + bjR
      pkL = ikL - bkL
      pkR = ikR + bkR
!
! Is the usable patch width larger than the width of f?
      if( min0(piL-fiL,fiR-piR,pjL-fjL,fjR-pjR,pkL-fkL,fkR-pkR)
     &   .lt. 0) then
        ierror = -10
        error = 'DER_0_1D: Interior + Green width > function width' 
        return
      endif
!
! Is the interior width larger than the width of df?
      if( min0(iiL-dfiL,dfiR-iiR,ijL-dfjL,dfjR-ijR,ikL-dfkL,dfkR-ikR)
     &   .lt. 0) then
        ierror = -20
        error = 'DER_0_1D: Interior width > derivative width' 
        return
      endif
!
! Have the number of green cells gone negative anywhere?
      if( min0(biL,biR,bjL,bjR,bkL,bkR) .lt. 0 ) then
        ierror = -40
        error = 'DER_0_1D: Green cell width < zero' 
        return
      endif
!
! Has the interior width gone negative?
      if( min0(iiR-iiL,ijR-ijL,ikR-ikL) .lt. 0 ) then
        ierror = -50
        error = 'DER_0_1D: Interior Width < zero' 
        return
      endif
!
! Stencil Widths
!
!   Centered stencils
!
      proL = -1
      proR = -1
!
      if( orderi .eq. 2 ) then
        proL = 0
        proR = 0
      elseif( orderi .eq. 4 ) then
        proL = 1
        proR = 1
      elseif( orderi .eq. 6 ) then
        proL = 2
        proR = 2
      elseif( orderi .eq. 8 ) then
        proL = 3
        proR = 3
      elseif( orderi .eq. 10 ) then
        proL = 4
        proR = 4
c     JR_CHANGE 04/15/06. Nope, not yet. No 12th order.
c      elseif( orderi .eq. 12 ) then
c        proL = 5
c        proR = 5
      endif
      width = proL + proR + 2
      jr_width = width
!
      if( ( proL .lt. 0) .or. ( proR .lt. 0) ) then
        ierror = -80
         error = 'DER_0_1D: No such scheme'
        return
      endif
!
      if( (iperx .lt. 0) .or. ( iperx .gt. 1) .or.
     &    (ipery .lt. 0) .or. ( ipery .gt. 1) .or.
     &    (iperz .lt. 0) .or. ( iperz .gt. 1) ) then
          ierror = -90
          error = 'DER_0_1D: Periodicity flags are set incorrectly'
          return
      endif
!
! Find maximum protrusion. 
!
      promax = max0( proL, proR )
!
! Determine where to begin Interior DO loops and how many
! boundary points need to be closed. Periodic domains
! will always (better) have enough green cells.
!
! X-direction
      if(( biL .ge. promax ) .or. (iperx .eq. 1)) then
        nproLx = 0
        xbegin = iiL
      else
        nproLx = promax - biL
        xbegin = iiL + nproLx
      endif
!
      if(( biR .ge. promax ) .or. (iperx .eq. 1)) then
        nproRx = 0
        xend = iiR - 1 
      else
        nproRx = promax - biR
        xend   = iiR - nproRx - 1
      endif
!
! Y-direction
!
      if(( bjL .ge. promax ) .or. (ipery .eq. 1)) then
        nproLy = 0
        ybegin = ijL
      else
        nproLy = promax - bjL
        ybegin = ijL + nproLy
      endif
!
      if(( bjR .ge. promax ) .or. (ipery .eq. 1)) then
        nproRy = 0
        yend = ijR - 1 
      else
        nproRy = promax - bjR
        yend   = ijR - nproRy - 1
      endif
!
! Z-direction
!
      if(( bkL .ge. promax ) .or. (iperz .eq. 1)) then
        nproLz = 0
        zbegin = ikL
      else
        nproLz = promax - bkL
        zbegin = ikL + nproLz
      endif
!
      if(( bkR .ge. promax ) .or. (iperz .eq. 1)) then
        nproRz = 0
        zend = ikR - 1
      else
        nproRz = promax - bkR
        zend   = ikR - nproRz - 1
      endif
!
! Set up Boundary stencil coefficients
!
! A - Wall point (orders 4 through 10)
!
          bnd4A(1) = +(    5.0/16.d0)
          bnd4A(2) = +(   15.0/16.d0)
          bnd4A(3) = -(    5.0/16.d0)
          bnd4A(4) = +(    1.0/16.d0)
!
          bnd6A(1) = +(   63.0/256.d0)
          bnd6A(2) = +(  315.0/256.d0)
          bnd6A(3) = -(  210.0/256.d0)
          bnd6A(4) = +(  126.0/256.d0)
          bnd6A(5) = -(   45.0/256.d0)
          bnd6A(6) = +(    7.0/256.d0)
!
          bnd8A(1) = +( 429.d0/2048.d0)
          bnd8A(2) = +(3003.d0/2048.d0)
          bnd8A(3) = -(3003.d0/2048.d0)
          bnd8A(4) = +(3003.d0/2048.d0)
          bnd8A(5) = -(2145.d0/2048.d0)
          bnd8A(6) = +(1001.d0/2048.d0)
          bnd8A(7) = -( 273.d0/2048.d0)
          bnd8A(8) = +(  33.d0/2048.d0)
!
          bnd10A( 1) = +( 12155.d0/65536.d0)
          bnd10A( 2) = +(109395.d0/65536.d0)
          bnd10A( 3) = -(145860.d0/65536.d0)
          bnd10A( 4) = +(204204.d0/65536.d0)
          bnd10A( 5) = -(218790.d0/65536.d0)
          bnd10A( 6) = +(170170.d0/65536.d0)
          bnd10A( 7) = -( 92820.d0/65536.d0)
          bnd10A( 8) = +( 33660.d0/65536.d0)
          bnd10A( 9) = -(  7293.d0/65536.d0)
          bnd10A(10) = +(   715.d0/65536.d0)
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!
!          bnd12A( 1) = +(  88179.d0/524288.d0)
!

! B - Second from Wall (orders 6 through 10)
!
          bnd6B(1) = -(    7.0/256.d0)
          bnd6B(2) = +(  105.0/256.d0)
          bnd6B(3) = +(  210.0/256.d0)
          bnd6B(4) = -(   70.0/256.d0)
          bnd6B(5) = +(   21.0/256.d0)
          bnd6B(6) = -(    3.0/256.d0)
!
          bnd8B(1) = -(  33.d0/2048.d0)
          bnd8B(2) = +( 693.d0/2048.d0)
          bnd8B(3) = +(2079.d0/2048.d0)
          bnd8B(4) = -(1155.d0/2048.d0)
          bnd8B(5) = +( 693.d0/2048.d0)
          bnd8B(6) = -( 297.d0/2048.d0)
          bnd8B(7) = +(  77.d0/2048.d0)
          bnd8B(8) = -(   9.d0/2048.d0)
!
          bnd10B( 1) = -(  715.d0/65536.d0)
          bnd10B( 2) = +(19305.d0/65536.d0)
          bnd10B( 3) = +(77220.d0/65536.d0)
          bnd10B( 4) = -(60060.d0/65536.d0)
          bnd10B( 5) = +(54054.d0/65536.d0)
          bnd10B( 6) = -(38610.d0/65536.d0)
          bnd10B( 7) = +(20020.d0/65536.d0)
          bnd10B( 8) = -( 7020.d0/65536.d0)
          bnd10B( 9) = +( 1485.d0/65536.d0)
          bnd10B(10) = -(  143.d0/65536.d0)
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!
!          bnd12B( 1) = -(  4199.d0/524288.d0)

!
! C - Third from Wall (orders 8 through 10)
!
          bnd8C(1) = +(   9.d0/2048.d0)
          bnd8C(2) = -( 105.d0/2048.d0)
          bnd8C(3) = +( 945.d0/2048.d0)
          bnd8C(4) = +(1575.d0/2048.d0)
          bnd8C(5) = -( 525.d0/2048.d0)
          bnd8C(6) = +( 189.d0/2048.d0)
          bnd8C(7) = -(  45.d0/2048.d0)
          bnd8C(8) = +(   5.d0/2048.d0)
!
          bnd10C( 1) = +(  143.d0/65536.d0)
          bnd10C( 2) = -( 2145.d0/65536.d0)
          bnd10C( 3) = +(25740.d0/65536.d0)
          bnd10C( 4) = +(60060.d0/65536.d0)
          bnd10C( 5) = -(30030.d0/65536.d0)
          bnd10C( 6) = +(18018.d0/65536.d0)
          bnd10C( 7) = -( 8580.d0/65536.d0)
          bnd10C( 8) = +( 2860.d0/65536.d0)
          bnd10C( 9) = -(  585.d0/65536.d0)
          bnd10C(10) = +(   55.d0/65536.d0)
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!
!          bnd12C( 1) = +(  663.d0/524288.d0)

!
! D - Fourth from Wall (orders 10 through 10)
!
          bnd10D( 1) = -(  55.d0/65536.d0)
          bnd10D( 2) = +( 693.d0/65536.d0)
          bnd10D( 3) = -(4620.d0/65536.d0)
          bnd10D( 4) = +(32340.d0/65536.d0)
          bnd10D( 5) = +(48510.d0/65536.d0)
          bnd10D( 6) = -(16170.d0/65536.d0)
          bnd10D( 7) = +( 6468.d0/65536.d0)
          bnd10D( 8) = -( 1980.d0/65536.d0)
          bnd10D( 9) = +(  385.d0/65536.d0)
          bnd10D(10) = -(   35.d0/65536.d0)
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!
!          bnd12D( 1) = -(   195.d0/524288.d0)

!
! E - Fifth from Wall (order 12)
!
! JR_CHANGE 04/15/06 - removing all mention of 12th order. Leave
!     one line to indicate that it used to be here.
!
!          bnd12E( 1) = +(    91.d0/524288.d0)

!
      return
      end
!===========================================================================
