/*
  Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
  with Sandia Corporation, the U.S. Governement retains certain rights in this software.

  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are met:
  
  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.
  * Neither the name of the Sandia National Laboratories nor the names of 
    its contributors may be used to endorse or promote products derived 
    from this software without specific prior written permission.
    
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
  OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
  

  Version 0.1, June 2006.
  Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
  Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
              jairay@ca.sandia.gov
*/

/*
  This contains the interface implementation of the C-callble functions embodied in
  interp.h and their FORTRAN 77 counterparts

  Jaideep Ray, jairay@ca.sandia.gov
  April 11, 2006
*/

#include "fortran_names.h"
#include "interp.h"

void  C_x_intp_cf_vc( double *uc, double *d0fx, int *orderi, int *orderb,
		      int *biL, int *biR, int *bjL, int *bjR, int *bkL, int *bkR,
		      int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
		      int *iiL, int *iiR, int *ijL, int *ijR, int *ikL, int *ikR,
		      int *dfiL, int *dfiR, int *dfjL, int *dfjR, int *dfkL, int *dfkR,
		      int *iperx, int *ipery, int *iperz, int *ierror, char *message)
{

  FORTNAME(x_intp_cf_vc)( uc, d0fx, orderi, orderb, biL, biR, bjL, bjR, bkL, bkR,
			  fiL, fiR, fjL, fjR, fkL, fkR, iiL, iiR, ijL, ijR, ikL, ikR,
			  dfiL, dfiR, dfjL, dfjR, dfkL, dfkR,
			  iperx, ipery, iperz, ierror, message) ;
  
  return ;
}
 
 
void C_y_intp_cf_vc( double *uc, double *d0fx, int *orderi, int *orderb,
		     int *biL, int *biR, int *bjL, int *bjR, int *bkL, int *bkR,
		     int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
		     int *iiL, int *iiR, int *ijL, int *ijR, int *ikL, int *ikR,
		     int *dfiL, int *dfiR, int *dfjL, int *dfjR, int *dfkL, int *dfkR,
		     int *iperx, int *ipery, int *iperz, int *ierror, char *message)
{

  FORTNAME(y_intp_cf_vc)( uc, d0fx, orderi, orderb,biL, biR, bjL, bjR, bkL, bkR,
			  fiL, fiR, fjL, fjR, fkL, fkR, iiL, iiR, ijL, ijR, ikL, ikR,
			  dfiL, dfiR, dfjL, dfjR, dfkL, dfkR, iperx, ipery, iperz, 
			  ierror, message) ;
  return ;
}
   
                                                                                                  
  void C_xy_intp_cf_vc( double *uc, double *d0fx, int *orderi, int *orderb,
			int *biL, int *biR, int *bjL, int *bjR, int *bkL, int *bkR,
			int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
			int *iiL, int *iiR, int *ijL, int *ijR, int *ikL, int *ikR,
			int *dfiL, int *dfiR, int *dfjL, int *dfjR, int *dfkL, int *dfkR,
			int *iperx, int *ipery, int *iperz, int *ierror, char *message,
			int *icorner)
{
  FORTNAME(xy_intp_cf_vc)( uc, d0fx, orderi, orderb, biL, biR, bjL, bjR, bkL, bkR,
			   fiL, fiR, fjL, fjR, fkL, fkR, iiL, iiR, ijL, ijR, ikL, ikR,
			   dfiL, dfiR, dfjL, dfjR, dfkL, dfkR, iperx, ipery, iperz, 
			   ierror, message, icorner) ;
  return ;
}
