/*
  Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
  with Sandia Corporation, the U.S. Governement retains certain rights in this software.

  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are met:
  
  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.
  * Neither the name of the Sandia National Laboratories nor the names of 
    its contributors may be used to endorse or promote products derived 
    from this software without specific prior written permission.
    
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
  OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
  

  Version 0.1, June 2006.
  Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
  Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
              jairay@ca.sandia.gov
*/

#ifndef INTERP_HEADER_SEEN
#define INTERP_HEADER_SEEN

/*
  Header file for interpolations. This is the interface for call the fortran
  subroutines from C/C++. 

  For an explanation of what the various arguments mean, see the User's Manual
*/

#ifdef __cplusplus
extern "C"
{
#endif
  /**
     Function that given a vertex-centered field with data at (i, j) will return a 
     field with data interpolated at points (i+1/2,j) [for x_intp], (i, j+1/2) [y_intp]
     or (i+1/2, j+1/2) [xy_intp]
     @param uc the 3D INPUT fortran array with data at (i, j)
     @param d0fx, the 3D OUTPUT fortran array with data filled up at (i+1/2. j) 
     (alternatively, (i, j+1/2) [y_intp] or (i+1/2, j+1/2) [xy_intp])
     @param orderi the order of interpolation in the interior of the field
     @param orderb, the same, but at domain boundaries where you run out of points
     See the manual to find out which orders are currently supported.
     and have to skew. Currently, this is ignored - we do our own skewing.
     @param biL, biR, bjL, bjR, bkL, bkR : the width of the halo at the lower and upper 
     extremities of each direction
     @param fiL, fiR, fjL, fjR, fkL, fkR : the lower and upper indices of the uc array
     @param iiL, iiR, ijL, ijR, ikL, ikR : the lower and upper indices of the array section
     of uc which is to be used for filling up d0fx
     @param dfiL, dfiR, dfjL, dfjR, dfkL, dfkR : lower and upper indices of the d0fx array
     @param iperx, ipery, iperz : should I assume the data is periodic in x, y, z? 0 is NO
     @param corner : do we want corner values to be filled up too ?
     @return ierror : error code.
        -10  : the interior + halo exceed the size of the array
	-20  : the interior is wider than the dize of d0fx
	-40  : the halo is negative !
	-50  : the interior region has an upper index < lower index
	-80  : Can't handle the requested order
	-90  : periodicity is neither set to no (0) or yes (1)
        -100 : Stencil wider than domain
     @return message : error message. Just make this a char array[256]
  */
  void  C_x_intp_cf_vc( double *uc, double *d0fx, int *orderi, int *orderb,
			int *biL, int *biR, int *bjL, int *bjR, int *bkL, int *bkR,
			int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
			int *iiL, int *iiR, int *ijL, int *ijR, int *ikL, int *ikR,
			int *dfiL, int *dfiR, int *dfjL, int *dfjR, int *dfkL, int *dfkR,
			int *iperx, int *ipery, int *iperz, int *ierror, char *message) ;
 
 
  void C_y_intp_cf_vc( double *uc, double *d0fx, int *orderi, int *orderb,
		       int *biL, int *biR, int *bjL, int *bjR, int *bkL, int *bkR,
		       int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
		       int *iiL, int *iiR, int *ijL, int *ijR, int *ikL, int *ikR,
		       int *dfiL, int *dfiR, int *dfjL, int *dfjR, int *dfkL, int *dfkR,
		       int *iperx, int *ipery, int *iperz, int *ierror, char *message) ;
   
                                                                                                  
  void C_xy_intp_cf_vc( double *uc, double *d0fx, int *orderi, int *orderb,
			int *biL, int *biR, int *bjL, int *bjR, int *bkL, int *bkR,
			int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
			int *iiL, int *iiR, int *ijL, int *ijR, int *ikL, int *ikR,
			int *dfiL, int *dfiR, int *dfjL, int *dfjR, int *dfkL, int *dfkR,
			int *iperx, int *ipery, int *iperz, int *ierror, char *message,
			int *icorner) ;

#ifdef __cplusplus                                                                              
}
#endif
#endif
