/*
  Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
  with Sandia Corporation, the U.S. Governement retains certain rights in this software.

  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are met:
  
  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.
  * Neither the name of the Sandia National Laboratories nor the names of 
    its contributors may be used to endorse or promote products derived 
    from this software without specific prior written permission.
    
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
  OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
  

  Version 0.1, June 2006.
  Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
  Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
              jairay@ca.sandia.gov
*/

#ifndef FILTER_HEADER_SEEN
#define FILTER_HEADER_SEEN

/*
  Header file for finite-difference filters. This is the interface for call the fortran
  subroutines from C/C++. 

  For an explanation of what the various arguments mean, see the User's Manual
*/

#ifdef __cplusplus
extern "C"
{
#endif
  /**
     Function that accepts a solution on a uniform mesh stored in a 3D Fortran array, 
     and returns it after filtering it with a filter of order iord
     @param fn : the 3D INPUT Fortran array containing the solution to be filtered. It will
     be returned in the same array
     @param ifilt_x, ifilt_y, ifiltz : Should I filter in x, y, and z? 0 is no.
     @param iord : Order of filter. Check the manual to see what orders are supported.
     @param fiL, fiR, fjL, fjR, fkL, fkR : lower and upper array indices for the fn array
     @param piL, piR, pjL, pjR, pkL, pkR : lower and upper indices of the patch. Keep it the
     same as fiL, fiR ....
     @param wiL, wiR, wjL, wjR, wkL, wkR : The array section of fn where filtering is to be
     done
     @param error : Error message - make is a char array[256]
     @param err_coeff : Error message regarding filter coefficients. Make it char array[256]
     @param ierror : error code :
        -30 : Filter stencil bigger than the array
     @param ierr_coeff : Error regarding coefficients
        -10 : The filter order must be even !
	-20 : Filter order must be positive !
  */
  void C_expfil(double *fn, int *ifilt_x, int *ifilt_y, int *ifilt_z, int *iord,
		int *fiL, int *fiR, int *fjL, int *fjR, int *fkL, int *fkR,
		int *piL, int *piR, int *pjL, int *pjR, int *pkL, int *pkR,
		int *wiL, int *wiR, int *wjL, int *wjR, int *wkL, int *wkR,
		int *ierror, char *error, int *ierr_coeff, char *err_coeff) ;

#ifdef __cplusplus
}
#endif

#endif
