c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!  ======================================================================
!! EXPFIL filters the incoming matrix using an explicit finite difference 
!    method by sweeping through each direction. The filter is really just
!    a matrix; the dissipation matrix. They basically work like this:
!    Feed in the matrix, say U_unfilt, and do this to it -
!
!    U_filt = (I - alpha_D*D)*U_unfilt
!
!    where alpha_D is just for scaling and D is the dissipation matrix.
!    D is based on finite-difference derivatives like d^{2n}/dx^{2n}.
!    A 10th-order filter uses a D based on d^{10}/dx^{10} stencils.
!    These filters are of order (iord) for the interior and (iord/2) 
!    at the boundary. Remember - in the interior, the stencils are symmetric
!    but not for the boundary stencils. However, the dissipation matrix
!    is symmetric. Details are in NASA TP-3484. The filter does not require 
!    green cells. Someone could check the number of green cells and then
!    use the filter boundaries sparingly. I have only included orders
!    2,4,6,8,10, and 12 here. If someone wants, 14,16,18, and 20 are
!    available.
!
!    Note that the array fn has some dimension. It may be passed into
!    this routine on some subset of that domain( a patch). Further, one 
!    may wish to filter on only a portion, or window, within that patch.
!
! INPUT
!  fn       - Function to be filtered
!  disb     - Dissipation matrix coefficients for the boundary grid points
!  disi     - Dissipation matrix coefficients for the interior grid points
!  fiL      - Global coordinates for domain boundaries ( Left side of x-direction)
!  fiR      - Global coordinates for domain boundaries (Right side of x-direction)
!  fjL      - Global coordinates for domain boundaries ( Left side of y-direction)
!  fjR      - Global coordinates for domain boundaries (Right side of y-direction)
!  fkL      - Global coordinates for domain boundaries ( Left side of z-direction)
!  fkR      - Global coordinates for domain boundaries (Right side of z-direction)
!  piL      - Global coordinates for f patch ( Left side of x-direction)
!  piR      - Global coordinates for f patch (Right side of x-direction)
!  pjL      - Global coordinates for f patch ( Left side of y-direction)
!  pjR      - Global coordinates for f patch (Right side of y-direction)
!  pkL      - Global coordinates for f patch ( Left side of z-direction)
!  pkR      - Global coordinates for f patch (Right side of z-direction)
!  wiL      - Global coordinates for window  ( Left side of x-direction)
!  wiR      - Global coordinates for window  (Right side of x-direction)
!  wjL      - Global coordinates for window  ( Left side of y-direction)
!  wjR      - Global coordinates for window  (Right side of y-direction)
!  wkL      - Global coordinates for window  ( Left side of z-direction)
!  wlR      - Global coordinates for window  (Right side of z-direction)
!  ierror   - Error flag
!
! OUTPUT
!  fn       - Filtered function
!
! LOCAL
!  alpha    - Scaling constant for Dissipation matrix coefficients
!  dfn      - High-wavenumber content of fn to be removed
!  iord     - Filter order
!  iordd2   - Filter order divided by 2
!  iordd2p1 - Filter order divided by 2 + 1
!  ka       - Interior filter stencil width left or right of center, i.e.
!             ....|.... is an 8th-order filter, is 9 wide, and ka=4
!  kap1     - ka + 1
!  kb       - Width of filter boundary stencil - 1
!  k1       - Left boundary filter stencil element 
!  k1a      - Right boundary filter stencil element 
!  k2       - Left boundary filter stencil number 
!  k2a      - Right boundary filter stencil number 
!  nx,ny,nz - number of grid points in direction x,y, and z, respectively.
!  ifilt_x  - Flag to filter in x-direction (0 = No) (1 = Yes)
!  ifilt_y  - Flag to filter in y-direction (0 = No) (1 = Yes)
!  ifilt_z  - Flag to filter in z-direction (0 = No) (1 = Yes)
!
! ERROR MESSAGES
!   ierror =  0: No errors
!   ierror <  0: Errors
!
!   ierror = -10 => The length of the x-domain is smaller than the filter stencil
!   ierror = -20 => The length of the y-domain is smaller than the filter stencil
!   ierror = -30 => The length of the z-domain is smaller than the filter stencil
!
!  ======================================================================
!
      implicit none
!
      integer i, j, k
      integer ifilt_x, ifilt_y, ifilt_z
      integer ierror, ierr_coeff
      integer iord
      integer k1
      integer k1a
      integer k2
      integer k2a
      integer ka
      integer kap1
      integer kb
      integer kmag
      integer m
      integer nx, ny, nz
      integer fiL, fiR, fjL, fjR, fkL, fkR
      integer piL, piR, pjL, pjR, pkL, pkR
      integer wiL, wiR, wjL, wjR, wkL, wkR
      integer iL, iR, jL, jR, kL, kR
      integer bi, bj, bk
      integer width
!
      real*8 dfn(fiL:fiR,fjL:fjR,fkL:fkR)
      real*8  fn(fiL:fiR,fjL:fjR,fkL:fkR)
!

!      JR_CHANGE. Adding in 14th-20th order stencils. December 17th, 2005
!      real*8 disi(7), disb(6,12)
!      JR_CHANGE Moving from 20th-order to 50th order filters. April 15th, 2006
!      real*8 disi(11), disb(10,20)
      real*8 disi(26), disb(25,50)
     
!
      integer k1ind, k2ind
!
      character*60 error, err_coeff
