c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!====================================================================
!
      subroutine y_der2_co(f,d2f,dx,dy,dz,orderi,orderb,
     &      biL, biR, bjL, bjR, bkL, bkR,
     &      fiL, fiR, fjL, fjR, fkL, fkR,
     &      iiL, iiR, ijL, ijR, ikL, ikR,
     &     dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &     iperx,ipery,iperz,ierror,error)
!
      include 'der2_include.h'
!
      call der2_pre( ierror, error,
     &   xbegin,xend,ybegin,yend,zbegin,zend,
     &   bnd2A, bnd3A, bnd3B, bnd4C, bnd6D,
     &   iperx,ipery,iperz, orderi, orderb,
     &   biL, biR, bjL, bjR, bkL, bkR,
     &   fiL, fiR, fjL, fjR, fkL, fkR,
     &   iiL, iiR, ijL, ijR, ikL, ikR,
     &   piL, piR, pjL, pjR, pkL, pkR,
     &   dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &   nproLx,nproRx,nproLy,nproRy,nproLz,nproRz,
     &   proL,proR,promax,dx,dy,dz,rdx2,rdy2,rdz2)
!
      if( 2*promax+1 .gt. pjR-pjL+1) then
        ierror = -100
        error = 'DER_2: Stencil is wider than the f domain'
        return
      endif
!
! Zero-out Second-Derivative
!
      do k = ikL, ikR
        do j = ijL, ijR
          do i = iiL, iiR
            d2f(i,j,k) = 0.0
          end do
        end do
      end do
!
!========================================================================
! CENTERED DIFFERENCE OPERATORS
!
!-----------------------------
!  2nd-order explicit: (2-2E-2)
!
      if ( orderi .eq. 2 ) then
!
        Up  = (-2.d0/ 1.d0)* rdy2
        ae  = ( 1.d0/ 1.d0)* rdy2
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ybegin, yend
            do i = iiL, iiR
              d2f(i,j,k) = Up *  f(i,j+0,k)
     &                   + ae *( f(i,j+1,k)+f(i,j-1,k) )
            end do   
          end do
        end do
!
!  Boundary nodes:
!   Left side:
!
        if ( nproLy .eq. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-1,k) = (bnd2A(1)*f(i,ybegin-1,k) +
     &                             bnd2A(2)*f(i,ybegin+0,k) +
     &                             bnd2A(3)*f(i,ybegin+1,k))*rdy2
            end do
          end do
        end if
!
!   Right side:
!
        if ( nproRy .eq. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+1,k) = (bnd2A(1)*f(i,yend+1,k) +
     &                           bnd2A(2)*f(i,yend+0,k) +
     &                           bnd2A(3)*f(i,yend-1,k))*rdy2
            end do
          end do
        end if
!
      end if
!
!-----------------------------
!  4th order explicit: (3,3-4E-3,3)
!
!
      if ( orderi .eq. 4 ) then

        Up  = -5.d0/ 2.d0 * rdy2
        ae  =  4.d0/ 3.d0 * rdy2
        be  = -1.d0/12.d0 * rdy2
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ybegin, yend
            do i = iiL, iiR
              d2f(i,j,k) = Up *  f(i,j  ,k)
     &                   + ae *( f(i,j+1,k)+f(i,j-1,k) )
     &                   + be *( f(i,j+2,k)+f(i,j-2,k) )
            end do   
          end do   
        end do
!
!  Boundary nodes:
!
!   Left side:
!
!
        if ( nproLy .ge. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-1,k) = (bnd3B(1)*f(i,ybegin-2,k) +
     &                             bnd3B(2)*f(i,ybegin-1,k) +
     &                             bnd3B(3)*f(i,ybegin+0,k) +
     &                             bnd3B(4)*f(i,ybegin+1,k) +
     &                             bnd3B(5)*f(i,ybegin+2,k))*rdy2
            end do
          end do
        end if
!
        if ( nproLy .eq. 2 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-2,k) = (bnd3A(1)*f(i,ybegin-2,k) +
     &                             bnd3A(2)*f(i,ybegin-1,k) +
     &                             bnd3A(3)*f(i,ybegin+0,k) +
     &                             bnd3A(4)*f(i,ybegin+1,k) +
     &                             bnd3A(5)*f(i,ybegin+2,k))*rdy2
            end do
          end do
        end if
!
!   Right side:
!
        if ( nproRy .ge. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+1,k) = (bnd3B(1)*f(i,yend+2,k) +
     &                           bnd3B(2)*f(i,yend+1,k) +
     &                           bnd3B(3)*f(i,yend+0,k) +
     &                           bnd3B(4)*f(i,yend-1,k) +
     &                           bnd3B(5)*f(i,yend-2,k))*rdy2
            end do
          end do
        end if
!
        if ( nproRy .eq. 2 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+2,k) = (bnd3A(1)*f(i,yend+2,k) +
     &                           bnd3A(2)*f(i,yend+1,k) +
     &                           bnd3A(3)*f(i,yend+0,k) +
     &                           bnd3A(4)*f(i,yend-1,k) +
     &                           bnd3A(5)*f(i,yend-2,k))*rdy2
            end do
          end do
        end if
!
      end if
!
!-----------------------------
!  6th order explicit: (3,3,4-6E-4,3,3)
!
!
      if ( orderi .eq. 6 ) then
!
        Up  =-49.d0/18.d0 * rdy2
        ae  =  3.d0/ 2.d0 * rdy2
        be  = -3.d0/20.d0 * rdy2
        ce  =  1.d0/90.d0 * rdy2
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ybegin, yend
            do i = iiL, iiR
              d2f(i,j,k) = Up *  f(i,j  ,k)
     &                   + ae *( f(i,j+1,k)+f(i,j-1,k) )
     &                   + be *( f(i,j+2,k)+f(i,j-2,k) )
     &                   + ce *( f(i,j+3,k)+f(i,j-3,k) ) 
            end do    
          end do    
        end do    
!
!  Boundary nodes:
!
!   Left side:
!
        if ( nproLy .ge. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-1,k) = (bnd4C(1)*f(i,ybegin-3,k) +
     &                             bnd4C(2)*f(i,ybegin-2,k) +
     &                             bnd4C(3)*f(i,ybegin-1,k) +
     &                             bnd4C(4)*f(i,ybegin+0,k) +
     &                             bnd4C(5)*f(i,ybegin+1,k))*rdy2
            end do
          end do
        end if
!
        if ( nproLy .ge. 2 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-2,k) = (bnd3B(1)*f(i,ybegin-3,k) +
     &                             bnd3B(2)*f(i,ybegin-2,k) +
     &                             bnd3B(3)*f(i,ybegin-1,k) +
     &                             bnd3B(4)*f(i,ybegin+0,k) +
     &                             bnd3B(5)*f(i,ybegin+1,k))*rdy2
            end do
          end do
        end if
!
        if ( nproLy .eq. 3 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-3,k) = (bnd3A(1)*f(i,ybegin-3,k) +
     &                             bnd3A(2)*f(i,ybegin-2,k) +
     &                             bnd3A(3)*f(i,ybegin-1,k) +
     &                             bnd3A(4)*f(i,ybegin+0,k) +
     &                             bnd3A(5)*f(i,ybegin+1,k))*rdy2
            end do
          end do
        end if
!
!   Right side:
!
        if ( nproRy .ge. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+1,k) = (bnd4C(1)*f(i,yend+3,k) +
     &                           bnd4C(2)*f(i,yend+2,k) +
     &                           bnd4C(3)*f(i,yend+1,k) +
     &                           bnd4C(4)*f(i,yend+0,k) +
     &                           bnd4C(5)*f(i,yend-1,k))*rdy2
            end do
          end do
        end if
!
        if ( nproRy .ge. 2 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+2,k) = (bnd3B(1)*f(i,yend+3,k) +
     &                           bnd3B(2)*f(i,yend+2,k) +
     &                           bnd3B(3)*f(i,yend+1,k) +
     &                           bnd3B(4)*f(i,yend+0,k) +
     &                           bnd3B(5)*f(i,yend-1,k))*rdy2
            end do
          end do
        end if
!
        if ( nproRy .eq. 3 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+3,k) = (bnd3A(1)*f(i,yend+3,k) +
     &                           bnd3A(2)*f(i,yend+2,k) +
     &                           bnd3A(3)*f(i,yend+1,k) +
     &                           bnd3A(4)*f(i,yend+0,k) +
     &                           bnd3A(5)*f(i,yend-1,k))*rdy2
            end do
          end do
        end if
      end if
!-----------------------------
!  8th order explicit: (3,3,4,6-8E-6,4,3,3)
!
!
      if ( orderi .eq. 8 ) then
!
        Up  =-205.d0/ 72.d0 * rdy2
        ae  =   8.d0/  5.d0 * rdy2
        be  =  -1.d0/  5.d0 * rdy2
        ce  =   8.d0/315.d0 * rdy2
        de  =  -1.d0/560.d0 * rdy2
!
!  Internal nodes:
!
        do k = ikL, ikR
          do j = ybegin, yend
            do i = iiL, iiR
              d2f(i,j,k) = Up *  f(i,j  ,k)
     &                   + ae *( f(i,j+1,k)+f(i,j-1,k) )
     &                   + be *( f(i,j+2,k)+f(i,j-2,k) )
     &                   + ce *( f(i,j+3,k)+f(i,j-3,k) ) 
     &                   + de *( f(i,j+4,k)+f(i,j-4,k) ) 
            end do    
          end do    
        end do    
!
!  Boundary nodes:
!
!   Left side:
!
        if ( nproLy .ge. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-1,k) = (bnd6D(1)*f(i,ybegin-4,k) +
     &                             bnd6D(2)*f(i,ybegin-3,k) +
     &                             bnd6D(3)*f(i,ybegin-2,k) +
     &                             bnd6D(4)*f(i,ybegin-1,k) +
     &                             bnd6D(5)*f(i,ybegin+0,k) +
     &                             bnd6D(6)*f(i,ybegin+1,k) +
     &                             bnd6D(7)*f(i,ybegin+2,k))*rdy2
            end do
          end do
        end if

        if ( nproLy .ge. 2 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-2,k) = (bnd4C(1)*f(i,ybegin-4,k) +
     &                             bnd4C(2)*f(i,ybegin-3,k) +
     &                             bnd4C(3)*f(i,ybegin-2,k) +
     &                             bnd4C(4)*f(i,ybegin-1,k) +
     &                             bnd4C(5)*f(i,ybegin+0,k))*rdy2
            end do
          end do
        end if
!
        if ( nproLy .ge. 3 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-3,k) = (bnd3B(1)*f(i,ybegin-4,k) +
     &                             bnd3B(2)*f(i,ybegin-3,k) +
     &                             bnd3B(3)*f(i,ybegin-2,k) +
     &                             bnd3B(4)*f(i,ybegin-1,k) +
     &                             bnd3B(5)*f(i,ybegin+0,k))*rdy2
            end do
          end do
        end if
!
        if ( nproLy .eq. 4 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,ybegin-4,k) = (bnd3A(1)*f(i,ybegin-4,k) +
     &                             bnd3A(2)*f(i,ybegin-3,k) +
     &                             bnd3A(3)*f(i,ybegin-2,k) +
     &                             bnd3A(4)*f(i,ybegin-1,k) +
     &                             bnd3A(5)*f(i,ybegin+0,k))*rdy2
            end do
          end do
        end if
!
!   Right side:
!
        if ( nproRy .ge. 1 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+1,k) = (bnd6D(1)*f(i,yend+4,k) +
     &                           bnd6D(2)*f(i,yend+3,k) +
     &                           bnd6D(3)*f(i,yend+2,k) +
     &                           bnd6D(4)*f(i,yend+1,k) +
     &                           bnd6D(5)*f(i,yend+0,k) +
     &                           bnd6D(6)*f(i,yend-1,k) +
     &                           bnd6D(7)*f(i,yend-2,k))*rdy2
            end do
          end do
        end if
!
        if ( nproRy .ge. 2 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+2,k) = (bnd4C(1)*f(i,yend+4,k) +
     &                           bnd4C(2)*f(i,yend+3,k) +
     &                           bnd4C(3)*f(i,yend+2,k) +
     &                           bnd4C(4)*f(i,yend+1,k) +
     &                           bnd4C(5)*f(i,yend+0,k))*rdy2
            end do
          end do
        end if
!
        if ( nproRy .ge. 3 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+3,k) = (bnd3B(1)*f(i,yend+4,k) +
     &                           bnd3B(2)*f(i,yend+3,k) +
     &                           bnd3B(3)*f(i,yend+2,k) +
     &                           bnd3B(4)*f(i,yend+1,k) +
     &                           bnd3B(5)*f(i,yend+0,k))*rdy2
            end do
          end do
        end if
!
        if ( nproRy .eq. 4 ) then
          do k = ikL, ikR
            do i = iiL, iiR
              d2f(i,yend+4,k) = (bnd3A(1)*f(i,yend+4,k) +
     &                           bnd3A(2)*f(i,yend+3,k) +
     &                           bnd3A(3)*f(i,yend+2,k) +
     &                           bnd3A(4)*f(i,yend+1,k) +
     &                           bnd3A(5)*f(i,yend+0,k))*rdy2
            end do
          end do
        end if
!
      end if
!
! End Centered Difference Operators
!
      return
      end
!====================================================================
