c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!===========================================================================
!
      subroutine der2_pre( ierror, error,
     &   xbegin,xend,ybegin,yend,zbegin,zend,
     &   bnd2A, bnd3A, bnd3B, bnd4C, bnd6D,
     &   iperx,ipery,iperz, orderi, orderb,
     &   biL, biR, bjL, bjR, bkL, bkR,
     &   fiL, fiR, fjL, fjR, fkL, fkR,
     &   iiL, iiR, ijL, ijR, ikL, ikR,
     &   piL, piR, pjL, pjR, pkL, pkR,
     &   dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
     &   nproLx,nproRx,nproLy,nproRy,nproLz,nproRz,
     &   proL,proR,promax,dx,dy,dz,rdx2,rdy2,rdz2)
!
      include 'der2_include.h'
!
!======================================================================
!
! Initialize IERROR to zero implying no errors
!
      ierror = 0
!
! Boundaries of usable f patch
      piL = iiL - biL
      piR = iiR + biR
      pjL = ijL - bjL
      pjR = ijR + bjR
      pkL = ikL - bkL
      pkR = ikR + bkR
!
! Is the usable patch width larger than the width of f?
      if( min0(piL-fiL,fiR-piR,pjL-fjL,fjR-pjR,pkL-fkL,fkR-pkR)
     &   .lt. 0) then
        ierror = -10
        error = 'DER_2: Interior + Green width > function width' 
        return
      endif
!
! Is the interior width larger than the width of df?
      if( min0(iiL-dfiL,dfiR-iiR,ijL-dfjL,dfjR-ijR,ikL-dfkL,dfkR-ikR)
     &   .lt. 0) then
        ierror = -20
        error = 'DER_2: Interior width > derivative width' 
        return
      endif
!
! Have the number of green cells gone negative anywhere?
      if( min0(biL,biR,bjL,bjR,bkL,bkR) .lt. 0 ) then
        ierror = -40
        error = 'DER_2: Green cell width < zero' 
        return
      endif
!
! Has the interior width gone negative?
      if( min0(iiR-iiL,ijR-ijL,ikR-ikL) .lt. 0 ) then
        ierror = -50
        error = 'DER_2: Interior Width < zero' 
        return
      endif
!
! Has the grid spacing gone negative?
      if(( dx .le. 0.d0 ) .or.
     &   ( dy .le. 0.d0 ) .or.
     &   ( dz .le. 0.d0 )) then
         ierror = -60
         error = 'DER_2: dx or dy or dz =< zero'
         return
      endif
!
! Grid Spacing (reciprocal)
        rdx2 = 1.d0/dx**2
        rdy2 = 1.d0/dy**2
        rdz2 = 1.d0/dz**2
!
! Stencil Widths
!
!   Centered stencils
!
      proL = -1
      proR = -1
!
      if( orderi .eq. 2 ) then
        proL = 1
        proR = 1
      elseif( orderi .eq. 4 ) then
        proL = 2
        proR = 2
      elseif( orderi .eq. 6 ) then
        proL = 3
        proR = 3
      elseif( orderi .eq. 8 ) then
        proL = 4
        proR = 4
      endif
      width = proL + 1 + proR
!
      if( ( proL .lt. 0) .or. ( proR .lt. 0) ) then
        ierror = -80
         error = 'DER_2: No such scheme'
        return
      endif
!
      if( (iperx .lt. 0) .or. ( iperx .gt. 1) .or.
     &    (ipery .lt. 0) .or. ( ipery .gt. 1) .or.
     &    (iperz .lt. 0) .or. ( iperz .gt. 1) ) then
          ierror = -90
          error = 'DER_2: Periodicity flags are set incorrectly'
          return
      endif
!
! Find maximum protrusion. 
!
      promax = max0( proL, proR )
!
! Determine where to begin Interior DO loops and how many
! boundary points need to be closed. Periodic domains
! will always (better) have enough green cells.
!
! X-direction
      if(( biL .ge. promax ) .or. (iperx .eq. 1)) then
        nproLx = 0
        xbegin = iiL
      else
        nproLx = promax - biL
        xbegin = iiL + nproLx
      endif
!
      if(( biR .ge. promax ) .or. (iperx .eq. 1)) then
        nproRx = 0
        xend = iiR
      else
        nproRx = promax - biR
        xend   = iiR - nproRx
      endif
!
! Y-direction
!
      if(( bjL .ge. promax ) .or. (ipery .eq. 1)) then
        nproLy = 0
        ybegin = ijL
      else
        nproLy = promax - bjL
        ybegin = ijL + nproLy
      endif
!
      if(( bjR .ge. promax ) .or. (ipery .eq. 1)) then
        nproRy = 0
        yend = ijR
      else
        nproRy = promax - bjR
        yend   = ijR - nproRy
      endif
!
! Z-direction
!
      if(( bkL .ge. promax ) .or. (iperz .eq. 1)) then
        nproLz = 0
        zbegin = ikL
      else
        nproLz = promax - bkL
        zbegin = ikL + nproLz
      endif
!
      if(( bkR .ge. promax ) .or. (iperz .eq. 1)) then
        nproRz = 0
        zend = ikR
      else
        nproRz = promax - bkR
        zend   = ikR - nproRz
      endif
!
! Set up Boundary stencil coefficients
!
      bnd2A(1) = +( 1.d0)
      bnd2A(2) = -( 2.d0)
      bnd2A(3) = +( 1.d0)
!
      bnd3A(1) = +( 35.d0/12.d0)
      bnd3A(2) = -(104.d0/12.d0)
      bnd3A(3) = +(114.d0/12.d0)
      bnd3A(4) = -( 56.d0/12.d0)
      bnd3A(5) = +( 11.d0/12.d0)
!
      bnd3B(1) = +( 11.d0/12.d0)
      bnd3B(2) = -( 20.d0/12.d0)
      bnd3B(3) = +(  6.d0/12.d0)
      bnd3B(4) = +(  4.d0/12.d0)
      bnd3B(5) = -(  1.d0/12.d0)
! 4E - Centered Difference
      bnd4C(1) = -(  1.d0/12.d0)
      bnd4C(2) = +( 16.d0/12.d0)
      bnd4C(3) = -( 30.d0/12.d0)
      bnd4C(4) = +( 16.d0/12.d0)
      bnd4C(5) = -(  1.d0/12.d0)
! 6E - Centered Difference
      bnd6D(1) = +(  2.d0/180.d0)
      bnd6D(2) = -( 27.d0/180.d0)
      bnd6D(3) = +(270.d0/180.d0)
      bnd6D(4) = -(490.d0/180.d0)
      bnd6D(5) = +(270.d0/180.d0)
      bnd6D(6) = -( 27.d0/180.d0)
      bnd6D(7) = +(  2.d0/180.d0)
!
      return
      end
!===========================================================================
