c     Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
c     with Sandia Corporation, the U.S. Governement retains certain rights in this software.
c
c     All rights reserved.
c     
c     Redistribution and use in source and binary forms, with or without 
c     modification, are permitted provided that the following conditions are met:
c     
c     * Redistributions of source code must retain the above copyright notice, 
c     this list of conditions and the following disclaimer.
c     * Redistributions in binary form must reproduce the above copyright notice, 
c     this list of conditions and the following disclaimer in the documentation 
c     and/or other materials provided with the distribution.
c     * Neither the name of the Sandia National Laboratories nor the names of 
c     its contributors may be used to endorse or promote products derived 
c     from this software without specific prior written permission.
c     
c     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
c     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
c     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
c     IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
c     INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
c     BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
c     DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
c     LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
c     OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
c     OF THE POSSIBILITY OF SUCH DAMAGE.
c     

c
c     Version 0.1, June 2006.
c     Authors : Christopher Kennedy, M. H. Carpenter and Jaideep Ray.
c     Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
c                 jairay@ca.sandia.gov
c
c

!  ======================================================================
!  X_DER1_CO, Y_DER1_CO, and Z_DER1_CO evaluate the first derivative 
!    in x-, y- and z-directions on collocated and uniform grids
!    using explicit finite-differencing. The routine is set up with AMR
!    applications in mind. In terms of derivatives, centered and upwind
!    stencils are provided that go as high as 8th-order accuracy.
!    Higher-order boundary closures have not been included because
!    they are often partly implicit. If desired, this could be changed
!    (volunteers welcome). This routine does not allow for nonuniform
!    grids directly. If an analytical mapping is available from a uniform
!    variable to a nonuniform one then one could use this routine as part
!    of the derivative evaluation. These derivative routines are hardwired
!    for the same operator in all directions! 
!
!    The reason for the variables VEL and UPWIND are to permit users to
!    specify whether they want upwinded or downwinded derivatives. 
!    Depending on the sign of the velocity and whether the user requests, 
!    an upwind or downwind stencil, either an upwinded stencil or it's
!    complex conjugate (in Fourier space) is applied. Near boundaries,
!    it is impractical to allow for all possiblities and hence all 
!    boundary points that can potentially be boundary points are always
!    treated as boundary points. These boundary points are closed using
!    skewed stencils near the wall and centered differences further away.
!    Upwinding/downwinding is slightly different for compressible and 
!    incompressible flows. The calling routine must chose an appropriate
!    ``velocity,'' i.e. u, u+c, u-c, etcetera.
!
!    This routine has been set up to be quite general. Arrays f, df,
!    and vel are allowed to enter the routine having arbitrary array
!    bounds. The calling routine must additionally specify the number
!    of green cells that are provided on all six boundaries as well
!    as delineate the exact region where derivatives are needed. Note
!    that not all elements of array df will be filled with useful 
!    derivatives. This depends on what the user specified for the array 
!    bounds. The key point is that all arrays are dimensioned relative to
!    the same grid; something the calling routine needs to reconcile.
!
!    Green cells are grid points that have been added to the current mesh
!    level by interpolating variables from the next most coarse grid.
!    They are placed around the interior patch to allow for the avoidance 
!    of non-centered derivative operators. In the interior portions of the 
!    computation, GrACE will drop the necessary number of green cells so 
!    that skewed stencils are unnecessary but near physical boundaries, 
!    this may not be possible.  In these cases, one needs to establish how 
!    many boundary points there are and close them properly. This is why 
!    left and right protrusions of stencils are considered. If the interior 
!    operator needs four boundary points closed but there are only three 
!    green cells then the net protrusion is one. This means that only one 
!    boundary point must be closed with one-sided derivatives.
!
!    Here's how the first derivatives are called:
!
!     subroutine x_der1_co
!    &    (f,df,dx,dy,dz,vel,upwind,orderi,orderb,
!    &     biL, biR, bjL, bjR, bkL, bkR,
!    &     fiL, fiR, fjL, fjR, fkL, fkR,
!    &     iiL, iiR, ijL, ijR, ikL, ikR,
!    &     viL, viR, vjL, vjR, vkL, vkR,
!    &     dfiL,dfiR,dfjL,dfjR,dfkL,dfkR,
!    &     iperx,ipery,iperz,ierror,error)
!
! INPUT
!  
!  f      - Function to be differentiated
!  dx,dy,dz - grid spacing in x-,y-, and z-directions
!  vel    - velocity vector -> used for orienting upwind stencils
!  upwind - direction -> upwind (+1,+2) or downwind (-1,-2)
!  orderi - Order of accuracy of the interior operator
!  orderb - Formal order of accuracy of the wall point boundary operator 
!           Currently not used!!
!  fiL    - Global coordinates for f ( Left side of x-direction)
!  fiR    - Global coordinates for f (Right side of x-direction)
!  fjL    - Global coordinates for f ( Left side of y-direction)
!  fjR    - Global coordinates for f (Right side of y-direction)
!  fkL    - Global coordinates for f ( Left side of z-direction)
!  fkR    - Global coordinates for f (Right side of z-direction)
!  dfiL   - Global coordinates for df patch ( Left side of x-direction)
!  dfiR   - Global coordinates for df patch (Right side of x-direction)
!  dfjL   - Global coordinates for df patch ( Left side of y-direction)
!  dfjR   - Global coordinates for df patch (Right side of y-direction)
!  dfkL   - Global coordinates for df patch ( Left side of z-direction)
!  dfkR   - Global coordinates for df patch (Right side of z-direction)
!  iiL    - Global coordinates for df ( Left side of x-direction)
!  iiR    - Global coordinates for df (Right side of x-direction)
!  ijL    - Global coordinates for df ( Left side of y-direction)
!  ijR    - Global coordinates for df (Right side of y-direction)
!  ikL    - Global coordinates for df ( Left side of z-direction)
!  ikR    - Global coordinates for df (Right side of z-direction)
!  viL    - Global coordinates for vel ( Left side of x-direction)
!  viR    - Global coordinates for vel (Right side of x-direction)
!  vjL    - Global coordinates for vel ( Left side of y-direction)
!  vjR    - Global coordinates for vel (Right side of y-direction)
!  vkL    - Global coordinates for vel ( Left side of z-direction)
!  vlR    - Global coordinates for vel (Right side of z-direction)
!  biL    - Number of green cells at left side of x-direction
!  biR    - Number of green cells at right side of x-direction
!  bjL    - Number of green cells at left side of y-direction
!  bjR    - Number of green cells at right side of y-direction
!  bkL    - Number of green cells at left side of z-direction
!  bkR    - Number of green cells at right side of z-direction
!  iperx  - Is the x-direction periodic -> (0) no, (1) yes
!  ipery  - Is the y-direction periodic -> (0) no, (1) yes
!  iperz  - Is the z-direction periodic -> (0) no, (1) yes
!  ierror - Error message - See below
!
! OUTPUT
!
!  df     - Differentiated Function
!
! LOCAL
!
!  proL   - Left protrusion of interior stencil
!  proR   - Right protrusion of interior stencil
!  promax - Maximum protrusion of interior stencil
!  nproL  - Net left protrusion of interior stencil
!  nproR  - Net right protrusion of interior stencil
!  width  - Total width of interior stencil
!  ae     - Explicit centered difference stencil coeff. at (i +/- 1)
!  be     - Explicit centered difference stencil coeff. at (i +/- 2)
!  ce     - Explicit centered difference stencil coeff. at (i +/- 3)
!  de     - Explicit centered difference stencil coeff. at (i +/- 4)
!  dL     - Explicit skewed difference stencil coeff. at (i - 4)
!  cL     - Explicit skewed difference stencil coeff. at (i - 3)
!  bL     - Explicit skewed difference stencil coeff. at (i - 2)
!  aL     - Explicit skewed difference stencil coeff. at (i - 1)
!  Up     - Explicit skewed difference stencil coeff. at (i)
!  aR     - Explicit skewed difference stencil coeff. at (i + 1)
!  bR     - Explicit skewed difference stencil coeff. at (i + 2)
!  cR     - Explicit skewed difference stencil coeff. at (i + 3)
!  dR     - Explicit skewed difference stencil coeff. at (i + 4)
!  x,y,zbegin - Beginning index for interior stencil
!  x,y,zend   - Ending index for interior stencil
!  piL    - Global coordinates for df + green cells ( Left side of x-direction)
!  piR    - Global coordinates for df + green cells (Right side of x-direction)
!  pjL    - Global coordinates for df + green cells ( Left side of y-direction)
!  pjR    - Global coordinates for df + green cells (Right side of y-direction)
!  pkL    - Global coordinates for df + green cells ( Left side of z-direction)
!  pkR    - Global coordinates for df + green cells (Right side of z-direction)
!  piL    - Global coordinates for df + green cells ( Left side of x-direction)
!
! OPTIONS:
!  Centered Differences
!   2E [orderi=2, orderb=1, upwind=0] (1-2E-1)
!   4E [orderi=4, orderb=3, upwind=0] (3,3-4E-3,3)
!   6E [orderi=6, orderb=3, upwind=0] (3,3,4-6E-4,3,3)
!   8E [orderi=8, orderb=3, upwind=0] (3,3,4,6-8E-6,4,3,3)
!  UpWind(Downwind) Differences
!   3U [orderi=3, orderb=3, upwind=(+/-1)] (3,3-3U-3,3)
!   4U [orderi=4, orderb=3, upwind=(+/-1)] (3,3,4-4U-4,3,3)
!   5U [orderi=5, orderb=3, upwind=(+/-1)] (3,3,4-5U-4,3,3)
!   6U [orderi=6, orderb=3, upwind=(+/-1)] (3,3,4,6-6U-6,4,3,3)
!   7U [orderi=7, orderb=3, upwind=(+/-1)] (3,3,4,6-7U-6,4,3,3)
!  Super-UpWind(Downwind) Differences
!  4UU [orderi=4, orderb=3, upwind=(+/-2)] (3,3,4,4-4U-4,4,3,3)
!  5UU [orderi=5, orderb=3, upwind=(+/-2)] (3,3,4,4-5U-4,4,3,3)
!
! note: Formal overall order equals MIN[ orderi, orderb+1].
!
! Initially written by Chris Kennedy in Dec. 2001
! Rewritten by Chris Kennedy in Feb. 2002
!  ======================================================================
!
! Integer stuff
!
      implicit none
!
      integer proL,proR,promax,width
      integer nproLx,nproLy,nproLz
      integer nproRx,nproRy,nproRz
      integer i, j, k
      integer orderi,orderb
      integer ierror
      integer iperx, ipery, iperz
      integer xbegin,ybegin,zbegin
      integer xend,  yend,  zend
      integer sign, upwind
      integer  biL, biR, bjL, bjR, bkL, bkR
      integer  fiL, fiR, fjL, fjR, fkL, fkR
      integer  iiL, iiR, ijL, ijR, ikL, ikR
      integer  piL, piR, pjL, pjR, pkL, pkR
      integer  viL, viR, vjL, vjR, vkL, vkR
      integer dfiL,dfiR,dfjL,dfjR,dfkL,dfkR
!
      real*8    f( fiL: fiR, fjL:fjR , fkL: fkR)
      real*8   df(dfiL:dfiR,dfjL:dfjR,dfkL:dfkR)
      real*8  vel( viL: viR, vjL:vjR , vkL: vkR)
      real*8  dx, dy, dz
      real*8 rdx,rdy,rdz
      real*8 ae,be,ce,de
      real*8 dL,cL,bL,aL,Up,aR,bR,cR,dR
      real*8 bnd1A(2)
      real*8 bnd3A(4)
      real*8 bnd3B(4)
      real*8 bnd4C(5)
      real*8 bnd6D(7)
!
      character*60 error
!
