(*
  Copyright (c) 2006, Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000
  with Sandia Corporation, the U.S. Governement retains certain rights in this software.

  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are met:
  
  * Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice, 
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.
  * Neither the name of the Sandia National Laboratories nor the names of 
    its contributors may be used to endorse or promote products derived 
    from this software without specific prior written permission.
    
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
  OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
  OF THE POSSIBILITY OF SUCH DAMAGE.
  

  Version 0.1, June 2006.
  Maintainer: Jaideep Ray, Advanced Software R. & D., Sandia National Laboratories, Livermore, CA, USA.
              jairay@ca.sandia.gov
*)

(* 
   These three routines are designed to provide the stencil coefficients
   for even ordered vertex-centered interpolants. There is a User Input
   area below. Monkey with anything alse at your own risk. Centered stencils
   use the stencils marked `I' and have ix or iy or iz = 0. If you want
   the stencil shifted one grid point, use `a' and ix or iy or iz = 1.
   For shifted 2, 3, 4, or 5, use b, c, d, or e, respectively.

Written by Chris Kennedy in 2002.
*)

(* ================================================================ *)
(*  End comments and begin stencil definition *)
(* ================================================================ *)

(* Second-Order *)

Psi2I[a_]:= Cos[a/2];
Psi2a[a_]:= ( Cos[a] + I*Sin[a] ) * 
    (   Cos[a/2] + I*( -2*Sin[a/2]));


(* Fourth-Order *)
Psi4I[a_]:=-Cos[a/2]*( -5 + Cos[a])/4;
Psi4a[a_]:= ( Cos[a] + I*Sin[a] ) * 
    (   5*Cos[a/2] + 3*Cos[3*a/2] + 
  I*( -10*Sin[a/2] - 2*Sin[3*a/2]))/8;
Psi4b[a_]:=-( Cos[2*a] + I*Sin[2*a] ) * 
    (   7*Cos[a/2] - 15*Cos[3*a/2] + 
  I*( -28*Sin[a/2] + 20*Sin[3*a/2]))/8;


(* Sixth-Order *)

Psi6I[a_]:= Cos[a/2]*( 89 - 28*Cos[a] + 3*Cos[2*a])/64;
Psi6a[a_]:= ( Cos[a] + I*Sin[a] ) * 
      ( 70*Cos[a/2] + 63*Cos[3*a/2] - 5*Cos[5*a/2] + 
  I*(- 140*Sin[a/2] - 42*Sin[3*a/2] + 2*Sin[5*a/2]))/128;
Psi6b[a_]:=-( Cos[2*a] + I*Sin[2*a] ) * 
      ( 42*Cos[a/2] - 135*Cos[3*a/2] - 35*Cos[5*a/2] + 
  I*( -168*Sin[a/2] + 180*Sin[3*a/2] + 28*Sin[5*a/2]))/128;
Psi6c[a_]:= ( Cos[3*a] + I*Sin[3*a] ) * 
      ( 198*Cos[a/2] - 385*Cos[3*a/2] + 315*Cos[5*a/2] + 
  I*( -1188*Sin[a/2] + 770*Sin[3*a/2] - 378*Sin[5*a/2]))/128;


(* Eighth-Order *)

Psi8I[a_]:=-Cos[a/2]*( -762 + 299*Cos[a] - 54*Cos[2*a] + 5*Cos[3*a])/512;
Psi8a[a_]:= ( Cos[a] + I*Sin[a] ) * 
      ( 525*Cos[a/2] + 567*Cos[3*a/2] - 75*Cos[5*a/2] + 7*Cos[7*a/2] + 
  I*( -1050*Sin[a/2] - 378*Sin[3*a/2] + 30*Sin[5*a/2] - 2*Sin[7*a/2]))/1024;
Psi8b[a_]:=-( Cos[2*a] + I*Sin[2*a] ) * 
     ( 231*Cos[a/2] - 891*Cos[3*a/2] - 385*Cos[5*a/2] + 21*Cos[7*a/2] + 
  I*( -924*Sin[a/2] + 1188*Sin[3*a/2] + 308*Sin[5*a/2] - 12*Sin[7*a/2]))/1024;
Psi8c[a_]:= ( Cos[3*a] + I*Sin[3*a] ) * 
      ( 429*Cos[a/2] - 1001*Cos[3*a/2] + 1365*Cos[5*a/2] + 231*Cos[7*a/2] +
  I*( -2574*Sin[a/2] + 2002*Sin[3*a/2] - 1638*Sin[5*a/2] - 198*Sin[7*a/2]))/1024;
Psi8d[a_]:=-( Cos[4*a] + I*Sin[4*a] ) * 
     (  3575*Cos[a/2] - 7371*Cos[3*a/2] + 5775*Cos[5*a/2] - 3003*Cos[7*a/2] + 
  I*( -28600*Sin[a/2] + 19656*Sin[3*a/2] - 9240*Sin[5*a/2] + 3432*Sin[7*a/2]))/1024;


(* Tenth-Order *)

Psi10I[a_]:= Cos[a/2]*(25609 - 11528*Cos[a] + 2708*Cos[2*a] - 440*Cos[3*a] + 
      35*Cos[4*a])/16384;
Psi10a[a_]:= ( Cos[a] + I*Sin[a] ) * 
     ( 16170*Cos[a/2] +  19404*Cos[3*a/2] -  3300*Cos[5*a/2] +   
      539*Cos[7*a/2] -   45*Cos[9*a/2] + 
  I*( -32340*Sin[a/2] -  12936*Sin[3*a/2] +  1320*Sin[5*a/2] -   
      154*Sin[7*a/2] +   10*Sin[9*a/2]))/32768;

Psi10b[a_]:=-( Cos[2*a] + I*Sin[2*a] ) * 
      ( 6006*Cos[a/2] -  25740*Cos[3*a/2] - 14300*Cos[5*a/2] +  
      1365*Cos[7*a/2] -   99*Cos[9*a/2] + 
  I*( -24024*Sin[a/2] +  34320*Sin[3*a/2] + 11440*Sin[5*a/2] -   
      780*Sin[7*a/2] +   44*Sin[9*a/2]))/32768;

Psi10c[a_]:= ( Cos[3*a] + I*Sin[3*a] ) * 
      ( 7722*Cos[a/2] -  20020*Cos[3*a/2] + 35100*Cos[5*a/2] + 
      10395*Cos[7*a/2] -  429*Cos[9*a/2] + 
  I*( -46332*Sin[a/2] +  40040*Sin[3*a/2] - 42120*Sin[5*a/2] -  
      8910*Sin[7*a/2] +  286*Sin[9*a/2]))/32768;

Psi10d[a_]:=-( Cos[4*a] + I*Sin[4*a] ) * 
     ( 24310*Cos[a/2] -  55692*Cos[3*a/2] + 56100*Cos[5*a/2] - 
      51051*Cos[7*a/2] - 6435*Cos[9*a/2] + 
 I*( -194480*Sin[a/2] + 148512*Sin[3*a/2] - 89760*Sin[5*a/2] + 
      58344*Sin[7*a/2] + 5720*Sin[9*a/2]))/32768;

Psi10e[a_]:= ( Cos[5*a] + I*Sin[5*a] ) * 
     ( 293930*Cos[a/2] -  639540*Cos[3*a/2] +  554268*Cos[5*a/2] - 
      285285*Cos[7*a/2] + 109395*Cos[9*a/2] + 
 I*( -2939300*Sin[a/2] + 2131800*Sin[3*a/2] - 1108536*Sin[5*a/2] + 
      407550*Sin[7*a/2] - 121550*Sin[9*a/2]))/32768;

(* ================================================================ *)
(*  End stencil definition *)
(* ================================================================ *)

(* ================================================================ *)
(* ================================================================ *)
(* ====================== Begin User Input ======================== *)
(* ================================================================ *)
(* ================================================================ *)

(* 
   You must change BOTH the values of ix, iy, and iz along with the
   various i's in PsiNi[] or else the code will give you garbage. All
   N (2,4,6,8, or 10, should be the same. I corresponds to 1, a to 
   1, b to 2 etcetera.
*)

order = 6
Psi = Expand[ TrigToExp[ Psi6I[x]*Psi6a[y]*Psi6b[z] ] ];
ix = 0; iy = 1; iz = 2;

(* ================================================================ *)
(* ================================================================ *)
(* ======================= End User Input ========================= *)
(* ================================================================ *)
(* ================================================================ *)

leftx  = -(order-1) + 2*ix; lefty  = -(order-1) + 2*iy; leftz  = -(order-1) + 2*iz;

psi = Expand[ Factor[ Normal[ Series[ Psi, {x,0,order}, {y,0,order}, {z,0,order}]]]]; 
Print[" psi = ", psi ];
psilistx = CoefficientList[ psi - 1,x] /. {y -> 0, z -> 0};
psilisty = CoefficientList[ psi - 1,y] /. {x -> 0, z -> 0};
psilistz = CoefficientList[ psi - 1,z] /. {x -> 0, y -> 0};
actualorder = Sum[ (psilistx[[i]]+psilisty[[i]]+psilistz[[i]]), {i,1,order-1}];


Do[ Print["Do loop counter = ", k];
Do[ Do[ bnd[i,j,k] = ExpToTrig[ Expand[ 
    Psi*Exp[-I*(leftx+2*(i-1))*x/2]*Exp[-I*(lefty+2*(j-1))*y/2]*Exp[-I*(leftz+2*(k-1))*z/2]]];
    , {i,1,order}];
x = 3; y = 17; z = 9973;
Do[ bnd[i,j,k] = Part[ bnd[i,j,k], 1 ];, {i,1,order}];
,{j,1,order}]; 
,{k,1,order}];

denominator = Part[ {8,2^12,2^24,2^33,2^48,2^58}, order/2]; 
letters = {I,a,b,c,d,e,f};

Do[ bnd[i,j,k] = Factor[ denominator*bnd[i,j,k] ];, {i,1,order},{j,1,order},{k,1,order}];
Do[ Print["      bnd",order,Part[letters,ix+1],Part[letters,iy+1],
    Part[letters,iz+1],"(",i,",",j,",",k,") = ", bnd[i,j,k],".d0/",
    denominator,".d0" ];, {i,1,order},{j,1,order},{k,1,order}];

If[ actualorder == 0, Print["Stencil is correct"], Print["Stencil is wrong"]];

(* ================================================================ *)
(* ================================================================ *)
(* ================================================================ *)
(* ================================================================ *)
(* ================================================================ *)
