!-----------------------------------------------------------------------   
!	This routine solves a linear system of equations employing a successi
!	ve overrelaxation technique.
!-----------------------------------------------------------------------
subroutine sor( a, b, c, d, e, f, u, jmax, lmax, rjac )

	implicit none

	!****** note: I have modified this routine **********
	! DIEGO: Where and what has been modified ???
	!-----------------------------------------------------------------
	!	INTERFACE PARAMETERS 
	!-----------------------------------------------------------------
	integer, 	intent(in) 		:: jmax, lmax
	!real(DP)            :: a(jmax,lmax), b(jmax,lmax), c(jmax,lmax)
	!real(DP)            :: d(jmax,lmax), e(jmax,lmax), f(jmax,lmax)
	!real(DP)            :: u(jmax,lmax)
	real(DP), intent(in) 		:: rjac
	!	DEBUG-DIEGO: added/changed on 06/13/2007
	real(DP), intent(in) 		:: a(:,:), b(:,:), c(:,:)
	real(DP), intent(in) 		:: d(:,:), e(:,:), f(:,:)
	real(DP), intent(inout) :: u(:,:)
	
	
  !-----------------------------------------------------------------
	!	INTERNAL PARAMETERS 
	!-----------------------------------------------------------------                  
  integer             :: ipass, j, jsw, l, lsw, n
  integer,  parameter :: MAXITS = 5000
  real(DP), parameter :: EPS = 1.0e-5
  real(DP)            :: anorm, anormf, omega, resid
   
   !====================================================================
   
   anormf = 0.0d0
   
   do j = 2,jmax-1
   	do l = 2,lmax-1
   		! determine residual
        	resid  = a(j,l)*u(j+1,l) + b(j,l)*u(j-1,l) + c(j,l)*u(j,l+1) &
        			 	 + d(j,l)*u(j,l-1) + e(j,l)*u(j,l) - f(j,l)
       	! sum up matrix norms to check convergence
        	anormf = anormf + dabs(resid)
		enddo
	enddo
	
	! set relaxation parameter
  omega = 1.0d0
      
  ! solve system iteratively through relaxation
	do n = 1,MAXITS
	
		anorm = 0.0d0
		jsw   = 1
		
		do ipass = 1,2
		
			lsw = jsw
			
			do j = 2,jmax-1
				do l = lsw+1,lmax-1,2
					
					if ( e(j,l) .ne. 0.0d0 ) then
						! determine residual
           	resid  = a(j,l)*u(j+1,l) + b(j,l)*u(j-1,l) + c(j,l)*u(j,l+1) &
						 			 + d(j,l)*u(j,l-1) + e(j,l)*u(j,l) - f(j,l)
						! sum up matrix norms to check convergence
   	   			anorm  = anorm +  dabs(resid)
   	   			! do relaxation step
           	u(j,l) = u(j,l) - omega*resid / e(j,l)
          else 
          	u(j,l) = u(j,l)
       		endif	
           
				enddo	! end-loop: l
	      
	    	lsw = 3 - lsw
			enddo	! end-loop: j
			
			jsw = 3 - jsw

			if ( (n .eq. 1) .and. (ipass .eq. 1) ) then
    		omega = 1.0d0 / (1.0d0 - 0.5d0*rjac**2)
     	else
      	omega = 1.0d0 / (1.0d0 - 0.25d0*rjac**2 * omega)
     	endif
         
    enddo	! end-loop: ipass
        
    if ( (anorm .le. EPS*anormf) .or. (anormf .eq. 0.0) ) then
    	print*,n
      return
   	endif
        
	enddo	! end-loop: n
      
  return
   
end subroutine sor


!-----------------------------------------------------------------------
!	LU-backsubstitution
!-----------------------------------------------------------------------
subroutine lubksb( a, n, np, indx, b )
      
  implicit none

	!-----------------------------------------------------------------
	!	INTERFACE PARAMETERS 
	!-----------------------------------------------------------------
  integer,  intent(in)    :: n, np, indx(n)
  real(DP), intent(in)    :: a(np,np)
  real(DP), intent(inout) :: b(n) 
  
  !-----------------------------------------------------------------
	!	INTERNAL PARAMETERS 
	!-----------------------------------------------------------------
  integer  :: i, ii, j, ll
 	real(DP) :: tmp
  
  !=================================================================
  
  ii = 0
  
  do i = 1,n
    
    ll    = indx(i)
    tmp   = b(ll)
    b(ll) = b(i)
    
    if (ii .ne. 0) then
    
      do j = ii,i-1
        tmp = tmp - a(i,j)*b(j)
			enddo

    else if (tmp .ne. 0.0) then
    
      ii = i
    
    endif
    
    b(i) = tmp
    
	enddo
  
  do i = n,1,-1
    
    tmp = b(i)
    
    do j = i+1,n
      tmp = tmp - a(i,j)*b(j)
		enddo
  
    b(i) = tmp / a(i,i)

	enddo

  return

end subroutine lubksb
!	--> END SUBROUTINE lubksb
   
!===================================================================================================
      
!-----------------------------------------------------------------------
!	LU decomposition 
!-----------------------------------------------------------------------
subroutine ludcmp( a, n, np, indx, d )
  
 	implicit none
  
  !-----------------------------------------------------------------
	!	INTERFACE PARAMETERS 
	!-----------------------------------------------------------------
  integer,  intent(in)    :: n, np
  integer,  intent(inout) :: indx(n)
  real(DP), intent(inout) :: d, a(np,np)
  
  !-----------------------------------------------------------------
	!	INTERNAL PARAMETERS 
	!-----------------------------------------------------------------
  integer,  parameter :: NMAX = 500
  integer             :: i, j, k, imax
  real(DP), parameter :: small = 1.0e-20
  real(DP)            :: aamax, dum, tmp, vv(NMAX)
  
  !=================================================================
  
  d = 1.0d0
  
  do i = 1,n
    aamax = 0.0d0
    
    do j = 1,n
      if (abs(a(i,j)) .gt. aamax) then
      	aamax = abs(a(i,j))
      endif
      	
		enddo	
		
    if (aamax .eq. 0.0d0) then
    	print*,'singular matrix in ludcmp'
    endif
    
    vv(i) = 1.0d0/aamax
	enddo	! end-loop: i

  do j = 1,n
  
    do i = 1,j-1  
      tmp = a(i,j)
    
      do k = 1,i-1
        tmp = tmp - a(i,k)*a(k,j)
			enddo
			
      a(i,j) = tmp
		enddo	! end-loop: i

    aamax = 0.0d0
    
    do i = j,n
    
      tmp = a(i,j)
      
      do k = 1,j-1
        tmp = tmp - a(i,k)*a(k,j)
			enddo

      a(i,j) = tmp
      dum    = vv(i)*abs(tmp)
      
      if (dum .ge. aamax) then
        imax  = i
        aamax = dum
      endif
      
		enddo	! end-loop: i

    if (j .ne. imax) then
      do k = 1,n
        dum       = a(imax,k)
        a(imax,k) = a(j,k)
        a(j,k)    = dum
			enddo

      d        = -d
      vv(imax) = vv(j)
    endif
    
    indx(j) = imax
    
    if (a(j,j) .eq. 0.0) then
    	a(j,j) = small
    endif
    	
    if (j .ne. n) then
      dum = 1.0d0 / a(j,j)
      
      do i = j+1,n
        a(i,j) = a(i,j)*dum
			enddo
    endif
    
	enddo	! end-loop: j
  
  return
  
end subroutine ludcmp
!	--> END SUBROUTINE ludcmp
